/*
 * Decompiled with CFR 0.152.
 */
package org.mini2Dx.core.collections.concurrent;

import org.mini2Dx.core.Mdx;
import org.mini2Dx.core.collections.concurrent.ConcurrentCollection;
import org.mini2Dx.gdx.utils.IntArray;
import org.mini2Dx.gdx.utils.IntSet;
import org.mini2Dx.lockprovider.ReadWriteLock;

public class ConcurrentIntSet
extends IntSet
implements ConcurrentCollection {
    protected ReadWriteLock lock = Mdx.locks.newReadWriteLock();

    public ConcurrentIntSet() {
    }

    public ConcurrentIntSet(int initialCapacity) {
        super(initialCapacity);
    }

    public ConcurrentIntSet(int initialCapacity, float loadFactor) {
        super(initialCapacity, loadFactor);
    }

    public ConcurrentIntSet(IntSet set) {
        super(set);
    }

    public int size() {
        this.lock.lockRead();
        int result = this.size;
        this.lock.unlockRead();
        return result;
    }

    public boolean add(int key) {
        this.lock.lockWrite();
        boolean b = super.add(key);
        this.lock.unlockWrite();
        return b;
    }

    public void addAll(IntArray array, int offset, int length) {
        boolean isOtherConcurrent = array instanceof ConcurrentCollection;
        if (isOtherConcurrent) {
            ((ConcurrentCollection)array).getLock().lockRead();
        }
        this.lock.lockWrite();
        super.addAll(array, offset, length);
        this.lock.unlockWrite();
        if (isOtherConcurrent) {
            ((ConcurrentCollection)array).getLock().unlockRead();
        }
    }

    public void addAll(int[] array, int offset, int length) {
        this.lock.lockWrite();
        super.addAll(array, offset, length);
        this.lock.unlockWrite();
    }

    public void addAll(IntSet set) {
        boolean isOtherConcurrent = set instanceof ConcurrentCollection;
        if (isOtherConcurrent) {
            ((ConcurrentCollection)set).getLock().lockRead();
        }
        this.lock.lockWrite();
        super.addAll(set);
        this.lock.unlockWrite();
        if (isOtherConcurrent) {
            ((ConcurrentCollection)set).getLock().unlockRead();
        }
    }

    public boolean remove(int key) {
        this.lock.lockWrite();
        boolean b = super.remove(key);
        this.lock.unlockWrite();
        return b;
    }

    public boolean notEmpty() {
        this.lock.lockWrite();
        boolean b = super.notEmpty();
        this.lock.unlockWrite();
        return b;
    }

    public boolean isEmpty() {
        this.lock.lockWrite();
        boolean b = super.isEmpty();
        this.lock.unlockWrite();
        return b;
    }

    public void shrink(int maximumCapacity) {
        this.lock.lockWrite();
        super.shrink(maximumCapacity);
        this.lock.unlockWrite();
    }

    public void clear(int maximumCapacity) {
        this.lock.lockWrite();
        super.clear(maximumCapacity);
        this.lock.unlockWrite();
    }

    public void clear() {
        this.lock.lockWrite();
        super.clear();
        this.lock.unlockWrite();
    }

    public boolean contains(int key) {
        this.lock.lockRead();
        boolean b = super.contains(key);
        this.lock.unlockRead();
        return b;
    }

    public int first() {
        this.lock.lockRead();
        int i = super.first();
        this.lock.unlockRead();
        return i;
    }

    public void ensureCapacity(int additionalCapacity) {
        this.lock.lockWrite();
        super.ensureCapacity(additionalCapacity);
        this.lock.unlockWrite();
    }

    public int hashCode() {
        this.lock.lockRead();
        int i = super.hashCode();
        this.lock.unlockRead();
        return i;
    }

    public boolean equals(Object obj) {
        boolean isOtherConcurrent = obj instanceof ConcurrentCollection;
        if (isOtherConcurrent) {
            ((ConcurrentCollection)obj).getLock().lockRead();
        }
        this.lock.lockRead();
        boolean b = super.equals(obj);
        this.lock.unlockRead();
        if (isOtherConcurrent) {
            ((ConcurrentCollection)obj).getLock().unlockRead();
        }
        return b;
    }

    public String toString() {
        this.lock.lockRead();
        String s = super.toString();
        this.lock.unlockRead();
        return s;
    }

    public IntSet.IntSetIterator iterator() {
        return new IntSet.IntSetIterator((IntSet)this);
    }

    @Override
    public ReadWriteLock getLock() {
        return this.lock;
    }
}

