/*
 * Decompiled with CFR 0.152.
 */
package org.mini2Dx.core.collections.concurrent;

import org.mini2Dx.core.Mdx;
import org.mini2Dx.core.collections.IntTreeMap;
import org.mini2Dx.core.collections.concurrent.ConcurrentCollection;
import org.mini2Dx.gdx.utils.IntMap;
import org.mini2Dx.lockprovider.ReadWriteLock;

public class ConcurrentIntTreeMap<T>
extends IntTreeMap<T>
implements ConcurrentCollection {
    protected ReadWriteLock lock = Mdx.locks.newReadWriteLock();

    public ConcurrentIntTreeMap() {
    }

    public ConcurrentIntTreeMap(int initialCapacity) {
        super(initialCapacity);
    }

    public ConcurrentIntTreeMap(int initialCapacity, float loadFactor) {
        super(initialCapacity, loadFactor);
    }

    public ConcurrentIntTreeMap(IntMap<? extends T> map) {
        super(map);
    }

    public int size() {
        this.lock.lockRead();
        int result = this.size;
        this.lock.unlockRead();
        return result;
    }

    @Override
    public T put(int key, T value) {
        this.lock.lockWrite();
        T t = super.put(key, value);
        this.lock.unlockWrite();
        return t;
    }

    public boolean putIfAbsent(int key, T value) {
        boolean result = false;
        this.lock.lockWrite();
        if (!super.containsKey(key)) {
            super.put(key, value);
            result = true;
        }
        this.lock.unlockWrite();
        return result;
    }

    public boolean putIfPresent(int key, T value) {
        boolean result = false;
        this.lock.lockWrite();
        if (super.containsKey(key)) {
            super.put(key, value);
            result = true;
        }
        this.lock.unlockWrite();
        return result;
    }

    @Override
    public void putAll(IntMap<? extends T> map) {
        boolean isOtherConcurrent = map instanceof ConcurrentCollection;
        if (isOtherConcurrent) {
            ((ConcurrentCollection)map).getLock().lockRead();
        }
        this.lock.lockWrite();
        super.putAll(map);
        this.lock.unlockWrite();
        if (isOtherConcurrent) {
            ((ConcurrentCollection)map).getLock().unlockRead();
        }
    }

    public T get(int key, T defaultValue) {
        this.lock.lockRead();
        Object t = super.get(key, defaultValue);
        this.lock.unlockRead();
        return (T)t;
    }

    @Override
    public T remove(int key) {
        this.lock.lockWrite();
        Object t = super.remove(key);
        this.lock.unlockWrite();
        return (T)t;
    }

    public void shrink(int maximumCapacity) {
        this.lock.lockWrite();
        super.shrink(maximumCapacity);
        this.lock.unlockWrite();
    }

    @Override
    public void clear(int maximumCapacity) {
        this.lock.lockWrite();
        super.clear(maximumCapacity);
        this.lock.unlockWrite();
    }

    @Override
    public void clear() {
        this.lock.lockWrite();
        super.clear();
        this.lock.unlockWrite();
    }

    public boolean containsValue(Object value, boolean identity) {
        this.lock.lockRead();
        boolean b = super.containsValue(value, identity);
        this.lock.unlockRead();
        return b;
    }

    public boolean containsKey(int key) {
        this.lock.lockRead();
        boolean b = super.containsKey(key);
        this.lock.unlockRead();
        return b;
    }

    public int findKey(Object value, boolean identity, int notFound) {
        this.lock.lockRead();
        int i = super.findKey(value, identity, notFound);
        this.lock.unlockRead();
        return i;
    }

    public void ensureCapacity(int additionalCapacity) {
        this.lock.lockWrite();
        super.ensureCapacity(additionalCapacity);
        this.lock.unlockWrite();
    }

    public int hashCode() {
        this.lock.lockRead();
        int hc = super.hashCode();
        this.lock.unlockRead();
        return hc;
    }

    public boolean equals(Object object) {
        boolean isOtherConcurrent = object instanceof ConcurrentCollection;
        if (isOtherConcurrent) {
            ((ConcurrentCollection)object).getLock().lockRead();
        }
        this.lock.lockRead();
        boolean e = super.equals(object);
        this.lock.unlockRead();
        if (isOtherConcurrent) {
            ((ConcurrentCollection)object).getLock().unlockRead();
        }
        return e;
    }

    public boolean notEmpty() {
        this.lock.lockRead();
        boolean b = super.notEmpty();
        this.lock.unlockRead();
        return b;
    }

    public boolean isEmpty() {
        this.lock.lockRead();
        boolean b = super.isEmpty();
        this.lock.unlockRead();
        return b;
    }

    public boolean equalsIdentity(Object obj) {
        boolean isOtherConcurrent = obj instanceof ConcurrentCollection;
        if (isOtherConcurrent) {
            ((ConcurrentCollection)obj).getLock().lockRead();
        }
        this.lock.lockRead();
        boolean b = super.equals(obj);
        this.lock.unlockRead();
        if (isOtherConcurrent) {
            ((ConcurrentCollection)obj).getLock().unlockRead();
        }
        return b;
    }

    public String toString() {
        this.lock.lockRead();
        String s = super.toString();
        this.lock.unlockRead();
        return s;
    }

    public IntMap.Entries<T> entries() {
        return new IntMap.Entries((IntMap)this);
    }

    public IntMap.Values<T> values() {
        return new IntMap.Values((IntMap)this);
    }

    public IntMap.Keys keys() {
        return new IntMap.Keys((IntMap)this);
    }

    @Override
    public IntMap.Keys ascendingKeys() {
        return new IntTreeMap.SortedKeys(this, true);
    }

    @Override
    public IntMap.Keys descendingKeys() {
        return new IntTreeMap.SortedKeys(this, false);
    }

    @Override
    public ReadWriteLock getLock() {
        return this.lock;
    }
}

