/*
 * Decompiled with CFR 0.152.
 */
package org.mini2Dx.core.collections.concurrent;

import org.mini2Dx.core.Mdx;
import org.mini2Dx.core.collections.LruIntMap;
import org.mini2Dx.core.collections.concurrent.ConcurrentCollection;
import org.mini2Dx.gdx.utils.IntMap;
import org.mini2Dx.lockprovider.ReadWriteLock;

public class ConcurrentLruIntMap<T>
extends LruIntMap<T>
implements ConcurrentCollection {
    protected ReadWriteLock lock = Mdx.locks.newReadWriteLock();

    public ConcurrentLruIntMap() {
    }

    public ConcurrentLruIntMap(int initialCapacity) {
        super(initialCapacity);
    }

    public ConcurrentLruIntMap(int initialCapacity, float loadFactor) {
        super(initialCapacity, loadFactor);
    }

    public ConcurrentLruIntMap(IntMap<? extends T> map) {
        super(map);
    }

    public ConcurrentLruIntMap(int initialCapacity, int maxCapacity) {
        super(initialCapacity, maxCapacity);
    }

    public ConcurrentLruIntMap(int initialCapacity, int maxCapacity, float loadFactor) {
        super(initialCapacity, maxCapacity, loadFactor);
    }

    public ConcurrentLruIntMap(IntMap<? extends T> map, int maxCapacity) {
        super(map, maxCapacity);
    }

    public int size() {
        this.lock.lockRead();
        int result = this.size;
        this.lock.unlockRead();
        return result;
    }

    @Override
    public T put(int key, T value) {
        this.lock.lockWrite();
        T t = super.put(key, value);
        this.lock.unlockWrite();
        return t;
    }

    public boolean putIfAbsent(int key, T value) {
        boolean result = false;
        this.lock.lockWrite();
        if (!super.containsKey(key)) {
            super.put(key, value);
            result = true;
        }
        this.lock.unlockWrite();
        return result;
    }

    public boolean putIfPresent(int key, T value) {
        boolean result = false;
        this.lock.lockWrite();
        if (super.containsKey(key)) {
            super.put(key, value);
            result = true;
        }
        this.lock.unlockWrite();
        return result;
    }

    @Override
    public void putAll(IntMap<? extends T> map) {
        boolean isOtherConcurrent = map instanceof ConcurrentCollection;
        if (isOtherConcurrent) {
            ((ConcurrentCollection)map).getLock().lockRead();
        }
        this.lock.lockWrite();
        super.putAll(map);
        this.lock.unlockWrite();
        if (isOtherConcurrent) {
            ((ConcurrentCollection)map).getLock().unlockRead();
        }
    }

    @Override
    public T get(int key, T defaultValue) {
        this.lock.lockRead();
        T t = super.get(key, defaultValue);
        this.lock.unlockRead();
        return t;
    }

    @Override
    public T get(int key) {
        this.lock.lockRead();
        Object t = super.get(key);
        this.lock.unlockRead();
        return (T)t;
    }

    @Override
    public T remove(int key) {
        this.lock.lockWrite();
        Object t = super.remove(key);
        this.lock.unlockWrite();
        return (T)t;
    }

    public boolean notEmpty() {
        this.lock.lockRead();
        boolean b = super.notEmpty();
        this.lock.unlockRead();
        return b;
    }

    public boolean isEmpty() {
        this.lock.lockRead();
        boolean b = super.isEmpty();
        this.lock.unlockRead();
        return b;
    }

    public void shrink(int maximumCapacity) {
        this.lock.lockWrite();
        super.shrink(maximumCapacity);
        this.lock.unlockWrite();
    }

    public void clear(int maximumCapacity) {
        this.lock.lockWrite();
        super.clear(maximumCapacity);
        this.lock.unlockWrite();
    }

    @Override
    public void clear() {
        this.lock.lockWrite();
        super.clear();
        this.lock.unlockWrite();
    }

    public boolean containsKey(int key) {
        this.lock.lockRead();
        boolean b = super.containsKey(key);
        this.lock.unlockRead();
        return b;
    }

    public int findKey(Object value, boolean identity, int notFound) {
        this.lock.lockRead();
        int i = super.findKey(value, identity, notFound);
        this.lock.unlockRead();
        return i;
    }

    public void ensureCapacity(int additionalCapacity) {
        this.lock.lockWrite();
        super.ensureCapacity(additionalCapacity);
        this.lock.unlockWrite();
    }

    public int hashCode() {
        this.lock.lockRead();
        int i = super.hashCode();
        this.lock.unlockRead();
        return i;
    }

    public boolean equals(Object obj) {
        boolean isOtherConcurrent = obj instanceof ConcurrentCollection;
        if (isOtherConcurrent) {
            ((ConcurrentCollection)obj).getLock().lockRead();
        }
        this.lock.lockRead();
        boolean b = super.equals(obj);
        this.lock.unlockRead();
        if (isOtherConcurrent) {
            ((ConcurrentCollection)obj).getLock().unlockRead();
        }
        return b;
    }

    public String toString() {
        this.lock.lockRead();
        String s = super.toString();
        this.lock.unlockRead();
        return s;
    }

    @Override
    public int getMaxCapacity() {
        this.lock.lockRead();
        int i = super.getMaxCapacity();
        this.lock.unlockRead();
        return i;
    }

    public IntMap.Entries<T> entries() {
        return new IntMap.Entries((IntMap)this);
    }

    public IntMap.Values<T> values() {
        return new IntMap.Values((IntMap)this);
    }

    public IntMap.Keys keys() {
        return new IntMap.Keys((IntMap)this);
    }

    @Override
    public ReadWriteLock getLock() {
        return this.lock;
    }
}

