/*
 * Decompiled with CFR 0.152.
 */
package org.mini2Dx.core.collections.concurrent;

import org.mini2Dx.core.Mdx;
import org.mini2Dx.core.collections.LruObjectMap;
import org.mini2Dx.core.collections.concurrent.ConcurrentCollection;
import org.mini2Dx.gdx.utils.ObjectMap;
import org.mini2Dx.lockprovider.ReadWriteLock;

public class ConcurrentLruObjectMap<K, V>
extends LruObjectMap<K, V>
implements ConcurrentCollection {
    protected ReadWriteLock lock = Mdx.locks.newReadWriteLock();

    public ConcurrentLruObjectMap() {
    }

    public ConcurrentLruObjectMap(int initialCapacity) {
        super(initialCapacity);
    }

    public ConcurrentLruObjectMap(int initialCapacity, float loadFactor) {
        super(initialCapacity, loadFactor);
    }

    public ConcurrentLruObjectMap(ObjectMap<? extends K, ? extends V> map) {
        super(map);
    }

    public ConcurrentLruObjectMap(int initialCapacity, int maxCapacity) {
        super(initialCapacity, maxCapacity);
    }

    public ConcurrentLruObjectMap(int initialCapacity, int maxCapacity, float loadFactor) {
        super(initialCapacity, maxCapacity, loadFactor);
    }

    public ConcurrentLruObjectMap(ObjectMap<? extends K, ? extends V> map, int maxCapacity) {
        super(map, maxCapacity);
    }

    public int size() {
        this.lock.lockRead();
        int result = this.size;
        this.lock.unlockRead();
        return result;
    }

    @Override
    public int getMaxCapacity() {
        this.lock.lockRead();
        int i = super.getMaxCapacity();
        this.lock.unlockRead();
        return i;
    }

    @Override
    public V put(K key, V value) {
        this.lock.lockWrite();
        V v = super.put(key, value);
        this.lock.unlockWrite();
        return v;
    }

    public boolean putIfAbsent(K key, V value) {
        boolean result = false;
        this.lock.lockWrite();
        if (!super.containsKey(key)) {
            super.put(key, value);
            result = true;
        }
        this.lock.unlockWrite();
        return result;
    }

    public boolean putIfPresent(K key, V value) {
        boolean result = false;
        this.lock.lockWrite();
        if (super.containsKey(key)) {
            super.put(key, value);
            result = true;
        }
        this.lock.unlockWrite();
        return result;
    }

    @Override
    public void putAll(ObjectMap<? extends K, ? extends V> map) {
        boolean isOtherConcurrent = map instanceof ConcurrentCollection;
        if (isOtherConcurrent) {
            ((ConcurrentCollection)map).getLock().lockRead();
        }
        this.lock.lockWrite();
        super.putAll(map);
        this.lock.unlockWrite();
        if (isOtherConcurrent) {
            ((ConcurrentCollection)map).getLock().unlockRead();
        }
    }

    @Override
    public <T extends K> V get(T key) {
        this.lock.lockRead();
        Object v = super.get(key);
        this.lock.unlockRead();
        return v;
    }

    @Override
    public V get(K key, V defaultValue) {
        this.lock.lockRead();
        V v = super.get(key, defaultValue);
        this.lock.unlockRead();
        return v;
    }

    @Override
    public V remove(K key) {
        this.lock.lockWrite();
        Object v = super.remove(key);
        this.lock.unlockWrite();
        return v;
    }

    public boolean notEmpty() {
        this.lock.lockRead();
        boolean b = super.notEmpty();
        this.lock.unlockRead();
        return b;
    }

    public boolean isEmpty() {
        this.lock.lockRead();
        boolean b = super.isEmpty();
        this.lock.unlockRead();
        return b;
    }

    public void shrink(int maximumCapacity) {
        this.lock.lockWrite();
        super.shrink(maximumCapacity);
        this.lock.unlockWrite();
    }

    public void clear(int maximumCapacity) {
        this.lock.lockWrite();
        super.clear(maximumCapacity);
        this.lock.unlockWrite();
    }

    @Override
    public void clear() {
        this.lock.lockWrite();
        super.clear();
        this.lock.unlockWrite();
    }

    public boolean containsValue(Object value, boolean identity) {
        this.lock.lockRead();
        boolean b = super.containsValue(value, identity);
        this.lock.unlockRead();
        return b;
    }

    public boolean containsKey(K key) {
        this.lock.lockRead();
        boolean b = super.containsKey(key);
        this.lock.unlockRead();
        return b;
    }

    public K findKey(Object value, boolean identity) {
        this.lock.lockRead();
        Object k = super.findKey(value, identity);
        this.lock.unlockRead();
        return (K)k;
    }

    public void ensureCapacity(int additionalCapacity) {
        this.lock.lockWrite();
        super.ensureCapacity(additionalCapacity);
        this.lock.unlockWrite();
    }

    public int hashCode() {
        this.lock.lockRead();
        int i = super.hashCode();
        this.lock.unlockRead();
        return i;
    }

    public boolean equals(Object obj) {
        boolean isOtherConcurrent = obj instanceof ConcurrentCollection;
        if (isOtherConcurrent) {
            ((ConcurrentCollection)obj).getLock().lockRead();
        }
        this.lock.lockRead();
        boolean b = super.equals(obj);
        this.lock.unlockRead();
        if (isOtherConcurrent) {
            ((ConcurrentCollection)obj).getLock().unlockRead();
        }
        return b;
    }

    public boolean equalsIdentity(Object obj) {
        boolean isOtherConcurrent = obj instanceof ConcurrentCollection;
        if (isOtherConcurrent) {
            ((ConcurrentCollection)obj).getLock().lockRead();
        }
        this.lock.lockRead();
        boolean b = super.equalsIdentity(obj);
        this.lock.unlockRead();
        if (isOtherConcurrent) {
            ((ConcurrentCollection)obj).getLock().unlockRead();
        }
        return b;
    }

    public String toString(String separator) {
        this.lock.lockRead();
        String s = super.toString(separator);
        this.lock.unlockRead();
        return s;
    }

    public String toString() {
        this.lock.lockRead();
        String s = super.toString();
        this.lock.unlockRead();
        return s;
    }

    public ObjectMap.Keys<K> keys() {
        return new ObjectMap.Keys((ObjectMap)this);
    }

    public ObjectMap.Entries<K, V> entries() {
        return new ObjectMap.Entries((ObjectMap)this);
    }

    public ObjectMap.Values<V> values() {
        return new ObjectMap.Values((ObjectMap)this);
    }

    @Override
    public ReadWriteLock getLock() {
        return this.lock;
    }
}

