/*
 * Decompiled with CFR 0.152.
 */
package org.mini2Dx.core.collections.concurrent;

import org.mini2Dx.core.Mdx;
import org.mini2Dx.core.collections.concurrent.ConcurrentCollection;
import org.mini2Dx.gdx.utils.ObjectFloatMap;
import org.mini2Dx.lockprovider.ReadWriteLock;

public class ConcurrentObjectFloatMap<K>
extends ObjectFloatMap<K>
implements ConcurrentCollection {
    protected ReadWriteLock lock = Mdx.locks.newReadWriteLock();

    public ConcurrentObjectFloatMap() {
    }

    public ConcurrentObjectFloatMap(int initialCapacity) {
        super(initialCapacity);
    }

    public ConcurrentObjectFloatMap(int initialCapacity, float loadFactor) {
        super(initialCapacity, loadFactor);
    }

    public ConcurrentObjectFloatMap(ObjectFloatMap<? extends K> map) {
        super(map);
    }

    public int size() {
        this.lock.lockRead();
        int result = this.size;
        this.lock.unlockRead();
        return result;
    }

    public void put(K key, float value) {
        this.lock.lockWrite();
        super.put(key, value);
        this.lock.unlockWrite();
    }

    public boolean putIfAbsent(K key, float value) {
        boolean result = false;
        this.lock.lockWrite();
        if (!super.containsKey(key)) {
            super.put(key, value);
            result = true;
        }
        this.lock.unlockWrite();
        return result;
    }

    public boolean putIfPresent(K key, float value) {
        boolean result = false;
        this.lock.lockWrite();
        if (super.containsKey(key)) {
            super.put(key, value);
            result = true;
        }
        this.lock.unlockWrite();
        return result;
    }

    public void putAll(ObjectFloatMap<? extends K> map) {
        boolean isOtherConcurrent = map instanceof ConcurrentCollection;
        if (isOtherConcurrent) {
            ((ConcurrentCollection)map).getLock().lockRead();
        }
        this.lock.lockWrite();
        super.putAll(map);
        this.lock.unlockWrite();
        if (isOtherConcurrent) {
            ((ConcurrentCollection)map).getLock().unlockRead();
        }
    }

    public float get(K key, float defaultValue) {
        this.lock.lockRead();
        float f = super.get(key, defaultValue);
        this.lock.unlockRead();
        return f;
    }

    public boolean notEmpty() {
        this.lock.lockRead();
        boolean b = super.notEmpty();
        this.lock.unlockRead();
        return b;
    }

    public boolean isEmpty() {
        this.lock.lockRead();
        boolean b = super.isEmpty();
        this.lock.unlockRead();
        return b;
    }

    public void shrink(int maximumCapacity) {
        this.lock.lockWrite();
        super.shrink(maximumCapacity);
        this.lock.unlockWrite();
    }

    public void clear(int maximumCapacity) {
        this.lock.lockWrite();
        super.clear(maximumCapacity);
        this.lock.unlockWrite();
    }

    public void clear() {
        this.lock.lockWrite();
        super.clear();
        this.lock.unlockWrite();
    }

    public boolean containsKey(K key) {
        this.lock.lockRead();
        boolean b = super.containsKey(key);
        this.lock.unlockRead();
        return b;
    }

    public void ensureCapacity(int additionalCapacity) {
        this.lock.lockWrite();
        super.ensureCapacity(additionalCapacity);
        this.lock.unlockWrite();
    }

    public float getAndIncrement(K key, float defaultValue, float increment) {
        this.lock.lockWrite();
        float f = super.getAndIncrement(key, defaultValue, increment);
        this.lock.unlockWrite();
        return f;
    }

    public float remove(K key, float defaultValue) {
        this.lock.lockWrite();
        float f = super.remove(key, defaultValue);
        this.lock.unlockWrite();
        return f;
    }

    public boolean containsValue(float value) {
        this.lock.lockRead();
        boolean b = super.containsValue(value);
        this.lock.unlockRead();
        return b;
    }

    public K findKey(float value) {
        this.lock.lockRead();
        Object k = super.findKey(value);
        this.lock.unlockRead();
        return (K)k;
    }

    public int hashCode() {
        this.lock.lockRead();
        int i = super.hashCode();
        this.lock.unlockRead();
        return i;
    }

    public boolean equals(Object obj) {
        boolean isOtherConcurrent = obj instanceof ConcurrentCollection;
        if (isOtherConcurrent) {
            ((ConcurrentCollection)obj).getLock().lockRead();
        }
        this.lock.lockRead();
        boolean b = super.equals(obj);
        this.lock.unlockRead();
        if (isOtherConcurrent) {
            ((ConcurrentCollection)obj).getLock().unlockRead();
        }
        return b;
    }

    public String toString() {
        this.lock.lockRead();
        String s = super.toString();
        this.lock.unlockRead();
        return s;
    }

    public ObjectFloatMap.Keys<K> keys() {
        return new ObjectFloatMap.Keys((ObjectFloatMap)this);
    }

    public ObjectFloatMap.Entries<K> entries() {
        return new ObjectFloatMap.Entries((ObjectFloatMap)this);
    }

    public ObjectFloatMap.Values values() {
        return new ObjectFloatMap.Values((ObjectFloatMap)this);
    }

    @Override
    public ReadWriteLock getLock() {
        return this.lock;
    }
}

