/*
 * Decompiled with CFR 0.152.
 */
package org.mini2Dx.core.collections.concurrent;

import org.mini2Dx.core.Mdx;
import org.mini2Dx.core.collections.concurrent.ConcurrentCollection;
import org.mini2Dx.gdx.utils.Array;
import org.mini2Dx.gdx.utils.ObjectSet;
import org.mini2Dx.lockprovider.ReadWriteLock;

public class ConcurrentObjectSet<T>
extends ObjectSet<T>
implements ConcurrentCollection {
    protected ReadWriteLock lock = Mdx.locks.newReadWriteLock();

    public ConcurrentObjectSet() {
    }

    public ConcurrentObjectSet(int initialCapacity) {
        super(initialCapacity);
    }

    public ConcurrentObjectSet(int initialCapacity, float loadFactor) {
        super(initialCapacity, loadFactor);
    }

    public ConcurrentObjectSet(ObjectSet<? extends T> set) {
        super(set);
    }

    public int size() {
        this.lock.lockRead();
        int result = this.size;
        this.lock.unlockRead();
        return result;
    }

    public boolean add(T key) {
        this.lock.lockWrite();
        boolean b = super.add(key);
        this.lock.unlockWrite();
        return b;
    }

    public void addAll(Array<? extends T> array, int offset, int length) {
        boolean isOtherConcurrent = array instanceof ConcurrentCollection;
        if (isOtherConcurrent) {
            ((ConcurrentCollection)array).getLock().lockRead();
        }
        this.lock.lockWrite();
        super.addAll(array, offset, length);
        this.lock.unlockWrite();
        if (isOtherConcurrent) {
            ((ConcurrentCollection)array).getLock().unlockRead();
        }
    }

    public boolean addAll(T[] array, int offset, int length) {
        this.lock.lockWrite();
        boolean result = super.addAll((Object[])array, offset, length);
        this.lock.unlockWrite();
        return result;
    }

    public void addAll(ObjectSet<T> set) {
        boolean isOtherConcurrent = set instanceof ConcurrentCollection;
        if (isOtherConcurrent) {
            ((ConcurrentCollection)set).getLock().lockRead();
        }
        this.lock.lockWrite();
        super.addAll(set);
        this.lock.unlockWrite();
        if (isOtherConcurrent) {
            ((ConcurrentCollection)set).getLock().unlockRead();
        }
    }

    public boolean remove(T key) {
        this.lock.lockWrite();
        boolean b = super.remove(key);
        this.lock.unlockWrite();
        return b;
    }

    public boolean notEmpty() {
        this.lock.lockRead();
        boolean b = super.notEmpty();
        this.lock.unlockRead();
        return b;
    }

    public boolean isEmpty() {
        this.lock.lockRead();
        boolean b = super.isEmpty();
        this.lock.unlockRead();
        return b;
    }

    public void shrink(int maximumCapacity) {
        this.lock.lockWrite();
        super.shrink(maximumCapacity);
        this.lock.unlockWrite();
    }

    public void clear(int maximumCapacity) {
        this.lock.lockWrite();
        super.clear(maximumCapacity);
        this.lock.unlockWrite();
    }

    public void clear() {
        this.lock.lockWrite();
        super.clear();
        this.lock.unlockWrite();
    }

    public boolean contains(T key) {
        this.lock.lockRead();
        boolean b = super.contains(key);
        this.lock.unlockRead();
        return b;
    }

    public T get(T key) {
        this.lock.lockRead();
        Object t = super.get(key);
        this.lock.unlockRead();
        return (T)t;
    }

    public T first() {
        this.lock.lockRead();
        Object t = super.first();
        this.lock.unlockRead();
        return (T)t;
    }

    public void ensureCapacity(int additionalCapacity) {
        this.lock.lockWrite();
        super.ensureCapacity(additionalCapacity);
        this.lock.unlockWrite();
    }

    public int hashCode() {
        this.lock.lockRead();
        int i = super.hashCode();
        this.lock.unlockRead();
        return i;
    }

    public boolean equals(Object obj) {
        boolean isOtherConcurrent = obj instanceof ConcurrentCollection;
        if (isOtherConcurrent) {
            ((ConcurrentCollection)obj).getLock().lockRead();
        }
        this.lock.lockRead();
        boolean b = super.equals(obj);
        this.lock.unlockRead();
        if (isOtherConcurrent) {
            ((ConcurrentCollection)obj).getLock().unlockRead();
        }
        return b;
    }

    public String toString() {
        this.lock.lockRead();
        String s = super.toString();
        this.lock.unlockRead();
        return s;
    }

    public String toString(String separator) {
        this.lock.lockRead();
        String s = super.toString(separator);
        this.lock.unlockRead();
        return s;
    }

    public ObjectSet.ObjectSetIterator<T> iterator() {
        return new ObjectSet.ObjectSetIterator((ObjectSet)this);
    }

    @Override
    public ReadWriteLock getLock() {
        return this.lock;
    }
}

