/*
 * Decompiled with CFR 0.152.
 */
package org.mini2Dx.core.collections.concurrent;

import org.mini2Dx.core.Mdx;
import org.mini2Dx.core.collections.concurrent.ConcurrentCollection;
import org.mini2Dx.gdx.utils.Array;
import org.mini2Dx.gdx.utils.ObjectMap;
import org.mini2Dx.gdx.utils.OrderedMap;
import org.mini2Dx.lockprovider.ReadWriteLock;

public class ConcurrentOrderedMap<K, V>
extends OrderedMap<K, V>
implements ConcurrentCollection {
    protected ReadWriteLock lock = Mdx.locks.newReadWriteLock();

    public ConcurrentOrderedMap() {
    }

    public ConcurrentOrderedMap(int initialCapacity) {
        super(initialCapacity);
    }

    public ConcurrentOrderedMap(int initialCapacity, float loadFactor) {
        super(initialCapacity, loadFactor);
    }

    public ConcurrentOrderedMap(OrderedMap<? extends K, ? extends V> map) {
        super(map);
    }

    public int size() {
        this.lock.lockRead();
        int result = this.size;
        this.lock.unlockRead();
        return result;
    }

    public V put(K key, V value) {
        this.lock.lockWrite();
        Object v = super.put(key, value);
        this.lock.unlockWrite();
        return (V)v;
    }

    public boolean putIfAbsent(K key, V value) {
        boolean result = false;
        this.lock.lockWrite();
        if (!super.containsKey(key)) {
            super.put(key, value);
            result = true;
        }
        this.lock.unlockWrite();
        return result;
    }

    public boolean putIfPresent(K key, V value) {
        boolean result = false;
        this.lock.lockWrite();
        if (super.containsKey(key)) {
            super.put(key, value);
            result = true;
        }
        this.lock.unlockWrite();
        return result;
    }

    public void putAll(ObjectMap<? extends K, ? extends V> map) {
        boolean isOtherConcurrent = map instanceof ConcurrentCollection;
        if (isOtherConcurrent) {
            ((ConcurrentCollection)map).getLock().lockRead();
        }
        this.lock.lockWrite();
        super.putAll(map);
        this.lock.unlockWrite();
        if (isOtherConcurrent) {
            ((ConcurrentCollection)map).getLock().unlockRead();
        }
    }

    public <T extends K> V get(T key) {
        this.lock.lockRead();
        Object v = super.get(key);
        this.lock.unlockRead();
        return (V)v;
    }

    public V get(K key, V defaultValue) {
        this.lock.lockRead();
        Object v = super.get(key, defaultValue);
        this.lock.unlockRead();
        return (V)v;
    }

    public V remove(K key) {
        this.lock.lockWrite();
        Object v = super.remove(key);
        this.lock.unlockWrite();
        return (V)v;
    }

    public boolean notEmpty() {
        this.lock.lockRead();
        boolean b = super.notEmpty();
        this.lock.unlockRead();
        return b;
    }

    public boolean isEmpty() {
        this.lock.lockRead();
        boolean b = super.isEmpty();
        this.lock.unlockRead();
        return b;
    }

    public void shrink(int maximumCapacity) {
        this.lock.lockWrite();
        super.shrink(maximumCapacity);
        this.lock.unlockWrite();
    }

    public void clear(int maximumCapacity) {
        this.lock.lockWrite();
        super.clear(maximumCapacity);
        this.lock.unlockWrite();
    }

    public void clear() {
        this.lock.lockWrite();
        super.clear();
        this.lock.unlockWrite();
    }

    public boolean containsValue(Object value, boolean identity) {
        this.lock.lockRead();
        boolean b = super.containsValue(value, identity);
        this.lock.unlockRead();
        return b;
    }

    public boolean containsKey(K key) {
        this.lock.lockRead();
        boolean b = super.containsKey(key);
        this.lock.unlockRead();
        return b;
    }

    public K findKey(Object value, boolean identity) {
        this.lock.lockRead();
        Object k = super.findKey(value, identity);
        this.lock.unlockRead();
        return (K)k;
    }

    public void ensureCapacity(int additionalCapacity) {
        this.lock.lockWrite();
        super.ensureCapacity(additionalCapacity);
        this.lock.unlockWrite();
    }

    public V removeIndex(int index) {
        this.lock.lockWrite();
        Object v = super.removeIndex(index);
        this.lock.unlockWrite();
        return (V)v;
    }

    public Array<K> orderedKeys() {
        this.lock.lockRead();
        Array aK = super.orderedKeys();
        this.lock.unlockRead();
        return aK;
    }

    public ObjectMap.Keys<K> keys() {
        return new ObjectMap.Keys((ObjectMap)this);
    }

    public int hashCode() {
        this.lock.lockRead();
        int i = super.hashCode();
        this.lock.unlockRead();
        return i;
    }

    public boolean equals(Object obj) {
        boolean isOtherConcurrent = obj instanceof ConcurrentCollection;
        if (isOtherConcurrent) {
            ((ConcurrentCollection)obj).getLock().lockRead();
        }
        this.lock.lockRead();
        boolean b = super.equals(obj);
        this.lock.unlockRead();
        if (isOtherConcurrent) {
            ((ConcurrentCollection)obj).getLock().unlockRead();
        }
        return b;
    }

    public boolean equalsIdentity(Object obj) {
        boolean isOtherConcurrent = obj instanceof ConcurrentCollection;
        if (isOtherConcurrent) {
            ((ConcurrentCollection)obj).getLock().lockRead();
        }
        this.lock.lockRead();
        boolean b = super.equalsIdentity(obj);
        this.lock.unlockRead();
        if (isOtherConcurrent) {
            ((ConcurrentCollection)obj).getLock().unlockRead();
        }
        return b;
    }

    public String toString(String separator) {
        this.lock.lockRead();
        String s = super.toString(separator);
        this.lock.unlockRead();
        return s;
    }

    public String toString() {
        this.lock.lockRead();
        String s = super.toString();
        this.lock.unlockRead();
        return s;
    }

    public ObjectMap.Entries<K, V> entries() {
        return new ObjectMap.Entries((ObjectMap)this);
    }

    public ObjectMap.Values<V> values() {
        return new ObjectMap.Values((ObjectMap)this);
    }

    @Override
    public ReadWriteLock getLock() {
        return this.lock;
    }
}

