/*
 * Decompiled with CFR 0.152.
 */
package org.mini2Dx.core.collections.concurrent;

import org.mini2Dx.core.Mdx;
import org.mini2Dx.core.collections.concurrent.ConcurrentCollection;
import org.mini2Dx.gdx.utils.PooledLinkedList;
import org.mini2Dx.lockprovider.ReadWriteLock;

public class ConcurrentPooledLinkedList<T>
extends PooledLinkedList<T>
implements ConcurrentCollection {
    protected ReadWriteLock lock = Mdx.locks.newReadWriteLock();

    public ConcurrentPooledLinkedList(int maxPoolSize) {
        super(maxPoolSize);
    }

    public void add(T object) {
        this.lock.lockWrite();
        super.add(object);
        this.lock.unlockWrite();
    }

    public void addFirst(T object) {
        this.lock.lockWrite();
        super.addFirst(object);
        this.lock.unlockWrite();
    }

    public int size() {
        this.lock.lockRead();
        int i = super.size();
        this.lock.unlockRead();
        return i;
    }

    public void iter() {
        this.lock.lockWrite();
        super.iter();
        this.lock.unlockWrite();
    }

    public void iterReverse() {
        this.lock.lockWrite();
        super.iterReverse();
        this.lock.unlockWrite();
    }

    public T next() {
        this.lock.lockWrite();
        Object t = super.next();
        this.lock.unlockWrite();
        return (T)t;
    }

    public T previous() {
        this.lock.lockWrite();
        Object t = super.previous();
        this.lock.unlockWrite();
        return (T)t;
    }

    public void remove() {
        this.lock.lockWrite();
        super.remove();
        this.lock.unlockWrite();
    }

    public T removeLast() {
        this.lock.lockWrite();
        Object t = super.removeLast();
        this.lock.unlockWrite();
        return (T)t;
    }

    public void clear() {
        this.lock.lockWrite();
        super.clear();
        this.lock.unlockWrite();
    }

    @Override
    public ReadWriteLock getLock() {
        return this.lock;
    }
}

