/*
 * Decompiled with CFR 0.152.
 */
package org.mini2Dx.core.collections.concurrent;

import org.mini2Dx.core.collections.concurrent.ConcurrentCollection;
import org.mini2Dx.core.collections.concurrent.ConcurrentObjectMap;
import org.mini2Dx.core.collections.concurrent.ConcurrentReflectionPool;
import org.mini2Dx.gdx.utils.Array;
import org.mini2Dx.gdx.utils.Pool;

public class ConcurrentPools {
    private static final ConcurrentObjectMap<Class, Pool> typePools = new ConcurrentObjectMap();

    public static <T> Pool<T> get(Class<T> type, int max) {
        typePools.getLock().lockWrite();
        Object pool = typePools.get(type);
        if (pool == null) {
            pool = new ConcurrentReflectionPool<T>(type, 4, max);
            typePools.put(type, (Pool)pool);
        }
        typePools.getLock().unlockWrite();
        return pool;
    }

    public static <T> Pool<T> get(Class<T> type) {
        return ConcurrentPools.get(type, 100);
    }

    public static <T> void set(Class<T> type, Pool<T> pool) {
        typePools.put(type, pool);
    }

    public static <T> T obtain(Class<T> type) {
        return (T)ConcurrentPools.get(type).obtain();
    }

    public static void free(Object object) {
        if (object == null) {
            throw new IllegalArgumentException("object cannot be null.");
        }
        Pool pool = typePools.get(object.getClass());
        if (pool == null) {
            return;
        }
        pool.free(object);
    }

    public static void freeAll(Array objects) {
        ConcurrentPools.freeAll(objects, false);
    }

    public static void freeAll(Array objects, boolean samePool) {
        if (objects == null) {
            throw new IllegalArgumentException("objects cannot be null.");
        }
        boolean isObjectsConcurrent = objects instanceof ConcurrentCollection;
        if (isObjectsConcurrent) {
            ((ConcurrentCollection)objects).getLock().lockRead();
        }
        Pool pool = null;
        int n = objects.size;
        for (int i = 0; i < n; ++i) {
            Object object = objects.get(i);
            if (object == null || pool == null && (pool = typePools.get(object.getClass())) == null) continue;
            pool.free(object);
            if (samePool) continue;
            pool = null;
        }
        if (isObjectsConcurrent) {
            ((ConcurrentCollection)objects).getLock().unlockRead();
        }
    }

    private ConcurrentPools() {
    }
}

