/*
 * Decompiled with CFR 0.152.
 */
package org.mini2Dx.core.collections.concurrent;

import java.util.Iterator;
import org.mini2Dx.core.Mdx;
import org.mini2Dx.core.collections.concurrent.ConcurrentCollection;
import org.mini2Dx.gdx.utils.Queue;
import org.mini2Dx.lockprovider.ReadWriteLock;

public class ConcurrentQueue<T>
extends Queue<T>
implements ConcurrentCollection {
    protected ReadWriteLock lock = Mdx.locks.newReadWriteLock();

    public ConcurrentQueue() {
    }

    public ConcurrentQueue(int initialSize) {
        super(initialSize);
    }

    public ConcurrentQueue(int initialSize, Class<T> type) {
        super(initialSize, type);
    }

    public int size() {
        this.lock.lockRead();
        int result = this.size;
        this.lock.unlockRead();
        return result;
    }

    public void addLast(T object) {
        this.lock.lockWrite();
        super.addLast(object);
        this.lock.unlockWrite();
    }

    public void addFirst(T object) {
        this.lock.lockWrite();
        super.addFirst(object);
        this.lock.unlockWrite();
    }

    public void ensureCapacity(int additional) {
        this.lock.lockWrite();
        super.ensureCapacity(additional);
        this.lock.unlockWrite();
    }

    public T removeFirst() {
        this.lock.lockWrite();
        Object t = super.removeFirst();
        this.lock.unlockWrite();
        return (T)t;
    }

    public T removeLast() {
        this.lock.lockWrite();
        Object t = super.removeLast();
        this.lock.unlockWrite();
        return (T)t;
    }

    public int indexOf(T value, boolean identity) {
        this.lock.lockRead();
        int i = super.indexOf(value, identity);
        this.lock.unlockRead();
        return i;
    }

    public boolean removeValue(T value, boolean identity) {
        this.lock.lockWrite();
        boolean b = super.removeValue(value, identity);
        this.lock.unlockWrite();
        return b;
    }

    public T removeIndex(int index) {
        this.lock.lockWrite();
        Object t = super.removeIndex(index);
        this.lock.unlockWrite();
        return (T)t;
    }

    public boolean notEmpty() {
        this.lock.lockRead();
        boolean b = super.notEmpty();
        this.lock.unlockRead();
        return b;
    }

    public boolean isEmpty() {
        this.lock.lockRead();
        boolean b = super.isEmpty();
        this.lock.unlockRead();
        return b;
    }

    public T first() {
        this.lock.lockRead();
        Object t = super.first();
        this.lock.unlockRead();
        return (T)t;
    }

    public T last() {
        this.lock.lockRead();
        Object t = super.last();
        this.lock.unlockRead();
        return (T)t;
    }

    public T get(int index) {
        this.lock.lockRead();
        Object t = super.get(index);
        this.lock.unlockRead();
        return (T)t;
    }

    public void clear() {
        this.lock.lockWrite();
        super.clear();
        this.lock.unlockWrite();
    }

    public Iterator<T> iterator() {
        return new Queue.QueueIterator((Queue)this);
    }

    public int hashCode() {
        this.lock.lockRead();
        int i = super.hashCode();
        this.lock.unlockRead();
        return i;
    }

    public boolean equals(Object obj) {
        boolean isOtherConcurrent = obj instanceof ConcurrentCollection;
        if (isOtherConcurrent) {
            ((ConcurrentCollection)obj).getLock().lockRead();
        }
        this.lock.lockRead();
        boolean b = super.equals(obj);
        this.lock.unlockRead();
        if (isOtherConcurrent) {
            ((ConcurrentCollection)obj).getLock().unlockRead();
        }
        return b;
    }

    public String toString() {
        this.lock.lockRead();
        String s = super.toString();
        this.lock.unlockRead();
        return s;
    }

    public boolean equalsIdentity(Object o) {
        return super.equalsIdentity(o);
    }

    @Override
    public ReadWriteLock getLock() {
        return this.lock;
    }
}

