/*
 * Decompiled with CFR 0.152.
 */
package org.mini2Dx.core.collections.concurrent;

import org.mini2Dx.core.Mdx;
import org.mini2Dx.core.collections.concurrent.ConcurrentCollection;
import org.mini2Dx.gdx.utils.Array;
import org.mini2Dx.gdx.utils.ReflectionPool;
import org.mini2Dx.lockprovider.ReadWriteLock;

public class ConcurrentReflectionPool<T>
extends ReflectionPool<T>
implements ConcurrentCollection {
    protected ReadWriteLock lock = Mdx.locks.newReadWriteLock();

    public ConcurrentReflectionPool(Class<T> type) {
        super(type);
    }

    public ConcurrentReflectionPool(Class<T> type, int initialCapacity) {
        super(type, initialCapacity);
    }

    public ConcurrentReflectionPool(Class<T> type, int initialCapacity, int max) {
        super(type, initialCapacity, max);
    }

    public T obtain() {
        this.lock.lockWrite();
        Object t = super.obtain();
        this.lock.unlockWrite();
        return (T)t;
    }

    public void free(T object) {
        this.lock.lockWrite();
        super.free(object);
        this.lock.unlockWrite();
    }

    protected void reset(T object) {
        super.reset(object);
    }

    public void freeAll(Array<T> objects) {
        boolean isOtherConcurrent = objects instanceof ConcurrentCollection;
        if (isOtherConcurrent) {
            ((ConcurrentCollection)objects).getLock().lockRead();
        }
        super.freeAll(objects);
        if (isOtherConcurrent) {
            ((ConcurrentCollection)objects).getLock().unlockRead();
        }
    }

    public void clear() {
        this.lock.lockWrite();
        super.clear();
        this.lock.unlockWrite();
    }

    public int getFree() {
        this.lock.lockRead();
        int i = super.getFree();
        this.lock.unlockRead();
        return i;
    }

    @Override
    public ReadWriteLock getLock() {
        return this.lock;
    }
}

