/*
 * Decompiled with CFR 0.152.
 */
package org.mini2Dx.core.collections.concurrent;

import org.mini2Dx.core.Mdx;
import org.mini2Dx.core.collections.ShortMap;
import org.mini2Dx.core.collections.concurrent.ConcurrentCollection;
import org.mini2Dx.lockprovider.ReadWriteLock;

public class ConcurrentShortMap<T>
extends ShortMap<T>
implements ConcurrentCollection {
    protected ReadWriteLock lock = Mdx.locks.newReadWriteLock();

    public ConcurrentShortMap() {
    }

    public ConcurrentShortMap(int initialCapacity) {
        super(initialCapacity);
    }

    public ConcurrentShortMap(int initialCapacity, float loadFactor) {
        super(initialCapacity, loadFactor);
    }

    public ConcurrentShortMap(ShortMap<? extends T> map) {
        super(map);
    }

    public int size() {
        this.lock.lockRead();
        int result = this.size;
        this.lock.unlockRead();
        return result;
    }

    @Override
    public T put(short key, T value) {
        this.lock.lockWrite();
        T t = super.put(key, value);
        this.lock.unlockWrite();
        return t;
    }

    public boolean putIfAbsent(short key, T value) {
        boolean result = false;
        this.lock.lockWrite();
        if (!super.containsKey(key)) {
            super.put(key, value);
            result = true;
        }
        this.lock.unlockWrite();
        return result;
    }

    public boolean putIfPresent(short key, T value) {
        boolean result = false;
        this.lock.lockWrite();
        if (super.containsKey(key)) {
            super.put(key, value);
            result = true;
        }
        this.lock.unlockWrite();
        return result;
    }

    @Override
    public void putAll(ShortMap<T> map) {
        boolean isOtherConcurrent = map instanceof ConcurrentCollection;
        if (isOtherConcurrent) {
            ((ConcurrentCollection)((Object)map)).getLock().lockRead();
        }
        this.lock.lockWrite();
        super.putAll(map);
        this.lock.unlockWrite();
        if (isOtherConcurrent) {
            ((ConcurrentCollection)((Object)map)).getLock().unlockRead();
        }
    }

    @Override
    public T get(short key, T defaultValue) {
        this.lock.lockRead();
        T t = super.get(key, defaultValue);
        this.lock.unlockRead();
        return t;
    }

    @Override
    public T remove(short key) {
        this.lock.lockWrite();
        Object t = super.remove(key);
        this.lock.unlockWrite();
        return (T)t;
    }

    @Override
    public void shrink(int maximumCapacity) {
        this.lock.lockWrite();
        super.shrink(maximumCapacity);
        this.lock.unlockWrite();
    }

    @Override
    public void clear(int maximumCapacity) {
        this.lock.lockWrite();
        super.clear(maximumCapacity);
        this.lock.unlockWrite();
    }

    @Override
    public void clear() {
        this.lock.lockWrite();
        super.clear();
        this.lock.unlockWrite();
    }

    @Override
    public boolean containsValue(Object value, boolean identity) {
        this.lock.lockRead();
        boolean b = super.containsValue(value, identity);
        this.lock.unlockRead();
        return b;
    }

    @Override
    public boolean containsKey(short key) {
        this.lock.lockRead();
        boolean b = super.containsKey(key);
        this.lock.unlockRead();
        return b;
    }

    @Override
    public short findKey(Object value, boolean identity, short notFound) {
        this.lock.lockRead();
        short s = super.findKey(value, identity, notFound);
        this.lock.unlockRead();
        return s;
    }

    @Override
    public void ensureCapacity(int additionalCapacity) {
        this.lock.lockWrite();
        super.ensureCapacity(additionalCapacity);
        this.lock.unlockWrite();
    }

    @Override
    public int hashCode() {
        this.lock.lockRead();
        int hc = super.hashCode();
        this.lock.unlockRead();
        return hc;
    }

    @Override
    public boolean equals(Object object) {
        boolean isOtherConcurrent = object instanceof ConcurrentCollection;
        if (isOtherConcurrent) {
            ((ConcurrentCollection)object).getLock().lockRead();
        }
        this.lock.lockRead();
        boolean e = super.equals(object);
        this.lock.unlockRead();
        if (isOtherConcurrent) {
            ((ConcurrentCollection)object).getLock().unlockRead();
        }
        return e;
    }

    @Override
    public String toString() {
        this.lock.lockRead();
        String s = super.toString();
        this.lock.unlockRead();
        return s;
    }

    @Override
    public ShortMap.Entries<T> entries() {
        return new ShortMap.Entries((ShortMap)this);
    }

    @Override
    public ShortMap.Values<T> values() {
        return new ShortMap.Values(this);
    }

    @Override
    public ShortMap.Keys keys() {
        return new ShortMap.Keys((ShortMap)this);
    }

    @Override
    public ReadWriteLock getLock() {
        return this.lock;
    }
}

