/*
 * Decompiled with CFR 0.152.
 */
package org.mini2Dx.core.collections.concurrent;

import java.util.Iterator;
import org.mini2Dx.core.Mdx;
import org.mini2Dx.core.collections.concurrent.ConcurrentCollection;
import org.mini2Dx.gdx.utils.SortedIntList;
import org.mini2Dx.lockprovider.ReadWriteLock;

public class ConcurrentSortedIntList<E>
extends SortedIntList<E>
implements ConcurrentCollection {
    protected ReadWriteLock lock = Mdx.locks.newReadWriteLock();

    public E insert(int index, E value) {
        this.lock.lockWrite();
        Object e = super.insert(index, value);
        this.lock.unlockWrite();
        return (E)e;
    }

    public E get(int index) {
        this.lock.lockRead();
        Object e = super.get(index);
        this.lock.unlockRead();
        return (E)e;
    }

    public void clear() {
        this.lock.lockWrite();
        super.clear();
        this.lock.unlockWrite();
    }

    public int size() {
        this.lock.lockRead();
        int i = super.size();
        this.lock.unlockRead();
        return i;
    }

    public boolean notEmpty() {
        this.lock.lockRead();
        boolean b = super.notEmpty();
        this.lock.unlockRead();
        return b;
    }

    public boolean isEmpty() {
        this.lock.lockRead();
        boolean b = super.isEmpty();
        this.lock.unlockRead();
        return b;
    }

    public Iterator<SortedIntList.Node<E>> iterator() {
        return super.iterator();
    }

    @Override
    public ReadWriteLock getLock() {
        return this.lock;
    }
}

