/*
 * Decompiled with CFR 0.152.
 */
package org.mini2Dx.core.collision;

import org.mini2Dx.core.Graphics;
import org.mini2Dx.core.collision.CellGrid;
import org.mini2Dx.core.collision.CollisionArea;
import org.mini2Dx.core.collision.CollisionDetection;
import org.mini2Dx.core.geom.LineSegment;
import org.mini2Dx.core.geom.Point;
import org.mini2Dx.core.geom.Rectangle;
import org.mini2Dx.core.geom.Shape;
import org.mini2Dx.gdx.utils.Array;
import org.mini2Dx.gdx.utils.IntMap;
import org.mini2Dx.gdx.utils.IntSet;

public class Cell<T extends CollisionArea>
extends Rectangle
implements CollisionDetection<T> {
    private final IntMap<T> elements = new IntMap();

    public Cell(int x, int y, int width, int height) {
        super(x, y, width, height);
    }

    @Override
    public void debugRender(Graphics g) {
        g.setColor(CellGrid.ELEMENT_COLOR);
        for (CollisionArea element : this.elements.values()) {
            g.drawRect(element.getX(), element.getY(), element.getWidth(), element.getHeight());
        }
    }

    @Override
    public boolean add(T element) {
        if (this.elements.containsKey(element.getId())) {
            return false;
        }
        this.elements.put(element.getId(), element);
        element.addPostionChangeListener(this);
        return true;
    }

    @Override
    public boolean remove(T element) {
        if (this.elements.remove(element.getId()) != null) {
            element.removePositionChangeListener(this);
            return true;
        }
        return false;
    }

    @Override
    public void addAll(Array<T> elements) {
        for (int i = 0; i < elements.size; ++i) {
            this.add((T)((CollisionArea)elements.get(i)));
        }
    }

    @Override
    public void removeAll(Array<T> elements) {
        for (int i = 0; i < elements.size; ++i) {
            this.add((T)((CollisionArea)elements.get(i)));
        }
    }

    @Override
    public void clear() {
        this.elements.clear();
    }

    @Override
    public Array<T> getElementsWithinArea(Shape area) {
        Array result = new Array();
        this.getElementsWithinArea(result, area);
        return result;
    }

    @Override
    public void getElementsWithinArea(Array<T> result, Shape area) {
        IntMap.Keys keys = this.elements.keys();
        while (keys.hasNext) {
            CollisionArea element = (CollisionArea)this.elements.get(keys.next());
            if (element == null || !area.contains(element) && !area.intersects(element)) continue;
            result.add((Object)element);
        }
    }

    @Override
    public void getElementsWithinArea(IntMap<T> result, Shape area) {
        IntMap.Keys keys = this.elements.keys();
        while (keys.hasNext) {
            CollisionArea element = (CollisionArea)this.elements.get(keys.next());
            if (element == null || result.containsKey(element.getId()) || !area.contains(element) && !area.intersects(element)) continue;
            result.put(element.getId(), (Object)element);
        }
    }

    @Override
    public Array<T> getElementsWithinAreaIgnoringEdges(Shape area) {
        Array result = new Array();
        this.getElementsWithinAreaIgnoringEdges(result, area);
        return result;
    }

    @Override
    public void getElementsWithinAreaIgnoringEdges(Array<T> result, Shape area) {
        IntMap.Keys keys = this.elements.keys();
        while (keys.hasNext) {
            CollisionArea element = (CollisionArea)this.elements.get(keys.next());
            if (element == null || !area.contains(element) && !area.intersectsIgnoringEdges(element)) continue;
            result.add((Object)element);
        }
    }

    @Override
    public void getElementsWithinAreaIgnoringEdges(IntMap<T> result, Shape area) {
        IntMap.Keys keys = this.elements.keys();
        while (keys.hasNext) {
            CollisionArea element = (CollisionArea)this.elements.get(keys.next());
            if (element == null || result.containsKey(element.getId()) || !area.contains(element) && !area.intersectsIgnoringEdges(element)) continue;
            result.put(element.getId(), (Object)element);
        }
    }

    @Override
    public Array<T> getElementsContainingArea(Shape area, boolean entirelyContained) {
        Array result = new Array();
        this.getElementsContainingArea(result, area, entirelyContained);
        return result;
    }

    @Override
    public void getElementsContainingArea(Array<T> result, Shape area, boolean entirelyContained) {
        if (entirelyContained) {
            IntMap.Keys keys = this.elements.keys();
            while (keys.hasNext) {
                CollisionArea element = (CollisionArea)this.elements.get(keys.next());
                if (element == null || !element.contains(area)) continue;
                result.add((Object)element);
            }
        } else {
            IntMap.Keys keys = this.elements.keys();
            while (keys.hasNext) {
                CollisionArea element = (CollisionArea)this.elements.get(keys.next());
                if (element == null || !element.contains(area) && !element.intersects(area) || area.getWidth() > element.getWidth() || area.getHeight() > element.getHeight()) continue;
                result.add((Object)element);
            }
        }
    }

    @Override
    public void getElementsContainingArea(IntMap<T> result, Shape area, boolean entirelyContained) {
        if (entirelyContained) {
            IntMap.Keys keys = this.elements.keys();
            while (keys.hasNext) {
                CollisionArea element = (CollisionArea)this.elements.get(keys.next());
                if (element == null || result.containsKey(element.getId()) || !element.contains(area)) continue;
                result.put(element.getId(), (Object)element);
            }
        } else {
            IntMap.Keys keys = this.elements.keys();
            while (keys.hasNext) {
                CollisionArea element = (CollisionArea)this.elements.get(keys.next());
                if (element == null || result.containsKey(element.getId()) || !element.contains(area) && !element.intersects(area) || area.getWidth() > element.getWidth() || area.getHeight() > element.getHeight()) continue;
                result.put(element.getId(), (Object)element);
            }
        }
    }

    @Override
    public Array<T> getElementsIntersectingLineSegment(LineSegment lineSegment) {
        Array result = new Array();
        this.getElementsIntersectingLineSegment(result, lineSegment);
        return result;
    }

    @Override
    public void getElementsIntersectingLineSegment(Array<T> result, LineSegment lineSegment) {
        IntMap.Keys keys = this.elements.keys();
        while (keys.hasNext) {
            CollisionArea element = (CollisionArea)this.elements.get(keys.next());
            if (element == null || !element.intersects(lineSegment)) continue;
            result.add((Object)element);
        }
    }

    @Override
    public void getElementsIntersectingLineSegment(IntMap<T> result, LineSegment lineSegment) {
        IntMap.Keys keys = this.elements.keys();
        while (keys.hasNext) {
            CollisionArea element = (CollisionArea)this.elements.get(keys.next());
            if (element == null || result.containsKey(element.getId()) || !element.intersects(lineSegment)) continue;
            result.put(element.getId(), (Object)element);
        }
    }

    @Override
    public Array<T> getElementsContainingPoint(Point point) {
        Array result = new Array();
        this.getElementsContainingPoint(result, point);
        return result;
    }

    @Override
    public void getElementsContainingPoint(Array<T> result, Point point) {
        IntMap.Keys keys = this.elements.keys();
        while (keys.hasNext) {
            CollisionArea element = (CollisionArea)this.elements.get(keys.next());
            if (element == null || !element.contains(point)) continue;
            result.add((Object)element);
        }
    }

    @Override
    public void getElementsContainingPoint(IntMap<T> result, Point point) {
        IntMap.Keys keys = this.elements.keys();
        while (keys.hasNext) {
            CollisionArea element = (CollisionArea)this.elements.get(keys.next());
            if (element == null || result.containsKey(element.getId()) || !element.contains(point)) continue;
            result.put(element.getId(), (Object)element);
        }
    }

    @Override
    public Array<T> getElements() {
        return this.elements.values().toArray();
    }

    @Override
    public void getElements(Array<T> result) {
        for (CollisionArea element : this.elements.values()) {
            result.add((Object)element);
        }
    }

    @Override
    public void getElements(IntMap<T> result) {
        result.putAll(this.elements);
    }

    @Override
    public int getTotalElements() {
        return this.elements.size;
    }

    public void getTotalElements(IntSet ids) {
        for (CollisionArea element : this.elements.values()) {
            ids.add(element.getId());
        }
    }

    @Override
    public void positionChanged(T moved) {
        if (moved.getMaxX() < this.getX()) {
            this.remove(moved);
            return;
        }
        if (moved.getMaxY() < this.getY()) {
            this.remove(moved);
            return;
        }
        if (moved.getX() > this.getMaxX()) {
            this.remove(moved);
            return;
        }
        if (moved.getY() > this.getMaxY()) {
            this.remove(moved);
            return;
        }
    }
}

