/*
 * Decompiled with CFR 0.152.
 */
package org.mini2Dx.core.collision;

import org.mini2Dx.core.Graphics;
import org.mini2Dx.core.Mdx;
import org.mini2Dx.core.collision.Cell;
import org.mini2Dx.core.collision.CollisionArea;
import org.mini2Dx.core.collision.CollisionDetection;
import org.mini2Dx.core.exception.MdxException;
import org.mini2Dx.core.geom.LineSegment;
import org.mini2Dx.core.geom.Point;
import org.mini2Dx.core.geom.Rectangle;
import org.mini2Dx.core.geom.Shape;
import org.mini2Dx.core.geom.SizeChangeListener;
import org.mini2Dx.core.graphics.Color;
import org.mini2Dx.gdx.math.MathUtils;
import org.mini2Dx.gdx.utils.Array;
import org.mini2Dx.gdx.utils.IntMap;
import org.mini2Dx.gdx.utils.IntSet;

public class CellGrid<T extends CollisionArea>
extends Rectangle
implements CollisionDetection<T>,
SizeChangeListener<T> {
    public static Color QUAD_COLOR = Mdx.graphics != null ? Mdx.graphics.newColor(1.0f, 0.0f, 0.0f, 0.5f) : null;
    public static Color ELEMENT_COLOR = Mdx.graphics != null ? Mdx.graphics.newColor(0.0f, 0.0f, 1.0f, 0.5f) : null;
    private final int cellWidth;
    private final int cellHeight;
    private final Cell<T>[][] cells;
    private final IntMap<T> tmpCollisions = new IntMap();
    private final Array<Cell<T>> tmpCells = new Array();

    public CellGrid(int x, int y, int width, int height, int cellWidth, int cellHeight) {
        super(x, y, width, height);
        this.cellWidth = cellWidth;
        this.cellHeight = cellHeight;
        if (width % cellWidth != 0) {
            throw new MdxException("Width of grid must be divisible by cell width");
        }
        if (height % cellHeight != 0) {
            throw new MdxException("Height of grid must be divisible by cell height");
        }
        this.cells = new Cell[width / cellWidth][height / cellHeight];
    }

    @Override
    public void debugRender(Graphics g) {
        Color tmp = g.getColor();
        for (int x = 0; x < this.cells.length; ++x) {
            for (int y = 0; y < this.cells[0].length; ++y) {
                if (this.cells[x][y] == null || this.cells[x][y].getX() - g.getTranslationX() > g.getViewportWidth() || this.cells[x][y].getY() - g.getTranslationY() > g.getViewportHeight() || this.cells[x][y].getMaxX() - g.getTranslationX() < 0.0f || this.cells[x][y].getMaxY() - g.getTranslationY() < 0.0f) continue;
                this.cells[x][y].debugRender(g);
                g.setColor(QUAD_COLOR);
                g.drawRect(this.cells[x][y].getX(), this.cells[x][y].getY(), this.cells[x][y].getWidth(), this.cells[x][y].getHeight());
            }
        }
        g.setColor(tmp);
    }

    @Override
    public boolean add(T element) {
        this.tmpCells.clear();
        this.getOrCreateFor(element, this.tmpCells);
        if (this.tmpCells.size == 0) {
            return false;
        }
        for (int i = 0; i < this.tmpCells.size; ++i) {
            ((Cell)this.tmpCells.get(i)).add(element);
        }
        element.addPostionChangeListener(this);
        element.addSizeChangeListener(this);
        return true;
    }

    @Override
    public boolean remove(T element) {
        this.tmpCells.clear();
        this.getOrCreateFor(element, this.tmpCells);
        boolean result = false;
        for (int i = 0; i < this.tmpCells.size; ++i) {
            result |= ((Cell)this.tmpCells.get(i)).remove(element);
        }
        element.removePositionChangeListener(this);
        element.removeSizeChangeListener(this);
        return result;
    }

    @Override
    public void addAll(Array<T> elements) {
        for (int i = 0; i < elements.size; ++i) {
            this.add((T)((CollisionArea)elements.get(i)));
        }
    }

    @Override
    public void removeAll(Array<T> elements) {
        for (int i = 0; i < elements.size; ++i) {
            this.remove((T)((CollisionArea)elements.get(i)));
        }
    }

    @Override
    public void clear() {
        for (int x = 0; x < this.cells.length; ++x) {
            for (int y = 0; y < this.cells[0].length; ++y) {
                if (this.cells[x][y] == null) continue;
                this.cells[x][y].clear();
            }
        }
    }

    @Override
    public Array<T> getElementsWithinArea(Shape area) {
        Array result = new Array();
        this.getElementsWithinArea(result, area);
        return result;
    }

    @Override
    public void getElementsWithinArea(Array<T> result, Shape area) {
        this.tmpCollisions.clear();
        this.getElementsWithinArea(this.tmpCollisions, area);
        IntMap.Keys keys = this.tmpCollisions.keys();
        while (keys.hasNext) {
            int id = keys.next();
            result.add(this.tmpCollisions.get(id));
        }
    }

    @Override
    public void getElementsWithinArea(IntMap<T> result, Shape area) {
        int minCellX = MathUtils.floor((float)((area.getMinX() - this.getX()) / (float)this.cellWidth));
        int minCellY = MathUtils.floor((float)((area.getMinY() - this.getY()) / (float)this.cellHeight));
        int maxCellX = MathUtils.ceil((float)((area.getMaxX() - this.getX()) / (float)this.cellWidth));
        int maxCellY = MathUtils.ceil((float)((area.getMaxY() - this.getY()) / (float)this.cellHeight));
        for (int x = minCellX; x <= maxCellX; ++x) {
            for (int y = minCellY; y <= maxCellY; ++y) {
                Cell<T> cell = this.getOrCreateCell(x, y);
                if (cell == null) continue;
                cell.getElementsWithinArea(result, area);
            }
        }
    }

    @Override
    public Array<T> getElementsWithinAreaIgnoringEdges(Shape area) {
        Array result = new Array();
        this.getElementsWithinAreaIgnoringEdges(result, area);
        return result;
    }

    @Override
    public void getElementsWithinAreaIgnoringEdges(Array<T> result, Shape area) {
        this.tmpCollisions.clear();
        this.getElementsWithinAreaIgnoringEdges(this.tmpCollisions, area);
        IntMap.Keys keys = this.tmpCollisions.keys();
        while (keys.hasNext) {
            int id = keys.next();
            result.add(this.tmpCollisions.get(id));
        }
    }

    @Override
    public void getElementsWithinAreaIgnoringEdges(IntMap<T> result, Shape area) {
        int minCellX = MathUtils.floor((float)((area.getMinX() - this.getX()) / (float)this.cellWidth));
        int minCellY = MathUtils.floor((float)((area.getMinY() - this.getY()) / (float)this.cellHeight));
        int maxCellX = MathUtils.ceil((float)((area.getMaxX() - this.getX()) / (float)this.cellWidth));
        int maxCellY = MathUtils.ceil((float)((area.getMaxY() - this.getY()) / (float)this.cellHeight));
        for (int x = minCellX; x <= maxCellX; ++x) {
            for (int y = minCellY; y <= maxCellY; ++y) {
                Cell<T> cell = this.getOrCreateCell(x, y);
                if (cell == null) continue;
                cell.getElementsWithinAreaIgnoringEdges(result, area);
            }
        }
    }

    @Override
    public Array<T> getElementsContainingArea(Shape area, boolean entirelyContained) {
        Array result = new Array();
        this.getElementsContainingArea(result, area, entirelyContained);
        return result;
    }

    @Override
    public void getElementsContainingArea(Array<T> result, Shape area, boolean entirelyContained) {
        this.tmpCollisions.clear();
        this.getElementsContainingArea(this.tmpCollisions, area, entirelyContained);
        IntMap.Keys keys = this.tmpCollisions.keys();
        while (keys.hasNext) {
            int id = keys.next();
            result.add(this.tmpCollisions.get(id));
        }
    }

    @Override
    public void getElementsContainingArea(IntMap<T> result, Shape area, boolean entirelyContained) {
        int minCellX = MathUtils.floor((float)((area.getMinX() - this.getX()) / (float)this.cellWidth));
        int minCellY = MathUtils.floor((float)((area.getMinY() - this.getY()) / (float)this.cellHeight));
        int maxCellX = MathUtils.ceil((float)((area.getMaxX() - this.getX()) / (float)this.cellWidth));
        int maxCellY = MathUtils.ceil((float)((area.getMaxY() - this.getY()) / (float)this.cellHeight));
        for (int x = minCellX; x <= maxCellX; ++x) {
            for (int y = minCellY; y <= maxCellY; ++y) {
                Cell<T> cell = this.getOrCreateCell(x, y);
                if (cell == null) continue;
                cell.getElementsContainingArea(result, area, entirelyContained);
            }
        }
    }

    @Override
    public Array<T> getElementsIntersectingLineSegment(LineSegment lineSegment) {
        Array result = new Array();
        this.getElementsIntersectingLineSegment(result, lineSegment);
        return result;
    }

    @Override
    public void getElementsIntersectingLineSegment(Array<T> result, LineSegment lineSegment) {
        this.tmpCollisions.clear();
        this.getElementsIntersectingLineSegment(this.tmpCollisions, lineSegment);
        IntMap.Keys keys = this.tmpCollisions.keys();
        while (keys.hasNext) {
            int id = keys.next();
            result.add(this.tmpCollisions.get(id));
        }
    }

    @Override
    public void getElementsIntersectingLineSegment(IntMap<T> result, LineSegment lineSegment) {
        int minCellX = MathUtils.floor((float)((lineSegment.getMinX() - this.getX()) / (float)this.cellWidth));
        int minCellY = MathUtils.floor((float)((lineSegment.getMinY() - this.getY()) / (float)this.cellHeight));
        int maxCellX = MathUtils.ceil((float)((lineSegment.getMaxX() - this.getX()) / (float)this.cellWidth));
        int maxCellY = MathUtils.ceil((float)((lineSegment.getMaxY() - this.getY()) / (float)this.cellHeight));
        for (int x = minCellX; x <= maxCellX; ++x) {
            for (int y = minCellY; y <= maxCellY; ++y) {
                Cell<T> cell = this.getOrCreateCell(x, y);
                if (cell == null) continue;
                cell.getElementsIntersectingLineSegment(result, lineSegment);
            }
        }
    }

    @Override
    public Array<T> getElementsContainingPoint(Point point) {
        Array result = new Array();
        this.getElementsContainingPoint(result, point);
        return result;
    }

    @Override
    public void getElementsContainingPoint(Array<T> result, Point point) {
        this.tmpCollisions.clear();
        this.getElementsContainingPoint(this.tmpCollisions, point);
        IntMap.Keys keys = this.tmpCollisions.keys();
        while (keys.hasNext) {
            int id = keys.next();
            result.add(this.tmpCollisions.get(id));
        }
    }

    @Override
    public void getElementsContainingPoint(IntMap<T> result, Point point) {
        int cellY;
        int cellX = MathUtils.floor((float)((point.getX() - this.getX()) / (float)this.cellWidth));
        Cell<T> cell = this.getOrCreateCell(cellX, cellY = MathUtils.floor((float)((point.getY() - this.getY()) / (float)this.cellHeight)));
        if (cell == null) {
            return;
        }
        cell.getElementsContainingPoint(result, point);
    }

    @Override
    public Array<T> getElements() {
        Array result = new Array();
        this.getElements(result);
        return result;
    }

    @Override
    public void getElements(Array<T> result) {
        IntMap elements = new IntMap();
        for (int x = 0; x < this.cells.length; ++x) {
            for (int y = 0; y < this.cells[0].length; ++y) {
                if (this.cells[x][y] == null) continue;
                this.cells[x][y].getElements(elements);
            }
        }
        for (CollisionArea element : elements.values()) {
            result.addAll((Object[])new CollisionArea[]{element});
        }
    }

    @Override
    public int getTotalElements() {
        IntSet result = new IntSet();
        for (int x = 0; x < this.cells.length; ++x) {
            for (int y = 0; y < this.cells[0].length; ++y) {
                if (this.cells[x][y] == null) continue;
                this.cells[x][y].getTotalElements(result);
            }
        }
        return result.size;
    }

    @Override
    public void positionChanged(T moved) {
        int minCellX = MathUtils.floor((float)((moved.getMinX() - this.getX()) / (float)this.cellWidth));
        int minCellY = MathUtils.floor((float)((moved.getMinY() - this.getY()) / (float)this.cellHeight));
        int maxCellX = MathUtils.ceil((float)((moved.getMaxX() - this.getX()) / (float)this.cellWidth));
        int maxCellY = MathUtils.ceil((float)((moved.getMaxY() - this.getY()) / (float)this.cellHeight));
        for (int x = minCellX; x <= maxCellX; ++x) {
            for (int y = minCellY; y <= maxCellY; ++y) {
                Cell<T> cell = this.getOrCreateCell(x, y);
                if (cell == null) continue;
                cell.add(moved);
            }
        }
    }

    @Override
    public void sizeChanged(T changed) {
        int minCellX = MathUtils.floor((float)((changed.getMinX() - this.getX()) / (float)this.cellWidth));
        int minCellY = MathUtils.floor((float)((changed.getMinY() - this.getY()) / (float)this.cellHeight));
        int maxCellX = MathUtils.ceil((float)((changed.getMaxX() - this.getX()) / (float)this.cellWidth));
        int maxCellY = MathUtils.ceil((float)((changed.getMaxY() - this.getY()) / (float)this.cellHeight));
        for (int x = minCellX; x <= maxCellX; ++x) {
            for (int y = minCellY; y <= maxCellY; ++y) {
                Cell<T> cell = this.getOrCreateCell(x, y);
                if (cell == null) continue;
                cell.add(changed);
            }
        }
    }

    private void getOrCreateFor(T sizeable, Array<Cell<T>> results) {
        int minCellX = MathUtils.floor((float)((sizeable.getMinX() - this.getX()) / (float)this.cellWidth));
        int minCellY = MathUtils.floor((float)((sizeable.getMinY() - this.getY()) / (float)this.cellHeight));
        int maxCellX = MathUtils.ceil((float)((sizeable.getMaxX() - this.getX()) / (float)this.cellWidth));
        int maxCellY = MathUtils.ceil((float)((sizeable.getMaxY() - this.getY()) / (float)this.cellHeight));
        for (int x = minCellX; x <= maxCellX; ++x) {
            for (int y = minCellY; y <= maxCellY; ++y) {
                Cell<T> cell = this.getOrCreateCell(x, y);
                if (cell == null) continue;
                results.add(cell);
            }
        }
    }

    private Cell<T> getOrCreateCell(int cellX, int cellY) {
        if (cellX < 0) {
            return null;
        }
        if (cellY < 0) {
            return null;
        }
        if (cellX >= this.cells.length) {
            return null;
        }
        if (cellY >= this.cells[0].length) {
            return null;
        }
        Cell<T> result = this.cells[cellX][cellY];
        if (result == null) {
            this.cells[cellX][cellY] = result = new Cell(MathUtils.round((float)(this.getX() + (float)(cellX * this.cellWidth))), MathUtils.round((float)(this.getY() + (float)(cellY * this.cellWidth))), this.cellWidth, this.cellHeight);
        }
        return result;
    }
}

