/*
 * Decompiled with CFR 0.152.
 */
package org.mini2Dx.core.collision;

import org.mini2Dx.core.Mdx;
import org.mini2Dx.core.TimestepMode;
import org.mini2Dx.core.collision.CollisionArea;
import org.mini2Dx.core.collision.CollisionIdSequence;
import org.mini2Dx.core.collision.Collisions;
import org.mini2Dx.core.collision.RenderCoordMode;
import org.mini2Dx.core.geom.PositionChangeListener;
import org.mini2Dx.core.geom.Positionable;
import org.mini2Dx.core.geom.Rectangle;
import org.mini2Dx.core.geom.SizeChangeListener;
import org.mini2Dx.core.geom.Sizeable;
import org.mini2Dx.core.util.HashUtils;
import org.mini2Dx.core.util.InterpolationTracker;
import org.mini2Dx.gdx.math.MathUtils;
import org.mini2Dx.gdx.utils.Array;
import org.mini2Dx.lockprovider.ReadWriteLock;

public class CollisionBox
extends Rectangle
implements CollisionArea,
PositionChangeListener<CollisionBox>,
SizeChangeListener<CollisionBox> {
    private final ReadWriteLock positionChangeListenerLock;
    private final ReadWriteLock sizeChangeListenerLock;
    private final Rectangle previousRectangle;
    private final Rectangle renderRectangle;
    protected Collisions collisions = null;
    private int id;
    private RenderCoordMode renderCoordMode = RenderCoordMode.GLOBAL_DEFAULT;
    private int renderX;
    private int renderY;
    private int renderWidth;
    private int renderHeight;
    private boolean interpolateRequired = false;

    public CollisionBox() {
        this(0.0f, 0.0f, 1.0f, 1.0f);
    }

    public CollisionBox(int id) {
        this(id, 0.0f, 0.0f, 1.0f, 1.0f);
    }

    public CollisionBox(float x, float y, float width, float height) {
        this(CollisionIdSequence.nextId(), x, y, width, height);
    }

    public CollisionBox(int id, float x, float y, float width, float height) {
        super(x, y, width, height);
        this.positionChangeListenerLock = Mdx.locks.newReadWriteLock();
        this.sizeChangeListenerLock = Mdx.locks.newReadWriteLock();
        this.addPostionChangeListener(this);
        this.addSizeChangeListener(this);
        this.previousRectangle = Mdx.geom.rectangle();
        this.renderRectangle = Mdx.geom.rectangle();
        this.init(id, x, y, width, height);
    }

    public CollisionBox(int id, Collisions collisions) {
        this(id);
        this.collisions = collisions;
    }

    protected void init(int id, float x, float y, float width, float height) {
        this.id = id;
        this.disposed = false;
        InterpolationTracker.register(this);
        this.forceTo(x, y, width, height);
    }

    private void storeRenderCoordinates() {
        this.renderX = this.renderCoordMode.apply(this.renderRectangle.getX());
        this.renderY = this.renderCoordMode.apply(this.renderRectangle.getY());
        this.renderWidth = this.renderCoordMode.apply(this.renderRectangle.getWidth());
        this.renderHeight = this.renderCoordMode.apply(this.renderRectangle.getHeight());
    }

    protected void release() {
        this.collisions.release(this);
    }

    @Override
    public void dispose() {
        if (this.disposed) {
            return;
        }
        InterpolationTracker.deregister(this);
        if (this.collisions != null) {
            this.clearPositionChangeListeners();
            this.clearSizeChangeListeners();
            this.addPostionChangeListener(this);
            this.addSizeChangeListener(this);
            this.disposed = true;
            this.release();
            return;
        }
        super.dispose();
        this.previousRectangle.dispose();
        this.renderRectangle.dispose();
    }

    @Override
    public void forceTo(float x, float y) {
        this.forceTo(x, y, this.getWidth(), this.getHeight());
    }

    @Override
    public CollisionArea setTo(float x, float y, float width, float height) {
        this.set(x, y, width, height);
        return this;
    }

    @Override
    public void forceTo(float x, float y, float width, float height) {
        super.set(x, y, width, height);
        this.previousRectangle.set(x, y, width, height);
        this.renderRectangle.set(this.previousRectangle);
        this.storeRenderCoordinates();
        this.interpolateRequired = false;
    }

    @Override
    public void forceToWidth(float width) {
        super.setWidth(width);
        this.previousRectangle.set(this);
        this.renderRectangle.set(this);
        this.storeRenderCoordinates();
        this.notifySizeChangeListeners();
    }

    @Override
    public void forceToHeight(float height) {
        super.setHeight(height);
        this.previousRectangle.set(this);
        this.renderRectangle.set(this);
        this.storeRenderCoordinates();
        this.notifySizeChangeListeners();
    }

    @Override
    public int getRenderWidth() {
        return this.renderWidth;
    }

    @Override
    public int getRenderHeight() {
        return this.renderHeight;
    }

    @Override
    public float getRawRenderWidth() {
        return this.renderRectangle.getWidth();
    }

    @Override
    public float getRawRenderHeight() {
        return this.renderRectangle.getHeight();
    }

    @Override
    public void preUpdate() {
        this.previousRectangle.set(this);
    }

    @Override
    public void interpolate(float alpha) {
        if (!this.interpolateRequired) {
            return;
        }
        if (Mdx.timestepMode.equals((Object)TimestepMode.DEFAULT)) {
            this.renderRectangle.set(this);
            this.storeRenderCoordinates();
            this.interpolateRequired = false;
            return;
        }
        this.previousRectangle.lerp(this.renderRectangle, this, alpha);
        this.storeRenderCoordinates();
        if (this.renderX != MathUtils.round((float)this.getX())) {
            return;
        }
        if (this.renderY != MathUtils.round((float)this.getY())) {
            return;
        }
        if (this.renderWidth != MathUtils.round((float)this.getWidth())) {
            return;
        }
        if (this.renderHeight != MathUtils.round((float)this.getHeight())) {
            return;
        }
        this.interpolateRequired = false;
    }

    @Override
    public int getRenderX() {
        return this.renderX;
    }

    @Override
    public int getRenderY() {
        return this.renderY;
    }

    @Override
    public float getRawRenderX() {
        return this.renderRectangle.getX();
    }

    @Override
    public float getRawRenderY() {
        return this.renderRectangle.getY();
    }

    @Override
    public RenderCoordMode getRenderCoordMode() {
        return this.renderCoordMode;
    }

    @Override
    public void setRenderCoordMode(RenderCoordMode mode) {
        if (mode == null) {
            return;
        }
        this.renderCoordMode = mode;
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public void positionChanged(CollisionBox moved) {
        if (moved.getId() != this.id) {
            return;
        }
        this.interpolateRequired = true;
    }

    @Override
    public void sizeChanged(CollisionBox changed) {
        if (changed.getId() != this.id) {
            return;
        }
        this.interpolateRequired = true;
    }

    @Override
    public <T extends Positionable> void addPostionChangeListener(PositionChangeListener<T> listener) {
        this.positionChangeListenerLock.lockWrite();
        this.positionChangeListeners.add(listener);
        this.positionChangeListenerLock.unlockWrite();
    }

    @Override
    public <T extends Positionable> void removePositionChangeListener(PositionChangeListener<T> listener) {
        CollisionBox.removePositionListener(this.positionChangeListenerLock, (Array<PositionChangeListener>)this.positionChangeListeners, listener);
    }

    @Override
    public <T extends Sizeable> void addSizeChangeListener(SizeChangeListener<T> listener) {
        this.sizeChangeListenerLock.lockWrite();
        this.sizeChangeListeners.add(listener);
        this.sizeChangeListenerLock.unlockWrite();
    }

    @Override
    public <T extends Sizeable> void removeSizeChangeListener(SizeChangeListener<T> listener) {
        CollisionBox.removeSizeListener(this.sizeChangeListenerLock, (Array<SizeChangeListener>)this.sizeChangeListeners, listener);
    }

    @Override
    protected void notifyPositionChangeListeners() {
        CollisionBox.notifyPositionListeners(this.positionChangeListenerLock, (Array<PositionChangeListener>)this.positionChangeListeners, this);
    }

    @Override
    protected void clearPositionChangeListeners() {
        CollisionBox.clearPositionListeners(this.positionChangeListenerLock, (Array<PositionChangeListener>)this.positionChangeListeners);
    }

    @Override
    protected void notifySizeChangeListeners() {
        CollisionBox.notifySizeListeners(this.sizeChangeListenerLock, (Array<SizeChangeListener>)this.sizeChangeListeners, this);
    }

    @Override
    protected void clearSizeChangeListeners() {
        CollisionBox.clearSizeListeners(this.sizeChangeListenerLock, (Array<SizeChangeListener>)this.sizeChangeListeners);
    }

    public boolean isInterpolateRequired() {
        return this.interpolateRequired;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof CollisionBox)) {
            return false;
        }
        CollisionBox that = (CollisionBox)o;
        if (this.id != that.id) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    public int hashCode() {
        return HashUtils.hashCode(this.id);
    }

    @Override
    public String toString() {
        return "CollisionBox [id=" + this.id + ", x=" + this.getX() + ", y=" + this.getY() + ", width=" + this.getWidth() + ", height=" + this.getHeight() + ", getRotation()=" + this.getRotation() + ", renderRectangle=" + this.renderRectangle + "]";
    }
}

