/*
 * Decompiled with CFR 0.152.
 */
package org.mini2Dx.core.collision;

import org.mini2Dx.core.Mdx;
import org.mini2Dx.core.TimestepMode;
import org.mini2Dx.core.collision.CollisionArea;
import org.mini2Dx.core.collision.CollisionIdSequence;
import org.mini2Dx.core.collision.Collisions;
import org.mini2Dx.core.collision.RenderCoordMode;
import org.mini2Dx.core.geom.Circle;
import org.mini2Dx.core.geom.PositionChangeListener;
import org.mini2Dx.core.geom.Positionable;
import org.mini2Dx.core.geom.SizeChangeListener;
import org.mini2Dx.core.geom.Sizeable;
import org.mini2Dx.core.util.HashUtils;
import org.mini2Dx.core.util.InterpolationTracker;
import org.mini2Dx.gdx.math.MathUtils;
import org.mini2Dx.gdx.utils.Array;
import org.mini2Dx.lockprovider.ReadWriteLock;

public class CollisionCircle
extends Circle
implements CollisionArea,
PositionChangeListener<CollisionCircle>,
SizeChangeListener<CollisionCircle> {
    private final ReadWriteLock positionChangeListenerLock;
    private final ReadWriteLock sizeChangeListenerLock;
    private final Circle previousCircle;
    private final Circle renderCircle;
    protected Collisions collisions = null;
    private int id;
    private RenderCoordMode renderCoordMode = RenderCoordMode.GLOBAL_DEFAULT;
    private int renderX;
    private int renderY;
    private int renderRadius;
    private boolean interpolateRequired = false;

    public CollisionCircle(float radius) {
        this(CollisionIdSequence.nextId(), radius);
    }

    public CollisionCircle(int id, float radius) {
        this(id, 0.0f, 0.0f, radius);
    }

    public CollisionCircle(float centerX, float centerY, float radius) {
        this(CollisionIdSequence.nextId(), centerX, centerY, radius);
    }

    public CollisionCircle(int id, float centerX, float centerY, float radius) {
        super(centerX, centerY, radius);
        this.positionChangeListenerLock = Mdx.locks.newReadWriteLock();
        this.sizeChangeListenerLock = Mdx.locks.newReadWriteLock();
        this.addPostionChangeListener(this);
        this.addSizeChangeListener(this);
        this.previousCircle = Mdx.geom.circle();
        this.renderCircle = Mdx.geom.circle();
        this.init(id, centerX, centerY, radius);
    }

    public CollisionCircle(int id, Collisions collisions) {
        this(id, 1.0f);
        this.collisions = collisions;
    }

    protected void init(int id, float centerX, float centerY, float radius) {
        this.id = id;
        this.disposed = false;
        InterpolationTracker.register(this);
        this.setXY(centerX, centerY);
        this.setRadius(radius);
        this.previousCircle.setXY(centerX, centerY);
        this.previousCircle.setRadius(radius);
        this.renderCircle.setXY(centerX, centerY);
        this.renderCircle.setRadius(radius);
        this.storeRenderCoordinates();
    }

    private void storeRenderCoordinates() {
        this.renderX = this.renderCoordMode.apply(this.renderCircle.getX());
        this.renderY = this.renderCoordMode.apply(this.renderCircle.getY());
        this.renderRadius = this.renderCoordMode.apply(this.renderCircle.getRadius());
    }

    protected void release() {
        this.collisions.release(this);
    }

    @Override
    public void dispose() {
        if (this.disposed) {
            return;
        }
        InterpolationTracker.deregister(this);
        if (this.collisions != null) {
            this.clearPositionChangeListeners();
            this.clearSizeChangeListeners();
            this.addPostionChangeListener(this);
            this.addSizeChangeListener(this);
            this.disposed = true;
            this.release();
            return;
        }
        super.dispose();
        this.previousCircle.dispose();
        this.renderCircle.dispose();
    }

    @Override
    public void preUpdate() {
        this.previousCircle.set(this);
    }

    @Override
    public void interpolate(float alpha) {
        if (!this.interpolateRequired) {
            return;
        }
        if (Mdx.timestepMode.equals((Object)TimestepMode.DEFAULT)) {
            this.renderCircle.set(this);
            this.storeRenderCoordinates();
            this.interpolateRequired = false;
            return;
        }
        this.previousCircle.lerp(this.renderCircle, this, alpha);
        this.storeRenderCoordinates();
        if (this.renderX != MathUtils.round((float)this.getX())) {
            return;
        }
        if (this.renderY != MathUtils.round((float)this.getY())) {
            return;
        }
        if (this.renderRadius != MathUtils.round((float)this.getRadius())) {
            return;
        }
        this.interpolateRequired = false;
    }

    @Override
    public CollisionArea setTo(float x, float y, float width, float height) {
        this.setXY(x, y);
        this.setRadius(width * 0.5f);
        return this;
    }

    @Override
    public void forceTo(float x, float y, float width, float height) {
        super.setXY(x, y);
        super.setRadius(width * 0.5f);
        this.previousCircle.setXY(x, y);
        this.previousCircle.setRadius(width * 0.5f);
        this.renderCircle.setXY(x, y);
        this.renderCircle.setRadius(width * 0.5f);
        this.storeRenderCoordinates();
        this.interpolateRequired = false;
    }

    @Override
    public void forceToWidth(float width) {
        this.setRadius(width * 0.5f);
        this.previousCircle.set(this);
        this.renderCircle.set(this);
        this.storeRenderCoordinates();
        this.interpolateRequired = false;
    }

    @Override
    public void forceToHeight(float height) {
        this.setRadius(height * 0.5f);
        this.previousCircle.set(this);
        this.renderCircle.set(this);
        this.storeRenderCoordinates();
        this.interpolateRequired = false;
    }

    @Override
    public void forceTo(float x, float y) {
        super.setXY(x, y);
        this.previousCircle.setXY(x, y);
        this.renderCircle.setXY(x, y);
        this.storeRenderCoordinates();
        this.interpolateRequired = false;
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public int getRenderX() {
        return this.renderX;
    }

    @Override
    public int getRenderY() {
        return this.renderY;
    }

    @Override
    public float getRawRenderX() {
        return this.renderCircle.getX();
    }

    @Override
    public float getRawRenderY() {
        return this.renderCircle.getY();
    }

    @Override
    public RenderCoordMode getRenderCoordMode() {
        return this.renderCoordMode;
    }

    @Override
    public void setRenderCoordMode(RenderCoordMode mode) {
        if (mode == null) {
            return;
        }
        this.renderCoordMode = mode;
    }

    @Override
    public int getRenderWidth() {
        return this.renderRadius * 2;
    }

    @Override
    public int getRenderHeight() {
        return this.renderRadius * 2;
    }

    @Override
    public float getRawRenderWidth() {
        return this.renderCircle.getRadius() * 2.0f;
    }

    @Override
    public float getRawRenderHeight() {
        return this.renderCircle.getRadius() * 2.0f;
    }

    public int getRenderRadius() {
        return this.renderRadius;
    }

    public float getRawRenderRadius() {
        return this.renderCircle.getRadius();
    }

    @Override
    public void positionChanged(CollisionCircle moved) {
        if (moved.getId() != this.id) {
            return;
        }
        this.interpolateRequired = true;
    }

    @Override
    public void sizeChanged(CollisionCircle changed) {
        if (changed.getId() != this.id) {
            return;
        }
        this.interpolateRequired = true;
    }

    @Override
    public <T extends Positionable> void addPostionChangeListener(PositionChangeListener<T> listener) {
        this.positionChangeListenerLock.lockWrite();
        this.positionChangeListeners.add(listener);
        this.positionChangeListenerLock.unlockWrite();
    }

    @Override
    public <T extends Positionable> void removePositionChangeListener(PositionChangeListener<T> listener) {
        CollisionCircle.removePositionListener(this.positionChangeListenerLock, (Array<PositionChangeListener>)this.positionChangeListeners, listener);
    }

    @Override
    public <T extends Sizeable> void addSizeChangeListener(SizeChangeListener<T> listener) {
        this.sizeChangeListenerLock.lockWrite();
        this.sizeChangeListeners.add(listener);
        this.sizeChangeListenerLock.unlockWrite();
    }

    @Override
    public <T extends Sizeable> void removeSizeChangeListener(SizeChangeListener<T> listener) {
        CollisionCircle.removeSizeListener(this.sizeChangeListenerLock, (Array<SizeChangeListener>)this.sizeChangeListeners, listener);
    }

    @Override
    protected void notifyPositionChangeListeners() {
        CollisionCircle.notifyPositionListeners(this.positionChangeListenerLock, (Array<PositionChangeListener>)this.positionChangeListeners, this);
    }

    @Override
    protected void clearPositionChangeListeners() {
        CollisionCircle.clearPositionListeners(this.positionChangeListenerLock, (Array<PositionChangeListener>)this.positionChangeListeners);
    }

    @Override
    protected void notifySizeChangeListeners() {
        CollisionCircle.notifySizeListeners(this.sizeChangeListenerLock, (Array<SizeChangeListener>)this.sizeChangeListeners, this);
    }

    @Override
    protected void clearSizeChangeListeners() {
        CollisionCircle.clearSizeListeners(this.sizeChangeListenerLock, (Array<SizeChangeListener>)this.sizeChangeListeners);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof CollisionCircle)) {
            return false;
        }
        CollisionCircle that = (CollisionCircle)o;
        if (this.id != that.id) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    public int hashCode() {
        return HashUtils.hashCode(this.id);
    }

    public String toString() {
        return "CollisionCircle [id=" + this.id + ", x=" + this.getX() + ", y=" + this.getY() + ", radius=" + this.getRadius() + ", renderCircle=" + this.renderCircle + "]";
    }
}

