/*
 * Decompiled with CFR 0.152.
 */
package org.mini2Dx.core.collision;

import org.mini2Dx.core.Mdx;
import org.mini2Dx.core.TimestepMode;
import org.mini2Dx.core.collision.CollisionIdSequence;
import org.mini2Dx.core.collision.CollisionObject;
import org.mini2Dx.core.collision.Collisions;
import org.mini2Dx.core.collision.RenderCoordMode;
import org.mini2Dx.core.geom.Point;
import org.mini2Dx.core.geom.PositionChangeListener;
import org.mini2Dx.core.geom.Positionable;
import org.mini2Dx.core.geom.Shape;
import org.mini2Dx.core.util.HashUtils;
import org.mini2Dx.core.util.InterpolationTracker;
import org.mini2Dx.gdx.math.MathUtils;
import org.mini2Dx.gdx.utils.Array;
import org.mini2Dx.lockprovider.ReadWriteLock;

public class CollisionPoint
extends Point
implements CollisionObject,
PositionChangeListener<CollisionPoint> {
    private final ReadWriteLock positionChangeListenerLock;
    private final Point previousPosition;
    private final Point renderPosition;
    protected Collisions collisions = null;
    private int id;
    private RenderCoordMode renderCoordMode = RenderCoordMode.GLOBAL_DEFAULT;
    private int renderX;
    private int renderY;
    private boolean interpolateRequired = false;

    public CollisionPoint() {
        this(0.0f, 0.0f);
    }

    public CollisionPoint(int id) {
        this(id, 0.0f, 0.0f);
    }

    public CollisionPoint(float x, float y) {
        this(CollisionIdSequence.nextId(), x, y);
    }

    public CollisionPoint(int id, float x, float y) {
        super(x, y);
        this.positionChangeListenerLock = Mdx.locks.newReadWriteLock();
        this.addPostionChangeListener(this);
        this.previousPosition = Mdx.geom.point();
        this.renderPosition = Mdx.geom.point();
        this.init(id, x, y);
    }

    public CollisionPoint(int id, Collisions collisions) {
        this();
        this.collisions = collisions;
    }

    protected void init(int id, float x, float y) {
        this.id = id;
        this.disposed = false;
        InterpolationTracker.register(this);
        this.forceTo(x, y);
    }

    private void storeRenderCoordinates() {
        this.renderX = this.renderCoordMode.apply(this.renderPosition.getX());
        this.renderY = this.renderCoordMode.apply(this.renderPosition.getY());
    }

    protected void release() {
        this.collisions.release(this);
    }

    @Override
    public void dispose() {
        if (this.disposed) {
            return;
        }
        InterpolationTracker.deregister(this);
        if (this.collisions != null) {
            this.clearPositionChangeListeners();
            this.addPostionChangeListener(this);
            this.disposed = true;
            this.release();
            return;
        }
        super.dispose();
        this.previousPosition.dispose();
        this.renderPosition.dispose();
    }

    @Override
    public void preUpdate() {
        this.previousPosition.set(this);
    }

    @Override
    public void interpolate(float alpha) {
        if (!this.interpolateRequired) {
            return;
        }
        if (Mdx.timestepMode.equals((Object)TimestepMode.DEFAULT)) {
            this.renderPosition.set(this);
            this.storeRenderCoordinates();
            this.interpolateRequired = false;
            return;
        }
        this.renderPosition.set(this.previousPosition.lerp(this, alpha));
        this.storeRenderCoordinates();
        if (this.renderX != MathUtils.round((float)this.x)) {
            return;
        }
        if (this.renderY != MathUtils.round((float)this.y)) {
            return;
        }
        this.interpolateRequired = false;
    }

    @Override
    public void forceTo(float x, float y) {
        super.set(x, y);
        this.previousPosition.set(x, y);
        this.renderPosition.set(x, y);
        this.storeRenderCoordinates();
        this.interpolateRequired = false;
    }

    @Override
    public int getRenderX() {
        return this.renderX;
    }

    @Override
    public int getRenderY() {
        return this.renderY;
    }

    @Override
    public float getRawRenderX() {
        return this.renderPosition.getX();
    }

    @Override
    public float getRawRenderY() {
        return this.renderPosition.getY();
    }

    @Override
    public RenderCoordMode getRenderCoordMode() {
        return this.renderCoordMode;
    }

    @Override
    public void setRenderCoordMode(RenderCoordMode mode) {
        if (mode == null) {
            return;
        }
        this.renderCoordMode = mode;
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public void positionChanged(CollisionPoint moved) {
        if (moved.getId() != this.id) {
            return;
        }
        this.interpolateRequired = true;
    }

    @Override
    public <T extends Positionable> void addPostionChangeListener(PositionChangeListener<T> listener) {
        this.positionChangeListenerLock.lockWrite();
        if (this.positionChangeListeners == null) {
            this.positionChangeListeners = new Array(true, 1);
        }
        this.positionChangeListeners.add(listener);
        this.positionChangeListenerLock.unlockWrite();
    }

    @Override
    public <T extends Positionable> void removePositionChangeListener(PositionChangeListener<T> listener) {
        Shape.removePositionListener(this.positionChangeListenerLock, (Array<PositionChangeListener>)this.positionChangeListeners, listener);
    }

    @Override
    protected void notifyPositionChangeListeners() {
        Shape.notifyPositionListeners(this.positionChangeListenerLock, (Array<PositionChangeListener>)this.positionChangeListeners, this);
    }

    @Override
    protected void clearPositionChangeListeners() {
        Shape.clearPositionListeners(this.positionChangeListenerLock, (Array<PositionChangeListener>)this.positionChangeListeners);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof CollisionPoint)) {
            return false;
        }
        CollisionPoint that = (CollisionPoint)o;
        if (this.id != that.id) {
            return false;
        }
        return super.equals(o);
    }

    public int hashCode() {
        return HashUtils.hashCode(this.id);
    }

    public String toString() {
        return "CollisionPoint{id=" + this.id + ", x=" + this.x + ", y=" + this.y + '}';
    }
}

