/*
 * Decompiled with CFR 0.152.
 */
package org.mini2Dx.core.collision;

import org.mini2Dx.core.Mdx;
import org.mini2Dx.core.TimestepMode;
import org.mini2Dx.core.collision.CollisionArea;
import org.mini2Dx.core.collision.CollisionIdSequence;
import org.mini2Dx.core.collision.Collisions;
import org.mini2Dx.core.collision.RenderCoordMode;
import org.mini2Dx.core.exception.MdxException;
import org.mini2Dx.core.geom.Polygon;
import org.mini2Dx.core.geom.PositionChangeListener;
import org.mini2Dx.core.geom.Positionable;
import org.mini2Dx.core.geom.SizeChangeListener;
import org.mini2Dx.core.geom.Sizeable;
import org.mini2Dx.core.util.HashUtils;
import org.mini2Dx.core.util.InterpolationTracker;
import org.mini2Dx.gdx.math.MathUtils;
import org.mini2Dx.gdx.math.Vector2;
import org.mini2Dx.gdx.utils.Array;
import org.mini2Dx.lockprovider.ReadWriteLock;

public class CollisionPolygon
extends Polygon
implements CollisionArea,
PositionChangeListener<CollisionPolygon>,
SizeChangeListener<CollisionPolygon> {
    private final ReadWriteLock positionChangeListenerLock;
    private final ReadWriteLock sizeChangeListenerLock;
    private final Polygon previousPolygon;
    private final Polygon renderPolygon;
    protected Collisions collisions = null;
    private int id;
    private RenderCoordMode renderCoordMode = RenderCoordMode.GLOBAL_DEFAULT;
    private int renderX;
    private int renderY;
    private int renderWidth;
    private int renderHeight;
    private boolean interpolateRequired = false;

    public CollisionPolygon(float[] vertices) {
        this(CollisionIdSequence.nextId(), vertices);
    }

    public CollisionPolygon(Vector2[] vectors) {
        this(CollisionIdSequence.nextId(), vectors);
    }

    public CollisionPolygon(int id, float[] vertices) {
        super(vertices);
        this.positionChangeListenerLock = Mdx.locks.newReadWriteLock();
        this.sizeChangeListenerLock = Mdx.locks.newReadWriteLock();
        this.addPostionChangeListener(this);
        this.addSizeChangeListener(this);
        this.previousPolygon = Mdx.geom.polygon(vertices);
        this.renderPolygon = Mdx.geom.polygon(vertices);
        this.init(id, vertices);
    }

    public CollisionPolygon(int id, Vector2[] vectors) {
        super(vectors);
        this.positionChangeListenerLock = Mdx.locks.newReadWriteLock();
        this.sizeChangeListenerLock = Mdx.locks.newReadWriteLock();
        this.addPostionChangeListener(this);
        this.addSizeChangeListener(this);
        this.previousPolygon = Mdx.geom.polygon();
        this.renderPolygon = Mdx.geom.polygon();
        this.init(id, vectors);
    }

    public CollisionPolygon(int id, Collisions collisions, float[] vertices) {
        this(id, vertices);
        this.collisions = collisions;
    }

    public CollisionPolygon(int id, Collisions collisions, Vector2[] vectors) {
        this(id, vectors);
        this.collisions = collisions;
    }

    protected void init(int id, float[] vertices) {
        this.id = id;
        this.disposed = false;
        InterpolationTracker.register(this);
        this.forceTo(vertices);
    }

    protected void init(int id, Vector2[] vectors) {
        this.id = id;
        this.disposed = false;
        InterpolationTracker.register(this);
        this.setVertices(vectors);
        this.previousPolygon.setVertices(vectors);
        this.renderPolygon.setVertices(vectors);
    }

    private void storeRenderCoordinates() {
        this.renderX = this.renderCoordMode.apply(this.renderPolygon.getX());
        this.renderY = this.renderCoordMode.apply(this.renderPolygon.getY());
        this.renderWidth = this.renderCoordMode.apply(this.renderPolygon.getWidth());
        this.renderHeight = this.renderCoordMode.apply(this.renderPolygon.getHeight());
    }

    protected void release() {
        this.collisions.release(this);
    }

    @Override
    public void dispose() {
        if (this.disposed) {
            return;
        }
        InterpolationTracker.deregister(this);
        if (this.collisions != null) {
            this.clearPositionChangeListeners();
            this.clearSizeChangeListeners();
            this.addPostionChangeListener(this);
            this.addSizeChangeListener(this);
            this.disposed = true;
            this.release();
            return;
        }
        super.dispose();
        this.previousPolygon.dispose();
        this.renderPolygon.dispose();
    }

    @Override
    public void preUpdate() {
        this.previousPolygon.set(this);
    }

    @Override
    public void interpolate(float alpha) {
        if (!this.interpolateRequired) {
            return;
        }
        if (Mdx.timestepMode.equals((Object)TimestepMode.DEFAULT)) {
            this.renderPolygon.set(this);
            this.storeRenderCoordinates();
            this.interpolateRequired = false;
            return;
        }
        this.previousPolygon.lerp(this.renderPolygon, this, alpha);
        this.storeRenderCoordinates();
        if (this.renderX != MathUtils.round((float)this.getX())) {
            return;
        }
        if (this.renderY != MathUtils.round((float)this.getY())) {
            return;
        }
        this.interpolateRequired = false;
    }

    @Override
    public void forceTo(float x, float y) {
        super.setXY(x, y);
        this.previousPolygon.set(this);
        this.renderPolygon.set(this.previousPolygon);
        this.storeRenderCoordinates();
        this.interpolateRequired = false;
    }

    @Override
    public CollisionArea setTo(float x, float y, float width, float height) {
        throw new MdxException("#setTo(x, y, width, height) not supported on CollisionPolygon");
    }

    @Override
    public void forceTo(float x, float y, float width, float height) {
        throw new MdxException("#forceTo(x, y, width, height) not supported on CollisionPolygon");
    }

    @Override
    public void forceToWidth(float width) {
        throw new MdxException("#forceToWidth(width) not supported on CollisionPolygon");
    }

    @Override
    public void forceToHeight(float height) {
        throw new MdxException("#forceToHeight(float height) not supported on CollisionPolygon");
    }

    public void forceTo(float[] vertices) {
        this.setVertices(vertices);
        this.previousPolygon.set(this);
        this.renderPolygon.set(this.previousPolygon);
        this.storeRenderCoordinates();
        this.interpolateRequired = false;
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public int getRenderX() {
        return this.renderX;
    }

    @Override
    public int getRenderY() {
        return this.renderY;
    }

    @Override
    public float getRawRenderX() {
        return this.renderPolygon.getX();
    }

    @Override
    public float getRawRenderY() {
        return this.renderPolygon.getY();
    }

    @Override
    public int getRenderWidth() {
        return this.renderWidth;
    }

    @Override
    public int getRenderHeight() {
        return this.renderHeight;
    }

    @Override
    public float getRawRenderWidth() {
        return this.renderPolygon.getWidth();
    }

    @Override
    public float getRawRenderHeight() {
        return this.renderPolygon.getHeight();
    }

    public int getRenderX(int index) {
        return MathUtils.round((float)this.renderPolygon.getX(index));
    }

    public int getRenderY(int index) {
        return MathUtils.round((float)this.renderPolygon.getY(index));
    }

    @Override
    public void positionChanged(CollisionPolygon moved) {
        if (moved.getId() != this.id) {
            return;
        }
        this.interpolateRequired = true;
    }

    @Override
    public void sizeChanged(CollisionPolygon changed) {
        if (changed.getId() != this.id) {
            return;
        }
        this.interpolateRequired = true;
    }

    @Override
    public <T extends Positionable> void addPostionChangeListener(PositionChangeListener<T> listener) {
        this.positionChangeListenerLock.lockWrite();
        this.positionChangeListeners.add(listener);
        this.positionChangeListenerLock.unlockWrite();
    }

    @Override
    public <T extends Positionable> void removePositionChangeListener(PositionChangeListener<T> listener) {
        CollisionPolygon.removePositionListener(this.positionChangeListenerLock, (Array<PositionChangeListener>)this.positionChangeListeners, listener);
    }

    @Override
    public <T extends Sizeable> void addSizeChangeListener(SizeChangeListener<T> listener) {
        this.sizeChangeListenerLock.lockWrite();
        this.sizeChangeListeners.add(listener);
        this.sizeChangeListenerLock.unlockWrite();
    }

    @Override
    public <T extends Sizeable> void removeSizeChangeListener(SizeChangeListener<T> listener) {
        CollisionPolygon.removeSizeListener(this.sizeChangeListenerLock, (Array<SizeChangeListener>)this.sizeChangeListeners, listener);
    }

    @Override
    protected void notifyPositionChangeListeners() {
        CollisionPolygon.notifyPositionListeners(this.positionChangeListenerLock, (Array<PositionChangeListener>)this.positionChangeListeners, this);
    }

    @Override
    protected void clearPositionChangeListeners() {
        CollisionPolygon.clearPositionListeners(this.positionChangeListenerLock, (Array<PositionChangeListener>)this.positionChangeListeners);
    }

    @Override
    protected void notifySizeChangeListeners() {
        CollisionPolygon.notifySizeListeners(this.sizeChangeListenerLock, (Array<SizeChangeListener>)this.sizeChangeListeners, this);
    }

    @Override
    protected void clearSizeChangeListeners() {
        CollisionPolygon.clearSizeListeners(this.sizeChangeListenerLock, (Array<SizeChangeListener>)this.sizeChangeListeners);
    }

    @Override
    public RenderCoordMode getRenderCoordMode() {
        return this.renderCoordMode;
    }

    @Override
    public void setRenderCoordMode(RenderCoordMode mode) {
        if (mode == null) {
            return;
        }
        this.renderCoordMode = mode;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof CollisionPolygon)) {
            return false;
        }
        CollisionPolygon that = (CollisionPolygon)o;
        if (this.id != that.id) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    public int hashCode() {
        return HashUtils.hashCode(this.id);
    }

    @Override
    public String toString() {
        return "CollisionPolygon{id=" + this.id + '}';
    }
}

