/*
 * Decompiled with CFR 0.152.
 */
package org.mini2Dx.core.collision;

import org.mini2Dx.core.collision.CollisionBox;
import org.mini2Dx.core.collision.CollisionCircle;
import org.mini2Dx.core.collision.CollisionIdSequence;
import org.mini2Dx.core.collision.CollisionPoint;
import org.mini2Dx.core.collision.CollisionPolygon;
import org.mini2Dx.core.collision.util.QuadTreeAwareCollisionBox;
import org.mini2Dx.core.collision.util.QuadTreeAwareCollisionCircle;
import org.mini2Dx.core.collision.util.QuadTreeAwareCollisionPoint;
import org.mini2Dx.core.collision.util.QuadTreeAwareCollisionPolygon;
import org.mini2Dx.core.collision.util.QuadTreeAwareStaticCollisionBox;
import org.mini2Dx.core.collision.util.QuadTreeAwareStaticCollisionCircle;
import org.mini2Dx.core.collision.util.QuadTreeAwareStaticCollisionPoint;
import org.mini2Dx.core.collision.util.QuadTreeAwareStaticCollisionPolygon;
import org.mini2Dx.core.collision.util.StaticCollisionBox;
import org.mini2Dx.core.collision.util.StaticCollisionCircle;
import org.mini2Dx.core.collision.util.StaticCollisionPoint;
import org.mini2Dx.core.collision.util.StaticCollisionPolygon;
import org.mini2Dx.core.util.InterpolationTracker;
import org.mini2Dx.gdx.math.Vector2;
import org.mini2Dx.gdx.utils.Queue;

public class Collisions {
    public static int DEFAULT_POOL_SIZE = 256;
    final Queue<CollisionBox> collisionBoxes = new Queue(DEFAULT_POOL_SIZE * 2);
    final Queue<CollisionCircle> collisionCircles = new Queue(DEFAULT_POOL_SIZE * 2);
    final Queue<CollisionPoint> collisionPoints = new Queue(DEFAULT_POOL_SIZE * 2);
    final Queue<CollisionPolygon> collisionPolygons = new Queue(DEFAULT_POOL_SIZE * 2);
    final Queue<QuadTreeAwareCollisionBox> quadTreeAwareCollisionBoxes = new Queue(DEFAULT_POOL_SIZE * 2);
    final Queue<QuadTreeAwareCollisionCircle> quadTreeAwareCollisionCircles = new Queue(DEFAULT_POOL_SIZE * 2);
    final Queue<QuadTreeAwareCollisionPoint> quadTreeAwareCollisionPoints = new Queue(DEFAULT_POOL_SIZE * 2);
    final Queue<QuadTreeAwareCollisionPolygon> quadTreeAwareCollisionPolygons = new Queue(DEFAULT_POOL_SIZE * 2);
    final Queue<StaticCollisionBox> staticCollisionBoxes = new Queue(DEFAULT_POOL_SIZE * 2);
    final Queue<StaticCollisionCircle> staticCollisionCircles = new Queue(DEFAULT_POOL_SIZE * 2);
    final Queue<StaticCollisionPoint> staticCollisionPoints = new Queue(DEFAULT_POOL_SIZE * 2);
    final Queue<StaticCollisionPolygon> staticCollisionPolygons = new Queue(DEFAULT_POOL_SIZE * 2);
    final Queue<QuadTreeAwareStaticCollisionBox> quadTreeAwareStaticCollisionBoxes = new Queue(DEFAULT_POOL_SIZE * 2);
    final Queue<QuadTreeAwareStaticCollisionCircle> quadTreeAwareStaticCollisionCircles = new Queue(DEFAULT_POOL_SIZE * 2);
    final Queue<QuadTreeAwareStaticCollisionPoint> quadTreeAwareStaticCollisionPoints = new Queue(DEFAULT_POOL_SIZE * 2);
    final Queue<QuadTreeAwareStaticCollisionPolygon> quadTreeAwareStaticCollisionPolygons = new Queue(DEFAULT_POOL_SIZE * 2);
    private boolean initialised = false;

    public synchronized void init() {
        if (this.initialised) {
            return;
        }
        for (int i = 0; i < DEFAULT_POOL_SIZE; ++i) {
            this.collisionBoxes.addLast((Object)new CollisionBox(CollisionIdSequence.nextId(), this));
            ((CollisionBox)this.collisionBoxes.removeLast()).dispose();
            this.collisionCircles.addLast((Object)new CollisionCircle(CollisionIdSequence.nextId(), this));
            ((CollisionCircle)this.collisionCircles.removeLast()).dispose();
            this.collisionPoints.addLast((Object)new CollisionPoint(CollisionIdSequence.nextId(), this));
            ((CollisionPoint)this.collisionPoints.removeLast()).dispose();
            this.quadTreeAwareCollisionBoxes.addLast((Object)new QuadTreeAwareCollisionBox(CollisionIdSequence.nextId(), this));
            ((QuadTreeAwareCollisionBox)this.quadTreeAwareCollisionBoxes.removeLast()).dispose();
            this.quadTreeAwareCollisionCircles.addLast((Object)new QuadTreeAwareCollisionCircle(CollisionIdSequence.nextId(), this));
            ((QuadTreeAwareCollisionCircle)this.quadTreeAwareCollisionCircles.removeLast()).dispose();
            this.quadTreeAwareCollisionPoints.addLast((Object)new QuadTreeAwareCollisionPoint(CollisionIdSequence.nextId(), this));
            ((QuadTreeAwareCollisionPoint)this.quadTreeAwareCollisionPoints.removeLast()).dispose();
            this.staticCollisionBoxes.addLast((Object)new StaticCollisionBox(CollisionIdSequence.nextId(), this));
            ((StaticCollisionBox)this.staticCollisionBoxes.removeLast()).dispose();
            this.staticCollisionCircles.addLast((Object)new StaticCollisionCircle(CollisionIdSequence.nextId(), this));
            ((StaticCollisionCircle)this.staticCollisionCircles.removeLast()).dispose();
            this.staticCollisionPoints.addLast((Object)new StaticCollisionPoint(CollisionIdSequence.nextId(), this));
            ((StaticCollisionPoint)this.staticCollisionPoints.removeLast()).dispose();
            this.quadTreeAwareStaticCollisionBoxes.addLast((Object)new QuadTreeAwareStaticCollisionBox(CollisionIdSequence.nextId(), this));
            ((QuadTreeAwareStaticCollisionBox)this.quadTreeAwareStaticCollisionBoxes.removeLast()).dispose();
            this.quadTreeAwareStaticCollisionCircles.addLast((Object)new QuadTreeAwareStaticCollisionCircle(CollisionIdSequence.nextId(), this));
            ((QuadTreeAwareStaticCollisionCircle)this.quadTreeAwareStaticCollisionCircles.removeLast()).dispose();
            this.quadTreeAwareStaticCollisionPoints.addLast((Object)new QuadTreeAwareStaticCollisionPoint(CollisionIdSequence.nextId(), this));
            ((QuadTreeAwareStaticCollisionPoint)this.quadTreeAwareStaticCollisionPoints.removeLast()).dispose();
        }
        this.initialised = true;
    }

    public CollisionBox collisionBox() {
        return this.collisionBox(CollisionIdSequence.nextId());
    }

    public CollisionBox collisionBox(int id) {
        return this.collisionBox(id, 0.0f, 0.0f, 1.0f, 1.0f);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CollisionBox collisionBox(int id, float x, float y, float width, float height) {
        CollisionBox result;
        this.init();
        Queue<CollisionBox> queue = this.collisionBoxes;
        synchronized (queue) {
            if (this.collisionBoxes.size == 0) {
                result = new CollisionBox(CollisionIdSequence.offset(id), this);
                InterpolationTracker.deregister(result);
            } else {
                result = (CollisionBox)this.collisionBoxes.removeFirst();
            }
        }
        result.init(id, x, y, width, height);
        return result;
    }

    public CollisionCircle collisionCircle() {
        return this.collisionCircle(CollisionIdSequence.nextId());
    }

    public CollisionCircle collisionCircle(int id) {
        return this.collisionCircle(id, 0.0f, 0.0f, 1.0f);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CollisionCircle collisionCircle(int id, float x, float y, float radius) {
        CollisionCircle result;
        this.init();
        Queue<CollisionCircle> queue = this.collisionCircles;
        synchronized (queue) {
            if (this.collisionCircles.size == 0) {
                result = new CollisionCircle(CollisionIdSequence.offset(id), this);
                InterpolationTracker.deregister(result);
            } else {
                result = (CollisionCircle)this.collisionCircles.removeFirst();
            }
        }
        result.init(id, x, y, radius);
        return result;
    }

    public CollisionPoint collisionPoint() {
        return this.collisionPoint(CollisionIdSequence.nextId());
    }

    public CollisionPoint collisionPoint(int id) {
        return this.collisionPoint(id, 0.0f, 0.0f);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CollisionPoint collisionPoint(int id, float x, float y) {
        CollisionPoint result;
        this.init();
        Queue<CollisionPoint> queue = this.collisionPoints;
        synchronized (queue) {
            if (this.collisionPoints.size == 0) {
                result = new CollisionPoint(CollisionIdSequence.offset(id), this);
                InterpolationTracker.deregister(result);
            } else {
                result = (CollisionPoint)this.collisionPoints.removeFirst();
            }
        }
        result.init(id, x, y);
        return result;
    }

    public CollisionPolygon collisionPolygon(float[] vertices) {
        return this.collisionPolygon(CollisionIdSequence.nextId(), vertices);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CollisionPolygon collisionPolygon(int id, float[] vertices) {
        CollisionPolygon result;
        this.init();
        Queue<CollisionPolygon> queue = this.collisionPolygons;
        synchronized (queue) {
            if (this.collisionPolygons.size == 0) {
                result = new CollisionPolygon(CollisionIdSequence.offset(id), this, vertices);
                InterpolationTracker.deregister(result);
            } else {
                result = (CollisionPolygon)this.collisionPolygons.removeFirst();
            }
        }
        result.init(id, vertices);
        return result;
    }

    public CollisionPolygon collisionPolygon(Vector2[] vectors) {
        return this.collisionPolygon(CollisionIdSequence.nextId(), vectors);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CollisionPolygon collisionPolygon(int id, Vector2[] vectors) {
        CollisionPolygon result;
        this.init();
        Queue<CollisionPolygon> queue = this.collisionPolygons;
        synchronized (queue) {
            if (this.collisionPolygons.size == 0) {
                result = new CollisionPolygon(CollisionIdSequence.offset(id), this, vectors);
                InterpolationTracker.deregister(result);
            } else {
                result = (CollisionPolygon)this.collisionPolygons.removeFirst();
            }
        }
        result.init(id, vectors);
        return result;
    }

    public QuadTreeAwareCollisionBox quadTreeAwareCollisionBox() {
        return this.quadTreeAwareCollisionBox(CollisionIdSequence.nextId());
    }

    public QuadTreeAwareCollisionBox quadTreeAwareCollisionBox(int id) {
        return this.quadTreeAwareCollisionBox(id, 0.0f, 0.0f, 1.0f, 1.0f);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public QuadTreeAwareCollisionBox quadTreeAwareCollisionBox(int id, float x, float y, float width, float height) {
        QuadTreeAwareCollisionBox result;
        this.init();
        Queue<QuadTreeAwareCollisionBox> queue = this.quadTreeAwareCollisionBoxes;
        synchronized (queue) {
            if (this.quadTreeAwareCollisionBoxes.size == 0) {
                result = new QuadTreeAwareCollisionBox(CollisionIdSequence.offset(id), this);
                InterpolationTracker.deregister(result);
            } else {
                result = (QuadTreeAwareCollisionBox)this.quadTreeAwareCollisionBoxes.removeFirst();
            }
        }
        result.init(id, x, y, width, height);
        return result;
    }

    public QuadTreeAwareCollisionCircle quadTreeAwareCollisionCircle() {
        return this.quadTreeAwareCollisionCircle(CollisionIdSequence.nextId());
    }

    public QuadTreeAwareCollisionCircle quadTreeAwareCollisionCircle(int id) {
        return this.quadTreeAwareCollisionCircle(id, 0.0f, 0.0f, 1.0f);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public QuadTreeAwareCollisionCircle quadTreeAwareCollisionCircle(int id, float x, float y, float radius) {
        QuadTreeAwareCollisionCircle result;
        this.init();
        Queue<QuadTreeAwareCollisionCircle> queue = this.quadTreeAwareCollisionCircles;
        synchronized (queue) {
            if (this.quadTreeAwareCollisionCircles.size == 0) {
                result = new QuadTreeAwareCollisionCircle(CollisionIdSequence.offset(id), this);
                InterpolationTracker.deregister(result);
            } else {
                result = (QuadTreeAwareCollisionCircle)this.quadTreeAwareCollisionCircles.removeFirst();
            }
        }
        result.init(id, x, y, radius);
        return result;
    }

    public QuadTreeAwareCollisionPoint quadTreeAwareCollisionPoint() {
        return this.quadTreeAwareCollisionPoint(CollisionIdSequence.nextId());
    }

    public QuadTreeAwareCollisionPoint quadTreeAwareCollisionPoint(int id) {
        return this.quadTreeAwareCollisionPoint(id, 0.0f, 0.0f);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public QuadTreeAwareCollisionPoint quadTreeAwareCollisionPoint(int id, float x, float y) {
        QuadTreeAwareCollisionPoint result;
        this.init();
        Queue<QuadTreeAwareCollisionPoint> queue = this.quadTreeAwareCollisionPoints;
        synchronized (queue) {
            if (this.quadTreeAwareCollisionPoints.size == 0) {
                result = new QuadTreeAwareCollisionPoint(CollisionIdSequence.offset(id), this);
                InterpolationTracker.deregister(result);
            } else {
                result = (QuadTreeAwareCollisionPoint)this.quadTreeAwareCollisionPoints.removeFirst();
            }
        }
        result.init(id, x, y);
        return result;
    }

    public QuadTreeAwareCollisionPolygon quadTreeAwareCollisionPolygon(float[] vertices) {
        return this.quadTreeAwareCollisionPolygon(CollisionIdSequence.nextId(), vertices);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public QuadTreeAwareCollisionPolygon quadTreeAwareCollisionPolygon(int id, float[] vertices) {
        QuadTreeAwareCollisionPolygon result;
        this.init();
        Queue<QuadTreeAwareCollisionPolygon> queue = this.quadTreeAwareCollisionPolygons;
        synchronized (queue) {
            if (this.quadTreeAwareCollisionPolygons.size == 0) {
                result = new QuadTreeAwareCollisionPolygon(CollisionIdSequence.offset(id), this, vertices);
                InterpolationTracker.deregister(result);
            } else {
                result = (QuadTreeAwareCollisionPolygon)this.quadTreeAwareCollisionPolygons.removeFirst();
            }
        }
        result.init(id, vertices);
        return result;
    }

    public QuadTreeAwareCollisionPolygon quadTreeAwareCollisionPolygon(Vector2[] vectors) {
        return this.quadTreeAwareCollisionPolygon(CollisionIdSequence.nextId(), vectors);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public QuadTreeAwareCollisionPolygon quadTreeAwareCollisionPolygon(int id, Vector2[] vectors) {
        QuadTreeAwareCollisionPolygon result;
        this.init();
        Queue<QuadTreeAwareCollisionPolygon> queue = this.quadTreeAwareCollisionPolygons;
        synchronized (queue) {
            if (this.quadTreeAwareCollisionPolygons.size == 0) {
                result = new QuadTreeAwareCollisionPolygon(CollisionIdSequence.offset(id), this, vectors);
                InterpolationTracker.deregister(result);
            } else {
                result = (QuadTreeAwareCollisionPolygon)this.quadTreeAwareCollisionPolygons.removeFirst();
            }
        }
        result.init(id, vectors);
        return result;
    }

    public StaticCollisionBox staticCollisionBox() {
        return this.staticCollisionBox(CollisionIdSequence.nextId());
    }

    public StaticCollisionBox staticCollisionBox(int id) {
        return this.staticCollisionBox(id, 0.0f, 0.0f, 1.0f, 1.0f);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StaticCollisionBox staticCollisionBox(int id, float x, float y, float width, float height) {
        StaticCollisionBox result;
        this.init();
        Queue<StaticCollisionBox> queue = this.staticCollisionBoxes;
        synchronized (queue) {
            result = this.staticCollisionBoxes.size == 0 ? new StaticCollisionBox(CollisionIdSequence.offset(id), this) : (StaticCollisionBox)this.staticCollisionBoxes.removeFirst();
        }
        result.init(id, x, y, width, height);
        return result;
    }

    public StaticCollisionCircle staticCollisionCircle() {
        return this.staticCollisionCircle(CollisionIdSequence.nextId());
    }

    public StaticCollisionCircle staticCollisionCircle(int id) {
        return this.staticCollisionCircle(id, 0.0f, 0.0f, 1.0f);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StaticCollisionCircle staticCollisionCircle(int id, float centerX, float centerY, float radius) {
        StaticCollisionCircle result;
        this.init();
        Queue<StaticCollisionCircle> queue = this.staticCollisionCircles;
        synchronized (queue) {
            result = this.staticCollisionCircles.size == 0 ? new StaticCollisionCircle(CollisionIdSequence.offset(id), this) : (StaticCollisionCircle)this.staticCollisionCircles.removeFirst();
        }
        result.init(id, centerX, centerY, radius);
        return result;
    }

    public StaticCollisionPoint staticCollisionPoint() {
        return this.staticCollisionPoint(CollisionIdSequence.nextId());
    }

    public StaticCollisionPoint staticCollisionPoint(int id) {
        return this.staticCollisionPoint(id, 0.0f, 0.0f);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StaticCollisionPoint staticCollisionPoint(int id, float x, float y) {
        StaticCollisionPoint result;
        this.init();
        Queue<StaticCollisionPoint> queue = this.staticCollisionPoints;
        synchronized (queue) {
            result = this.staticCollisionPoints.size == 0 ? new StaticCollisionPoint(CollisionIdSequence.offset(id), this) : (StaticCollisionPoint)this.staticCollisionPoints.removeFirst();
        }
        result.init(id, x, y);
        return result;
    }

    public StaticCollisionPolygon staticCollisionPolygon(float[] vertices) {
        return this.staticCollisionPolygon(CollisionIdSequence.nextId(), vertices);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StaticCollisionPolygon staticCollisionPolygon(int id, float[] vertices) {
        StaticCollisionPolygon result;
        this.init();
        Queue<StaticCollisionPolygon> queue = this.staticCollisionPolygons;
        synchronized (queue) {
            result = this.staticCollisionPolygons.size == 0 ? new StaticCollisionPolygon(CollisionIdSequence.offset(id), this, vertices) : (StaticCollisionPolygon)this.staticCollisionPolygons.removeFirst();
        }
        result.init(id, vertices);
        return result;
    }

    public StaticCollisionPolygon staticCollisionPolygon(Vector2[] vectors) {
        return this.staticCollisionPolygon(CollisionIdSequence.nextId(), vectors);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StaticCollisionPolygon staticCollisionPolygon(int id, Vector2[] vectors) {
        StaticCollisionPolygon result;
        this.init();
        Queue<StaticCollisionPolygon> queue = this.staticCollisionPolygons;
        synchronized (queue) {
            result = this.staticCollisionPolygons.size == 0 ? new StaticCollisionPolygon(CollisionIdSequence.offset(id), this, vectors) : (StaticCollisionPolygon)this.staticCollisionPolygons.removeFirst();
        }
        result.init(id, vectors);
        return result;
    }

    public QuadTreeAwareStaticCollisionBox quadTreeAwareStaticCollisionBox() {
        return this.quadTreeAwareStaticCollisionBox(CollisionIdSequence.nextId());
    }

    public QuadTreeAwareStaticCollisionBox quadTreeAwareStaticCollisionBox(int id) {
        return this.quadTreeAwareStaticCollisionBox(id, 0.0f, 0.0f, 1.0f, 1.0f);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public QuadTreeAwareStaticCollisionBox quadTreeAwareStaticCollisionBox(int id, float x, float y, float width, float height) {
        QuadTreeAwareStaticCollisionBox result;
        this.init();
        Queue<QuadTreeAwareStaticCollisionBox> queue = this.quadTreeAwareStaticCollisionBoxes;
        synchronized (queue) {
            result = this.quadTreeAwareStaticCollisionBoxes.size == 0 ? new QuadTreeAwareStaticCollisionBox(CollisionIdSequence.offset(id), this) : (QuadTreeAwareStaticCollisionBox)this.quadTreeAwareStaticCollisionBoxes.removeFirst();
        }
        result.init(id, x, y, width, height);
        return result;
    }

    public QuadTreeAwareStaticCollisionCircle quadTreeAwareStaticCollisionCircle() {
        return this.quadTreeAwareStaticCollisionCircle(CollisionIdSequence.nextId());
    }

    public QuadTreeAwareStaticCollisionCircle quadTreeAwareStaticCollisionCircle(int id) {
        return this.quadTreeAwareStaticCollisionCircle(id, 0.0f, 0.0f, 1.0f);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public QuadTreeAwareStaticCollisionCircle quadTreeAwareStaticCollisionCircle(int id, float centerX, float centerY, float radius) {
        QuadTreeAwareStaticCollisionCircle result;
        this.init();
        QuadTreeAwareStaticCollisionCircle quadTreeAwareStaticCollisionCircle = this.quadTreeAwareStaticCollisionCircle();
        synchronized (quadTreeAwareStaticCollisionCircle) {
            result = this.quadTreeAwareStaticCollisionCircles.size == 0 ? new QuadTreeAwareStaticCollisionCircle(CollisionIdSequence.offset(id), this) : (QuadTreeAwareStaticCollisionCircle)this.quadTreeAwareStaticCollisionCircles.removeFirst();
        }
        result.init(id, centerX, centerY, radius);
        return result;
    }

    public QuadTreeAwareStaticCollisionPoint quadTreeAwareStaticCollisionPoint() {
        return this.quadTreeAwareStaticCollisionPoint(CollisionIdSequence.nextId());
    }

    public QuadTreeAwareStaticCollisionPoint quadTreeAwareStaticCollisionPoint(int id) {
        return this.quadTreeAwareStaticCollisionPoint(id, 0.0f, 0.0f);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public QuadTreeAwareStaticCollisionPoint quadTreeAwareStaticCollisionPoint(int id, float x, float y) {
        QuadTreeAwareStaticCollisionPoint result;
        this.init();
        Queue<QuadTreeAwareStaticCollisionPoint> queue = this.quadTreeAwareStaticCollisionPoints;
        synchronized (queue) {
            result = this.quadTreeAwareStaticCollisionPoints.size == 0 ? new QuadTreeAwareStaticCollisionPoint(CollisionIdSequence.offset(id), this) : (QuadTreeAwareStaticCollisionPoint)this.quadTreeAwareStaticCollisionPoints.removeFirst();
        }
        result.init(id, x, y);
        return result;
    }

    public QuadTreeAwareStaticCollisionPolygon quadTreeAwareStaticCollisionPolygon(float[] vertices) {
        return this.quadTreeAwareStaticCollisionPolygon(CollisionIdSequence.nextId(), vertices);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public QuadTreeAwareStaticCollisionPolygon quadTreeAwareStaticCollisionPolygon(int id, float[] vertices) {
        QuadTreeAwareStaticCollisionPolygon result;
        this.init();
        Queue<QuadTreeAwareStaticCollisionPolygon> queue = this.quadTreeAwareStaticCollisionPolygons;
        synchronized (queue) {
            result = this.quadTreeAwareStaticCollisionPolygons.size == 0 ? new QuadTreeAwareStaticCollisionPolygon(CollisionIdSequence.offset(id), this, vertices) : (QuadTreeAwareStaticCollisionPolygon)this.quadTreeAwareStaticCollisionPolygons.removeFirst();
        }
        result.init(id, vertices);
        return result;
    }

    public QuadTreeAwareStaticCollisionPolygon quadTreeAwareStaticCollisionPolygon(Vector2[] vectors) {
        return this.quadTreeAwareStaticCollisionPolygon(CollisionIdSequence.nextId(), vectors);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public QuadTreeAwareStaticCollisionPolygon quadTreeAwareStaticCollisionPolygon(int id, Vector2[] vectors) {
        QuadTreeAwareStaticCollisionPolygon result;
        this.init();
        Queue<QuadTreeAwareStaticCollisionPolygon> queue = this.quadTreeAwareStaticCollisionPolygons;
        synchronized (queue) {
            result = this.quadTreeAwareStaticCollisionPolygons.size == 0 ? new QuadTreeAwareStaticCollisionPolygon(CollisionIdSequence.offset(id), this, vectors) : (QuadTreeAwareStaticCollisionPolygon)this.quadTreeAwareStaticCollisionPolygons.removeFirst();
        }
        result.init(id, vectors);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release(CollisionBox collisionBox) {
        Queue<CollisionBox> queue = this.collisionBoxes;
        synchronized (queue) {
            this.collisionBoxes.addLast((Object)collisionBox);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release(CollisionCircle collisionCircle) {
        Queue<CollisionCircle> queue = this.collisionCircles;
        synchronized (queue) {
            this.collisionCircles.addLast((Object)collisionCircle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release(CollisionPoint collisionPoint) {
        Queue<CollisionPoint> queue = this.collisionPoints;
        synchronized (queue) {
            this.collisionPoints.addLast((Object)collisionPoint);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release(CollisionPolygon collisionPolygon) {
        Queue<CollisionPolygon> queue = this.collisionPolygons;
        synchronized (queue) {
            this.collisionPolygons.addLast((Object)collisionPolygon);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release(QuadTreeAwareCollisionBox collisionBox) {
        Queue<QuadTreeAwareCollisionBox> queue = this.quadTreeAwareCollisionBoxes;
        synchronized (queue) {
            this.quadTreeAwareCollisionBoxes.addLast((Object)collisionBox);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release(QuadTreeAwareCollisionCircle collisionCircle) {
        Queue<QuadTreeAwareCollisionCircle> queue = this.quadTreeAwareCollisionCircles;
        synchronized (queue) {
            this.quadTreeAwareCollisionCircles.addLast((Object)collisionCircle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release(QuadTreeAwareCollisionPoint collisionPoint) {
        Queue<QuadTreeAwareCollisionPoint> queue = this.quadTreeAwareCollisionPoints;
        synchronized (queue) {
            this.quadTreeAwareCollisionPoints.addLast((Object)collisionPoint);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release(QuadTreeAwareCollisionPolygon collisionPolygon) {
        Queue<QuadTreeAwareCollisionPolygon> queue = this.quadTreeAwareCollisionPolygons;
        synchronized (queue) {
            this.quadTreeAwareCollisionPolygons.addLast((Object)collisionPolygon);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release(StaticCollisionBox collisionBox) {
        Queue<StaticCollisionBox> queue = this.staticCollisionBoxes;
        synchronized (queue) {
            this.staticCollisionBoxes.addLast((Object)collisionBox);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release(StaticCollisionCircle collisionCircle) {
        Queue<StaticCollisionCircle> queue = this.staticCollisionCircles;
        synchronized (queue) {
            this.staticCollisionCircles.addLast((Object)collisionCircle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release(StaticCollisionPoint collisionPoint) {
        Queue<StaticCollisionPoint> queue = this.staticCollisionPoints;
        synchronized (queue) {
            this.staticCollisionPoints.addLast((Object)collisionPoint);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release(StaticCollisionPolygon collisionPolygon) {
        Queue<StaticCollisionPolygon> queue = this.staticCollisionPolygons;
        synchronized (queue) {
            this.staticCollisionPolygons.addLast((Object)collisionPolygon);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release(QuadTreeAwareStaticCollisionBox collisionBox) {
        Queue<QuadTreeAwareStaticCollisionBox> queue = this.quadTreeAwareStaticCollisionBoxes;
        synchronized (queue) {
            this.quadTreeAwareStaticCollisionBoxes.addLast((Object)collisionBox);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release(QuadTreeAwareStaticCollisionCircle collisionCircle) {
        Queue<QuadTreeAwareStaticCollisionCircle> queue = this.quadTreeAwareStaticCollisionCircles;
        synchronized (queue) {
            this.quadTreeAwareStaticCollisionCircles.addLast((Object)collisionCircle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release(QuadTreeAwareStaticCollisionPoint collisionPoint) {
        Queue<QuadTreeAwareStaticCollisionPoint> queue = this.quadTreeAwareStaticCollisionPoints;
        synchronized (queue) {
            this.quadTreeAwareStaticCollisionPoints.addLast((Object)collisionPoint);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release(QuadTreeAwareStaticCollisionPolygon collisionPolygon) {
        Queue<QuadTreeAwareStaticCollisionPolygon> queue = this.quadTreeAwareStaticCollisionPolygons;
        synchronized (queue) {
            this.quadTreeAwareStaticCollisionPolygons.addLast((Object)collisionPolygon);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getTotalCollisionBoxesAvailable() {
        this.init();
        Queue<CollisionBox> queue = this.collisionBoxes;
        synchronized (queue) {
            return this.collisionBoxes.size;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getTotalCollisionCirclesAvailable() {
        this.init();
        Queue<CollisionCircle> queue = this.collisionCircles;
        synchronized (queue) {
            return this.collisionCircles.size;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getTotalCollisionPointsAvailable() {
        this.init();
        Queue<CollisionPoint> queue = this.collisionPoints;
        synchronized (queue) {
            return this.collisionPoints.size;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getTotalCollisionPolygonsAvailable() {
        this.init();
        Queue<CollisionPolygon> queue = this.collisionPolygons;
        synchronized (queue) {
            return this.collisionPolygons.size;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getTotalQuadTreeAwareCollisionBoxesAvailable() {
        this.init();
        Queue<QuadTreeAwareCollisionBox> queue = this.quadTreeAwareCollisionBoxes;
        synchronized (queue) {
            return this.quadTreeAwareCollisionBoxes.size;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getTotalQuadTreeAwareCollisionCirclesAvailable() {
        this.init();
        Queue<QuadTreeAwareCollisionCircle> queue = this.quadTreeAwareCollisionCircles;
        synchronized (queue) {
            return this.quadTreeAwareCollisionCircles.size;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getTotalQuadTreeAwareCollisionPointsAvailable() {
        this.init();
        Queue<QuadTreeAwareCollisionPoint> queue = this.quadTreeAwareCollisionPoints;
        synchronized (queue) {
            return this.quadTreeAwareCollisionPoints.size;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getTotalQuadTreeAwareCollisionPolygonsAvailable() {
        this.init();
        Queue<QuadTreeAwareCollisionPolygon> queue = this.quadTreeAwareCollisionPolygons;
        synchronized (queue) {
            return this.quadTreeAwareCollisionPolygons.size;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getTotalStaticCollisionBoxesAvailable() {
        this.init();
        Queue<StaticCollisionBox> queue = this.staticCollisionBoxes;
        synchronized (queue) {
            return this.staticCollisionBoxes.size;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getTotalStaticCollisionCirclesAvailable() {
        this.init();
        Queue<StaticCollisionCircle> queue = this.staticCollisionCircles;
        synchronized (queue) {
            return this.staticCollisionCircles.size;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getTotalStaticCollisionPointsAvailable() {
        this.init();
        Queue<StaticCollisionPoint> queue = this.staticCollisionPoints;
        synchronized (queue) {
            return this.staticCollisionPoints.size;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getTotalStaticCollisionPolygonsAvailable() {
        this.init();
        Queue<StaticCollisionPolygon> queue = this.staticCollisionPolygons;
        synchronized (queue) {
            return this.staticCollisionPolygons.size;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getTotalQuadTreeAwareStaticCollisionBoxesAvailable() {
        this.init();
        Queue<QuadTreeAwareStaticCollisionBox> queue = this.quadTreeAwareStaticCollisionBoxes;
        synchronized (queue) {
            return this.quadTreeAwareStaticCollisionBoxes.size;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getTotalQuadTreeAwareStaticCollisionCirclesAvailable() {
        this.init();
        Queue<QuadTreeAwareStaticCollisionCircle> queue = this.quadTreeAwareStaticCollisionCircles;
        synchronized (queue) {
            return this.quadTreeAwareStaticCollisionCircles.size;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getTotalQuadTreeAwareStaticCollisionPointsAvailable() {
        this.init();
        Queue<QuadTreeAwareStaticCollisionPoint> queue = this.quadTreeAwareStaticCollisionPoints;
        synchronized (queue) {
            return this.quadTreeAwareStaticCollisionPoints.size;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getTotalQuadTreeAwareStaticCollisionPolygonsAvailable() {
        this.init();
        Queue<QuadTreeAwareStaticCollisionPolygon> queue = this.quadTreeAwareStaticCollisionPolygons;
        synchronized (queue) {
            return this.quadTreeAwareStaticCollisionPolygons.size;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void warmupCollisionBoxes(int poolSize) {
        for (int i = 0; i < poolSize; ++i) {
            Queue<CollisionBox> queue = this.collisionBoxes;
            synchronized (queue) {
                this.collisionBoxes.addLast((Object)new CollisionBox(CollisionIdSequence.nextId(), this));
                ((CollisionBox)this.collisionBoxes.removeLast()).dispose();
                continue;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void warmupCollisionCircles(int poolSize) {
        for (int i = 0; i < poolSize; ++i) {
            Queue<CollisionCircle> queue = this.collisionCircles;
            synchronized (queue) {
                this.collisionCircles.addLast((Object)new CollisionCircle(CollisionIdSequence.nextId(), this));
                ((CollisionCircle)this.collisionCircles.removeLast()).dispose();
                continue;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void warmupCollisionPoints(int poolSize) {
        for (int i = 0; i < poolSize; ++i) {
            Queue<CollisionPoint> queue = this.collisionPoints;
            synchronized (queue) {
                this.collisionPoints.addLast((Object)new CollisionPoint(CollisionIdSequence.nextId(), this));
                ((CollisionPoint)this.collisionPoints.removeLast()).dispose();
                continue;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void warmupStaticCollisionBoxes(int poolSize) {
        for (int i = 0; i < poolSize; ++i) {
            Queue<StaticCollisionBox> queue = this.staticCollisionBoxes;
            synchronized (queue) {
                this.staticCollisionBoxes.addLast((Object)new StaticCollisionBox(CollisionIdSequence.nextId(), this));
                ((StaticCollisionBox)this.staticCollisionBoxes.removeLast()).dispose();
                continue;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void warmupStaticCollisionCircles(int poolSize) {
        for (int i = 0; i < poolSize; ++i) {
            Queue<StaticCollisionCircle> queue = this.staticCollisionCircles;
            synchronized (queue) {
                this.staticCollisionCircles.addLast((Object)new StaticCollisionCircle(CollisionIdSequence.nextId(), this));
                ((StaticCollisionCircle)this.staticCollisionCircles.removeLast()).dispose();
                continue;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void warmupStaticCollisionPoints(int poolSize) {
        for (int i = 0; i < poolSize; ++i) {
            Queue<StaticCollisionPoint> queue = this.staticCollisionPoints;
            synchronized (queue) {
                this.staticCollisionPoints.addLast((Object)new StaticCollisionPoint(CollisionIdSequence.nextId(), this));
                ((StaticCollisionPoint)this.staticCollisionPoints.removeLast()).dispose();
                continue;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void warmupQuadTreeAwareCollisionBoxes(int poolSize) {
        for (int i = 0; i < poolSize; ++i) {
            Queue<QuadTreeAwareCollisionBox> queue = this.quadTreeAwareCollisionBoxes;
            synchronized (queue) {
                this.quadTreeAwareCollisionBoxes.addLast((Object)new QuadTreeAwareCollisionBox(CollisionIdSequence.nextId(), this));
                ((QuadTreeAwareCollisionBox)this.quadTreeAwareCollisionBoxes.removeLast()).dispose();
                continue;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void warmupQuadTreeAwareCollisionCircles(int poolSize) {
        for (int i = 0; i < poolSize; ++i) {
            Queue<QuadTreeAwareCollisionCircle> queue = this.quadTreeAwareCollisionCircles;
            synchronized (queue) {
                this.quadTreeAwareCollisionCircles.addLast((Object)new QuadTreeAwareCollisionCircle(CollisionIdSequence.nextId(), this));
                ((QuadTreeAwareCollisionCircle)this.quadTreeAwareCollisionCircles.removeLast()).dispose();
                continue;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void warmupQuadTreeAwareCollisionPoints(int poolSize) {
        for (int i = 0; i < poolSize; ++i) {
            Queue<QuadTreeAwareCollisionPoint> queue = this.quadTreeAwareCollisionPoints;
            synchronized (queue) {
                this.quadTreeAwareCollisionPoints.addLast((Object)new QuadTreeAwareCollisionPoint(CollisionIdSequence.nextId(), this));
                ((QuadTreeAwareCollisionPoint)this.quadTreeAwareCollisionPoints.removeLast()).dispose();
                continue;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void warmupQuadTreeAwareStaticCollisionBoxes(int poolSize) {
        for (int i = 0; i < poolSize; ++i) {
            Queue<QuadTreeAwareStaticCollisionBox> queue = this.quadTreeAwareStaticCollisionBoxes;
            synchronized (queue) {
                this.quadTreeAwareStaticCollisionBoxes.addLast((Object)new QuadTreeAwareStaticCollisionBox(CollisionIdSequence.nextId(), this));
                ((QuadTreeAwareStaticCollisionBox)this.quadTreeAwareStaticCollisionBoxes.removeLast()).dispose();
                continue;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void warmupQuadTreeAwareStaticCollisionCircles(int poolSize) {
        for (int i = 0; i < poolSize; ++i) {
            Queue<QuadTreeAwareStaticCollisionCircle> queue = this.quadTreeAwareStaticCollisionCircles;
            synchronized (queue) {
                this.quadTreeAwareStaticCollisionCircles.addLast((Object)new QuadTreeAwareStaticCollisionCircle(CollisionIdSequence.nextId(), this));
                ((QuadTreeAwareStaticCollisionCircle)this.quadTreeAwareStaticCollisionCircles.removeLast()).dispose();
                continue;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void warmupQuadTreeAwareStaticCollisionPoints(int poolSize) {
        for (int i = 0; i < poolSize; ++i) {
            Queue<QuadTreeAwareStaticCollisionPoint> queue = this.quadTreeAwareStaticCollisionPoints;
            synchronized (queue) {
                this.quadTreeAwareStaticCollisionPoints.addLast((Object)new QuadTreeAwareStaticCollisionPoint(CollisionIdSequence.nextId(), this));
                ((QuadTreeAwareStaticCollisionPoint)this.quadTreeAwareStaticCollisionPoints.removeLast()).dispose();
                continue;
            }
        }
    }
}

