/*
 * Decompiled with CFR 0.152.
 */
package org.mini2Dx.core.collision;

import org.mini2Dx.core.Graphics;
import org.mini2Dx.core.Mdx;
import org.mini2Dx.core.collision.QuadTree;
import org.mini2Dx.core.collision.QuadTreeAwareUtils;
import org.mini2Dx.core.collision.QuadTreeSearchDirection;
import org.mini2Dx.core.collision.QuadWatermarkException;
import org.mini2Dx.core.geom.LineSegment;
import org.mini2Dx.core.geom.Point;
import org.mini2Dx.core.geom.Positionable;
import org.mini2Dx.core.geom.Rectangle;
import org.mini2Dx.core.geom.Shape;
import org.mini2Dx.core.graphics.Color;
import org.mini2Dx.gdx.utils.Array;
import org.mini2Dx.lockprovider.ReadWriteLock;

public class ConcurrentPointQuadTree<T extends Positionable>
extends Rectangle
implements QuadTree<T> {
    private static final long serialVersionUID = 1926686293793174173L;
    public static Color QUAD_COLOR = Mdx.graphics != null ? Mdx.graphics.newColor(1.0f, 0.0f, 0.0f, 0.5f) : null;
    public static Color ELEMENT_COLOR = Mdx.graphics != null ? Mdx.graphics.newColor(0.0f, 0.0f, 1.0f, 0.5f) : null;
    protected ConcurrentPointQuadTree<T> parent;
    protected ConcurrentPointQuadTree<T> topLeft;
    protected ConcurrentPointQuadTree<T> topRight;
    protected ConcurrentPointQuadTree<T> bottomLeft;
    protected ConcurrentPointQuadTree<T> bottomRight;
    protected Array<T> elements;
    protected final int elementLimitPerQuad;
    protected final int mergeWatermark;
    protected final float minimumQuadWidth;
    protected final float minimumQuadHeight;
    protected final ReadWriteLock lock;
    protected int totalElementsCache = -1;
    protected int totalMerges = 0;

    public ConcurrentPointQuadTree(int elementLimitPerQuad, float x, float y, float width, float height) {
        this(elementLimitPerQuad, 0, x, y, width, height);
    }

    public ConcurrentPointQuadTree(ConcurrentPointQuadTree<T> parent, float x, float y, float width, float height) {
        this(parent.getMinimumQuadWidth(), parent.getMinimumQuadHeight(), parent.getElementLimitPerQuad(), parent.getMergeWatermark(), x, y, width, height);
        this.parent = parent;
    }

    public ConcurrentPointQuadTree(int elementLimitPerQuad, int mergeWatermark, float x, float y, float width, float height) {
        this(8.0f, 8.0f, elementLimitPerQuad, mergeWatermark, x, y, width, height);
    }

    public ConcurrentPointQuadTree(float minimumQuadWidth, float minimumQuadHeight, int elementLimitPerQuad, int mergeWatermark, float x, float y, float width, float height) {
        super(x, y, width, height);
        if (mergeWatermark >= elementLimitPerQuad) {
            throw new QuadWatermarkException(elementLimitPerQuad, mergeWatermark);
        }
        this.elementLimitPerQuad = elementLimitPerQuad;
        this.mergeWatermark = mergeWatermark;
        this.minimumQuadWidth = minimumQuadWidth;
        this.minimumQuadHeight = minimumQuadHeight;
        this.lock = Mdx.locks.newReadWriteLock();
        this.elements = new Array(true, elementLimitPerQuad);
    }

    @Override
    public void debugRender(Graphics g) {
        if (this.getX() - g.getTranslationX() > g.getViewportWidth()) {
            return;
        }
        if (this.getY() - g.getTranslationY() > g.getViewportHeight()) {
            return;
        }
        if (this.getMaxX() - g.getTranslationX() < 0.0f) {
            return;
        }
        if (this.getMaxY() - g.getTranslationY() < 0.0f) {
            return;
        }
        Color tmp = g.getColor();
        this.lock.lockRead();
        if (this.topLeft != null) {
            this.topLeft.debugRender(g);
            this.topRight.debugRender(g);
            this.bottomLeft.debugRender(g);
            this.bottomRight.debugRender(g);
        } else {
            g.setColor(QUAD_COLOR);
            g.drawShape(this);
            g.drawRect(this.getX(), this.getY(), this.getWidth(), this.getHeight());
            g.setColor(ELEMENT_COLOR);
            for (Positionable element : this.elements) {
                g.fillRect(element.getX(), element.getY(), 1.0f, 1.0f);
            }
        }
        g.setColor(tmp);
        this.lock.unlockRead();
    }

    @Override
    public void addAll(Array<T> elementsToAdd) {
        if (elementsToAdd == null || elementsToAdd.size == 0) {
            return;
        }
        this.clearTotalElementsCache();
        Array elementsWithinQuad = new Array();
        for (Positionable element : elementsToAdd) {
            if (!this.contains(element.getX(), element.getY())) continue;
            elementsWithinQuad.add((Object)element);
        }
        this.lock.lockWrite();
        if (this.topLeft != null) {
            this.lock.lockRead();
            this.lock.unlockWrite();
            for (Positionable element : elementsWithinQuad) {
                if (!this.topLeft.add(element) && !this.topRight.add(element) && !this.bottomLeft.add(element) && !this.bottomRight.add(element)) continue;
            }
            this.lock.unlockRead();
            return;
        }
        this.elements.addAll(elementsWithinQuad);
        for (Positionable element : elementsWithinQuad) {
            element.addPostionChangeListener(this);
        }
        int totalElements = this.elements.size;
        this.lock.unlockWrite();
        if (totalElements > this.elementLimitPerQuad && this.getWidth() * 0.5f >= this.minimumQuadWidth && this.getHeight() * 0.5f >= this.minimumQuadHeight) {
            this.subdivide();
        }
    }

    @Override
    public boolean add(T element) {
        if (element == null) {
            return false;
        }
        if (!this.contains(element.getX(), element.getY())) {
            return false;
        }
        this.clearTotalElementsCache();
        return this.addElement(element);
    }

    protected boolean addElement(T element) {
        this.lock.lockWrite();
        if (this.topLeft != null) {
            this.lock.lockRead();
            this.lock.unlockWrite();
            return this.addElementToChild(element);
        }
        this.elements.add(element);
        element.addPostionChangeListener(this);
        QuadTreeAwareUtils.setQuadTreeRef(element, this);
        int totalElements = this.elements.size;
        this.lock.unlockWrite();
        if (totalElements > this.elementLimitPerQuad && this.getWidth() * 0.5f >= this.minimumQuadWidth && this.getHeight() * 0.5f >= this.minimumQuadHeight) {
            this.subdivide();
        }
        return true;
    }

    protected boolean addElementToChild(T element) {
        if (this.topLeft.add(element)) {
            this.lock.unlockRead();
            return true;
        }
        if (this.topRight.add(element)) {
            this.lock.unlockRead();
            return true;
        }
        if (this.bottomLeft.add(element)) {
            this.lock.unlockRead();
            return true;
        }
        if (this.bottomRight.add(element)) {
            this.lock.unlockRead();
            return true;
        }
        this.lock.unlockRead();
        return false;
    }

    protected void subdivide() {
        this.lock.lockRead();
        if (this.topLeft != null) {
            this.lock.unlockRead();
            return;
        }
        this.lock.unlockRead();
        this.lock.lockWrite();
        if (this.topLeft != null) {
            this.lock.unlockWrite();
            return;
        }
        float halfWidth = this.getWidth() / 2.0f;
        float halfHeight = this.getHeight() / 2.0f;
        this.topLeft = new ConcurrentPointQuadTree<T>(this, this.getX(), this.getY(), halfWidth, halfHeight);
        this.topRight = new ConcurrentPointQuadTree<T>(this, this.getX() + halfWidth, this.getY(), halfWidth, halfHeight);
        this.bottomLeft = new ConcurrentPointQuadTree<T>(this, this.getX(), this.getY() + halfHeight, halfWidth, halfHeight);
        this.bottomRight = new ConcurrentPointQuadTree<T>(this, this.getX() + halfWidth, this.getY() + halfHeight, halfWidth, halfHeight);
        for (int i = this.elements.size - 1; i >= 0; --i) {
            Positionable element = (Positionable)this.elements.removeIndex(i);
            element.removePositionChangeListener(this);
            this.lock.lockRead();
            this.addElementToChild(element);
        }
        this.lock.unlockWrite();
    }

    protected boolean isMergable() {
        if (this.mergeWatermark <= 0) {
            return false;
        }
        this.lock.lockRead();
        int topLeftTotal = this.topLeft.getTotalElements();
        if (topLeftTotal >= this.mergeWatermark) {
            this.lock.unlockRead();
            return false;
        }
        int topRightTotal = this.topRight.getTotalElements();
        if (topRightTotal >= this.mergeWatermark) {
            this.lock.unlockRead();
            return false;
        }
        int bottomLeftTotal = this.bottomLeft.getTotalElements();
        if (bottomLeftTotal >= this.mergeWatermark) {
            this.lock.unlockRead();
            return false;
        }
        int bottomRightTotal = this.bottomRight.getTotalElements();
        if (bottomRightTotal >= this.mergeWatermark) {
            this.lock.unlockRead();
            return false;
        }
        this.lock.unlockRead();
        return topLeftTotal + topRightTotal + bottomLeftTotal + bottomRightTotal < this.mergeWatermark;
    }

    protected void merge() {
        if (this.topLeft == null) {
            return;
        }
        this.lock.unlockRead();
        this.lock.lockWrite();
        if (this.topLeft == null) {
            this.lock.lockRead();
            this.lock.unlockWrite();
            return;
        }
        this.topLeft.getElements(this.elements);
        this.topRight.getElements(this.elements);
        this.bottomLeft.getElements(this.elements);
        this.bottomRight.getElements(this.elements);
        for (Positionable element : this.elements) {
            this.topLeft.elements.removeValue((Object)element, false);
            element.removePositionChangeListener(this.topLeft);
            this.topRight.elements.removeValue((Object)element, false);
            element.removePositionChangeListener(this.topRight);
            this.bottomLeft.elements.removeValue((Object)element, false);
            element.removePositionChangeListener(this.bottomLeft);
            this.bottomRight.elements.removeValue((Object)element, false);
            element.removePositionChangeListener(this.bottomRight);
            element.addPostionChangeListener(this);
        }
        this.totalMerges += this.topLeft.getTotalMergeOperations();
        this.totalMerges += this.topRight.getTotalMergeOperations();
        this.totalMerges += this.bottomLeft.getTotalMergeOperations();
        this.totalMerges += this.bottomRight.getTotalMergeOperations();
        ++this.totalMerges;
        this.topLeft = null;
        this.topRight = null;
        this.bottomLeft = null;
        this.bottomRight = null;
        this.lock.unlockWrite();
        this.lock.lockRead();
    }

    @Override
    public void removeAll(Array<T> elementsToRemove) {
        if (elementsToRemove == null || elementsToRemove.size == 0) {
            return;
        }
        this.clearTotalElementsCache();
        Array elementsWithinQuad = new Array();
        for (Positionable element : elementsToRemove) {
            if (!this.contains(element.getX(), element.getY())) continue;
            elementsWithinQuad.add((Object)element);
        }
        this.lock.lockRead();
        if (this.topLeft != null) {
            for (int i = elementsWithinQuad.size - 1; i >= 0; --i) {
                Positionable element;
                element = (Positionable)elementsWithinQuad.get(i);
                if (this.topLeft.remove(element)) {
                    elementsWithinQuad.removeIndex(i);
                    continue;
                }
                if (this.topRight.remove(element)) {
                    elementsWithinQuad.removeIndex(i);
                    continue;
                }
                if (this.bottomLeft.remove(element)) {
                    elementsWithinQuad.removeIndex(i);
                    continue;
                }
                if (!this.bottomRight.remove(element)) continue;
                elementsWithinQuad.removeIndex(i);
            }
        }
        this.lock.unlockRead();
        this.lock.lockWrite();
        this.elements.removeAll(elementsWithinQuad, false);
        this.lock.unlockWrite();
        for (Positionable element : elementsWithinQuad) {
            element.removePositionChangeListener(this);
        }
        if (this.parent == null) {
            return;
        }
        if (this.parent.isMergable()) {
            this.parent.merge();
        }
    }

    @Override
    public void clear() {
        this.lock.lockWrite();
        if (this.topLeft != null) {
            this.topLeft.clear();
            this.topRight.clear();
            this.bottomLeft.clear();
            this.bottomRight.clear();
            this.topLeft = null;
            this.topRight = null;
            this.bottomLeft = null;
            this.bottomRight = null;
        }
        this.elements.clear();
        this.lock.unlockWrite();
    }

    @Override
    public boolean remove(T element) {
        if (element == null) {
            return false;
        }
        if (!this.contains(element.getX(), element.getY())) {
            return false;
        }
        this.clearTotalElementsCache();
        this.lock.lockRead();
        if (this.topLeft != null) {
            return this.removeElementFromChild(element);
        }
        this.lock.unlockRead();
        return this.removeElement(element, true);
    }

    protected boolean removeElementFromChild(T element) {
        if (this.topLeft.remove(element)) {
            this.lock.unlockRead();
            return true;
        }
        if (this.topRight.remove(element)) {
            this.lock.unlockRead();
            return true;
        }
        if (this.bottomLeft.remove(element)) {
            this.lock.unlockRead();
            return true;
        }
        if (this.bottomRight.remove(element)) {
            this.lock.unlockRead();
            return true;
        }
        this.lock.unlockRead();
        return false;
    }

    protected boolean removeElement(T element, boolean topDownInvocation) {
        this.lock.lockWrite();
        if (this.topLeft != null) {
            this.lock.lockRead();
            this.lock.unlockWrite();
            return this.removeElementFromChild(element);
        }
        boolean result = this.elements.removeValue(element, false);
        this.lock.unlockWrite();
        element.removePositionChangeListener(this);
        if (this.parent == null) {
            return result;
        }
        if (result) {
            if (this.parent.isMergable()) {
                if (!topDownInvocation) {
                    this.parent.lock.lockRead();
                }
                this.parent.merge();
                if (!topDownInvocation) {
                    this.parent.lock.unlockRead();
                }
            }
            QuadTreeAwareUtils.removeQuadTreeRef(element);
        }
        return result;
    }

    @Override
    public Array<T> getElementsWithinArea(Shape area) {
        Array result = new Array();
        this.getElementsWithinArea(result, area);
        return result;
    }

    @Override
    public Array<T> getElementsWithinArea(Shape area, QuadTreeSearchDirection searchDirection) {
        Array result = new Array();
        switch (searchDirection) {
            case UPWARDS: {
                this.getElementsWithinArea(result, area, searchDirection);
                break;
            }
            case DOWNWARDS: {
                this.getElementsWithinArea(result, area);
            }
        }
        return result;
    }

    protected void addElementsWithinArea(Array<T> result, Shape area) {
        for (int i = this.elements.size - 1; i >= 0; --i) {
            Positionable element = (Positionable)this.elements.get(i);
            if (element == null || !area.contains(element.getX(), element.getY())) continue;
            result.add((Object)element);
        }
    }

    @Override
    public void getElementsWithinArea(Array<T> result, Shape area) {
        this.lock.lockRead();
        if (this.topLeft != null) {
            this.topLeft.getElementsWithinArea(result, area);
            this.topRight.getElementsWithinArea(result, area);
            this.bottomLeft.getElementsWithinArea(result, area);
            this.bottomRight.getElementsWithinArea(result, area);
        } else {
            this.addElementsWithinArea(result, area);
        }
        this.lock.unlockRead();
    }

    @Override
    public void getElementsWithinArea(Array<T> result, Shape area, QuadTreeSearchDirection searchDirection) {
        switch (searchDirection) {
            case UPWARDS: {
                this.lock.lockRead();
                if (this.elements != null) {
                    this.addElementsWithinArea(result, area);
                }
                if (this.parent != null) {
                    if (this.parent.topLeft != this && (area.contains(this.parent.topLeft) || area.intersects(this.parent.topLeft))) {
                        this.parent.topLeft.getElementsWithinArea(result, area);
                    }
                    if (this.parent.topRight != this && (area.contains(this.parent.topRight) || area.intersects(this.parent.topRight))) {
                        this.parent.topRight.getElementsWithinArea(result, area);
                    }
                    if (this.parent.bottomLeft != this && (area.contains(this.parent.bottomLeft) || area.intersects(this.parent.bottomLeft))) {
                        this.parent.bottomLeft.getElementsWithinArea(result, area);
                    }
                    if (this.parent.bottomRight != this && (area.contains(this.parent.bottomRight) || area.intersects(this.parent.bottomRight))) {
                        this.parent.bottomRight.getElementsWithinArea(result, area);
                    }
                    this.parent.getElementsWithinArea(result, area, searchDirection);
                }
                this.lock.unlockRead();
                break;
            }
            case DOWNWARDS: {
                this.getElementsWithinArea(result, area);
            }
        }
    }

    @Override
    public Array<T> getElementsWithinAreaIgnoringEdges(Shape area) {
        Array result = new Array();
        this.getElementsWithinAreaIgnoringEdges(result, area);
        return result;
    }

    @Override
    public Array<T> getElementsWithinAreaIgnoringEdges(Shape area, QuadTreeSearchDirection searchDirection) {
        Array result = new Array();
        this.getElementsWithinAreaIgnoringEdges(result, area, searchDirection);
        return result;
    }

    @Override
    public void getElementsWithinAreaIgnoringEdges(Array<T> result, Shape area) {
        this.lock.lockRead();
        if (this.topLeft != null) {
            this.topLeft.getElementsWithinAreaIgnoringEdges(result, area);
            this.topRight.getElementsWithinAreaIgnoringEdges(result, area);
            this.bottomLeft.getElementsWithinAreaIgnoringEdges(result, area);
            this.bottomRight.getElementsWithinAreaIgnoringEdges(result, area);
        } else {
            this.addElementsWithinArea(result, area);
        }
        this.lock.unlockRead();
    }

    @Override
    public void getElementsWithinAreaIgnoringEdges(Array<T> result, Shape area, QuadTreeSearchDirection searchDirection) {
        switch (searchDirection) {
            case UPWARDS: {
                this.lock.lockRead();
                if (this.elements != null) {
                    this.addElementsWithinArea(result, area);
                }
                if (this.parent != null) {
                    if (this.parent.topLeft != this && (area.contains(this.parent.topLeft) || area.intersectsIgnoringEdges(this.parent.topLeft))) {
                        this.parent.topLeft.getElementsWithinAreaIgnoringEdges(result, area);
                    }
                    if (this.parent.topRight != this && (area.contains(this.parent.topRight) || area.intersectsIgnoringEdges(this.parent.topRight))) {
                        this.parent.topRight.getElementsWithinAreaIgnoringEdges(result, area);
                    }
                    if (this.parent.bottomLeft != this && (area.contains(this.parent.bottomLeft) || area.intersectsIgnoringEdges(this.parent.bottomLeft))) {
                        this.parent.bottomLeft.getElementsWithinAreaIgnoringEdges(result, area);
                    }
                    if (this.parent.bottomRight != this && (area.contains(this.parent.bottomRight) || area.intersectsIgnoringEdges(this.parent.bottomRight))) {
                        this.parent.bottomRight.getElementsWithinAreaIgnoringEdges(result, area);
                    }
                    this.parent.getElementsWithinAreaIgnoringEdges(result, area, searchDirection);
                }
                this.lock.unlockRead();
                break;
            }
            case DOWNWARDS: {
                this.getElementsWithinAreaIgnoringEdges(result, area);
            }
        }
    }

    @Override
    public Array<T> getElementsContainingArea(Shape area, boolean entirelyContained) {
        return new Array();
    }

    @Override
    public Array<T> getElementsContainingArea(Shape area, QuadTreeSearchDirection searchDirection, boolean entirelyContained) {
        return new Array();
    }

    @Override
    public void getElementsContainingArea(Array<T> result, Shape area, boolean entirelyContained) {
    }

    @Override
    public void getElementsContainingArea(Array<T> result, Shape area, QuadTreeSearchDirection searchDirection, boolean entirelyContained) {
    }

    @Override
    public Array<T> getElementsContainingPoint(Point point) {
        Array result = new Array();
        this.getElementsContainingPoint(result, point);
        return result;
    }

    @Override
    public Array<T> getElementsContainingPoint(Point point, QuadTreeSearchDirection searchDirection) {
        Array result = new Array();
        switch (searchDirection) {
            case UPWARDS: {
                this.getElementsContainingPoint(result, point, searchDirection);
                break;
            }
            case DOWNWARDS: {
                this.getElementsContainingPoint(result, point);
            }
        }
        return result;
    }

    @Override
    public void getElementsContainingPoint(Array<T> result, Point point) {
        this.lock.lockRead();
        if (this.topLeft != null) {
            if (this.topLeft.contains(point)) {
                this.topLeft.getElementsContainingPoint(result, point);
            }
            if (this.topRight.contains(point)) {
                this.topRight.getElementsContainingPoint(result, point);
            }
            if (this.bottomLeft.contains(point)) {
                this.bottomLeft.getElementsContainingPoint(result, point);
            }
            if (this.bottomRight.contains(point)) {
                this.bottomRight.getElementsContainingPoint(result, point);
            }
        } else {
            for (int i = this.elements.size - 1; i >= 0; --i) {
                Positionable element = (Positionable)this.elements.get(i);
                if (element == null || element.getX() != point.x || element.getY() != point.y) continue;
                result.add((Object)element);
            }
        }
        this.lock.unlockRead();
    }

    protected void addElementsContainingPoint(Array<T> result, Point point) {
        this.lock.lockRead();
        for (int i = this.elements.size - 1; i >= 0; --i) {
            Positionable element = (Positionable)this.elements.get(i);
            if (element == null || element.getX() != point.x || element.getY() != point.y) continue;
            result.add((Object)element);
        }
        this.lock.unlockRead();
    }

    @Override
    public void getElementsContainingPoint(Array<T> result, Point point, QuadTreeSearchDirection searchDirection) {
        switch (searchDirection) {
            case UPWARDS: {
                if (this.elements == null) break;
                this.addElementsContainingPoint(result, point);
                break;
            }
            case DOWNWARDS: {
                this.getElementsContainingPoint(result, point);
            }
        }
    }

    @Override
    public Array<T> getElementsIntersectingLineSegment(LineSegment lineSegment) {
        Array result = new Array();
        this.getElementsIntersectingLineSegment(result, lineSegment);
        return result;
    }

    @Override
    public Array<T> getElementsIntersectingLineSegment(LineSegment lineSegment, QuadTreeSearchDirection searchDirection) {
        Array result = new Array();
        switch (searchDirection) {
            case UPWARDS: {
                this.getElementsIntersectingLineSegment(result, lineSegment, searchDirection);
                break;
            }
            case DOWNWARDS: {
                this.getElementsIntersectingLineSegment(result, lineSegment);
            }
        }
        return result;
    }

    protected static boolean intersects(ConcurrentPointQuadTree tree, LineSegment segment) {
        return tree.intersects(segment) || tree.contains(segment.getPointA()) || tree.contains(segment.getPointB());
    }

    protected void addElementsIntersectingLineSegment(Array<T> result, LineSegment lineSegment) {
        for (int i = this.elements.size - 1; i >= 0; --i) {
            Positionable element = (Positionable)this.elements.get(i);
            if (element == null || !lineSegment.contains(element.getX(), element.getY())) continue;
            result.add((Object)element);
        }
    }

    @Override
    public void getElementsIntersectingLineSegment(Array<T> result, LineSegment lineSegment) {
        this.lock.lockRead();
        if (this.topLeft != null) {
            if (ConcurrentPointQuadTree.intersects(this.topLeft, lineSegment)) {
                this.topLeft.getElementsIntersectingLineSegment(result, lineSegment);
            }
            if (ConcurrentPointQuadTree.intersects(this.topRight, lineSegment)) {
                this.topRight.getElementsIntersectingLineSegment(result, lineSegment);
            }
            if (ConcurrentPointQuadTree.intersects(this.bottomLeft, lineSegment)) {
                this.bottomLeft.getElementsIntersectingLineSegment(result, lineSegment);
            }
            if (ConcurrentPointQuadTree.intersects(this.bottomRight, lineSegment)) {
                this.bottomRight.getElementsIntersectingLineSegment(result, lineSegment);
            }
        } else {
            this.addElementsIntersectingLineSegment(result, lineSegment);
        }
        this.lock.unlockRead();
    }

    @Override
    public void getElementsIntersectingLineSegment(Array<T> result, LineSegment lineSegment, QuadTreeSearchDirection searchDirection) {
        switch (searchDirection) {
            case UPWARDS: {
                this.lock.lockRead();
                if (this.elements != null) {
                    this.addElementsIntersectingLineSegment(result, lineSegment);
                }
                if (this.parent != null) {
                    if (this.parent.topLeft != this && ConcurrentPointQuadTree.intersects(this.parent.topLeft, lineSegment)) {
                        this.parent.topLeft.getElementsIntersectingLineSegment(result, lineSegment);
                    }
                    if (this.parent.topRight != this && ConcurrentPointQuadTree.intersects(this.parent.topRight, lineSegment)) {
                        this.parent.topRight.getElementsIntersectingLineSegment(result, lineSegment);
                    }
                    if (this.parent.bottomLeft != this && ConcurrentPointQuadTree.intersects(this.parent.bottomLeft, lineSegment)) {
                        this.parent.bottomLeft.getElementsIntersectingLineSegment(result, lineSegment);
                    }
                    if (this.parent.bottomRight != this && ConcurrentPointQuadTree.intersects(this.parent.bottomRight, lineSegment)) {
                        this.parent.bottomRight.getElementsIntersectingLineSegment(result, lineSegment);
                    }
                    this.parent.getElementsIntersectingLineSegment(result, lineSegment, searchDirection);
                }
                this.lock.unlockRead();
                break;
            }
            case DOWNWARDS: {
                this.getElementsIntersectingLineSegment(result, lineSegment);
            }
        }
    }

    @Override
    public Array<T> getElements() {
        Array result = new Array();
        this.getElements(result);
        return result;
    }

    @Override
    public void getElements(Array<T> result) {
        this.lock.lockRead();
        if (this.topLeft != null) {
            this.topLeft.getElements(result);
            this.topRight.getElements(result);
            this.bottomLeft.getElements(result);
            this.bottomRight.getElements(result);
        } else {
            result.addAll(this.elements);
        }
        this.lock.unlockRead();
    }

    @Override
    public int getTotalQuads() {
        this.lock.lockRead();
        if (this.topLeft != null) {
            int result = this.topLeft.getTotalQuads();
            result += this.topRight.getTotalQuads();
            result += this.bottomLeft.getTotalQuads();
            this.lock.unlockRead();
            return result += this.bottomRight.getTotalQuads();
        }
        this.lock.unlockRead();
        return 1;
    }

    @Override
    public int getTotalElements() {
        if (this.totalElementsCache >= 0) {
            return this.totalElementsCache;
        }
        this.lock.lockRead();
        if (this.topLeft != null) {
            this.totalElementsCache = this.topLeft.getTotalElements();
            this.totalElementsCache += this.topRight.getTotalElements();
            this.totalElementsCache += this.bottomLeft.getTotalElements();
            this.totalElementsCache += this.bottomRight.getTotalElements();
        } else {
            this.totalElementsCache = this.elements.size;
        }
        this.lock.unlockRead();
        return this.totalElementsCache;
    }

    protected void clearTotalElementsCache() {
        this.totalElementsCache = -1;
    }

    @Override
    public void positionChanged(T moved) {
        if (this.contains(moved.getX(), moved.getY())) {
            return;
        }
        this.removeElement(moved, false);
        for (QuadTree<T> parentQuad = this.parent; parentQuad != null; parentQuad = parentQuad.getParent()) {
            if (!parentQuad.add(moved)) continue;
            return;
        }
    }

    @Override
    public QuadTree<T> getParent() {
        return this.parent;
    }

    public int getTotalMergeOperations() {
        this.lock.lockRead();
        int result = this.totalMerges;
        if (this.topLeft != null) {
            result += this.topLeft.getTotalMergeOperations();
            result += this.topRight.getTotalMergeOperations();
            result += this.bottomLeft.getTotalMergeOperations();
            result += this.bottomRight.getTotalMergeOperations();
        }
        this.lock.unlockRead();
        return result;
    }

    public int getElementLimitPerQuad() {
        return this.elementLimitPerQuad;
    }

    public int getMergeWatermark() {
        return this.mergeWatermark;
    }

    @Override
    public float getMinimumQuadWidth() {
        return this.minimumQuadWidth;
    }

    @Override
    public float getMinimumQuadHeight() {
        return this.minimumQuadHeight;
    }
}

