/*
 * Decompiled with CFR 0.152.
 */
package org.mini2Dx.core.collision;

import org.mini2Dx.core.Graphics;
import org.mini2Dx.core.collision.ConcurrentPointQuadTree;
import org.mini2Dx.core.collision.QuadTree;
import org.mini2Dx.core.collision.QuadTreeAwareUtils;
import org.mini2Dx.core.collision.QuadTreeSearchDirection;
import org.mini2Dx.core.geom.LineSegment;
import org.mini2Dx.core.geom.Point;
import org.mini2Dx.core.geom.Shape;
import org.mini2Dx.core.geom.Sizeable;
import org.mini2Dx.core.graphics.Color;
import org.mini2Dx.gdx.utils.Array;

public class ConcurrentRegionQuadTree<T extends Sizeable>
extends ConcurrentPointQuadTree<T> {
    private static final long serialVersionUID = 2344163859287984782L;

    public ConcurrentRegionQuadTree(int elementLimit, int mergeWatermark, float x, float y, float width, float height) {
        super(elementLimit, mergeWatermark, x, y, width, height);
    }

    public ConcurrentRegionQuadTree(int elementLimit, float x, float y, float width, float height) {
        super(elementLimit, x, y, width, height);
    }

    public ConcurrentRegionQuadTree(ConcurrentRegionQuadTree<T> parent, float x, float y, float width, float height) {
        super(parent, x, y, width, height);
    }

    public ConcurrentRegionQuadTree(float minimumQuadWidth, float minimumQuadHeight, int elementLimitPerQuad, int mergeWatermark, float x, float y, float width, float height) {
        super(minimumQuadWidth, minimumQuadHeight, elementLimitPerQuad, mergeWatermark, x, y, width, height);
    }

    @Override
    public void debugRender(Graphics g) {
        if (this.getX() - g.getTranslationX() > g.getViewportWidth()) {
            return;
        }
        if (this.getY() - g.getTranslationY() > g.getViewportHeight()) {
            return;
        }
        if (this.getMaxX() - g.getTranslationX() < 0.0f) {
            return;
        }
        if (this.getMaxY() - g.getTranslationY() < 0.0f) {
            return;
        }
        Color tmp = g.getColor();
        this.lock.lockRead();
        if (this.topLeft != null) {
            this.topLeft.debugRender(g);
            this.topRight.debugRender(g);
            this.bottomLeft.debugRender(g);
            this.bottomRight.debugRender(g);
        } else {
            g.setColor(QUAD_COLOR);
            g.drawRect(this.getX(), this.getY(), this.getWidth(), this.getHeight());
            g.setColor(tmp);
        }
        tmp = g.getColor();
        g.setColor(ELEMENT_COLOR);
        for (Sizeable element : this.elements) {
            g.drawRect(element.getX(), element.getY(), element.getWidth(), element.getHeight());
        }
        this.lock.unlockRead();
        g.setColor(tmp);
    }

    @Override
    public void addAll(Array<T> elements) {
        if (elements == null || elements.size == 0) {
            return;
        }
        Array elementsWithinQuad = new Array();
        for (Sizeable element : elements) {
            if (!this.contains(element) && !this.intersects(element)) continue;
            elementsWithinQuad.add((Object)element);
        }
        this.clearTotalElementsCache();
        this.lock.lockWrite();
        if (this.topLeft != null) {
            this.lock.lockRead();
            this.lock.unlockWrite();
            for (int i = elementsWithinQuad.size - 1; i >= 0; --i) {
                Sizeable element;
                element = (Sizeable)elementsWithinQuad.get(i);
                if (this.topLeft.add(element)) {
                    elementsWithinQuad.removeIndex(i);
                    continue;
                }
                if (this.topRight.add(element)) {
                    elementsWithinQuad.removeIndex(i);
                    continue;
                }
                if (this.bottomLeft.add(element)) {
                    elementsWithinQuad.removeIndex(i);
                    continue;
                }
                if (!this.bottomRight.add(element)) continue;
                elementsWithinQuad.removeIndex(i);
            }
            this.lock.unlockRead();
            if (elementsWithinQuad.size == 0) {
                return;
            }
            this.lock.lockWrite();
        }
        this.elements.addAll(elementsWithinQuad);
        for (Sizeable element : elementsWithinQuad) {
            element.addPostionChangeListener(this);
        }
        int totalElements = this.elements.size;
        this.lock.unlockWrite();
        if (totalElements > this.elementLimitPerQuad && this.getWidth() >= 2.0f && this.getHeight() >= 2.0f) {
            this.subdivide();
        }
    }

    @Override
    public boolean add(T element) {
        if (element == null) {
            return false;
        }
        if (!this.intersects((Sizeable)element) && !this.contains((Sizeable)element)) {
            return false;
        }
        this.clearTotalElementsCache();
        return this.addElement(element);
    }

    @Override
    protected boolean addElement(T element) {
        this.lock.lockWrite();
        if (this.topLeft != null) {
            this.lock.lockRead();
            this.lock.unlockWrite();
            boolean result = this.addElementToChild(element);
            if (result) {
                return true;
            }
            this.lock.lockWrite();
        }
        this.elements.add(element);
        element.addPostionChangeListener(this);
        QuadTreeAwareUtils.setQuadTreeRef(element, this);
        if (this.elements.size > this.elementLimitPerQuad && this.getWidth() >= 2.0f && this.getHeight() >= 2.0f) {
            this.subdivide();
        }
        this.lock.unlockWrite();
        return true;
    }

    @Override
    protected boolean addElementToChild(T element) {
        if (this.topLeft.contains((Sizeable)element)) {
            boolean result = this.topLeft.add(element);
            this.lock.unlockRead();
            return result;
        }
        if (this.topRight.contains((Sizeable)element)) {
            boolean result = this.topRight.add(element);
            this.lock.unlockRead();
            return result;
        }
        if (this.bottomLeft.contains((Sizeable)element)) {
            boolean result = this.bottomLeft.add(element);
            this.lock.unlockRead();
            return result;
        }
        if (this.bottomRight.contains((Sizeable)element)) {
            boolean result = this.bottomRight.add(element);
            this.lock.unlockRead();
            return result;
        }
        this.lock.unlockRead();
        return false;
    }

    @Override
    protected void subdivide() {
        this.lock.lockRead();
        if (this.topLeft != null) {
            this.lock.unlockRead();
            return;
        }
        this.lock.unlockRead();
        this.lock.lockWrite();
        if (this.topLeft != null) {
            this.lock.unlockWrite();
            return;
        }
        float halfWidth = this.getWidth() / 2.0f;
        float halfHeight = this.getHeight() / 2.0f;
        this.topLeft = new ConcurrentRegionQuadTree<T>(this, this.getX(), this.getY(), halfWidth, halfHeight);
        this.topRight = new ConcurrentRegionQuadTree<T>(this, this.getX() + halfWidth, this.getY(), halfWidth, halfHeight);
        this.bottomLeft = new ConcurrentRegionQuadTree<T>(this, this.getX(), this.getY() + halfHeight, halfWidth, halfHeight);
        this.bottomRight = new ConcurrentRegionQuadTree<T>(this, this.getX() + halfWidth, this.getY() + halfHeight, halfWidth, halfHeight);
        for (int i = this.elements.size - 1; i >= 0; --i) {
            this.lock.lockRead();
            Sizeable element = (Sizeable)this.elements.get(i);
            if (!this.addElementToChild((T)element)) continue;
            this.elements.removeValue((Object)element, false);
            element.removePositionChangeListener(this);
        }
        this.lock.unlockWrite();
    }

    @Override
    public void removeAll(Array<T> elementsToRemove) {
        if (elementsToRemove == null || elementsToRemove.size == 0) {
            return;
        }
        this.clearTotalElementsCache();
        Array elementsWithinQuad = new Array();
        for (Sizeable element : elementsToRemove) {
            if (!this.contains(element) && !this.intersects(element)) continue;
            elementsWithinQuad.add((Object)element);
        }
        this.lock.lockRead();
        if (this.topLeft != null) {
            for (int i = elementsWithinQuad.size - 1; i >= 0; --i) {
                Sizeable element;
                element = (Sizeable)elementsWithinQuad.get(i);
                if (this.topLeft.remove(element)) {
                    elementsWithinQuad.removeIndex(i);
                    continue;
                }
                if (this.topRight.remove(element)) {
                    elementsWithinQuad.removeIndex(i);
                    continue;
                }
                if (this.bottomLeft.remove(element)) {
                    elementsWithinQuad.removeIndex(i);
                    continue;
                }
                if (!this.bottomRight.remove(element)) continue;
                elementsWithinQuad.removeIndex(i);
            }
        }
        this.lock.unlockRead();
        this.lock.lockWrite();
        this.elements.removeAll(elementsWithinQuad, false);
        this.lock.unlockWrite();
        for (Sizeable element : elementsWithinQuad) {
            element.removePositionChangeListener(this);
        }
        if (this.parent == null) {
            return;
        }
        if (this.parent.isMergable()) {
            this.parent.merge();
        }
    }

    @Override
    public boolean remove(T element) {
        if (element == null) {
            return false;
        }
        if (!this.intersects((Sizeable)element) && !this.contains((Sizeable)element)) {
            return false;
        }
        this.clearTotalElementsCache();
        return this.removeElement(element, true);
    }

    @Override
    protected boolean removeElement(T element, boolean topDownInvocation) {
        boolean result;
        this.lock.lockWrite();
        if (this.topLeft != null) {
            this.lock.lockRead();
            this.lock.unlockWrite();
            result = this.removeElementFromChild(element);
            if (result) {
                return true;
            }
            this.lock.lockWrite();
        }
        result = this.elements.removeValue(element, false);
        this.lock.unlockWrite();
        element.removePositionChangeListener(this);
        if (this.parent == null) {
            return result;
        }
        if (result) {
            if (this.parent.isMergable()) {
                if (!topDownInvocation) {
                    this.parent.lock.lockRead();
                }
                this.parent.merge();
                if (!topDownInvocation) {
                    this.parent.lock.unlockRead();
                }
            }
            QuadTreeAwareUtils.removeQuadTreeRef(element);
        }
        return result;
    }

    @Override
    protected void addElementsWithinArea(Array<T> result, Shape area) {
        for (int i = this.elements.size - 1; i >= 0; --i) {
            Sizeable element = (Sizeable)this.elements.get(i);
            if (element == null || !area.contains(element) && !area.intersects(element)) continue;
            result.add((Object)element);
        }
    }

    @Override
    public void getElementsWithinArea(Array<T> result, Shape area) {
        this.lock.lockRead();
        if (this.topLeft != null) {
            if (this.topLeft.contains(area) || this.topLeft.intersects(area)) {
                this.topLeft.getElementsWithinArea(result, area);
            }
            if (this.topRight.contains(area) || this.topRight.intersects(area)) {
                this.topRight.getElementsWithinArea(result, area);
            }
            if (this.bottomLeft.contains(area) || this.bottomLeft.intersects(area)) {
                this.bottomLeft.getElementsWithinArea(result, area);
            }
            if (this.bottomRight.contains(area) || this.bottomRight.intersects(area)) {
                this.bottomRight.getElementsWithinArea(result, area);
            }
        }
        this.addElementsWithinArea(result, area);
        this.lock.unlockRead();
    }

    @Override
    public void getElementsWithinArea(Array<T> result, Shape area, QuadTreeSearchDirection searchDirection) {
        switch (searchDirection) {
            case UPWARDS: {
                this.getElementsWithinAreaUpwards(result, area, true);
                break;
            }
            case DOWNWARDS: {
                this.getElementsWithinArea(result, area);
            }
        }
    }

    private void getElementsWithinAreaUpwards(Array<T> result, Shape area, boolean firstInvocation) {
        this.lock.lockRead();
        if (this.elements != null) {
            this.addElementsWithinArea(result, area);
        }
        if (firstInvocation && this.topLeft != null) {
            if (area.contains(this.topLeft) || area.intersects(this.topLeft)) {
                this.topLeft.getElementsWithinArea(result, area);
            }
            if (area.contains(this.topRight) || area.intersects(this.topRight)) {
                this.topRight.getElementsWithinArea(result, area);
            }
            if (area.contains(this.bottomLeft) || area.intersects(this.bottomLeft)) {
                this.bottomLeft.getElementsWithinArea(result, area);
            }
            if (area.contains(this.bottomRight) || area.intersects(this.bottomRight)) {
                this.bottomRight.getElementsWithinArea(result, area);
            }
        }
        if (this.parent != null) {
            if (this.parent.topLeft != this && (area.contains(this.parent.topLeft) || area.intersects(this.parent.topLeft))) {
                this.parent.topLeft.getElementsWithinArea(result, area);
            }
            if (this.parent.topRight != this && (area.contains(this.parent.topRight) || area.intersects(this.parent.topRight))) {
                this.parent.topRight.getElementsWithinArea(result, area);
            }
            if (this.parent.bottomLeft != this && (area.contains(this.parent.bottomLeft) || area.intersects(this.parent.bottomLeft))) {
                this.parent.bottomLeft.getElementsWithinArea(result, area);
            }
            if (this.parent.bottomRight != this && (area.contains(this.parent.bottomRight) || area.intersects(this.parent.bottomRight))) {
                this.parent.bottomRight.getElementsWithinArea(result, area);
            }
            ((ConcurrentRegionQuadTree)this.parent).getElementsWithinAreaUpwards(result, area, false);
        }
        this.lock.unlockRead();
    }

    @Override
    public Array<T> getElementsContainingArea(Shape area, boolean entirelyContained) {
        Array result = new Array();
        this.getElementsContainingArea(result, area, entirelyContained);
        return result;
    }

    @Override
    public Array<T> getElementsContainingArea(Shape area, QuadTreeSearchDirection searchDirection, boolean entirelyContained) {
        Array result = new Array();
        switch (searchDirection) {
            case UPWARDS: {
                this.getElementsContainingArea(result, area, searchDirection, entirelyContained);
                break;
            }
            case DOWNWARDS: {
                this.getElementsContainingArea(result, area, entirelyContained);
            }
        }
        return result;
    }

    protected void addElementsContainingArea(Array<T> result, Shape area, boolean entirelyContained) {
        if (entirelyContained) {
            for (int i = this.elements.size - 1; i >= 0; --i) {
                Sizeable element = (Sizeable)this.elements.get(i);
                if (element == null || !element.contains(area)) continue;
                result.add((Object)element);
            }
        } else {
            for (int i = this.elements.size - 1; i >= 0; --i) {
                Sizeable element = (Sizeable)this.elements.get(i);
                if (element == null || !element.contains(area) && !element.intersects(area) || area.getWidth() > element.getWidth() || area.getHeight() > element.getHeight()) continue;
                result.add((Object)element);
            }
        }
    }

    @Override
    public void getElementsContainingArea(Array<T> result, Shape area, boolean entirelyContained) {
        this.lock.lockRead();
        if (this.topLeft != null) {
            if (this.topLeft.contains(area) || this.topLeft.intersects(area)) {
                this.topLeft.getElementsContainingArea(result, area, entirelyContained);
            }
            if (this.topRight.contains(area) || this.topRight.intersects(area)) {
                this.topRight.getElementsContainingArea(result, area, entirelyContained);
            }
            if (this.bottomLeft.contains(area) || this.bottomLeft.intersects(area)) {
                this.bottomLeft.getElementsContainingArea(result, area, entirelyContained);
            }
            if (this.bottomRight.contains(area) || this.bottomRight.intersects(area)) {
                this.bottomRight.getElementsContainingArea(result, area, entirelyContained);
            }
        }
        this.addElementsContainingArea(result, area, entirelyContained);
        this.lock.unlockRead();
    }

    @Override
    public void getElementsContainingArea(Array<T> result, Shape area, QuadTreeSearchDirection searchDirection, boolean entirelyContained) {
        switch (searchDirection) {
            case UPWARDS: {
                this.getElementsContainingAreaUpwards(result, area, true, entirelyContained);
                break;
            }
            case DOWNWARDS: {
                this.getElementsContainingArea(result, area, entirelyContained);
            }
        }
    }

    protected void getElementsContainingAreaUpwards(Array<T> result, Shape area, boolean firstInvocation, boolean entirelyContained) {
        this.lock.lockRead();
        if (this.elements != null) {
            this.addElementsContainingArea(result, area, entirelyContained);
        }
        if (firstInvocation && this.topLeft != null) {
            if (area.contains(this.topLeft) || area.intersects(this.topLeft)) {
                this.topLeft.getElementsContainingArea(result, area, entirelyContained);
            }
            if (area.contains(this.topRight) || area.intersects(this.topRight)) {
                this.topRight.getElementsContainingArea(result, area, entirelyContained);
            }
            if (area.contains(this.bottomLeft) || area.intersects(this.bottomLeft)) {
                this.bottomLeft.getElementsContainingArea(result, area, entirelyContained);
            }
            if (area.contains(this.bottomRight) || area.intersects(this.bottomRight)) {
                this.bottomRight.getElementsContainingArea(result, area, entirelyContained);
            }
        }
        if (this.parent != null) {
            if (this.parent.topLeft != this && (area.contains(this.parent.topLeft) || area.intersects(this.parent.topLeft))) {
                this.parent.topLeft.getElementsContainingArea(result, area, entirelyContained);
            }
            if (this.parent.topRight != this && (area.contains(this.parent.topRight) || area.intersects(this.parent.topRight))) {
                this.parent.topRight.getElementsContainingArea(result, area, entirelyContained);
            }
            if (this.parent.bottomLeft != this && (area.contains(this.parent.bottomLeft) || area.intersects(this.parent.bottomLeft))) {
                this.parent.bottomLeft.getElementsContainingArea(result, area, entirelyContained);
            }
            if (this.parent.bottomRight != this && (area.contains(this.parent.bottomRight) || area.intersects(this.parent.bottomRight))) {
                this.parent.bottomRight.getElementsContainingArea(result, area, entirelyContained);
            }
            ((ConcurrentRegionQuadTree)this.parent).getElementsContainingAreaUpwards(result, area, false, entirelyContained);
        }
        this.lock.unlockRead();
    }

    @Override
    protected void addElementsContainingPoint(Array<T> result, Point point) {
        for (int i = this.elements.size - 1; i >= 0; --i) {
            Sizeable element = (Sizeable)this.elements.get(i);
            if (element == null || !element.contains(point)) continue;
            result.add((Object)element);
        }
    }

    @Override
    public void getElementsContainingPoint(Array<T> result, Point point) {
        this.lock.lockRead();
        if (this.topLeft != null) {
            if (this.topLeft.contains(point)) {
                this.topLeft.getElementsContainingPoint(result, point);
            }
            if (this.topRight.contains(point)) {
                this.topRight.getElementsContainingPoint(result, point);
            }
            if (this.bottomLeft.contains(point)) {
                this.bottomLeft.getElementsContainingPoint(result, point);
            }
            if (this.bottomRight.contains(point)) {
                this.bottomRight.getElementsContainingPoint(result, point);
            }
        }
        this.addElementsContainingPoint(result, point);
        this.lock.unlockRead();
    }

    @Override
    public void getElementsContainingPoint(Array<T> result, Point point, QuadTreeSearchDirection searchDirection) {
        switch (searchDirection) {
            case UPWARDS: {
                this.getElementsContainingPointUpwards(result, point, true);
                break;
            }
            case DOWNWARDS: {
                this.getElementsContainingPoint(result, point);
            }
        }
    }

    private void getElementsContainingPointUpwards(Array<T> result, Point point, boolean firstInvocation) {
        this.lock.lockRead();
        if (this.elements != null) {
            this.addElementsContainingPoint(result, point);
        }
        if (firstInvocation && this.topLeft != null) {
            if (this.topLeft.contains(point)) {
                this.topLeft.getElementsContainingPoint(result, point);
            }
            if (this.topRight.contains(point)) {
                this.topRight.getElementsContainingPoint(result, point);
            }
            if (this.bottomLeft.contains(point)) {
                this.bottomLeft.getElementsContainingPoint(result, point);
            }
            if (this.bottomRight.contains(point)) {
                this.bottomRight.getElementsContainingPoint(result, point);
            }
        }
        if (this.parent != null) {
            if (this.parent.topLeft != this && (this.parent.topLeft.contains(point) || this.parent.topLeft.contains(point))) {
                this.parent.topLeft.getElementsContainingPoint(result, point);
            }
            if (this.parent.topRight != this && (this.parent.topRight.contains(point) || this.parent.topRight.contains(point))) {
                this.parent.topRight.getElementsContainingPoint(result, point);
            }
            if (this.parent.bottomLeft != this && (this.parent.bottomLeft.contains(point) || this.parent.bottomLeft.contains(point))) {
                this.parent.bottomLeft.getElementsContainingPoint(result, point);
            }
            if (this.parent.bottomRight != this && (this.parent.bottomRight.contains(point) || this.parent.bottomRight.contains(point))) {
                this.parent.bottomRight.getElementsContainingPoint(result, point);
            }
            ((ConcurrentRegionQuadTree)this.parent).getElementsContainingPointUpwards(result, point, false);
        }
        this.lock.unlockRead();
    }

    @Override
    protected void addElementsIntersectingLineSegment(Array<T> result, LineSegment lineSegment) {
        for (int i = this.elements.size - 1; i >= 0; --i) {
            Sizeable element = (Sizeable)this.elements.get(i);
            if (element == null || !element.intersects(lineSegment)) continue;
            result.add((Object)element);
        }
    }

    @Override
    public void getElementsIntersectingLineSegment(Array<T> result, LineSegment lineSegment) {
        this.lock.lockRead();
        if (this.topLeft != null) {
            if (ConcurrentRegionQuadTree.intersects(this.topLeft, lineSegment)) {
                this.topLeft.getElementsIntersectingLineSegment(result, lineSegment);
            }
            if (ConcurrentRegionQuadTree.intersects(this.topRight, lineSegment)) {
                this.topRight.getElementsIntersectingLineSegment(result, lineSegment);
            }
            if (ConcurrentRegionQuadTree.intersects(this.bottomLeft, lineSegment)) {
                this.bottomLeft.getElementsIntersectingLineSegment(result, lineSegment);
            }
            if (ConcurrentRegionQuadTree.intersects(this.bottomRight, lineSegment)) {
                this.bottomRight.getElementsIntersectingLineSegment(result, lineSegment);
            }
        }
        this.addElementsIntersectingLineSegment(result, lineSegment);
        this.lock.unlockRead();
    }

    @Override
    public void getElementsIntersectingLineSegment(Array<T> result, LineSegment lineSegment, QuadTreeSearchDirection searchDirection) {
        switch (searchDirection) {
            case UPWARDS: {
                this.addElementsIntersectingLineSegmentUpwards(result, lineSegment, true);
                break;
            }
            case DOWNWARDS: {
                this.getElementsIntersectingLineSegment(result, lineSegment);
            }
        }
    }

    private void addElementsIntersectingLineSegmentUpwards(Array<T> result, LineSegment lineSegment, boolean firstInvocation) {
        this.lock.lockRead();
        if (this.elements != null) {
            this.addElementsIntersectingLineSegment(result, lineSegment);
        }
        if (this.topLeft != null && firstInvocation) {
            if (ConcurrentRegionQuadTree.intersects(this.topLeft, lineSegment)) {
                this.topLeft.getElementsIntersectingLineSegment(result, lineSegment);
            }
            if (ConcurrentRegionQuadTree.intersects(this.topRight, lineSegment)) {
                this.topRight.getElementsIntersectingLineSegment(result, lineSegment);
            }
            if (ConcurrentRegionQuadTree.intersects(this.bottomLeft, lineSegment)) {
                this.bottomLeft.getElementsIntersectingLineSegment(result, lineSegment);
            }
            if (ConcurrentRegionQuadTree.intersects(this.bottomRight, lineSegment)) {
                this.bottomRight.getElementsIntersectingLineSegment(result, lineSegment);
            }
        }
        if (this.parent != null) {
            if (this.parent.topLeft != this && ConcurrentRegionQuadTree.intersects(this.parent.topLeft, lineSegment)) {
                this.parent.topLeft.getElementsIntersectingLineSegment(result, lineSegment);
            }
            if (this.parent.topRight != this && ConcurrentRegionQuadTree.intersects(this.parent.topRight, lineSegment)) {
                this.parent.topRight.getElementsIntersectingLineSegment(result, lineSegment);
            }
            if (this.parent.bottomLeft != this && ConcurrentRegionQuadTree.intersects(this.parent.bottomLeft, lineSegment)) {
                this.parent.bottomLeft.getElementsIntersectingLineSegment(result, lineSegment);
            }
            if (this.parent.bottomRight != this && ConcurrentRegionQuadTree.intersects(this.parent.bottomRight, lineSegment)) {
                this.parent.bottomRight.getElementsIntersectingLineSegment(result, lineSegment);
            }
            ((ConcurrentRegionQuadTree)this.parent).addElementsIntersectingLineSegmentUpwards(result, lineSegment, false);
        }
        this.lock.unlockRead();
    }

    @Override
    public Array<T> getElements() {
        Array result = new Array();
        this.getElements(result);
        return result;
    }

    @Override
    public void getElements(Array<T> result) {
        this.lock.lockRead();
        if (this.topLeft != null) {
            ((ConcurrentRegionQuadTree)this.topLeft).getElements(result);
            ((ConcurrentRegionQuadTree)this.topRight).getElements(result);
            ((ConcurrentRegionQuadTree)this.bottomLeft).getElements(result);
            ((ConcurrentRegionQuadTree)this.bottomRight).getElements(result);
        }
        result.addAll(this.elements);
        this.lock.unlockRead();
    }

    @Override
    public int getTotalElements() {
        if (this.totalElementsCache >= 0) {
            return this.totalElementsCache;
        }
        this.totalElementsCache = 0;
        this.lock.lockRead();
        if (this.topLeft != null) {
            this.totalElementsCache = this.topLeft.getTotalElements();
            this.totalElementsCache += this.topRight.getTotalElements();
            this.totalElementsCache += this.bottomLeft.getTotalElements();
            this.totalElementsCache += this.bottomRight.getTotalElements();
        }
        this.totalElementsCache += this.elements.size;
        this.lock.unlockRead();
        return this.totalElementsCache;
    }

    @Override
    public void positionChanged(T moved) {
        if (this.contains((Sizeable)moved)) {
            return;
        }
        this.removeElement(moved, false);
        for (QuadTree parentQuad = this.parent; parentQuad != null; parentQuad = parentQuad.getParent()) {
            if (!parentQuad.add(moved)) continue;
            return;
        }
    }
}

