/*
 * Decompiled with CFR 0.152.
 */
package org.mini2Dx.core.collision;

import org.mini2Dx.core.Graphics;
import org.mini2Dx.core.Mdx;
import org.mini2Dx.core.collision.QuadTree;
import org.mini2Dx.core.collision.QuadTreeAwareUtils;
import org.mini2Dx.core.collision.QuadTreeSearchDirection;
import org.mini2Dx.core.collision.QuadWatermarkException;
import org.mini2Dx.core.geom.LineSegment;
import org.mini2Dx.core.geom.Point;
import org.mini2Dx.core.geom.Positionable;
import org.mini2Dx.core.geom.Rectangle;
import org.mini2Dx.core.geom.Shape;
import org.mini2Dx.core.graphics.Color;
import org.mini2Dx.gdx.utils.Array;
import org.mini2Dx.gdx.utils.Queue;

public class PointQuadTree<T extends Positionable>
extends Rectangle
implements QuadTree<T> {
    public static final float DEFAULT_MINIMUM_QUAD_SIZE = 8.0f;
    public static Color QUAD_COLOR = Mdx.graphics != null ? Mdx.graphics.newColor(1.0f, 0.0f, 0.0f, 0.5f) : null;
    public static Color ELEMENT_COLOR = Mdx.graphics != null ? Mdx.graphics.newColor(0.0f, 0.0f, 1.0f, 0.5f) : null;
    private static final long serialVersionUID = -2034928347848875105L;
    protected Queue<PointQuadTree<T>> pool;
    protected PointQuadTree<T> parent;
    protected PointQuadTree<T> topLeft;
    protected PointQuadTree<T> topRight;
    protected PointQuadTree<T> bottomLeft;
    protected PointQuadTree<T> bottomRight;
    protected Array<T> elements;
    protected final int elementLimitPerQuad;
    protected final int mergeWatermark;
    protected final float minimumQuadWidth;
    protected final float minimumQuadHeight;
    protected int totalElementsCache = -1;

    public PointQuadTree(int elementLimitPerQuad, int mergeWatermark, float x, float y, float width, float height) {
        this(8.0f, 8.0f, elementLimitPerQuad, mergeWatermark, x, y, width, height);
        this.pool = new Queue();
    }

    public PointQuadTree(int elementLimitPerQuad, float x, float y, float width, float height) {
        this(elementLimitPerQuad, 0, x, y, width, height);
        this.pool = new Queue();
    }

    public PointQuadTree(PointQuadTree<T> parent, float x, float y, float width, float height) {
        this(parent.getMinimumQuadWidth(), parent.getMinimumQuadHeight(), parent.getElementLimitPerQuad(), parent.getMergeWatermark(), x, y, width, height);
        this.parent = parent;
        this.pool = parent.pool;
    }

    public PointQuadTree(float minimumQuadWidth, float minimumQuadHeight, int elementLimitPerQuad, int mergeWatermark, float x, float y, float width, float height) {
        super(x, y, width, height);
        if (mergeWatermark >= elementLimitPerQuad) {
            throw new QuadWatermarkException(elementLimitPerQuad, mergeWatermark);
        }
        this.elementLimitPerQuad = elementLimitPerQuad;
        this.mergeWatermark = mergeWatermark;
        this.minimumQuadWidth = minimumQuadWidth;
        this.minimumQuadHeight = minimumQuadHeight;
        this.elements = new Array(true, elementLimitPerQuad);
    }

    public void warmupWithDepth(int depth) {
        if (depth > 0) {
            this.subdivide();
            this.topLeft.warmupWithDepth(depth - 1);
            this.topRight.warmupWithDepth(depth - 1);
            this.bottomLeft.warmupWithDepth(depth - 1);
            this.bottomRight.warmupWithDepth(depth - 1);
        }
    }

    public void warmupWithObjects(Array<T> elements) {
        this.addAll(elements);
        this.removeAll(elements);
    }

    public void warmupPool(int poolSize) {
        this.warmupPool(poolSize, 16);
    }

    public void warmupPool(int poolSize, int expectedElementsPerQuad) {
        if (this.pool == null) {
            this.pool = new Queue();
        }
        for (int i = 0; i < poolSize; ++i) {
            PointQuadTree<T> pointQuadTree = new PointQuadTree<T>(this, 0.0f, 0.0f, 1.0f, 1.0f);
            pointQuadTree.elements = new Array(expectedElementsPerQuad);
            this.pool.addLast(pointQuadTree);
        }
    }

    @Override
    public void debugRender(Graphics g) {
        if (this.getX() - g.getTranslationX() > g.getViewportWidth()) {
            return;
        }
        if (this.getY() - g.getTranslationY() > g.getViewportHeight()) {
            return;
        }
        if (this.getMaxX() - g.getTranslationX() < 0.0f) {
            return;
        }
        if (this.getMaxY() - g.getTranslationY() < 0.0f) {
            return;
        }
        Color tmp = g.getColor();
        if (this.topLeft != null) {
            this.topLeft.debugRender(g);
            this.topRight.debugRender(g);
            this.bottomLeft.debugRender(g);
            this.bottomRight.debugRender(g);
        } else {
            g.setColor(QUAD_COLOR);
            g.drawShape(this);
            g.drawRect(this.getX(), this.getY(), this.getWidth(), this.getHeight());
            g.setColor(ELEMENT_COLOR);
            for (Positionable element : this.elements) {
                g.fillRect(element.getX(), element.getY(), 1.0f, 1.0f);
            }
        }
        g.setColor(tmp);
    }

    @Override
    public void addAll(Array<T> elementsToAdd) {
        if (elementsToAdd == null || elementsToAdd.size == 0) {
            return;
        }
        Array elementsWithinQuad = new Array();
        for (Positionable element : elementsToAdd) {
            if (!this.contains(element.getX(), element.getY())) continue;
            elementsWithinQuad.add((Object)element);
        }
        this.clearTotalElementsCache();
        if (this.topLeft != null) {
            for (Positionable element : elementsWithinQuad) {
                this.addElementToChild(element);
            }
            return;
        }
        for (Positionable element : elementsWithinQuad) {
            this.elements.add((Object)element);
            element.addPostionChangeListener(this);
        }
        if (this.elements.size > this.elementLimitPerQuad && this.getWidth() * 0.5f >= this.minimumQuadWidth && this.getHeight() * 0.5f >= this.minimumQuadHeight) {
            this.subdivide();
        }
    }

    @Override
    public boolean add(T element) {
        if (element == null) {
            return false;
        }
        if (!this.contains(element.getX(), element.getY())) {
            return false;
        }
        this.clearTotalElementsCache();
        if (this.topLeft != null) {
            return this.addElementToChild(element);
        }
        return this.addElement(element);
    }

    protected boolean addElement(T element) {
        this.elements.add(element);
        element.addPostionChangeListener(this);
        QuadTreeAwareUtils.setQuadTreeRef(element, this);
        if (this.elements.size > this.elementLimitPerQuad && this.getWidth() * 0.5f >= this.minimumQuadWidth && this.getHeight() * 0.5f >= this.minimumQuadHeight) {
            this.subdivide();
        }
        return true;
    }

    protected boolean addElementToChild(T element) {
        if (this.topLeft.add(element)) {
            return true;
        }
        if (this.topRight.add(element)) {
            return true;
        }
        if (this.bottomLeft.add(element)) {
            return true;
        }
        return this.bottomRight.add(element);
    }

    protected void subdivide() {
        if (this.topLeft != null) {
            return;
        }
        float halfWidth = this.getWidth() * 0.5f;
        float halfHeight = this.getHeight() * 0.5f;
        this.topLeft = this.allocate(this, this.getX(), this.getY(), halfWidth, halfHeight);
        this.topRight = this.allocate(this, this.getX() + halfWidth, this.getY(), halfWidth, halfHeight);
        this.bottomLeft = this.allocate(this, this.getX(), this.getY() + halfHeight, halfWidth, halfHeight);
        this.bottomRight = this.allocate(this, this.getX() + halfWidth, this.getY() + halfHeight, halfWidth, halfHeight);
        for (int i = this.elements.size - 1; i >= 0; --i) {
            Positionable element = (Positionable)this.elements.removeIndex(i);
            element.removePositionChangeListener(this);
            this.addElementToChild(element);
        }
        this.elements = null;
    }

    protected PointQuadTree<T> allocate(PointQuadTree<T> parent, float x, float y, float width, float height) {
        if (this.pool == null || this.pool.size == 0) {
            return new PointQuadTree<T>(parent, x, y, width, height);
        }
        PointQuadTree result = (PointQuadTree)this.pool.removeFirst();
        result.parent = parent;
        result.set(x, y, width, height);
        if (result.elements != null) {
            result.elements.clear();
        }
        return result;
    }

    protected boolean isMergable() {
        if (this.topLeft == null) {
            return false;
        }
        if (this.mergeWatermark <= 0) {
            return false;
        }
        int topLeftTotal = this.topLeft.getTotalElements();
        if (topLeftTotal >= this.mergeWatermark) {
            return false;
        }
        int topRightTotal = this.topRight.getTotalElements();
        if (topRightTotal >= this.mergeWatermark) {
            return false;
        }
        int bottomLeftTotal = this.bottomLeft.getTotalElements();
        if (bottomLeftTotal >= this.mergeWatermark) {
            return false;
        }
        int bottomRightTotal = this.bottomRight.getTotalElements();
        if (bottomRightTotal >= this.mergeWatermark) {
            return false;
        }
        return topLeftTotal + topRightTotal + bottomLeftTotal + bottomRightTotal < this.mergeWatermark;
    }

    protected void merge() {
        if (this.topLeft == null) {
            return;
        }
        this.elements = new Array(true, this.elementLimitPerQuad);
        this.topLeft.getElements(this.elements);
        this.topRight.getElements(this.elements);
        this.bottomLeft.getElements(this.elements);
        this.bottomRight.getElements(this.elements);
        for (Positionable element : this.elements) {
            this.topLeft.elements.removeValue((Object)element, false);
            element.removePositionChangeListener(this.topLeft);
            this.topRight.elements.removeValue((Object)element, false);
            element.removePositionChangeListener(this.topRight);
            this.bottomLeft.elements.removeValue((Object)element, false);
            element.removePositionChangeListener(this.bottomLeft);
            this.bottomRight.elements.removeValue((Object)element, false);
            element.removePositionChangeListener(this.bottomRight);
            element.addPostionChangeListener(this);
        }
        this.topLeft = null;
        this.topRight = null;
        this.bottomLeft = null;
        this.bottomRight = null;
    }

    @Override
    public void removeAll(Array<T> elementsToRemove) {
        if (elementsToRemove == null || elementsToRemove.size == 0) {
            return;
        }
        Array elementsWithinQuad = new Array();
        for (Positionable element : elementsToRemove) {
            if (!this.contains(element.getX(), element.getY())) continue;
            elementsWithinQuad.add((Object)element);
        }
        this.clearTotalElementsCache();
        if (this.topLeft != null) {
            for (Positionable element : elementsWithinQuad) {
                this.removeElementFromChild(element);
            }
        }
        if (this.elements == null) {
            return;
        }
        this.elements.removeAll(elementsWithinQuad, false);
        for (Positionable element : elementsWithinQuad) {
            element.removePositionChangeListener(this);
        }
        if (this.parent == null) {
            return;
        }
        if (this.parent.isMergable()) {
            this.parent.merge();
        }
    }

    @Override
    public boolean remove(T element) {
        if (element == null) {
            return false;
        }
        if (!this.contains(element.getX(), element.getY())) {
            return false;
        }
        this.clearTotalElementsCache();
        if (this.topLeft != null) {
            return this.removeElementFromChild(element);
        }
        return this.removeElement(element);
    }

    @Override
    public void clear() {
        if (this.topLeft != null) {
            this.topLeft.clear();
            this.topRight.clear();
            this.bottomLeft.clear();
            this.bottomRight.clear();
            if (this.pool != null) {
                this.pool.addLast(this.topLeft);
                this.pool.addLast(this.topRight);
                this.pool.addLast(this.bottomLeft);
                this.pool.addLast(this.bottomRight);
            }
            this.topLeft = null;
            this.topRight = null;
            this.bottomLeft = null;
            this.bottomRight = null;
            this.elements = new Array(true, this.elementLimitPerQuad);
        } else {
            for (int i = 0; i < this.elements.size; ++i) {
                ((Positionable)this.elements.get(i)).removePositionChangeListener(this);
            }
            this.elements.clear();
        }
        this.clearTotalElementsCache();
    }

    protected boolean removeElementFromChild(T element) {
        if (this.topLeft.remove(element)) {
            return true;
        }
        if (this.topRight.remove(element)) {
            return true;
        }
        if (this.bottomLeft.remove(element)) {
            return true;
        }
        return this.bottomRight.remove(element);
    }

    protected boolean removeElement(T element) {
        boolean result = this.elements.removeValue(element, false);
        element.removePositionChangeListener(this);
        if (this.parent == null) {
            return result;
        }
        if (result) {
            QuadTreeAwareUtils.removeQuadTreeRef(element);
            if (this.parent.isMergable()) {
                this.parent.merge();
            }
        }
        return result;
    }

    @Override
    public Array<T> getElementsWithinArea(Shape area) {
        Array result = new Array();
        this.getElementsWithinArea(result, area);
        return result;
    }

    @Override
    public Array<T> getElementsWithinArea(Shape area, QuadTreeSearchDirection searchDirection) {
        Array result = new Array();
        switch (searchDirection) {
            case UPWARDS: {
                this.getElementsWithinArea(result, area, searchDirection);
                break;
            }
            case DOWNWARDS: {
                this.getElementsWithinArea(result, area);
            }
        }
        return result;
    }

    protected void addElementsWithinArea(Array<T> result, Shape area) {
        for (int i = this.elements.size - 1; i >= 0; --i) {
            Positionable element = (Positionable)this.elements.get(i);
            if (element == null || !area.contains(element.getX(), element.getY())) continue;
            result.add((Object)element);
        }
    }

    @Override
    public void getElementsWithinArea(Array<T> result, Shape area) {
        if (this.topLeft != null) {
            if (this.topLeft.isSearchRequired() && (area.contains(this.topLeft) || area.intersects(this.topLeft))) {
                this.topLeft.getElementsWithinArea(result, area);
            }
            if (this.topRight.isSearchRequired() && (area.contains(this.topRight) || area.intersects(this.topRight))) {
                this.topRight.getElementsWithinArea(result, area);
            }
            if (this.bottomLeft.isSearchRequired() && (area.contains(this.bottomLeft) || area.intersects(this.bottomLeft))) {
                this.bottomLeft.getElementsWithinArea(result, area);
            }
            if (this.bottomRight.isSearchRequired() && (area.contains(this.bottomRight) || area.intersects(this.bottomRight))) {
                this.bottomRight.getElementsWithinArea(result, area);
            }
        } else {
            this.addElementsWithinArea(result, area);
        }
    }

    @Override
    public void getElementsWithinArea(Array<T> result, Shape area, QuadTreeSearchDirection searchDirection) {
        switch (searchDirection) {
            case UPWARDS: {
                if (this.elements != null) {
                    this.addElementsWithinArea(result, area);
                }
                if (this.parent == null) break;
                if (this.parent.topLeft != this && this.parent.topLeft.isSearchRequired() && (area.contains(this.parent.topLeft) || area.intersects(this.parent.topLeft))) {
                    this.parent.topLeft.getElementsWithinArea(result, area);
                }
                if (this.parent.topRight != this && this.parent.topRight.isSearchRequired() && (area.contains(this.parent.topRight) || area.intersects(this.parent.topRight))) {
                    this.parent.topRight.getElementsWithinArea(result, area);
                }
                if (this.parent.bottomLeft != this && this.parent.bottomLeft.isSearchRequired() && (area.contains(this.parent.bottomLeft) || area.intersects(this.parent.bottomLeft))) {
                    this.parent.bottomLeft.getElementsWithinArea(result, area);
                }
                if (this.parent.bottomRight != this && this.parent.bottomRight.isSearchRequired() && (area.contains(this.parent.bottomRight) || area.intersects(this.parent.bottomRight))) {
                    this.parent.bottomRight.getElementsWithinArea(result, area);
                }
                this.parent.getElementsWithinArea(result, area, searchDirection);
                break;
            }
            case DOWNWARDS: {
                this.getElementsWithinArea(result, area);
            }
        }
    }

    @Override
    public Array<T> getElementsWithinAreaIgnoringEdges(Shape area) {
        Array result = new Array();
        this.getElementsWithinAreaIgnoringEdges(result, area);
        return result;
    }

    @Override
    public Array<T> getElementsWithinAreaIgnoringEdges(Shape area, QuadTreeSearchDirection searchDirection) {
        Array result = new Array();
        this.getElementsWithinAreaIgnoringEdges(result, area, searchDirection);
        return result;
    }

    @Override
    public void getElementsWithinAreaIgnoringEdges(Array<T> result, Shape area) {
        if (this.topLeft != null) {
            if (this.topLeft.isSearchRequired() && (area.contains(this.topLeft) || area.intersects(this.topLeft))) {
                this.topLeft.getElementsWithinAreaIgnoringEdges(result, area);
            }
            if (this.topRight.isSearchRequired() && (area.contains(this.topRight) || area.intersects(this.topRight))) {
                this.topRight.getElementsWithinAreaIgnoringEdges(result, area);
            }
            if (this.bottomLeft.isSearchRequired() && (area.contains(this.bottomLeft) || area.intersects(this.bottomLeft))) {
                this.bottomLeft.getElementsWithinAreaIgnoringEdges(result, area);
            }
            if (this.bottomRight.isSearchRequired() && (area.contains(this.bottomRight) || area.intersects(this.bottomRight))) {
                this.bottomRight.getElementsWithinAreaIgnoringEdges(result, area);
            }
        } else {
            this.addElementsWithinArea(result, area);
        }
    }

    @Override
    public void getElementsWithinAreaIgnoringEdges(Array<T> result, Shape area, QuadTreeSearchDirection searchDirection) {
        switch (searchDirection) {
            case UPWARDS: {
                if (this.elements != null) {
                    this.addElementsWithinArea(result, area);
                }
                if (this.parent == null) break;
                if (this.parent.topLeft != this && this.parent.topLeft.isSearchRequired() && (area.contains(this.parent.topLeft) || area.intersectsIgnoringEdges(this.parent.topLeft))) {
                    this.parent.topLeft.getElementsWithinAreaIgnoringEdges(result, area);
                }
                if (this.parent.topRight != this && this.parent.topRight.isSearchRequired() && (area.contains(this.parent.topRight) || area.intersectsIgnoringEdges(this.parent.topRight))) {
                    this.parent.topRight.getElementsWithinAreaIgnoringEdges(result, area);
                }
                if (this.parent.bottomLeft != this && this.parent.bottomLeft.isSearchRequired() && (area.contains(this.parent.bottomLeft) || area.intersectsIgnoringEdges(this.parent.bottomLeft))) {
                    this.parent.bottomLeft.getElementsWithinAreaIgnoringEdges(result, area);
                }
                if (this.parent.bottomRight != this && this.parent.bottomRight.isSearchRequired() && (area.contains(this.parent.bottomRight) || area.intersectsIgnoringEdges(this.parent.bottomRight))) {
                    this.parent.bottomRight.getElementsWithinAreaIgnoringEdges(result, area);
                }
                this.parent.getElementsWithinAreaIgnoringEdges(result, area, searchDirection);
                break;
            }
            case DOWNWARDS: {
                this.getElementsWithinAreaIgnoringEdges(result, area);
            }
        }
    }

    @Override
    public Array<T> getElementsContainingArea(Shape area, boolean entirelyContained) {
        return new Array();
    }

    @Override
    public Array<T> getElementsContainingArea(Shape area, QuadTreeSearchDirection searchDirection, boolean entirelyContained) {
        return new Array();
    }

    @Override
    public void getElementsContainingArea(Array<T> result, Shape area, boolean entirelyContained) {
    }

    @Override
    public void getElementsContainingArea(Array<T> result, Shape area, QuadTreeSearchDirection searchDirection, boolean entirelyContained) {
    }

    @Override
    public Array<T> getElementsContainingPoint(Point point) {
        Array result = new Array();
        this.getElementsContainingPoint(result, point);
        return result;
    }

    @Override
    public Array<T> getElementsContainingPoint(Point point, QuadTreeSearchDirection searchDirection) {
        Array result = new Array();
        switch (searchDirection) {
            case UPWARDS: {
                this.getElementsContainingPoint(result, point, searchDirection);
                break;
            }
            case DOWNWARDS: {
                this.getElementsContainingPoint(result, point);
            }
        }
        return result;
    }

    protected void addElementsContainingPoint(Array<T> result, Point point) {
        for (int i = this.elements.size - 1; i >= 0; --i) {
            Positionable element = (Positionable)this.elements.get(i);
            if (element == null || element.getX() != point.x || element.getY() != point.y) continue;
            result.add((Object)element);
        }
    }

    @Override
    public void getElementsContainingPoint(Array<T> result, Point point) {
        if (this.topLeft != null) {
            if (this.topLeft.isSearchRequired() && this.topLeft.contains(point)) {
                this.topLeft.getElementsContainingPoint(result, point);
            }
            if (this.topRight.isSearchRequired() && this.topRight.contains(point)) {
                this.topRight.getElementsContainingPoint(result, point);
            }
            if (this.bottomLeft.isSearchRequired() && this.bottomLeft.contains(point)) {
                this.bottomLeft.getElementsContainingPoint(result, point);
            }
            if (this.bottomRight.isSearchRequired() && this.bottomRight.contains(point)) {
                this.bottomRight.getElementsContainingPoint(result, point);
            }
        } else {
            this.addElementsContainingPoint(result, point);
        }
    }

    @Override
    public void getElementsContainingPoint(Array<T> result, Point point, QuadTreeSearchDirection searchDirection) {
        switch (searchDirection) {
            case UPWARDS: {
                if (this.elements == null) break;
                this.addElementsContainingPoint(result, point);
                break;
            }
            case DOWNWARDS: {
                this.getElementsContainingPoint(result, point);
            }
        }
    }

    @Override
    public Array<T> getElementsIntersectingLineSegment(LineSegment lineSegment) {
        Array result = new Array();
        this.getElementsIntersectingLineSegment(result, lineSegment);
        return result;
    }

    @Override
    public Array<T> getElementsIntersectingLineSegment(LineSegment lineSegment, QuadTreeSearchDirection searchDirection) {
        Array result = new Array();
        switch (searchDirection) {
            case UPWARDS: {
                this.getElementsIntersectingLineSegment(result, lineSegment, searchDirection);
                break;
            }
            case DOWNWARDS: {
                this.getElementsIntersectingLineSegment(result, lineSegment);
            }
        }
        return result;
    }

    protected void addElementsIntersectingLineSegment(Array<T> result, LineSegment lineSegment) {
        for (int i = this.elements.size - 1; i >= 0; --i) {
            Positionable element = (Positionable)this.elements.get(i);
            if (element == null || !lineSegment.contains(element.getX(), element.getY())) continue;
            result.add((Object)element);
        }
    }

    protected static boolean intersects(PointQuadTree tree, LineSegment segment) {
        return tree.intersects(segment) || tree.contains(segment.getPointA()) || tree.contains(segment.getPointB());
    }

    @Override
    public void getElementsIntersectingLineSegment(Array<T> result, LineSegment lineSegment) {
        if (this.topLeft != null) {
            if (this.topLeft.isSearchRequired() && PointQuadTree.intersects(this.topLeft, lineSegment)) {
                this.topLeft.getElementsIntersectingLineSegment(result, lineSegment);
            }
            if (this.topRight.isSearchRequired() && PointQuadTree.intersects(this.topRight, lineSegment)) {
                this.topRight.getElementsIntersectingLineSegment(result, lineSegment);
            }
            if (this.bottomLeft.isSearchRequired() && PointQuadTree.intersects(this.bottomLeft, lineSegment)) {
                this.bottomLeft.getElementsIntersectingLineSegment(result, lineSegment);
            }
            if (this.bottomRight.isSearchRequired() && PointQuadTree.intersects(this.bottomRight, lineSegment)) {
                this.bottomRight.getElementsIntersectingLineSegment(result, lineSegment);
            }
        } else {
            this.addElementsIntersectingLineSegment(result, lineSegment);
        }
    }

    @Override
    public void getElementsIntersectingLineSegment(Array<T> result, LineSegment lineSegment, QuadTreeSearchDirection searchDirection) {
        switch (searchDirection) {
            case UPWARDS: {
                if (this.elements != null) {
                    this.addElementsIntersectingLineSegment(result, lineSegment);
                }
                if (this.parent == null) break;
                if (this.parent.topLeft != this && this.parent.topLeft.isSearchRequired() && PointQuadTree.intersects(this.parent.topLeft, lineSegment)) {
                    this.parent.topLeft.getElementsIntersectingLineSegment(result, lineSegment);
                }
                if (this.parent.topRight != this && this.parent.topRight.isSearchRequired() && PointQuadTree.intersects(this.parent.topRight, lineSegment)) {
                    this.parent.topRight.getElementsIntersectingLineSegment(result, lineSegment);
                }
                if (this.parent.bottomLeft != this && this.parent.bottomLeft.isSearchRequired() && PointQuadTree.intersects(this.parent.bottomLeft, lineSegment)) {
                    this.parent.bottomLeft.getElementsIntersectingLineSegment(result, lineSegment);
                }
                if (this.parent.bottomRight != this && this.parent.bottomRight.isSearchRequired() && PointQuadTree.intersects(this.parent.bottomRight, lineSegment)) {
                    this.parent.bottomRight.getElementsIntersectingLineSegment(result, lineSegment);
                }
                this.parent.getElementsIntersectingLineSegment(result, lineSegment, searchDirection);
                break;
            }
            case DOWNWARDS: {
                this.getElementsIntersectingLineSegment(result, lineSegment);
            }
        }
    }

    @Override
    public Array<T> getElements() {
        Array result = new Array();
        this.getElements(result);
        return result;
    }

    @Override
    public void getElements(Array<T> result) {
        if (this.topLeft != null) {
            this.topLeft.getElements(result);
            this.topRight.getElements(result);
            this.bottomLeft.getElements(result);
            this.bottomRight.getElements(result);
        } else {
            result.addAll(this.elements);
        }
    }

    @Override
    public int getTotalQuads() {
        if (this.topLeft != null) {
            int result = this.topLeft.getTotalQuads();
            result += this.topRight.getTotalQuads();
            result += this.bottomLeft.getTotalQuads();
            return result += this.bottomRight.getTotalQuads();
        }
        return 1;
    }

    @Override
    public int getTotalElements() {
        if (this.totalElementsCache >= 0) {
            return this.totalElementsCache;
        }
        if (this.topLeft != null) {
            this.totalElementsCache = this.topLeft.getTotalElements();
            this.totalElementsCache += this.topRight.getTotalElements();
            this.totalElementsCache += this.bottomLeft.getTotalElements();
            this.totalElementsCache += this.bottomRight.getTotalElements();
        } else {
            this.totalElementsCache = this.elements.size;
        }
        return this.totalElementsCache;
    }

    protected void clearTotalElementsCache() {
        this.totalElementsCache = -1;
    }

    @Override
    public void positionChanged(T moved) {
        if (this.contains(moved.getX(), moved.getY())) {
            return;
        }
        this.removeElement(moved);
        for (QuadTree<T> parentQuad = this.parent; parentQuad != null; parentQuad = parentQuad.getParent()) {
            if (!parentQuad.add(moved)) continue;
            return;
        }
    }

    protected boolean isSearchRequired() {
        if (this.topLeft != null) {
            return true;
        }
        return this.elements.size > 0;
    }

    @Override
    public QuadTree<T> getParent() {
        return this.parent;
    }

    public int getElementLimitPerQuad() {
        return this.elementLimitPerQuad;
    }

    public int getMergeWatermark() {
        return this.mergeWatermark;
    }

    public boolean hasChildQuads() {
        return this.topLeft != null;
    }

    @Override
    public float getMinimumQuadWidth() {
        return this.minimumQuadWidth;
    }

    @Override
    public float getMinimumQuadHeight() {
        return this.minimumQuadHeight;
    }
}

