/*
 * Decompiled with CFR 0.152.
 */
package org.mini2Dx.core.collision;

import org.mini2Dx.core.Graphics;
import org.mini2Dx.core.collision.PointQuadTree;
import org.mini2Dx.core.collision.QuadTree;
import org.mini2Dx.core.collision.QuadTreeSearchDirection;
import org.mini2Dx.core.geom.LineSegment;
import org.mini2Dx.core.geom.Point;
import org.mini2Dx.core.geom.Positionable;
import org.mini2Dx.core.geom.Shape;
import org.mini2Dx.core.geom.Sizeable;
import org.mini2Dx.core.graphics.Color;
import org.mini2Dx.gdx.utils.Array;
import org.mini2Dx.gdx.utils.Queue;

public class RegionQuadTree<T extends Sizeable>
extends PointQuadTree<T> {
    private static final long serialVersionUID = -2417612178966065600L;

    public RegionQuadTree(int elementLimit, int mergeWatermark, float x, float y, float width, float height) {
        super(elementLimit, mergeWatermark, x, y, width, height);
    }

    public RegionQuadTree(int elementLimit, float x, float y, float width, float height) {
        super(elementLimit, x, y, width, height);
    }

    public RegionQuadTree(RegionQuadTree<T> parent, float x, float y, float width, float height) {
        super(parent, x, y, width, height);
    }

    public RegionQuadTree(float minimumQuadWidth, float minimumQuadHeight, int elementLimitPerQuad, int mergeWatermark, float x, float y, float width, float height) {
        super(minimumQuadWidth, minimumQuadHeight, elementLimitPerQuad, mergeWatermark, x, y, width, height);
    }

    @Override
    public void warmupPool(int poolSize) {
        this.warmupPool(poolSize, 16);
    }

    @Override
    public void warmupPool(int poolSize, int expectedElementsPerQuad) {
        if (this.pool == null) {
            this.pool = new Queue();
        }
        for (int i = 0; i < poolSize; ++i) {
            RegionQuadTree<T> regionQuadTree = new RegionQuadTree<T>(this, 0.0f, 0.0f, 1.0f, 1.0f);
            regionQuadTree.elements = new Array(expectedElementsPerQuad);
            this.pool.addLast(regionQuadTree);
        }
    }

    @Override
    public void debugRender(Graphics g) {
        if (this.getX() - g.getTranslationX() > g.getViewportWidth()) {
            return;
        }
        if (this.getY() - g.getTranslationY() > g.getViewportHeight()) {
            return;
        }
        if (this.getMaxX() - g.getTranslationX() < 0.0f) {
            return;
        }
        if (this.getMaxY() - g.getTranslationY() < 0.0f) {
            return;
        }
        Color tmp = g.getColor();
        if (this.topLeft != null) {
            this.topLeft.debugRender(g);
            this.topRight.debugRender(g);
            this.bottomLeft.debugRender(g);
            this.bottomRight.debugRender(g);
        } else {
            g.setColor(QUAD_COLOR);
            g.drawRect(this.getX(), this.getY(), this.getWidth(), this.getHeight());
            g.setColor(tmp);
        }
        g.setColor(ELEMENT_COLOR);
        for (Sizeable element : this.elements) {
            g.drawRect(element.getX(), element.getY(), element.getWidth(), element.getHeight());
        }
        g.setColor(tmp);
    }

    @Override
    public void addAll(Array<T> elementsToAdd) {
        if (elementsToAdd == null || elementsToAdd.size == 0) {
            return;
        }
        this.clearTotalElementsCache();
        Array elementsWithinQuad = new Array();
        for (Sizeable element : elementsToAdd) {
            if (!this.contains(element) && !this.intersects(element)) continue;
            elementsWithinQuad.add((Object)element);
        }
        for (Sizeable element : elementsWithinQuad) {
            if (this.topLeft == null) {
                this.addElement(element);
                continue;
            }
            if (this.addElementToChild((T)element)) continue;
            this.addElement(element);
        }
    }

    @Override
    public boolean add(T element) {
        if (element == null) {
            return false;
        }
        if (!this.intersects((Sizeable)element) && !this.contains((Sizeable)element)) {
            return false;
        }
        this.clearTotalElementsCache();
        if (this.topLeft == null) {
            return this.addElement(element);
        }
        if (this.addElementToChild(element)) {
            return true;
        }
        return this.addElement(element);
    }

    @Override
    protected boolean addElementToChild(T element) {
        if (this.topLeft.contains((Sizeable)element)) {
            return this.topLeft.add(element);
        }
        if (this.topRight.contains((Sizeable)element)) {
            return this.topRight.add(element);
        }
        if (this.bottomLeft.contains((Sizeable)element)) {
            return this.bottomLeft.add(element);
        }
        if (this.bottomRight.contains((Sizeable)element)) {
            return this.bottomRight.add(element);
        }
        return false;
    }

    @Override
    protected void subdivide() {
        if (this.topLeft != null) {
            return;
        }
        float halfWidth = this.getWidth() / 2.0f;
        float halfHeight = this.getHeight() / 2.0f;
        this.topLeft = this.allocate(this, this.getX(), this.getY(), halfWidth, halfHeight);
        this.topRight = this.allocate(this, this.getX() + halfWidth, this.getY(), halfWidth, halfHeight);
        this.bottomLeft = this.allocate(this, this.getX(), this.getY() + halfHeight, halfWidth, halfHeight);
        this.bottomRight = this.allocate(this, this.getX() + halfWidth, this.getY() + halfHeight, halfWidth, halfHeight);
        for (int i = this.elements.size - 1; i >= 0; --i) {
            if (!this.addElementToChild((T)((Sizeable)this.elements.get(i)))) continue;
            this.removeElement((Positionable)this.elements.get(i));
        }
    }

    @Override
    protected RegionQuadTree<T> allocate(RegionQuadTree<T> parent, float x, float y, float width, float height) {
        if (this.pool == null || this.pool.size == 0) {
            return new RegionQuadTree<T>(parent, x, y, width, height);
        }
        RegionQuadTree result = (RegionQuadTree)this.pool.removeFirst();
        result.parent = parent;
        result.set(x, y, width, height);
        if (result.elements != null) {
            result.elements.clear();
        }
        return result;
    }

    @Override
    public boolean remove(T element) {
        if (element == null) {
            return false;
        }
        if (!this.intersects((Sizeable)element) && !this.contains((Sizeable)element)) {
            return false;
        }
        this.clearTotalElementsCache();
        if (this.removeElement(element)) {
            return true;
        }
        if (this.topLeft == null) {
            return false;
        }
        return this.removeElementFromChild(element);
    }

    @Override
    public void clear() {
        if (this.topLeft != null) {
            this.topLeft.clear();
            this.topRight.clear();
            this.bottomLeft.clear();
            this.bottomRight.clear();
            if (this.pool != null) {
                this.pool.addLast((Object)this.topLeft);
                this.pool.addLast((Object)this.topRight);
                this.pool.addLast((Object)this.bottomLeft);
                this.pool.addLast((Object)this.bottomRight);
            }
            this.topLeft = null;
            this.topRight = null;
            this.bottomLeft = null;
            this.bottomRight = null;
        }
        for (int i = 0; i < this.elements.size; ++i) {
            ((Sizeable)this.elements.get(i)).removePositionChangeListener(this);
        }
        this.elements.clear();
        this.clearTotalElementsCache();
    }

    @Override
    protected void addElementsWithinArea(Array<T> result, Shape area) {
        for (int i = this.elements.size - 1; i >= 0; --i) {
            Sizeable element = (Sizeable)this.elements.get(i);
            if (element == null || !area.contains(element) && !area.intersects(element)) continue;
            result.add((Object)element);
        }
    }

    protected void addElementsWithinAreaIgnoringEdges(Array<T> result, Shape area) {
        for (int i = this.elements.size - 1; i >= 0; --i) {
            Sizeable element = (Sizeable)this.elements.get(i);
            if (element == null || !area.contains(element) && !area.intersectsIgnoringEdges(element)) continue;
            result.add((Object)element);
        }
    }

    @Override
    public void getElementsWithinArea(Array<T> result, Shape area) {
        if (this.topLeft != null) {
            if (this.topLeft.isSearchRequired() && (this.topLeft.contains(area) || this.topLeft.intersects(area))) {
                this.topLeft.getElementsWithinArea(result, area);
            }
            if (this.topRight.isSearchRequired() && (this.topRight.contains(area) || this.topRight.intersects(area))) {
                this.topRight.getElementsWithinArea(result, area);
            }
            if (this.bottomLeft.isSearchRequired() && (this.bottomLeft.contains(area) || this.bottomLeft.intersects(area))) {
                this.bottomLeft.getElementsWithinArea(result, area);
            }
            if (this.bottomRight.isSearchRequired() && (this.bottomRight.contains(area) || this.bottomRight.intersects(area))) {
                this.bottomRight.getElementsWithinArea(result, area);
            }
        }
        this.addElementsWithinArea(result, area);
    }

    @Override
    public void getElementsWithinArea(Array<T> result, Shape area, QuadTreeSearchDirection searchDirection) {
        switch (searchDirection) {
            case UPWARDS: {
                this.getElementsWithinAreaUpwards(result, area, true, false);
                break;
            }
            case DOWNWARDS: {
                this.getElementsWithinArea(result, area);
            }
        }
    }

    private void getElementsWithinAreaUpwards(Array<T> result, Shape area, boolean firstInvocation, boolean childNodeCrossed) {
        if (this.elements != null) {
            this.addElementsWithinArea(result, area);
        }
        boolean nodeCrossed = false;
        if (firstInvocation && this.topLeft != null) {
            if (this.topLeft.isSearchRequired() && (area.contains(this.topLeft) || area.intersects(this.topLeft))) {
                this.topLeft.getElementsWithinArea(result, area);
            }
            if (this.topRight.isSearchRequired() && (area.contains(this.topRight) || area.intersects(this.topRight))) {
                this.topRight.getElementsWithinArea(result, area);
            }
            if (this.bottomLeft.isSearchRequired() && (area.contains(this.bottomLeft) || area.intersects(this.bottomLeft))) {
                this.bottomLeft.getElementsWithinArea(result, area);
            }
            if (this.bottomRight.isSearchRequired() && (area.contains(this.bottomRight) || area.intersects(this.bottomRight))) {
                this.bottomRight.getElementsWithinArea(result, area);
            }
            nodeCrossed = true;
        }
        if (this.parent == null) {
            return;
        }
        if (childNodeCrossed || firstInvocation) {
            if (this.parent.topLeft != this && this.parent.topLeft.isSearchRequired() && (area.contains(this.parent.topLeft) || area.intersects(this.parent.topLeft))) {
                this.parent.topLeft.getElementsWithinArea(result, area);
                nodeCrossed = true;
            }
            if (this.parent.topRight != this && this.parent.topRight.isSearchRequired() && (area.contains(this.parent.topRight) || area.intersects(this.parent.topRight))) {
                this.parent.topRight.getElementsWithinArea(result, area);
                nodeCrossed = true;
            }
            if (this.parent.bottomLeft != this && this.parent.bottomLeft.isSearchRequired() && (area.contains(this.parent.bottomLeft) || area.intersects(this.parent.bottomLeft))) {
                this.parent.bottomLeft.getElementsWithinArea(result, area);
                nodeCrossed = true;
            }
            if (this.parent.bottomRight != this && this.parent.bottomRight.isSearchRequired() && (area.contains(this.parent.bottomRight) || area.intersects(this.parent.bottomRight))) {
                this.parent.bottomRight.getElementsWithinArea(result, area);
                nodeCrossed = true;
            }
        }
        ((RegionQuadTree)this.parent).getElementsWithinAreaUpwards(result, area, false, nodeCrossed);
    }

    @Override
    public Array<T> getElementsWithinAreaIgnoringEdges(Shape area) {
        Array result = new Array();
        this.getElementsWithinAreaIgnoringEdges(result, area);
        return result;
    }

    @Override
    public Array<T> getElementsWithinAreaIgnoringEdges(Shape area, QuadTreeSearchDirection searchDirection) {
        Array result = new Array();
        this.getElementsWithinAreaIgnoringEdges(result, area, searchDirection);
        return result;
    }

    @Override
    public void getElementsWithinAreaIgnoringEdges(Array<T> result, Shape area) {
        if (this.topLeft != null) {
            if (this.topLeft.isSearchRequired() && (this.topLeft.contains(area) || this.topLeft.intersectsIgnoringEdges(area))) {
                this.topLeft.getElementsWithinAreaIgnoringEdges(result, area);
            }
            if (this.topRight.isSearchRequired() && (this.topRight.contains(area) || this.topRight.intersectsIgnoringEdges(area))) {
                this.topRight.getElementsWithinAreaIgnoringEdges(result, area);
            }
            if (this.bottomLeft.isSearchRequired() && (this.bottomLeft.contains(area) || this.bottomLeft.intersectsIgnoringEdges(area))) {
                this.bottomLeft.getElementsWithinAreaIgnoringEdges(result, area);
            }
            if (this.bottomRight.isSearchRequired() && (this.bottomRight.contains(area) || this.bottomRight.intersectsIgnoringEdges(area))) {
                this.bottomRight.getElementsWithinAreaIgnoringEdges(result, area);
            }
        }
        this.addElementsWithinAreaIgnoringEdges(result, area);
    }

    @Override
    public void getElementsWithinAreaIgnoringEdges(Array<T> result, Shape area, QuadTreeSearchDirection searchDirection) {
        switch (searchDirection) {
            case UPWARDS: {
                this.getElementsWithinAreaIgnoringEdgesUpwards(result, area, true);
                break;
            }
            case DOWNWARDS: {
                this.getElementsWithinAreaIgnoringEdges(result, area);
            }
        }
    }

    private void getElementsWithinAreaIgnoringEdgesUpwards(Array<T> result, Shape area, boolean firstInvocation) {
        if (this.elements != null) {
            this.addElementsWithinArea(result, area);
        }
        if (firstInvocation && this.topLeft != null) {
            if (this.topLeft.isSearchRequired() && (area.contains(this.topLeft) || area.intersectsIgnoringEdges(this.topLeft))) {
                this.topLeft.getElementsWithinAreaIgnoringEdges(result, area);
            }
            if (this.topRight.isSearchRequired() && (area.contains(this.topRight) || area.intersectsIgnoringEdges(this.topRight))) {
                this.topRight.getElementsWithinAreaIgnoringEdges(result, area);
            }
            if (this.bottomLeft.isSearchRequired() && (area.contains(this.bottomLeft) || area.intersectsIgnoringEdges(this.bottomLeft))) {
                this.bottomLeft.getElementsWithinAreaIgnoringEdges(result, area);
            }
            if (this.bottomRight.isSearchRequired() && (area.contains(this.bottomRight) || area.intersectsIgnoringEdges(this.bottomRight))) {
                this.bottomRight.getElementsWithinAreaIgnoringEdges(result, area);
            }
        }
        if (this.parent != null) {
            if (this.parent.topLeft != this && this.parent.topLeft.isSearchRequired() && (area.contains(this.parent.topLeft) || area.intersectsIgnoringEdges(this.parent.topLeft))) {
                this.parent.topLeft.getElementsWithinAreaIgnoringEdges(result, area);
            }
            if (this.parent.topRight != this && this.parent.topRight.isSearchRequired() && (area.contains(this.parent.topRight) || area.intersectsIgnoringEdges(this.parent.topRight))) {
                this.parent.topRight.getElementsWithinAreaIgnoringEdges(result, area);
            }
            if (this.parent.bottomLeft != this && this.parent.bottomLeft.isSearchRequired() && (area.contains(this.parent.bottomLeft) || area.intersectsIgnoringEdges(this.parent.bottomLeft))) {
                this.parent.bottomLeft.getElementsWithinAreaIgnoringEdges(result, area);
            }
            if (this.parent.bottomRight != this && this.parent.bottomRight.isSearchRequired() && (area.contains(this.parent.bottomRight) || area.intersectsIgnoringEdges(this.parent.bottomRight))) {
                this.parent.bottomRight.getElementsWithinAreaIgnoringEdges(result, area);
            }
            ((RegionQuadTree)this.parent).getElementsWithinAreaIgnoringEdgesUpwards(result, area, false);
        }
    }

    @Override
    public Array<T> getElementsContainingArea(Shape area, boolean entirelyContained) {
        Array result = new Array();
        this.getElementsContainingArea(result, area, entirelyContained);
        return result;
    }

    @Override
    public Array<T> getElementsContainingArea(Shape area, QuadTreeSearchDirection searchDirection, boolean entirelyContained) {
        Array result = new Array();
        switch (searchDirection) {
            case UPWARDS: {
                this.getElementsContainingArea(result, area, searchDirection, entirelyContained);
                break;
            }
            case DOWNWARDS: {
                this.getElementsContainingArea(result, area, entirelyContained);
            }
        }
        return result;
    }

    protected void addElementsContainingArea(Array<T> result, Shape area, boolean entirelyContained) {
        if (entirelyContained) {
            for (int i = this.elements.size - 1; i >= 0; --i) {
                Sizeable element = (Sizeable)this.elements.get(i);
                if (element == null || !element.contains(area)) continue;
                result.add((Object)element);
            }
        } else {
            for (int i = this.elements.size - 1; i >= 0; --i) {
                Sizeable element = (Sizeable)this.elements.get(i);
                if (element == null || !element.contains(area) && !element.intersects(area) || area.getWidth() > element.getWidth() || area.getHeight() > element.getHeight()) continue;
                result.add((Object)element);
            }
        }
    }

    @Override
    public void getElementsContainingArea(Array<T> result, Shape area, boolean entirelyContained) {
        if (this.topLeft != null) {
            if (this.topLeft.isSearchRequired() && (this.topLeft.contains(area) || this.topLeft.intersects(area))) {
                this.topLeft.getElementsContainingArea(result, area, entirelyContained);
            }
            if (this.topRight.isSearchRequired() && (this.topRight.contains(area) || this.topRight.intersects(area))) {
                this.topRight.getElementsContainingArea(result, area, entirelyContained);
            }
            if (this.bottomLeft.isSearchRequired() && (this.bottomLeft.contains(area) || this.bottomLeft.intersects(area))) {
                this.bottomLeft.getElementsContainingArea(result, area, entirelyContained);
            }
            if (this.bottomRight.isSearchRequired() && (this.bottomRight.contains(area) || this.bottomRight.intersects(area))) {
                this.bottomRight.getElementsContainingArea(result, area, entirelyContained);
            }
        }
        this.addElementsContainingArea(result, area, entirelyContained);
    }

    @Override
    public void getElementsContainingArea(Array<T> result, Shape area, QuadTreeSearchDirection searchDirection, boolean entirelyContained) {
        switch (searchDirection) {
            case UPWARDS: {
                this.getElementsContainingAreaUpwards(result, area, true, entirelyContained);
                break;
            }
            case DOWNWARDS: {
                this.getElementsContainingArea(result, area, entirelyContained);
            }
        }
    }

    protected void getElementsContainingAreaUpwards(Array<T> result, Shape area, boolean firstInvocation, boolean entirelyContained) {
        if (this.elements != null) {
            this.addElementsContainingArea(result, area, entirelyContained);
        }
        if (firstInvocation && this.topLeft != null) {
            if (this.topLeft.isSearchRequired() && (area.contains(this.topLeft) || area.intersects(this.topLeft))) {
                this.topLeft.getElementsContainingArea(result, area, entirelyContained);
            }
            if (this.topRight.isSearchRequired() && (area.contains(this.topRight) || area.intersects(this.topRight))) {
                this.topRight.getElementsContainingArea(result, area, entirelyContained);
            }
            if (this.bottomLeft.isSearchRequired() && (area.contains(this.bottomLeft) || area.intersects(this.bottomLeft))) {
                this.bottomLeft.getElementsContainingArea(result, area, entirelyContained);
            }
            if (this.bottomRight.isSearchRequired() && (area.contains(this.bottomRight) || area.intersects(this.bottomRight))) {
                this.bottomRight.getElementsContainingArea(result, area, entirelyContained);
            }
        }
        if (this.parent != null) {
            if (this.parent.topLeft != this && this.parent.topLeft.isSearchRequired() && (area.contains(this.parent.topLeft) || area.intersects(this.parent.topLeft))) {
                this.parent.topLeft.getElementsContainingArea(result, area, entirelyContained);
            }
            if (this.parent.topRight != this && this.parent.topRight.isSearchRequired() && (area.contains(this.parent.topRight) || area.intersects(this.parent.topRight))) {
                this.parent.topRight.getElementsContainingArea(result, area, entirelyContained);
            }
            if (this.parent.bottomLeft != this && this.parent.bottomLeft.isSearchRequired() && (area.contains(this.parent.bottomLeft) || area.intersects(this.parent.bottomLeft))) {
                this.parent.bottomLeft.getElementsContainingArea(result, area, entirelyContained);
            }
            if (this.parent.bottomRight != this && this.parent.bottomRight.isSearchRequired() && (area.contains(this.parent.bottomRight) || area.intersects(this.parent.bottomRight))) {
                this.parent.bottomRight.getElementsContainingArea(result, area, entirelyContained);
            }
            ((RegionQuadTree)this.parent).getElementsContainingAreaUpwards(result, area, false, entirelyContained);
        }
    }

    @Override
    protected void addElementsContainingPoint(Array<T> result, Point point) {
        for (int i = this.elements.size - 1; i >= 0; --i) {
            Sizeable element = (Sizeable)this.elements.get(i);
            if (element == null || !element.contains(point)) continue;
            result.add((Object)element);
        }
    }

    @Override
    public void getElementsContainingPoint(Array<T> result, Point point) {
        if (this.topLeft != null) {
            if (this.topLeft.isSearchRequired() && this.topLeft.contains(point)) {
                this.topLeft.getElementsContainingPoint(result, point);
            }
            if (this.topRight.isSearchRequired() && this.topRight.contains(point)) {
                this.topRight.getElementsContainingPoint(result, point);
            }
            if (this.bottomLeft.isSearchRequired() && this.bottomLeft.contains(point)) {
                this.bottomLeft.getElementsContainingPoint(result, point);
            }
            if (this.bottomRight.isSearchRequired() && this.bottomRight.contains(point)) {
                this.bottomRight.getElementsContainingPoint(result, point);
            }
        }
        for (int i = this.elements.size - 1; i >= 0; --i) {
            Sizeable element = (Sizeable)this.elements.get(i);
            if (element == null || !element.contains(point)) continue;
            result.add((Object)element);
        }
    }

    @Override
    public void getElementsContainingPoint(Array<T> result, Point point, QuadTreeSearchDirection searchDirection) {
        switch (searchDirection) {
            case UPWARDS: {
                this.getElementsContainingPointUpwards(result, point, true);
                break;
            }
            case DOWNWARDS: {
                this.getElementsContainingPoint(result, point);
            }
        }
    }

    private void getElementsContainingPointUpwards(Array<T> result, Point point, boolean firstInvocation) {
        if (this.elements != null) {
            this.addElementsContainingPoint(result, point);
        }
        if (firstInvocation && this.topLeft != null) {
            if (this.topLeft.isSearchRequired() && this.topLeft.contains(point)) {
                this.topLeft.getElementsContainingPoint(result, point);
            }
            if (this.topRight.isSearchRequired() && this.topRight.contains(point)) {
                this.topRight.getElementsContainingPoint(result, point);
            }
            if (this.bottomLeft.isSearchRequired() && this.bottomLeft.contains(point)) {
                this.bottomLeft.getElementsContainingPoint(result, point);
            }
            if (this.bottomRight.isSearchRequired() && this.bottomRight.contains(point)) {
                this.bottomRight.getElementsContainingPoint(result, point);
            }
        }
        if (this.parent != null) {
            if (this.parent.topLeft != this && this.parent.topLeft.isSearchRequired() && (this.parent.topLeft.contains(point) || this.parent.topLeft.contains(point))) {
                this.parent.topLeft.getElementsContainingPoint(result, point);
            }
            if (this.parent.topRight != this && this.parent.topRight.isSearchRequired() && (this.parent.topRight.contains(point) || this.parent.topRight.contains(point))) {
                this.parent.topRight.getElementsContainingPoint(result, point);
            }
            if (this.parent.bottomLeft != this && this.parent.bottomLeft.isSearchRequired() && (this.parent.bottomLeft.contains(point) || this.parent.bottomLeft.contains(point))) {
                this.parent.bottomLeft.getElementsContainingPoint(result, point);
            }
            if (this.parent.bottomRight != this && this.parent.bottomRight.isSearchRequired() && (this.parent.bottomRight.contains(point) || this.parent.bottomRight.contains(point))) {
                this.parent.bottomRight.getElementsContainingPoint(result, point);
            }
            ((RegionQuadTree)this.parent).getElementsContainingPointUpwards(result, point, false);
        }
    }

    @Override
    protected void addElementsIntersectingLineSegment(Array<T> result, LineSegment lineSegment) {
        for (int i = this.elements.size - 1; i >= 0; --i) {
            Sizeable element = (Sizeable)this.elements.get(i);
            if (element == null || !element.intersects(lineSegment)) continue;
            result.add((Object)element);
        }
    }

    @Override
    public void getElementsIntersectingLineSegment(Array<T> result, LineSegment lineSegment) {
        if (this.topLeft != null) {
            if (this.topLeft.isSearchRequired() && RegionQuadTree.intersects(this.topLeft, lineSegment)) {
                this.topLeft.getElementsIntersectingLineSegment(result, lineSegment);
            }
            if (this.topRight.isSearchRequired() && RegionQuadTree.intersects(this.topRight, lineSegment)) {
                this.topRight.getElementsIntersectingLineSegment(result, lineSegment);
            }
            if (this.bottomLeft.isSearchRequired() && RegionQuadTree.intersects(this.bottomLeft, lineSegment)) {
                this.bottomLeft.getElementsIntersectingLineSegment(result, lineSegment);
            }
            if (this.bottomRight.isSearchRequired() && RegionQuadTree.intersects(this.bottomRight, lineSegment)) {
                this.bottomRight.getElementsIntersectingLineSegment(result, lineSegment);
            }
        }
        this.addElementsIntersectingLineSegment(result, lineSegment);
    }

    @Override
    public void getElementsIntersectingLineSegment(Array<T> result, LineSegment lineSegment, QuadTreeSearchDirection searchDirection) {
        switch (searchDirection) {
            case UPWARDS: {
                this.addElementsIntersectingLineSegmentUpwards(result, lineSegment, true);
                break;
            }
            case DOWNWARDS: {
                this.getElementsIntersectingLineSegment(result, lineSegment);
            }
        }
    }

    private void addElementsIntersectingLineSegmentUpwards(Array<T> result, LineSegment lineSegment, boolean firstInvocation) {
        if (this.elements != null) {
            this.addElementsIntersectingLineSegment(result, lineSegment);
        }
        if (this.topLeft != null && firstInvocation) {
            if (this.topLeft.isSearchRequired() && RegionQuadTree.intersects(this.topLeft, lineSegment)) {
                this.topLeft.getElementsIntersectingLineSegment(result, lineSegment);
            }
            if (this.topRight.isSearchRequired() && RegionQuadTree.intersects(this.topRight, lineSegment)) {
                this.topRight.getElementsIntersectingLineSegment(result, lineSegment);
            }
            if (this.bottomLeft.isSearchRequired() && RegionQuadTree.intersects(this.bottomLeft, lineSegment)) {
                this.bottomLeft.getElementsIntersectingLineSegment(result, lineSegment);
            }
            if (this.bottomRight.isSearchRequired() && RegionQuadTree.intersects(this.bottomRight, lineSegment)) {
                this.bottomRight.getElementsIntersectingLineSegment(result, lineSegment);
            }
        }
        if (this.parent != null) {
            if (this.parent.topLeft != this && this.parent.topLeft.isSearchRequired() && RegionQuadTree.intersects(this.parent.topLeft, lineSegment)) {
                this.parent.topLeft.getElementsIntersectingLineSegment(result, lineSegment);
            }
            if (this.parent.topRight != this && this.parent.topRight.isSearchRequired() && RegionQuadTree.intersects(this.parent.topRight, lineSegment)) {
                this.parent.topRight.getElementsIntersectingLineSegment(result, lineSegment);
            }
            if (this.parent.bottomLeft != this && this.parent.bottomLeft.isSearchRequired() && RegionQuadTree.intersects(this.parent.bottomLeft, lineSegment)) {
                this.parent.bottomLeft.getElementsIntersectingLineSegment(result, lineSegment);
            }
            if (this.parent.bottomRight != this && this.parent.bottomRight.isSearchRequired() && RegionQuadTree.intersects(this.parent.bottomRight, lineSegment)) {
                this.parent.bottomRight.getElementsIntersectingLineSegment(result, lineSegment);
            }
            ((RegionQuadTree)this.parent).addElementsIntersectingLineSegmentUpwards(result, lineSegment, false);
        }
    }

    @Override
    public Array<T> getElements() {
        Array result = new Array();
        this.getElements(result);
        return result;
    }

    @Override
    public void getElements(Array<T> result) {
        if (this.topLeft != null) {
            ((RegionQuadTree)this.topLeft).getElements(result);
            ((RegionQuadTree)this.topRight).getElements(result);
            ((RegionQuadTree)this.bottomLeft).getElements(result);
            ((RegionQuadTree)this.bottomRight).getElements(result);
        }
        result.addAll(this.elements);
    }

    @Override
    public int getTotalElements() {
        if (this.totalElementsCache >= 0) {
            return this.totalElementsCache;
        }
        this.totalElementsCache = 0;
        if (this.topLeft != null) {
            this.totalElementsCache = this.topLeft.getTotalElements();
            this.totalElementsCache += this.topRight.getTotalElements();
            this.totalElementsCache += this.bottomLeft.getTotalElements();
            this.totalElementsCache += this.bottomRight.getTotalElements();
        }
        this.totalElementsCache += this.elements.size;
        return this.totalElementsCache;
    }

    @Override
    public void positionChanged(T moved) {
        if (this.contains((Sizeable)moved)) {
            return;
        }
        this.removeElement(moved);
        for (QuadTree parentQuad = this.parent; parentQuad != null; parentQuad = parentQuad.getParent()) {
            if (!parentQuad.add(moved)) continue;
            return;
        }
    }
}

