/*
 * Decompiled with CFR 0.152.
 */
package org.mini2Dx.core.collision.util;

import org.mini2Dx.core.collision.CollisionArea;
import org.mini2Dx.core.collision.CollisionIdSequence;
import org.mini2Dx.core.collision.Collisions;
import org.mini2Dx.core.collision.RenderCoordMode;
import org.mini2Dx.core.collision.util.StaticCollision;
import org.mini2Dx.core.geom.Rectangle;
import org.mini2Dx.core.util.HashUtils;

public class StaticCollisionBox
extends Rectangle
implements CollisionArea,
StaticCollision {
    protected Collisions collisions = null;
    private int id;
    private RenderCoordMode renderCoordMode = RenderCoordMode.GLOBAL_DEFAULT;

    public StaticCollisionBox() {
        this(CollisionIdSequence.nextId());
    }

    public StaticCollisionBox(float x, float y, float width, float height) {
        this(CollisionIdSequence.nextId(), x, y, width, height);
    }

    public StaticCollisionBox(Rectangle rectangle) {
        this(CollisionIdSequence.nextId(), rectangle);
    }

    public StaticCollisionBox(int id) {
        this(id, 0.0f, 0.0f, 1.0f, 1.0f);
    }

    public StaticCollisionBox(int id, Rectangle rectangle) {
        this(id, rectangle.getX(), rectangle.getY(), rectangle.getWidth(), rectangle.getHeight());
    }

    public StaticCollisionBox(int id, float x, float y, float width, float height) {
        super(x, y, width, height);
        this.id = id;
        this.init(id, x, y, width, height);
    }

    public StaticCollisionBox(int id, Collisions collisions) {
        this(id);
        this.collisions = collisions;
    }

    public void init(int id, float x, float y, float width, float height) {
        this.id = id;
        this.disposed = false;
        this.forceTo(x, y, width, height);
    }

    protected void release() {
        this.collisions.release(this);
    }

    @Override
    public void dispose() {
        if (this.disposed) {
            return;
        }
        if (this.collisions != null) {
            this.clearPositionChangeListeners();
            this.clearSizeChangeListeners();
            this.disposed = true;
            this.release();
            return;
        }
        super.dispose();
    }

    @Override
    public void forceTo(float x, float y, float width, float height) {
        this.set(x, y, width, height);
    }

    @Override
    public void forceToWidth(float width) {
        this.setWidth(width);
    }

    @Override
    public void forceToHeight(float height) {
        this.setHeight(height);
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public void preUpdate() {
    }

    @Override
    public void interpolate(float alpha) {
    }

    @Override
    public void forceTo(float x, float y) {
        this.set(x, y, this.getWidth(), this.getHeight());
    }

    @Override
    public CollisionArea setTo(float x, float y, float width, float height) {
        this.set(x, y, width, height);
        return this;
    }

    @Override
    public int getRenderX() {
        return this.renderCoordMode.apply(this.getX());
    }

    @Override
    public int getRenderY() {
        return this.renderCoordMode.apply(this.getY());
    }

    @Override
    public float getRawRenderX() {
        return this.getX();
    }

    @Override
    public float getRawRenderY() {
        return this.getY();
    }

    @Override
    public int getRenderWidth() {
        return this.renderCoordMode.apply(this.getWidth());
    }

    @Override
    public int getRenderHeight() {
        return this.renderCoordMode.apply(this.getHeight());
    }

    @Override
    public float getRawRenderWidth() {
        return this.getWidth();
    }

    @Override
    public float getRawRenderHeight() {
        return this.getHeight();
    }

    @Override
    public RenderCoordMode getRenderCoordMode() {
        return this.renderCoordMode;
    }

    @Override
    public void setRenderCoordMode(RenderCoordMode mode) {
        if (mode == null) {
            return;
        }
        this.renderCoordMode = mode;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof StaticCollisionBox)) {
            return false;
        }
        StaticCollisionBox that = (StaticCollisionBox)o;
        if (this.id != that.id) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    public int hashCode() {
        return HashUtils.hashCode(this.id);
    }
}

