/*
 * Decompiled with CFR 0.152.
 */
package org.mini2Dx.core.collision.util;

import org.mini2Dx.core.collision.CollisionArea;
import org.mini2Dx.core.collision.CollisionIdSequence;
import org.mini2Dx.core.collision.Collisions;
import org.mini2Dx.core.collision.RenderCoordMode;
import org.mini2Dx.core.collision.util.StaticCollision;
import org.mini2Dx.core.geom.Circle;
import org.mini2Dx.core.util.HashUtils;

public class StaticCollisionCircle
extends Circle
implements CollisionArea,
StaticCollision {
    private int id;
    protected Collisions collisions = null;
    private RenderCoordMode renderCoordMode = RenderCoordMode.GLOBAL_DEFAULT;

    public StaticCollisionCircle(float radius) {
        this(CollisionIdSequence.nextId(), radius);
    }

    public StaticCollisionCircle(float centerX, float centerY, float radius) {
        this(CollisionIdSequence.nextId(), centerX, centerY, radius);
    }

    public StaticCollisionCircle(Circle circle) {
        this(CollisionIdSequence.nextId(), circle);
    }

    public StaticCollisionCircle(int id, float radius) {
        this(id, 0.0f, 0.0f, radius);
    }

    public StaticCollisionCircle(int id, Circle circle) {
        this(id, circle.getX(), circle.getY(), circle.getRadius());
    }

    public StaticCollisionCircle(int id, Collisions collisions) {
        this(id, 0.0f, 0.0f, 1.0f);
        this.collisions = collisions;
    }

    public StaticCollisionCircle(int id, float centerX, float centerY, float radius) {
        super(centerX, centerY, radius);
        this.init(id, centerX, centerY, radius);
    }

    public void init(int id, float centerX, float centerY, float radius) {
        this.id = id;
        this.disposed = false;
        this.setXY(centerX, centerY);
        this.setRadius(radius);
    }

    protected void release() {
        this.collisions.release(this);
    }

    @Override
    public void dispose() {
        if (this.disposed) {
            return;
        }
        if (this.collisions != null) {
            this.clearPositionChangeListeners();
            this.clearSizeChangeListeners();
            this.disposed = true;
            this.release();
            return;
        }
        super.dispose();
    }

    @Override
    public CollisionArea setTo(float x, float y, float width, float height) {
        this.setXY(x, y);
        this.setRadius(width * 0.5f);
        return this;
    }

    @Override
    public void forceTo(float x, float y, float width, float height) {
        this.setXY(x, y);
        this.setRadius(width * 0.5f);
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public void preUpdate() {
    }

    @Override
    public void interpolate(float alpha) {
    }

    @Override
    public void forceTo(float x, float y) {
        this.setXY(x, y);
    }

    @Override
    public void forceToWidth(float width) {
        this.setRadius(width * 0.5f);
    }

    @Override
    public void forceToHeight(float height) {
        this.setRadius(height * 0.5f);
    }

    @Override
    public int getRenderX() {
        return this.renderCoordMode.apply(this.getX());
    }

    @Override
    public int getRenderY() {
        return this.renderCoordMode.apply(this.getY());
    }

    public int getRenderRadius() {
        return this.renderCoordMode.apply(this.getRadius());
    }

    @Override
    public float getRawRenderX() {
        return this.getX();
    }

    @Override
    public float getRawRenderY() {
        return this.getY();
    }

    @Override
    public int getRenderWidth() {
        return this.renderCoordMode.apply(this.getWidth());
    }

    @Override
    public int getRenderHeight() {
        return this.renderCoordMode.apply(this.getHeight());
    }

    @Override
    public float getRawRenderWidth() {
        return this.getWidth();
    }

    @Override
    public float getRawRenderHeight() {
        return this.getHeight();
    }

    @Override
    public RenderCoordMode getRenderCoordMode() {
        return this.renderCoordMode;
    }

    @Override
    public void setRenderCoordMode(RenderCoordMode mode) {
        if (mode == null) {
            return;
        }
        this.renderCoordMode = mode;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof StaticCollisionCircle)) {
            return false;
        }
        StaticCollisionCircle that = (StaticCollisionCircle)o;
        if (this.id != that.id) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    public int hashCode() {
        return HashUtils.hashCode(this.id);
    }
}

