/*
 * Decompiled with CFR 0.152.
 */
package org.mini2Dx.core.collision.util;

import org.mini2Dx.core.collision.CollisionIdSequence;
import org.mini2Dx.core.collision.CollisionObject;
import org.mini2Dx.core.collision.Collisions;
import org.mini2Dx.core.collision.RenderCoordMode;
import org.mini2Dx.core.collision.util.StaticCollision;
import org.mini2Dx.core.geom.Point;
import org.mini2Dx.core.util.HashUtils;

public class StaticCollisionPoint
extends Point
implements CollisionObject,
StaticCollision {
    private int id;
    protected Collisions collisions = null;
    private RenderCoordMode renderCoordMode = RenderCoordMode.GLOBAL_DEFAULT;

    public StaticCollisionPoint() {
        this(CollisionIdSequence.nextId());
    }

    public StaticCollisionPoint(float x, float y) {
        this(CollisionIdSequence.nextId(), x, y);
    }

    public StaticCollisionPoint(Point point) {
        this(CollisionIdSequence.nextId(), point);
    }

    public StaticCollisionPoint(int id) {
        this(id, 0.0f, 0.0f);
    }

    public StaticCollisionPoint(int id, Point point) {
        this(id, point.getX(), point.getY());
    }

    public StaticCollisionPoint(int id, float x, float y) {
        super(x, y);
        this.init(id, x, y);
    }

    public StaticCollisionPoint(int id, Collisions collisions) {
        this(id);
        this.collisions = collisions;
    }

    public void init(int id, float x, float y) {
        this.id = id;
        this.disposed = false;
        this.forceTo(x, y);
    }

    protected void release() {
        this.collisions.release(this);
    }

    @Override
    public void dispose() {
        if (this.disposed) {
            return;
        }
        if (this.collisions != null) {
            this.clearPositionChangeListeners();
            this.disposed = true;
            this.release();
            return;
        }
        super.dispose();
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public void preUpdate() {
    }

    @Override
    public void interpolate(float alpha) {
    }

    @Override
    public void forceTo(float x, float y) {
        this.set(x, y);
    }

    @Override
    public int getRenderX() {
        return this.renderCoordMode.apply(this.x);
    }

    @Override
    public int getRenderY() {
        return this.renderCoordMode.apply(this.y);
    }

    @Override
    public float getRawRenderX() {
        return this.x;
    }

    @Override
    public float getRawRenderY() {
        return this.y;
    }

    @Override
    public RenderCoordMode getRenderCoordMode() {
        return this.renderCoordMode;
    }

    @Override
    public void setRenderCoordMode(RenderCoordMode mode) {
        if (mode == null) {
            return;
        }
        this.renderCoordMode = mode;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof StaticCollisionPoint)) {
            return false;
        }
        StaticCollisionPoint that = (StaticCollisionPoint)o;
        if (this.id != that.id) {
            return false;
        }
        return super.equals(o);
    }

    public int hashCode() {
        return HashUtils.hashCode(this.id);
    }
}

