/*
 * Decompiled with CFR 0.152.
 */
package org.mini2Dx.core.collision.util;

import org.mini2Dx.core.collision.CollisionArea;
import org.mini2Dx.core.collision.CollisionIdSequence;
import org.mini2Dx.core.collision.Collisions;
import org.mini2Dx.core.collision.RenderCoordMode;
import org.mini2Dx.core.collision.util.StaticCollision;
import org.mini2Dx.core.exception.MdxException;
import org.mini2Dx.core.geom.Polygon;
import org.mini2Dx.core.util.HashUtils;
import org.mini2Dx.gdx.math.Vector2;

public class StaticCollisionPolygon
extends Polygon
implements CollisionArea,
StaticCollision {
    private int id;
    protected Collisions collisions = null;
    private RenderCoordMode renderCoordMode = RenderCoordMode.GLOBAL_DEFAULT;

    public StaticCollisionPolygon(float[] vertices) {
        this(CollisionIdSequence.nextId(), vertices);
    }

    public StaticCollisionPolygon(Vector2[] points) {
        this(CollisionIdSequence.nextId(), points);
    }

    public StaticCollisionPolygon(int id, float[] vertices) {
        super(vertices);
        this.init(id, vertices);
    }

    public StaticCollisionPolygon(int id, Vector2[] points) {
        super(points);
        this.init(id, points);
    }

    public StaticCollisionPolygon(int id, Collisions collisions, float[] vertices) {
        this(id, vertices);
        this.collisions = collisions;
    }

    public StaticCollisionPolygon(int id, Collisions collisions, Vector2[] points) {
        this(id, points);
        this.collisions = collisions;
    }

    public void init(int id, float[] vertices) {
        this.id = id;
        this.disposed = false;
        this.setVertices(vertices);
    }

    public void init(int id, Vector2[] points) {
        this.id = id;
        this.disposed = false;
        this.setVertices(points);
    }

    protected void release() {
        this.collisions.release(this);
    }

    @Override
    public void dispose() {
        if (this.disposed) {
            return;
        }
        if (this.collisions != null) {
            this.clearPositionChangeListeners();
            this.clearSizeChangeListeners();
            this.disposed = true;
            this.release();
            return;
        }
        super.dispose();
    }

    @Override
    public CollisionArea setTo(float x, float y, float width, float height) {
        throw new MdxException("#setTo(x, y, width, height) not supported on StaticCollisionPolygon");
    }

    @Override
    public void forceTo(float x, float y, float width, float height) {
        throw new MdxException("#forceTo(x, y, width, height) not supported on StaticCollisionPolygon");
    }

    @Override
    public void forceToWidth(float width) {
        throw new MdxException("#forceToWidth(width) not supported on StaticCollisionPolygon");
    }

    @Override
    public void forceToHeight(float height) {
        throw new MdxException("#forceToHeight(float height) not supported on StaticCollisionPolygon");
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public void preUpdate() {
    }

    @Override
    public void interpolate(float alpha) {
    }

    @Override
    public void forceTo(float x, float y) {
        this.setXY(x, y);
    }

    @Override
    public int getRenderX() {
        return this.renderCoordMode.apply(this.getX());
    }

    @Override
    public int getRenderY() {
        return this.renderCoordMode.apply(this.getY());
    }

    @Override
    public float getRawRenderX() {
        return this.getX();
    }

    @Override
    public float getRawRenderY() {
        return this.getY();
    }

    @Override
    public int getRenderWidth() {
        return this.renderCoordMode.apply(this.getWidth());
    }

    @Override
    public int getRenderHeight() {
        return this.renderCoordMode.apply(this.getHeight());
    }

    @Override
    public float getRawRenderWidth() {
        return this.getWidth();
    }

    @Override
    public float getRawRenderHeight() {
        return this.getHeight();
    }

    @Override
    public RenderCoordMode getRenderCoordMode() {
        return this.renderCoordMode;
    }

    @Override
    public void setRenderCoordMode(RenderCoordMode mode) {
        if (mode == null) {
            return;
        }
        this.renderCoordMode = mode;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof StaticCollisionPolygon)) {
            return false;
        }
        StaticCollisionPolygon that = (StaticCollisionPolygon)o;
        if (this.id != that.id) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    public int hashCode() {
        return HashUtils.hashCode(this.id);
    }
}

