/*
 * Decompiled with CFR 0.152.
 */
package org.mini2Dx.core.di;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.Scanner;
import org.mini2Dx.core.di.ComponentScanner;
import org.mini2Dx.core.exception.MdxException;
import org.mini2Dx.gdx.utils.Array;

public class BasicComponentScanner
implements ComponentScanner {
    protected Array<Class<?>> singletonClasses = new Array();
    protected Array<Class<?>> prototypeClasses = new Array();

    @Override
    public void scan(String[] packageNames) throws MdxException, IOException {
    }

    @Override
    public void saveTo(Writer writer) {
        int i;
        PrintWriter printWriter = new PrintWriter(writer);
        printWriter.println("--- Singletons ---");
        for (i = 0; i < this.singletonClasses.size; ++i) {
            printWriter.println(((Class)this.singletonClasses.get(i)).getName());
        }
        printWriter.println("--- Prototypes ---");
        for (i = 0; i < this.prototypeClasses.size; ++i) {
            printWriter.println(((Class)this.prototypeClasses.get(i)).getName());
        }
        printWriter.flush();
        printWriter.close();
    }

    @Override
    public void restoreFrom(Reader reader) throws ClassNotFoundException {
        Scanner scanner = new Scanner(reader);
        boolean singletons = true;
        scanner.nextLine();
        while (scanner.hasNext()) {
            String line = scanner.nextLine();
            if (line.startsWith("---")) {
                singletons = false;
                continue;
            }
            if (singletons) {
                this.singletonClasses.add(Class.forName(line));
                continue;
            }
            this.prototypeClasses.add(Class.forName(line));
        }
        scanner.close();
    }

    @Override
    public Array<Class<?>> getSingletonClasses() {
        return this.singletonClasses;
    }

    @Override
    public Array<Class<?>> getPrototypeClasses() {
        return this.prototypeClasses;
    }
}

