/*
 * Decompiled with CFR 0.152.
 */
package org.mini2Dx.core.di.injection;

import org.mini2Dx.core.Mdx;
import org.mini2Dx.core.di.annotation.Autowired;
import org.mini2Dx.core.di.annotation.PostInject;
import org.mini2Dx.core.di.bean.Bean;
import org.mini2Dx.core.di.bean.PrototypeBean;
import org.mini2Dx.core.di.bean.SingletonBean;
import org.mini2Dx.core.di.injection.PrototypeInjectionMap;
import org.mini2Dx.core.exception.NoSuchBeanException;
import org.mini2Dx.core.exception.PostInjectException;
import org.mini2Dx.core.exception.ReflectionException;
import org.mini2Dx.core.reflect.Annotation;
import org.mini2Dx.core.reflect.Field;
import org.mini2Dx.core.reflect.Method;
import org.mini2Dx.gdx.utils.Array;
import org.mini2Dx.gdx.utils.ObjectMap;
import org.mini2Dx.gdx.utils.OrderedMap;

public class BeanInjector {
    private static final String LOGGING_TAG = BeanInjector.class.getSimpleName();
    private OrderedMap<String, Object> singletons;
    private OrderedMap<String, Object> prototypes;
    private OrderedMap<String, NoSuchBeanException> exceptions;

    public BeanInjector(OrderedMap<String, Object> singletons, OrderedMap<String, Object> prototypes) {
        this.singletons = singletons;
        this.prototypes = prototypes;
        this.exceptions = new OrderedMap();
    }

    public void inject() throws NoSuchBeanException, IllegalArgumentException, IllegalAccessException {
        Object object;
        String key2;
        this.injectSingletons();
        this.injectPrototypes();
        this.checkInjectionSuccessful();
        for (String key2 : this.prototypes.keys()) {
            object = this.prototypes.get((Object)key2);
            try {
                this.invokePostInject(object);
            }
            catch (ReflectionException e) {
                Mdx.log.error(LOGGING_TAG, e.getMessage(), e);
            }
        }
        ObjectMap.Keys keys = this.singletons.keys().iterator();
        while (keys.hasNext()) {
            key2 = (String)keys.next();
            object = this.singletons.get((Object)key2);
            try {
                this.invokePostInject(object);
            }
            catch (ReflectionException e) {
                Mdx.log.error(LOGGING_TAG, e.getMessage(), e);
            }
        }
        if (this.exceptions.size > 0 && (keys = this.exceptions.keys().iterator()).hasNext()) {
            key2 = (String)keys.next();
            throw (NoSuchBeanException)this.exceptions.get((Object)key2);
        }
    }

    public OrderedMap<String, Bean> getInjectionResult() {
        Object object;
        OrderedMap result = new OrderedMap();
        for (String key : this.singletons.keys()) {
            object = this.singletons.get((Object)key);
            result.put((Object)key, (Object)new SingletonBean(object));
        }
        for (String key : this.prototypes.keys()) {
            object = this.prototypes.get((Object)key);
            PrototypeBean prototypeBean = new PrototypeBean(object);
            result.put((Object)key, (Object)prototypeBean);
        }
        return result;
    }

    private void invokePostInject(Object object) throws IllegalArgumentException {
        for (Method method : Mdx.reflect.getMethods(object.getClass())) {
            if (!method.isAnnotationPresent(PostInject.class)) continue;
            if (method.getParameterTypes().length > 0) {
                throw new PostInjectException();
            }
            method.invoke(object, new Object[0]);
        }
    }

    private void injectPrototypes() throws NoSuchBeanException, IllegalArgumentException, IllegalAccessException {
        Object object;
        PrototypeInjectionMap<String, Object> prototypeInjectionMap = new PrototypeInjectionMap<String, Object>(this.prototypes);
        for (String key : this.prototypes.keys()) {
            object = this.prototypes.get((Object)key);
            this.inject(object, key, prototypeInjectionMap);
        }
        for (String key : this.singletons.keys()) {
            object = this.singletons.get((Object)key);
            this.inject(object, key, prototypeInjectionMap);
        }
    }

    private void injectSingletons() throws NoSuchBeanException, IllegalArgumentException, IllegalAccessException {
        Object object;
        Array keys = new Array();
        for (String key : this.singletons.keys()) {
            keys.add((Object)key);
        }
        for (String key : keys) {
            object = this.singletons.get((Object)key);
            this.inject(object, key, this.singletons);
        }
        keys.clear();
        for (String key : this.prototypes.keys()) {
            keys.add((Object)key);
        }
        for (String key : keys) {
            object = this.prototypes.get((Object)key);
            this.inject(object, key, this.singletons);
        }
        keys.clear();
    }

    private void checkInjectionSuccessful() throws NoSuchBeanException, IllegalArgumentException, IllegalAccessException {
        Object object;
        for (String key : this.singletons.keys()) {
            object = this.singletons.get((Object)key);
            this.checkInjectionSuccessful(object, key);
        }
        for (String key : this.prototypes.keys()) {
            object = this.prototypes.get((Object)key);
            this.checkInjectionSuccessful(object, key);
        }
    }

    private void checkInjectionSuccessful(Object object, String objectKey) throws NoSuchBeanException, IllegalArgumentException, IllegalAccessException {
        Class<?> currentClass = object.getClass();
        while (!currentClass.equals(Object.class)) {
            for (Field field : Mdx.reflect.getDeclaredFields(currentClass)) {
                Annotation annotation = field.getDeclaredAnnotation(Autowired.class);
                if (annotation == null) continue;
                Autowired autowireAnnotaiton = annotation.getAnnotation(Autowired.class);
                Object value = field.get(object);
                if (autowireAnnotaiton == null || value != null || !autowireAnnotaiton.required()) continue;
                Class clazz = field.getType();
                String clazzKey = Bean.getClassKey(clazz);
                this.exceptions.put((Object)clazzKey, (Object)new NoSuchBeanException(object.getClass().getSimpleName(), field.getName(), clazz.getSimpleName()));
            }
            currentClass = currentClass.getSuperclass();
        }
    }

    private void inject(Object object, String objectKey, OrderedMap<String, Object> beans) throws NoSuchBeanException, IllegalArgumentException, IllegalAccessException {
        Class<?> currentClass = object.getClass();
        while (!currentClass.equals(Object.class)) {
            block1: for (Field field : Mdx.reflect.getDeclaredFields(currentClass)) {
                Annotation annotation = field.getDeclaredAnnotation(Autowired.class);
                if (annotation == null) continue;
                Autowired autowireAnnotaiton = annotation.getAnnotation(Autowired.class);
                Object value = field.get(object);
                if (autowireAnnotaiton == null || value != null) continue;
                Class clazz = field.getType();
                String clazzKey = Bean.getClassKey(clazz);
                if (beans.containsKey((Object)clazzKey)) {
                    Object dependency = beans.get((Object)clazzKey, null);
                    field.set(object, dependency);
                    continue;
                }
                if (!clazz.isInterface()) continue;
                boolean found = false;
                for (String beanKey : beans.keys()) {
                    if (beanKey.compareTo(objectKey) == 0) continue;
                    Object beanToInject = beans.get((Object)beanKey);
                    for (Class<?> interfaceImpl : beanToInject.getClass().getInterfaces()) {
                        if (!interfaceImpl.equals(clazz)) continue;
                        field.set(object, beanToInject);
                        found = true;
                        break;
                    }
                    if (!found) continue;
                    continue block1;
                }
            }
            currentClass = currentClass.getSuperclass();
        }
    }
}

