/*
 * Decompiled with CFR 0.152.
 */
package org.mini2Dx.core.files;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.FileFilter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import org.mini2Dx.core.files.FileType;

public interface FileHandle {
    public String path();

    public String normalize();

    public FileHandle normalizedHandle();

    public String name();

    public String extension();

    public String nameWithoutExtension();

    public String pathWithoutExtension();

    public FileType type();

    public InputStream read() throws IOException;

    public BufferedInputStream read(int var1) throws IOException;

    public Reader reader() throws IOException;

    public Reader reader(String var1) throws IOException;

    public BufferedReader reader(int var1) throws IOException;

    public BufferedReader reader(int var1, String var2) throws IOException;

    public String readString() throws IOException;

    public byte[] headBytes(int var1) throws IOException;

    default public String head() throws IOException {
        return this.head(Charset.defaultCharset().name());
    }

    default public String head(int lines) throws IOException {
        return this.head(lines, Charset.defaultCharset().name());
    }

    default public String head(String charset) throws IOException {
        return this.head(10, charset);
    }

    public String head(int var1, String var2) throws IOException;

    public String readString(String var1) throws IOException;

    public String[] readAllLines() throws IOException;

    public byte[] readBytes() throws IOException;

    public int readBytes(byte[] var1, int var2, int var3) throws IOException;

    public OutputStream write(boolean var1) throws IOException;

    public OutputStream write(boolean var1, int var2) throws IOException;

    public void write(InputStream var1, boolean var2) throws IOException;

    public Writer writer(boolean var1) throws IOException;

    public Writer writer(boolean var1, String var2) throws IOException;

    public void writeString(String var1, boolean var2) throws IOException;

    public void writeString(String var1, boolean var2, String var3) throws IOException;

    public void writeBytes(byte[] var1, boolean var2) throws IOException;

    public void writeBytes(byte[] var1, int var2, int var3, boolean var4) throws IOException;

    public FileHandle[] list() throws IOException;

    public FileHandle[] list(FileFilter var1) throws IOException;

    public FileHandle[] list(FilenameFilter var1) throws IOException;

    public FileHandle[] list(String var1) throws IOException;

    public boolean isDirectory();

    public FileHandle child(String var1);

    public FileHandle sibling(String var1);

    public FileHandle parent();

    public void mkdirs() throws IOException;

    public boolean exists();

    public boolean delete() throws IOException;

    public boolean deleteDirectory() throws IOException;

    public void emptyDirectory() throws IOException;

    public void emptyDirectory(boolean var1) throws IOException;

    public void copyTo(FileHandle var1) throws IOException;

    public void moveTo(FileHandle var1) throws IOException;

    public long length();

    public long lastModified();
}

