/*
 * Decompiled with CFR 0.152.
 */
package org.mini2Dx.core.font;

import org.mini2Dx.core.Graphics;
import org.mini2Dx.core.Mdx;
import org.mini2Dx.core.assets.AssetManager;
import org.mini2Dx.core.collections.CharMap;
import org.mini2Dx.core.exception.MdxException;
import org.mini2Dx.core.files.FileHandle;
import org.mini2Dx.core.files.FileType;
import org.mini2Dx.core.font.FontBuilderGameFontCache;
import org.mini2Dx.core.font.FontBuilderGlyph;
import org.mini2Dx.core.font.FontBuilderGlyphLayout;
import org.mini2Dx.core.font.FontBuilderXmlReader;
import org.mini2Dx.core.font.FontGlyphLayout;
import org.mini2Dx.core.font.GameFont;
import org.mini2Dx.core.font.GameFontCache;
import org.mini2Dx.core.font.MonospaceGameFont;
import org.mini2Dx.core.graphics.Color;
import org.mini2Dx.core.graphics.Texture;
import org.mini2Dx.core.graphics.TextureAtlas;
import org.mini2Dx.core.graphics.TextureAtlasRegion;
import org.mini2Dx.core.graphics.TextureRegion;
import org.mini2Dx.core.serialization.annotation.Field;
import org.mini2Dx.gdx.utils.Array;

public class FontBuilderGameFont
implements GameFont {
    private static final String LOGGING_TAG = FontBuilderGameFont.class.getSimpleName();
    private static final FontBuilderXmlReader XML_READER = new FontBuilderXmlReader();
    private final FontBuilderGlyphLayout sharedGlyphLayout;
    final FontParameters fontParameters;
    final FontProperties fontProperties = new FontProperties();
    final CharMap<FontBuilderChar> charMap = new CharMap();
    private Color color = Mdx.graphics.newColor(0.0f, 0.0f, 0.0f, 1.0f);

    public FontBuilderGameFont(FontParameters fontParameters) {
        this.fontParameters = fontParameters;
        this.sharedGlyphLayout = (FontBuilderGlyphLayout)this.newGlyphLayout();
    }

    @Override
    public boolean loadInternal() {
        if (this.fontParameters.xmlFileHandleType != null && !this.fontParameters.xmlFileHandleType.equals((Object)FileType.INTERNAL)) {
            throw new MdxException("Attempting to use loadInternal() but font is set to file handle type " + (Object)((Object)this.fontParameters.xmlFileHandleType));
        }
        return this.load(Mdx.files.internal(this.fontParameters.xmlPath), Mdx.graphics.newTextureRegion(Mdx.graphics.newTexture(Mdx.files.internal(this.fontParameters.texturePath))));
    }

    @Override
    public boolean loadExternal() {
        if (this.fontParameters.xmlFileHandleType != null && !this.fontParameters.xmlFileHandleType.equals((Object)FileType.EXTERNAL)) {
            throw new MdxException("Attempting to use loadExternal() but font is set to file handle type " + (Object)((Object)this.fontParameters.xmlFileHandleType));
        }
        return this.load(Mdx.files.external(this.fontParameters.xmlPath), Mdx.graphics.newTextureRegion(Mdx.graphics.newTexture(Mdx.files.external(this.fontParameters.texturePath))));
    }

    @Override
    public boolean load(AssetManager assetManager) {
        TextureRegion textureRegion;
        FileHandle xmlFileHandle;
        if (this.fontParameters.xmlFileHandleType == null) {
            throw new MdxException("Attempting to use load(AssetManager) but xmlFileHandleType is not set");
        }
        switch (this.fontParameters.xmlFileHandleType) {
            case EXTERNAL: {
                xmlFileHandle = Mdx.files.external(this.fontParameters.xmlPath);
                break;
            }
            case LOCAL: {
                xmlFileHandle = Mdx.files.local(this.fontParameters.xmlPath);
                break;
            }
            default: {
                xmlFileHandle = Mdx.files.internal(this.fontParameters.xmlPath);
            }
        }
        if (this.fontParameters.textureAtlasPath != null) {
            if (!assetManager.isLoaded(this.fontParameters.textureAtlasPath)) {
                assetManager.load(this.fontParameters.textureAtlasPath, TextureAtlas.class);
                return false;
            }
            TextureAtlas textureAtlas = assetManager.get(this.fontParameters.textureAtlasPath, TextureAtlas.class);
            if (textureAtlas == null) {
                throw new MdxException("No such texture atlas '" + this.fontParameters.textureAtlasPath + "'");
            }
            TextureAtlasRegion textureAtlasRegion = textureAtlas.findRegion(this.fontParameters.texturePath);
            if (textureAtlasRegion == null) {
                throw new MdxException("No such texture atlas region '" + this.fontParameters.texturePath + "' in '" + this.fontParameters.textureAtlasPath + "'");
            }
            textureRegion = Mdx.graphics.newTextureRegion(textureAtlasRegion);
        } else {
            if (!assetManager.isLoaded(this.fontParameters.texturePath)) {
                assetManager.load(this.fontParameters.texturePath, Texture.class);
                return false;
            }
            textureRegion = Mdx.graphics.newTextureRegion(assetManager.get(this.fontParameters.texturePath, Texture.class));
        }
        return this.load(xmlFileHandle, textureRegion);
    }

    private boolean load(FileHandle xmlFileHandle, TextureRegion textureRegion) {
        if (this.charMap.size > 0) {
            return true;
        }
        try {
            XML_READER.read(xmlFileHandle, this.fontProperties, this.charMap);
        }
        catch (Exception e) {
            Mdx.log.error(LOGGING_TAG, e.getMessage(), e);
            return false;
        }
        for (FontBuilderChar fontChar : this.charMap.values()) {
            fontChar.textureRegion = Mdx.graphics.newTextureRegion(textureRegion, fontChar.rectX, fontChar.rectY, fontChar.rectWidth, fontChar.rectHeight);
        }
        return true;
    }

    @Override
    public void draw(Graphics g, String str, float x, float y) {
        this.draw(g, str, x, y, -1.0f);
    }

    @Override
    public void draw(Graphics g, String str, float x, float y, float renderWidth) {
        this.draw(g, str, x, y, renderWidth, 8, true);
    }

    @Override
    public void draw(Graphics g, String str, float x, float y, float renderWidth, int horizontalAlignment, boolean wrap) {
        this.draw(g, str, x, y, renderWidth, horizontalAlignment, wrap, null);
    }

    public void draw(Graphics g, String str, float x, float y, float renderWidth, MonospaceGameFont.FontRenderListener listener) {
        this.draw(g, str, x, y, renderWidth, 8, true, listener);
    }

    public void draw(Graphics g, String str, float x, float y, float renderWidth, int horizontalAlignment, boolean wrap, MonospaceGameFont.FontRenderListener listener) {
        this.sharedGlyphLayout.setText(str, this.color, renderWidth, horizontalAlignment, wrap);
        this.draw(g, this.sharedGlyphLayout.getGlyphs(), x, y, listener);
    }

    public void draw(Graphics g, Array<FontBuilderGlyph> glyphs, float x, float y, MonospaceGameFont.FontRenderListener listener) {
        Color previousTint = g.getTint();
        for (int i = 0; i < glyphs.size; ++i) {
            FontBuilderGlyph glyph = (FontBuilderGlyph)glyphs.get(i);
            if (glyph.glyphChar == null || glyph.glyphChar.textureRegion == null) continue;
            float renderX = x + glyph.x + (float)glyph.glyphChar.offsetX;
            float renderY = y + glyph.y + (float)glyph.glyphChar.offsetY;
            g.setTint(glyph.color);
            if (listener == null) {
                g.drawTextureRegion(glyph.glyphChar.textureRegion, renderX, renderY);
                continue;
            }
            if (listener.preRenderChar(g, glyph.glyphChar.code, renderX, renderY, glyph.glyphChar.rectWidth, glyph.glyphChar.rectHeight)) {
                g.drawTextureRegion(glyph.glyphChar.textureRegion, renderX, renderY);
            }
            listener.postRenderChar(g, glyph.glyphChar.code, renderX, renderY, glyph.glyphChar.rectWidth, glyph.glyphChar.rectHeight);
        }
        g.setTint(previousTint);
    }

    @Override
    public FontGlyphLayout newGlyphLayout() {
        return new FontBuilderGlyphLayout(this);
    }

    @Override
    public FontGlyphLayout getSharedGlyphLayout() {
        return this.sharedGlyphLayout;
    }

    @Override
    public GameFontCache newCache() {
        return new FontBuilderGameFontCache(this);
    }

    @Override
    public Color getColor() {
        return this.color;
    }

    @Override
    public void setColor(Color color) {
        if (color == null) {
            return;
        }
        this.color = color;
    }

    @Override
    public float getLineHeight() {
        return this.fontProperties.height;
    }

    @Override
    public float getCapHeight() {
        return this.fontProperties.height;
    }

    @Override
    public boolean useIntegerPositions() {
        return true;
    }

    @Override
    public void dispose() {
        if (this.sharedGlyphLayout != null) {
            this.sharedGlyphLayout.dispose();
        }
    }

    public static class FontProperties {
        public int size;
        public String family;
        public int height;
        public String style;
    }

    public static class FontBuilderChar {
        public char code;
        public int width;
        public int offsetX;
        public int offsetY;
        public int rectX;
        public int rectY;
        public int rectWidth;
        public int rectHeight;
        public TextureRegion textureRegion;
    }

    public static class FontParameters {
        @Field(optional=true)
        public String textureAtlasPath;
        @Field(optional=true)
        public String texturePath;
        @Field
        public String xmlPath;
        @Field(optional=true)
        public FileType xmlFileHandleType;
    }
}

