/*
 * Decompiled with CFR 0.152.
 */
package org.mini2Dx.core.font;

import org.mini2Dx.core.Mdx;
import org.mini2Dx.core.font.FontBuilderGameFont;
import org.mini2Dx.core.font.FontBuilderGlyph;
import org.mini2Dx.core.font.FontGlyphLayout;
import org.mini2Dx.core.font.GameFont;
import org.mini2Dx.core.graphics.Color;
import org.mini2Dx.gdx.math.MathUtils;
import org.mini2Dx.gdx.utils.Array;

public class FontBuilderGlyphLayout
implements FontGlyphLayout {
    private final Array<FontBuilderGlyph> glyphs = new Array();
    private final FontBuilderGameFont font;
    private final Color black = Mdx.graphics.newColor(0.0f, 0.0f, 0.0f, 1.0f);
    private float maxX;
    private float maxY;

    public FontBuilderGlyphLayout(FontBuilderGameFont font) {
        this.font = font;
    }

    @Override
    public void setText(CharSequence str) {
        this.setText(str, this.black, -1.0f, 8, true);
    }

    @Override
    public void setText(CharSequence str, Color color, float targetWidth, int halign, boolean wrap) {
        FontBuilderGlyph glyph;
        int i;
        this.maxX = -1.0f;
        this.maxY = -1.0f;
        switch (halign) {
            default: {
                this.setTextLeftAlign(str, color, targetWidth, wrap);
                break;
            }
            case 16: {
                this.setTextRightAlign(str, color, targetWidth, wrap);
                break;
            }
            case 1: {
                this.setTextCenterAlign(str, color, targetWidth, wrap);
            }
        }
        if (this.glyphs.size > str.length()) {
            for (i = this.glyphs.size - 1; i >= str.length(); --i) {
                glyph = (FontBuilderGlyph)this.glyphs.removeIndex(i);
                glyph.release();
            }
        }
        for (i = 0; i < this.glyphs.size; ++i) {
            glyph = this.getGlyph(i);
            if (glyph.glyphChar == null || glyph.glyphChar.code == '\n' || glyph.glyphChar.code == '\r') continue;
            this.maxX = Math.max(this.maxX, glyph.x + (float)glyph.glyphChar.width);
            this.maxY = Math.max(this.maxY, glyph.y + (float)this.font.fontProperties.height);
        }
        if (halign == 1 && targetWidth >= 0.0f) {
            this.maxX = targetWidth;
        }
    }

    private void setTextLeftAlign(CharSequence str, Color color, float targetWidth, boolean wrap) {
        if (targetWidth < 0.0f) {
            targetWidth = Float.MAX_VALUE;
        }
        float yOffset = 0.0f;
        float xOffset = 0.0f;
        int i = 0;
        while (i < str.length()) {
            char startChar = this.resolveChar(str.charAt(i));
            if (startChar == '\n' || startChar == '\r' || Character.isWhitespace(startChar)) {
                FontBuilderGlyph glyph = this.getGlyph(i);
                glyph.color.set(color);
                glyph.glyphChar = null;
                glyph.x = -1.0f;
                glyph.y = -1.0f;
                ++i;
                continue;
            }
            float lineWidth = this.calculateMaxWidthBeforeWrap(str, i, targetWidth);
            if (MathUtils.isZero((float)lineWidth)) {
                ++i;
                continue;
            }
            while (i < str.length() && xOffset < lineWidth) {
                char c = this.resolveChar(str.charAt(i));
                float previousXOffset = xOffset;
                if (this.font.charMap.containsKey(c)) {
                    FontBuilderGlyph glyph = this.getGlyph(i);
                    glyph.color.set(color);
                    FontBuilderGameFont.FontBuilderChar fontChar = this.font.charMap.get(c);
                    glyph.x = xOffset;
                    glyph.y = yOffset;
                    glyph.glyphChar = fontChar;
                    xOffset = previousXOffset + (float)fontChar.width;
                }
                ++i;
            }
            if (!wrap) {
                return;
            }
            xOffset = 0.0f;
            yOffset += (float)this.font.fontProperties.height;
        }
    }

    private void setTextRightAlign(CharSequence str, Color color, float targetWidth, boolean wrap) {
        if (targetWidth < 0.0f && MathUtils.isZero((float)(targetWidth = this.calculateMaxWidthBeforeWrap(str, 0, Float.MAX_VALUE)))) {
            return;
        }
        float yOffset = 0.0f;
        float xOffset = Float.MAX_VALUE;
        int i = 0;
        while (i < str.length()) {
            char startChar = this.resolveChar(str.charAt(i));
            if (startChar == '\n' || startChar == '\r' || Character.isWhitespace(startChar)) {
                FontBuilderGlyph glyph = this.getGlyph(i);
                glyph.color.set(color);
                glyph.glyphChar = null;
                glyph.x = -1.0f;
                glyph.y = -1.0f;
                ++i;
                continue;
            }
            float lineWidth = this.calculateMaxWidthBeforeWrap(str, i, targetWidth);
            if (MathUtils.isZero((float)lineWidth)) {
                ++i;
                continue;
            }
            xOffset = lineWidth < targetWidth ? targetWidth - lineWidth : 0.0f;
            while (i < str.length() && xOffset < targetWidth) {
                char c = this.resolveChar(str.charAt(i));
                float previousXOffset = xOffset;
                if (this.font.charMap.containsKey(c)) {
                    FontBuilderGlyph glyph = this.getGlyph(i);
                    glyph.color.set(color);
                    FontBuilderGameFont.FontBuilderChar fontChar = this.font.charMap.get(c);
                    glyph.x = xOffset;
                    glyph.y = yOffset;
                    glyph.glyphChar = fontChar;
                    xOffset = previousXOffset + (float)fontChar.width;
                }
                ++i;
            }
            if (!wrap) {
                return;
            }
            yOffset += (float)this.font.fontProperties.height;
        }
    }

    private void setTextCenterAlign(CharSequence str, Color color, float targetWidth, boolean wrap) {
        if (targetWidth < 0.0f && MathUtils.isZero((float)(targetWidth = this.calculateMaxWidthBeforeWrap(str, 0, Float.MAX_VALUE)))) {
            return;
        }
        float yOffset = 0.0f;
        int i = 0;
        while (i < str.length()) {
            char startChar = this.resolveChar(str.charAt(i));
            if (startChar == '\n' || startChar == '\r' || Character.isWhitespace(startChar)) {
                FontBuilderGlyph glyph = this.getGlyph(i);
                glyph.color.set(color);
                glyph.glyphChar = null;
                glyph.x = -1.0f;
                glyph.y = -1.0f;
                ++i;
                continue;
            }
            float lineWidth = this.calculateMaxWidthBeforeWrap(str, i, targetWidth);
            if (MathUtils.isZero((float)lineWidth)) {
                ++i;
                continue;
            }
            float xOffset = MathUtils.round((float)(targetWidth * 0.5f - lineWidth * 0.5f));
            while (i < str.length() && xOffset < targetWidth) {
                char c = this.resolveChar(str.charAt(i));
                float previousXOffset = xOffset;
                if (this.font.charMap.containsKey(c)) {
                    FontBuilderGlyph glyph = this.getGlyph(i);
                    glyph.color.set(color);
                    FontBuilderGameFont.FontBuilderChar fontChar = this.font.charMap.get(c);
                    glyph.x = xOffset;
                    glyph.y = yOffset;
                    glyph.glyphChar = fontChar;
                    xOffset = previousXOffset + (float)fontChar.width;
                }
                ++i;
            }
            if (!wrap) {
                return;
            }
            yOffset += (float)this.font.fontProperties.height;
        }
    }

    public float calculateMaxWidthBeforeWrap(CharSequence str, int from, float targetWidth) {
        float x = 0.0f;
        for (int i = from; i < str.length(); ++i) {
            char c = this.resolveChar(str.charAt(i));
            switch (c) {
                case '\n': 
                case '\r': {
                    return x;
                }
            }
            if (!this.font.charMap.containsKey(c)) continue;
            FontBuilderGameFont.FontBuilderChar fontChar = this.font.charMap.get(c);
            if (x + (float)fontChar.width > targetWidth) {
                if (Character.isWhitespace(c)) {
                    return x;
                }
                if (c == '\n' || c == '\r') {
                    return x;
                }
                float spaceX = x;
                for (int j = i - 1; j >= from; --j) {
                    char previousChar = str.charAt(j);
                    if (!this.font.charMap.containsKey(previousChar)) continue;
                    FontBuilderGameFont.FontBuilderChar previousFontChar = this.font.charMap.get(previousChar);
                    spaceX -= (float)previousFontChar.width;
                    if (Character.isWhitespace(previousChar)) {
                        return spaceX;
                    }
                    if (!Character.isIdeographic(previousChar)) continue;
                    return spaceX;
                }
                return x;
            }
            x += (float)fontChar.width;
        }
        return x;
    }

    @Override
    public void reset() {
        while (this.glyphs.size > 0) {
            FontBuilderGlyph run = (FontBuilderGlyph)this.glyphs.removeIndex(0);
            run.release();
        }
        this.maxX = -1.0f;
        this.maxY = -1.0f;
    }

    @Override
    public void dispose() {
        this.reset();
    }

    @Override
    public float getWidth() {
        return this.maxX;
    }

    @Override
    public float getHeight() {
        return this.maxY;
    }

    @Override
    public GameFont getFont() {
        return this.font;
    }

    private char resolveChar(char c) {
        if (this.font.charMap.containsKey(c)) {
            return c;
        }
        if (c == '\u3002') {
            return '.';
        }
        if (c == '\uff0c') {
            return ',';
        }
        if (c == '\uff1f') {
            return '?';
        }
        if (c == '\uff01') {
            return '!';
        }
        if (c == '\u2026') {
            return '.';
        }
        return c;
    }

    public void transferGlyphsTo(Array<FontBuilderGlyph> result, float x, float y) {
        while (this.glyphs.size > 0) {
            FontBuilderGlyph glyph = (FontBuilderGlyph)this.glyphs.removeIndex(0);
            glyph.x += x;
            glyph.y += y;
            result.add((Object)glyph);
        }
    }

    public Array<FontBuilderGlyph> getGlyphs() {
        return this.glyphs;
    }

    private FontBuilderGlyph getGlyph(int index) {
        while (index >= this.glyphs.size) {
            FontBuilderGlyph result = FontBuilderGlyph.allocate();
            this.glyphs.add((Object)result);
        }
        return (FontBuilderGlyph)this.glyphs.get(index);
    }
}

