/*
 * Decompiled with CFR 0.152.
 */
package org.mini2Dx.core.font;

import java.io.IOException;
import java.io.Reader;
import org.mini2Dx.core.collections.CharMap;
import org.mini2Dx.core.files.FileHandle;
import org.mini2Dx.core.font.FontBuilderGameFont;
import org.mini2Dx.gdx.utils.Array;
import org.mini2Dx.gdx.xml.XmlReader;

public class FontBuilderXmlReader {
    private static final String ENCODING = "UTF-8";
    private static final String ELEMENT_FONT = "Font";
    private static final String ELEMENT_CHAR = "Char";
    private static final String ATTRIBUTE_SIZE = "size";
    private static final String ATTRIBUTE_FAMILY = "family";
    private static final String ATTRIBUTE_WIDTH = "width";
    private static final String ATTRIBUTE_HEIGHT = "height";
    private static final String ATTRIBUTE_STYLE = "style";
    private static final String ATTRIBUTE_CODE = "code";
    private static final String ATTRIBUTE_OFFSET = "offset";
    private static final String ATTRIBUTE_RECT = "rect";
    private static final String DEFAULT_RECT = "0 0 1 1";

    public void read(FileHandle xmlFileHandle, FontBuilderGameFont.FontProperties fontProperties, CharMap<FontBuilderGameFont.FontBuilderChar> charMap) throws IOException {
        XmlReader xmlReader = new XmlReader();
        Reader ioReader = xmlFileHandle.reader(ENCODING);
        XmlReader.Element rootElement = xmlReader.parse(ioReader);
        ioReader.close();
        if (!rootElement.getName().equals(ELEMENT_FONT)) {
            rootElement = rootElement.getChildByName(ELEMENT_FONT);
        }
        fontProperties.size = rootElement.getIntAttribute(ATTRIBUTE_SIZE, 0);
        fontProperties.family = rootElement.getAttribute(ATTRIBUTE_FAMILY, "");
        fontProperties.height = rootElement.getIntAttribute(ATTRIBUTE_HEIGHT, 0);
        fontProperties.style = rootElement.getAttribute(ATTRIBUTE_STYLE, "");
        Array charElements = rootElement.getChildrenByName(ELEMENT_CHAR);
        for (XmlReader.Element charElement : charElements) {
            if (!charElement.hasAttribute(ATTRIBUTE_CODE)) continue;
            FontBuilderGameFont.FontBuilderChar fontChar = new FontBuilderGameFont.FontBuilderChar();
            char code = charElement.getAttribute(ATTRIBUTE_CODE).charAt(0);
            String rect = charElement.getAttribute(ATTRIBUTE_RECT, DEFAULT_RECT);
            fontChar.code = code;
            fontChar.width = charElement.getIntAttribute(ATTRIBUTE_WIDTH, 0);
            String[] rectComponents = rect.split(" ");
            fontChar.rectX = Integer.parseInt(rectComponents[0]);
            fontChar.rectY = Integer.parseInt(rectComponents[1]);
            fontChar.rectWidth = Integer.parseInt(rectComponents[2]);
            fontChar.rectHeight = Integer.parseInt(rectComponents[3]);
            if (charElement.hasAttribute(ATTRIBUTE_OFFSET)) {
                String offset = charElement.getAttribute(ATTRIBUTE_OFFSET);
                String[] offsetComponents = offset.split(" ");
                fontChar.offsetX = Integer.parseInt(offsetComponents[0]);
                fontChar.offsetY = Integer.parseInt(offsetComponents[1]);
            }
            charMap.put(code, fontChar);
        }
    }
}

