/*
 * Decompiled with CFR 0.152.
 */
package org.mini2Dx.core.font;

import org.mini2Dx.core.Mdx;
import org.mini2Dx.core.font.FontGlyphLayout;
import org.mini2Dx.core.font.GameFont;
import org.mini2Dx.core.font.MonospaceGameFont;
import org.mini2Dx.core.font.MonospaceGlyph;
import org.mini2Dx.core.graphics.Color;
import org.mini2Dx.gdx.math.MathUtils;
import org.mini2Dx.gdx.utils.Array;

public class MonospaceFontGlyphLayout
implements FontGlyphLayout {
    private final Array<MonospaceGlyph> glyphs = new Array();
    private final MonospaceGameFont monospaceFont;
    private final MonospaceGameFont.FontParameters fontParameters;
    private final Color black = Mdx.graphics.newColor(0.0f, 0.0f, 0.0f, 1.0f);
    private float maxX;
    private float maxY;

    public MonospaceFontGlyphLayout(MonospaceGameFont monospaceFont) {
        this.monospaceFont = monospaceFont;
        this.fontParameters = monospaceFont.getFontParameters();
    }

    @Override
    public void setText(CharSequence str) {
        this.setText(str, this.black, -1.0f, 8, true);
    }

    @Override
    public void setText(CharSequence str, Color color, float targetWidth, int halign, boolean wrap) {
        MonospaceGlyph glyph;
        int i;
        this.maxX = -1.0f;
        this.maxY = -1.0f;
        switch (halign) {
            default: {
                this.setTextLeftAlign(str, color, targetWidth, wrap);
                break;
            }
            case 16: {
                this.setTextRightAlign(str, color, targetWidth, wrap);
                break;
            }
            case 1: {
                this.setTextCenterAlign(str, color, targetWidth, wrap);
            }
        }
        if (this.glyphs.size > str.length()) {
            for (i = this.glyphs.size - 1; i >= str.length(); --i) {
                glyph = (MonospaceGlyph)this.glyphs.removeIndex(i);
                glyph.release();
            }
        }
        for (i = 0; i < this.glyphs.size; ++i) {
            glyph = this.getGlyph(i);
            if (glyph.glyphChar == '\n' || glyph.glyphChar == '\r') continue;
            this.maxX = Math.max(this.maxX, glyph.x + (float)this.fontParameters.characterWidth);
            this.maxY = Math.max(this.maxY, glyph.y + (float)this.fontParameters.lineHeight);
        }
        if (halign == 1 && targetWidth >= 0.0f) {
            this.maxX = targetWidth;
        }
    }

    private void setTextLeftAlign(CharSequence str, Color color, float targetWidth, boolean wrap) {
        int estimateMaxCharsPerLine;
        if (targetWidth < 0.0f) {
            targetWidth = Float.MAX_VALUE;
            estimateMaxCharsPerLine = Integer.MAX_VALUE;
        } else {
            estimateMaxCharsPerLine = MathUtils.round((float)(targetWidth / (float)(this.fontParameters.characterWidth + this.fontParameters.spacing)));
        }
        float yOffset = 0.0f;
        float xOffset = 0.0f;
        int i = 0;
        while (i < str.length()) {
            char startChar = str.charAt(i);
            if (startChar == '\n' || startChar == '\r' || Character.isWhitespace(startChar)) {
                MonospaceGlyph glyph = this.getGlyph(i);
                glyph.color.set(color);
                glyph.glyphChar = startChar;
                glyph.x = -1.0f;
                glyph.y = -1.0f;
                glyph.textureRegion = null;
                ++i;
                continue;
            }
            int totalChars = Math.max(1, this.calculateMaxCharactersBeforeWrap(str, i, estimateMaxCharsPerLine, targetWidth));
            for (int j = i; j < i + totalChars && j < str.length(); ++j) {
                char c = str.charAt(j);
                MonospaceGlyph glyph = this.getGlyph(j);
                glyph.color.set(color);
                glyph.glyphChar = c;
                glyph.x = xOffset;
                glyph.y = yOffset;
                glyph.textureRegion = this.monospaceFont.getTextureRegion(c);
                xOffset += (float)(this.fontParameters.characterWidth + this.fontParameters.spacing);
            }
            if (!wrap) {
                return;
            }
            xOffset = 0.0f;
            yOffset += (float)this.fontParameters.lineHeight;
            i += totalChars;
        }
    }

    private void setTextRightAlign(CharSequence str, Color color, float targetWidth, boolean wrap) {
        int charactersPerLine;
        if (targetWidth < 0.0f) {
            int maxCharsPerLine = 0;
            int i = 0;
            while (i < str.length()) {
                if (str.charAt(i) == '\n' || str.charAt(i) == '\r' || Character.isWhitespace(str.charAt(i))) {
                    ++i;
                    continue;
                }
                int totalChars = this.calculateMaxCharactersBeforeWrap(str, i, Integer.MAX_VALUE, Float.MAX_VALUE);
                maxCharsPerLine = Math.max(totalChars, maxCharsPerLine);
                i += totalChars;
            }
            if (maxCharsPerLine == 0) {
                return;
            }
            charactersPerLine = maxCharsPerLine;
            targetWidth = charactersPerLine * this.fontParameters.characterWidth + charactersPerLine * this.fontParameters.spacing - this.fontParameters.spacing;
        } else {
            charactersPerLine = MathUtils.round((float)(targetWidth / (float)(this.fontParameters.characterWidth + this.fontParameters.spacing)));
        }
        float yOffset = 0.0f;
        float xOffset = targetWidth - (float)this.fontParameters.characterWidth;
        int i = 0;
        while (i < str.length()) {
            char startChar = str.charAt(i);
            if (startChar == '\n' || startChar == '\r' || Character.isWhitespace(startChar)) {
                MonospaceGlyph glyph = this.getGlyph(i);
                glyph.color.set(color);
                glyph.glyphChar = startChar;
                glyph.x = -1.0f;
                glyph.y = -1.0f;
                glyph.textureRegion = null;
                ++i;
                continue;
            }
            int totalChars = Math.max(1, this.calculateMaxCharactersBeforeWrap(str, i, charactersPerLine, targetWidth));
            for (int j = i + totalChars - 1; j >= i; --j) {
                char c = str.charAt(j);
                MonospaceGlyph glyph = this.getGlyph(j);
                glyph.x = xOffset;
                glyph.y = yOffset;
                glyph.glyphChar = c;
                glyph.color.set(color);
                glyph.textureRegion = this.monospaceFont.getTextureRegion(c);
                xOffset -= (float)(this.fontParameters.characterWidth + this.fontParameters.spacing);
            }
            if (!wrap) {
                return;
            }
            xOffset = targetWidth - (float)this.fontParameters.characterWidth;
            yOffset += (float)this.fontParameters.lineHeight;
            i += totalChars;
        }
    }

    private void setTextCenterAlign(CharSequence str, Color color, float targetWidth, boolean wrap) {
        int charactersPerLine;
        int i;
        if (targetWidth < 0.0f) {
            int maxCharsPerLine = 0;
            i = 0;
            while (i < str.length()) {
                if (str.charAt(i) == '\n' || str.charAt(i) == '\r' || Character.isWhitespace(str.charAt(i))) {
                    ++i;
                    continue;
                }
                int totalChars = this.calculateMaxCharactersBeforeWrap(str, i, Integer.MAX_VALUE, Float.MAX_VALUE);
                maxCharsPerLine = Math.max(totalChars, maxCharsPerLine);
                i += totalChars;
            }
            if (maxCharsPerLine == 0) {
                return;
            }
            charactersPerLine = maxCharsPerLine;
            targetWidth = charactersPerLine * this.fontParameters.characterWidth + charactersPerLine * this.fontParameters.spacing - this.fontParameters.spacing;
        } else {
            charactersPerLine = MathUtils.round((float)(targetWidth / (float)(this.fontParameters.characterWidth + this.fontParameters.spacing)));
        }
        float yOffset = 0.0f;
        i = 0;
        while (i < str.length()) {
            char startChar = str.charAt(i);
            if (startChar == '\n' || startChar == '\r' || Character.isWhitespace(startChar)) {
                MonospaceGlyph glyph = this.getGlyph(i);
                glyph.color.set(color);
                glyph.glyphChar = startChar;
                glyph.x = -1.0f;
                glyph.y = -1.0f;
                glyph.textureRegion = null;
                ++i;
                continue;
            }
            int totalChars = Math.max(1, this.calculateMaxCharactersBeforeWrap(str, i, charactersPerLine, targetWidth));
            float lineWidth = totalChars * this.fontParameters.characterWidth + totalChars * this.fontParameters.spacing - this.fontParameters.spacing;
            float xOffset = MathUtils.round((float)(targetWidth * 0.5f - lineWidth * 0.5f));
            for (int j = i; j < i + totalChars; ++j) {
                char c = str.charAt(j);
                MonospaceGlyph glyph = this.getGlyph(j);
                glyph.x = xOffset;
                glyph.y = yOffset;
                glyph.glyphChar = c;
                glyph.color.set(color);
                glyph.textureRegion = this.monospaceFont.getTextureRegion(c);
                xOffset += (float)(this.fontParameters.characterWidth + this.fontParameters.spacing);
            }
            if (!wrap) {
                return;
            }
            yOffset += (float)this.fontParameters.lineHeight;
            i += totalChars;
        }
    }

    public int calculateMaxCharactersBeforeWrap(CharSequence str, int from, int estimate, float targetWidth) {
        float x = 0.0f;
        for (int i = from; i < str.length(); ++i) {
            char c = str.charAt(i);
            switch (c) {
                case '\n': 
                case '\r': {
                    return i - from;
                }
            }
            if (x + (float)this.fontParameters.characterWidth > targetWidth) {
                if (Character.isWhitespace(c)) {
                    return i - from;
                }
                if (c == '\n' || c == '\r') {
                    return i - from;
                }
                for (int j = i - 1; j >= from; --j) {
                    char previousChar = str.charAt(j);
                    if (Character.isWhitespace(previousChar)) {
                        return j - from;
                    }
                    if (!Character.isIdeographic(previousChar)) continue;
                    return j - from;
                }
                return i - from;
            }
            x += (float)(this.fontParameters.characterWidth + this.fontParameters.spacing);
        }
        return Math.min(estimate, str.length() - from);
    }

    @Override
    public void reset() {
        while (this.glyphs.size > 0) {
            MonospaceGlyph run = (MonospaceGlyph)this.glyphs.removeIndex(0);
            run.release();
        }
        this.maxX = -1.0f;
        this.maxY = -1.0f;
    }

    @Override
    public void dispose() {
        this.reset();
    }

    @Override
    public float getWidth() {
        return this.maxX;
    }

    @Override
    public float getHeight() {
        return this.maxY;
    }

    @Override
    public GameFont getFont() {
        return this.monospaceFont;
    }

    public void transferGlyphsTo(Array<MonospaceGlyph> result, float x, float y) {
        while (this.glyphs.size > 0) {
            MonospaceGlyph glyph = (MonospaceGlyph)this.glyphs.removeIndex(0);
            glyph.x += x;
            glyph.y += y;
            result.add((Object)glyph);
        }
    }

    public Array<MonospaceGlyph> getGlyphs() {
        return this.glyphs;
    }

    private MonospaceGlyph getGlyph(int index) {
        while (index >= this.glyphs.size) {
            MonospaceGlyph result = MonospaceGlyph.allocate();
            this.glyphs.add((Object)result);
        }
        return (MonospaceGlyph)this.glyphs.get(index);
    }
}

