/*
 * Decompiled with CFR 0.152.
 */
package org.mini2Dx.core.font;

import org.mini2Dx.core.Graphics;
import org.mini2Dx.core.Mdx;
import org.mini2Dx.core.assets.AssetManager;
import org.mini2Dx.core.exception.MdxException;
import org.mini2Dx.core.files.FileHandle;
import org.mini2Dx.core.font.FontGlyphLayout;
import org.mini2Dx.core.font.GameFont;
import org.mini2Dx.core.font.GameFontCache;
import org.mini2Dx.core.font.MonospaceFontGlyphLayout;
import org.mini2Dx.core.font.MonospaceGameFontCache;
import org.mini2Dx.core.font.MonospaceGlyph;
import org.mini2Dx.core.graphics.Color;
import org.mini2Dx.core.graphics.Texture;
import org.mini2Dx.core.graphics.TextureAtlas;
import org.mini2Dx.core.graphics.TextureRegion;
import org.mini2Dx.core.serialization.annotation.Field;
import org.mini2Dx.core.serialization.annotation.PostDeserialize;
import org.mini2Dx.gdx.utils.Array;
import org.mini2Dx.gdx.utils.CharArray;
import org.mini2Dx.gdx.utils.IntIntMap;

public class MonospaceGameFont
implements GameFont {
    private final MonospaceFontGlyphLayout sharedGlyphLayout;
    private final FontParameters fontParameters;
    private TextureRegion[][] characterTextures;
    private int charactersPerRow;
    private int charactersPerColumn;
    private Color color = Mdx.graphics.newColor(0.0f, 0.0f, 0.0f, 1.0f);

    public MonospaceGameFont(FontParameters fontParameters) {
        this.fontParameters = fontParameters;
        if (fontParameters.frameWidth <= 0) {
            throw new MdxException("fontParameters.frameWidth must be greater than 0");
        }
        if (fontParameters.frameHeight <= 0) {
            throw new MdxException("fontParameters.frameHeight must be greater than 0");
        }
        if (fontParameters.characterWidth < 0) {
            fontParameters.characterWidth = fontParameters.frameWidth;
        }
        if (fontParameters.lineHeight < 0) {
            fontParameters.lineHeight = fontParameters.frameHeight;
        }
        this.sharedGlyphLayout = (MonospaceFontGlyphLayout)this.newGlyphLayout();
    }

    @Override
    public boolean loadInternal() {
        return this.load(Mdx.files.internal(this.fontParameters.texturePath));
    }

    @Override
    public boolean loadExternal() {
        return this.load(Mdx.files.external(this.fontParameters.texturePath));
    }

    public boolean load(FileHandle textureHandle) {
        if (this.characterTextures != null) {
            return true;
        }
        this.load(Mdx.graphics.newTextureRegion(Mdx.graphics.newTexture(textureHandle)));
        return true;
    }

    @Override
    public boolean load(AssetManager assetManager) {
        TextureRegion textureRegion;
        if (this.characterTextures != null) {
            return true;
        }
        if (this.fontParameters.textureAtlasPath != null) {
            if (!assetManager.isLoaded(this.fontParameters.textureAtlasPath)) {
                assetManager.load(this.fontParameters.textureAtlasPath, TextureAtlas.class);
                return false;
            }
            TextureAtlas textureAtlas = assetManager.get(this.fontParameters.textureAtlasPath, TextureAtlas.class);
            if (textureAtlas == null) {
                throw new MdxException("No such texture atlas '" + this.fontParameters.textureAtlasPath + "'");
            }
            textureRegion = Mdx.graphics.newTextureRegion(textureAtlas.findRegion(this.fontParameters.texturePath));
        } else {
            if (!assetManager.isLoaded(this.fontParameters.texturePath)) {
                assetManager.load(this.fontParameters.texturePath, Texture.class);
                return false;
            }
            textureRegion = Mdx.graphics.newTextureRegion(assetManager.get(this.fontParameters.texturePath, Texture.class));
        }
        this.load(textureRegion);
        return true;
    }

    private void load(TextureRegion textureRegion) {
        this.charactersPerRow = textureRegion.getRegionWidth() / this.fontParameters.frameWidth;
        this.charactersPerColumn = textureRegion.getRegionHeight() / this.fontParameters.frameHeight;
        this.characterTextures = new TextureRegion[this.charactersPerRow][this.charactersPerColumn];
        for (int x = 0; x < this.charactersPerRow; ++x) {
            for (int y = 0; y < this.charactersPerColumn; ++y) {
                int textureX = x * this.fontParameters.frameWidth + this.fontParameters.framePaddingLeft;
                int textureY = y * this.fontParameters.frameHeight + this.fontParameters.framePaddingTop;
                int textureWidth = this.fontParameters.frameWidth - this.fontParameters.framePaddingLeft - this.fontParameters.framePaddingRight;
                int textureHeight = this.fontParameters.frameHeight - this.fontParameters.framePaddingTop - this.fontParameters.framePaddingBottom;
                this.characterTextures[x][y] = Mdx.graphics.newTextureRegion(textureRegion, textureX, textureY, textureWidth, textureHeight);
            }
        }
    }

    @Override
    public void draw(Graphics g, String str, float x, float y) {
        this.draw(g, str, x, y, -1.0f);
    }

    @Override
    public void draw(Graphics g, String str, float x, float y, float renderWidth) {
        this.draw(g, str, x, y, renderWidth, 8, true);
    }

    @Override
    public void draw(Graphics g, String str, float x, float y, float renderWidth, int horizontalAlignment, boolean wrap) {
        this.draw(g, str, x, y, renderWidth, horizontalAlignment, wrap, null);
    }

    public void draw(Graphics g, String str, float x, float y, float renderWidth, FontRenderListener listener) {
        this.draw(g, str, x, y, renderWidth, 8, true, listener);
    }

    public void draw(Graphics g, String str, float x, float y, float renderWidth, int horizontalAlignment, boolean wrap, FontRenderListener listener) {
        this.sharedGlyphLayout.setText(str, this.color, renderWidth, horizontalAlignment, wrap);
        this.draw(g, this.sharedGlyphLayout.getGlyphs(), x, y, listener);
    }

    public void draw(Graphics g, Array<MonospaceGlyph> glyphs, float x, float y, FontRenderListener listener) {
        float charRenderWidth = this.fontParameters.characterWidth;
        float charRenderHeight = this.fontParameters.lineHeight;
        Color previousTint = g.getTint();
        for (int i = 0; i < glyphs.size; ++i) {
            MonospaceGlyph glyph = (MonospaceGlyph)glyphs.get(i);
            if (glyph.textureRegion == null) continue;
            float renderX = x + glyph.x;
            float renderY = y + glyph.y;
            g.setTint(glyph.color);
            if (listener == null) {
                g.drawTextureRegion(glyph.textureRegion, renderX, renderY);
                continue;
            }
            if (listener.preRenderChar(g, glyph.glyphChar, renderX, renderY, charRenderWidth, charRenderHeight)) {
                g.drawTextureRegion(glyph.textureRegion, renderX, renderY);
            }
            listener.postRenderChar(g, glyph.glyphChar, renderX, renderY, charRenderWidth, charRenderHeight);
        }
        g.setTint(previousTint);
    }

    @Override
    public FontGlyphLayout newGlyphLayout() {
        return new MonospaceFontGlyphLayout(this);
    }

    @Override
    public FontGlyphLayout getSharedGlyphLayout() {
        return this.sharedGlyphLayout;
    }

    @Override
    public GameFontCache newCache() {
        return new MonospaceGameFontCache(this);
    }

    @Override
    public Color getColor() {
        return this.color;
    }

    @Override
    public void setColor(Color color) {
        if (color == null) {
            return;
        }
        this.color = color;
    }

    @Override
    public float getLineHeight() {
        return this.fontParameters.lineHeight;
    }

    @Override
    public float getCapHeight() {
        return this.fontParameters.lineHeight;
    }

    private int getXIndex(int index, int charactersPerRow) {
        return index % charactersPerRow;
    }

    private int getYIndex(int index, int charactersPerRow) {
        return index / charactersPerRow;
    }

    public TextureRegion getTextureRegion(char c) {
        int yIndex;
        int xIndex;
        if (this.characterTextures == null) {
            return null;
        }
        if (this.fontParameters.overrideCharacterIndices != null) {
            int index = this.fontParameters.overrideCharacterIndices.get((int)c, -1);
            if (index < 0) {
                return null;
            }
            xIndex = this.getXIndex(index, this.charactersPerRow);
            yIndex = this.getYIndex(index, this.charactersPerRow);
        } else {
            xIndex = this.getXIndex(c, this.charactersPerRow);
            yIndex = this.getYIndex(c, this.charactersPerRow);
        }
        return this.characterTextures[xIndex][yIndex];
    }

    @Override
    public boolean useIntegerPositions() {
        return true;
    }

    @Override
    public void dispose() {
        if (this.sharedGlyphLayout != null) {
            this.sharedGlyphLayout.dispose();
        }
    }

    public FontParameters getFontParameters() {
        return this.fontParameters;
    }

    public static interface FontRenderListener {
        public boolean preRenderChar(Graphics var1, char var2, float var3, float var4, float var5, float var6);

        public void postRenderChar(Graphics var1, char var2, float var3, float var4, float var5, float var6);
    }

    public static class FontParameters {
        @Field(optional=true)
        public String textureAtlasPath;
        @Field(optional=true)
        public String texturePath;
        @Field
        public int frameWidth;
        @Field
        public int frameHeight;
        @Field(optional=true)
        public int framePaddingLeft;
        @Field(optional=true)
        public int framePaddingRight;
        @Field(optional=true)
        public int framePaddingTop;
        @Field(optional=true)
        public int framePaddingBottom;
        @Field(optional=true)
        public int characterWidth = -1;
        @Field(optional=true)
        public int lineHeight = -1;
        @Field(optional=true)
        public int spacing = 1;
        @Field(optional=true)
        public IntIntMap overrideCharacterIndices;
        @Field(optional=true)
        public CharArray overrideCharacterIndicesList;

        @PostDeserialize
        public void postDeserialize() {
            if (this.overrideCharacterIndicesList != null) {
                this.overrideCharacterIndices = new IntIntMap();
                for (int i = 0; i < this.overrideCharacterIndicesList.size; ++i) {
                    this.overrideCharacterIndices.put((int)this.overrideCharacterIndicesList.get(i), i);
                }
                this.overrideCharacterIndicesList.clear();
            }
        }
    }
}

