/*
 * Decompiled with CFR 0.152.
 */
package org.mini2Dx.core.font;

import org.mini2Dx.core.Graphics;
import org.mini2Dx.core.Mdx;
import org.mini2Dx.core.font.GameFont;
import org.mini2Dx.core.font.GameFontCache;
import org.mini2Dx.core.font.MonospaceFontGlyphLayout;
import org.mini2Dx.core.font.MonospaceGameFont;
import org.mini2Dx.core.font.MonospaceGlyph;
import org.mini2Dx.core.graphics.Color;
import org.mini2Dx.gdx.utils.Array;

public class MonospaceGameFontCache
implements GameFontCache {
    private final Array<MonospaceGlyph> glyphs = new Array();
    private final MonospaceGameFont monospaceFont;
    private final MonospaceFontGlyphLayout glyphLayout;
    private final Color color = Mdx.graphics.newColor(0.0f, 0.0f, 0.0f, 1.0f);
    private float x;
    private float y;

    public MonospaceGameFontCache(MonospaceGameFont monospaceFont) {
        this.monospaceFont = monospaceFont;
        this.glyphLayout = new MonospaceFontGlyphLayout(monospaceFont);
    }

    @Override
    public void addText(CharSequence str, float x, float y) {
        this.glyphLayout.setText(str, this.color, -1.0f, 8, true);
        this.glyphLayout.transferGlyphsTo(this.glyphs, x, y);
    }

    @Override
    public void addText(CharSequence str, float x, float y, float targetWidth, int halign, boolean wrap) {
        this.glyphLayout.setText(str, this.color, targetWidth, halign, wrap);
        this.glyphLayout.transferGlyphsTo(this.glyphs, x, y);
    }

    @Override
    public void clear() {
        while (this.glyphs.size > 0) {
            MonospaceGlyph glyph = (MonospaceGlyph)this.glyphs.removeIndex(0);
            glyph.release();
        }
    }

    @Override
    public void draw(Graphics g) {
        this.monospaceFont.draw(g, this.glyphs, this.x, this.y, null);
    }

    @Override
    public Color getColor() {
        return this.color;
    }

    @Override
    public void setColor(Color color) {
        this.color.set(color);
    }

    @Override
    public void setAllColors(Color color) {
        for (int i = 0; i < this.glyphs.size; ++i) {
            ((MonospaceGlyph)this.glyphs.get((int)i)).color.set(color);
        }
    }

    @Override
    public void setAllAlphas(float alpha) {
        for (int i = 0; i < this.glyphs.size; ++i) {
            ((MonospaceGlyph)this.glyphs.get((int)i)).color.setA(alpha);
        }
    }

    @Override
    public void setText(CharSequence str, float x, float y) {
        this.clear();
        this.glyphLayout.setText(str, this.color, -1.0f, 8, true);
        this.glyphLayout.transferGlyphsTo(this.glyphs, x, y);
    }

    @Override
    public void setText(CharSequence str, float x, float y, float targetWidth, int halign, boolean wrap) {
        this.clear();
        this.glyphLayout.setText(str, this.color, targetWidth, halign, wrap);
        this.glyphLayout.transferGlyphsTo(this.glyphs, x, y);
    }

    @Override
    public void translate(float x, float y) {
        this.x += x;
        this.y += y;
    }

    @Override
    public void setPosition(float x, float y) {
        this.x = x;
        this.y = y;
    }

    @Override
    public GameFont getFont() {
        return this.monospaceFont;
    }
}

