/*
 * Decompiled with CFR 0.152.
 */
package org.mini2Dx.core.game;

import org.mini2Dx.core.Graphics;
import org.mini2Dx.core.Mdx;
import org.mini2Dx.core.game.GameResizeListener;
import org.mini2Dx.core.util.InterpolationTracker;
import org.mini2Dx.gdx.utils.Array;

public abstract class GameContainer {
    public static int TARGET_FPS = 60;
    protected int width;
    protected int height;
    protected Graphics graphics;
    private boolean isInitialised = false;
    private Array<GameResizeListener> gameResizeListeners;

    public abstract void initialise();

    public void preUpdate(float delta) {
        Mdx.executor.update(delta);
    }

    public void preUpdatePhysics(float delta) {
        InterpolationTracker.preUpdate();
    }

    public abstract void update(float var1);

    public void updatePhysics(float delta) {
    }

    public void interpolate(float alpha) {
        InterpolationTracker.interpolate(alpha);
    }

    public abstract void render(Graphics var1);

    public abstract void onPause();

    public abstract void onResume();

    public void render() {
        this.graphics.preRender(this.width, this.height);
        this.render(this.graphics);
        this.graphics.postRender();
    }

    public void resize(int width, int height) {
        this.width = width;
        this.height = height;
        for (GameResizeListener listener : this.gameResizeListeners) {
            listener.onResize(width, height);
        }
    }

    protected void preinit(Graphics g) {
        this.gameResizeListeners = new Array(1);
        this.graphics = g;
    }

    protected void postinit() {
    }

    public void start(Graphics g) {
        this.width = g.getWindowWidth();
        this.height = g.getWindowHeight();
        if (!this.isInitialised) {
            this.preinit(g);
            this.initialise();
            this.postinit();
            this.isInitialised = true;
        }
    }

    public void dispose() {
    }

    public void addResizeListener(GameResizeListener listener) {
        this.gameResizeListeners.add((Object)listener);
    }

    public void removeResizeListener(GameResizeListener listener) {
        this.gameResizeListeners.removeValue((Object)listener, true);
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }
}

