/*
 * Decompiled with CFR 0.152.
 */
package org.mini2Dx.core.geom;

import org.mini2Dx.core.Geometry;
import org.mini2Dx.core.Graphics;
import org.mini2Dx.core.geom.EdgeIterator;
import org.mini2Dx.core.geom.Intersector;
import org.mini2Dx.core.geom.LineSegment;
import org.mini2Dx.core.geom.Polygon;
import org.mini2Dx.core.geom.Rectangle;
import org.mini2Dx.core.geom.Shape;
import org.mini2Dx.core.geom.Sizeable;
import org.mini2Dx.core.util.Lerper;
import org.mini2Dx.gdx.math.MathUtils;
import org.mini2Dx.gdx.math.Vector2;

public class Circle
extends Shape {
    private static final long serialVersionUID = 7900371446650127192L;
    private static final ThreadLocal<Vector2> TMP_VECTOR1 = new ThreadLocal<Vector2>(){

        @Override
        protected Vector2 initialValue() {
            return new Vector2();
        }
    };
    private static final ThreadLocal<Vector2> TMP_VECTOR2 = new ThreadLocal<Vector2>(){

        @Override
        protected Vector2 initialValue() {
            return new Vector2();
        }
    };
    private static final ThreadLocal<Vector2> CENTER_TMP = new ThreadLocal<Vector2>(){

        @Override
        protected Vector2 initialValue() {
            return new Vector2();
        }
    };
    private final Geometry geometry;
    private final Rectangle boundingBox = new Rectangle();
    private final CircleEdgeIterator edgeIterator = new CircleEdgeIterator();
    final org.mini2Dx.gdx.math.Circle circle;
    private boolean dirty = true;

    public Circle(Geometry geometry) {
        this.circle = new org.mini2Dx.gdx.math.Circle(0.0f, 0.0f, 1.0f);
        this.geometry = geometry;
    }

    public Circle(float radius) {
        this(0.0f, 0.0f, radius);
    }

    public Circle(float centerX, float centerY, float radius) {
        this.circle = new org.mini2Dx.gdx.math.Circle(centerX, centerY, radius);
        this.geometry = null;
    }

    public Circle(Circle circle) {
        this.circle = new org.mini2Dx.gdx.math.Circle(circle.circle);
        this.geometry = null;
    }

    @Override
    public void dispose() {
        if (this.disposed) {
            return;
        }
        this.disposed = true;
        this.clearPositionChangeListeners();
        this.clearSizeChangeListeners();
        if (this.geometry == null) {
            return;
        }
        this.geometry.release(this);
    }

    @Override
    public Shape copy() {
        return new Circle(this);
    }

    public Circle lerp(Circle target, float alpha) {
        this.lerp(this, target, alpha);
        return this;
    }

    public void lerp(Circle result, Circle target, float alpha) {
        Circle.lerp(result, this, target, alpha);
    }

    public static void lerp(Circle result, Circle from, Circle target, float alpha) {
        result.circle.x = Lerper.lerp(from.circle.x, target.circle.x, alpha);
        result.circle.y = Lerper.lerp(from.circle.y, target.circle.y, alpha);
        result.circle.radius = Lerper.lerp(from.circle.radius, target.circle.radius, alpha);
        result.notifyPositionChangeListeners();
        result.notifyPositionChangeListeners();
        result.notifySizeChangeListeners();
        result.setDirty();
    }

    @Override
    public boolean contains(Vector2 point) {
        return this.contains(point.x, point.y);
    }

    @Override
    public boolean contains(float x, float y) {
        float dx = Math.abs(x - this.circle.x);
        if (dx > this.circle.radius) {
            return false;
        }
        float dy = Math.abs(y - this.circle.y);
        if (dy > this.circle.radius) {
            return false;
        }
        if (dx + dy <= this.circle.radius) {
            return true;
        }
        return dx * dx + dy * dy <= this.circle.radius * this.circle.radius;
    }

    @Override
    public boolean contains(Sizeable shape) {
        if (shape.isCircle()) {
            return this.contains((Circle)shape);
        }
        if (shape.getNumberOfSides() == 4) {
            float distanceY;
            float distanceX = Math.max(this.circle.x - shape.getMinX(), shape.getMaxX() - this.circle.x);
            return this.circle.radius * this.circle.radius >= distanceX * distanceX + (distanceY = Math.max(this.circle.y - shape.getMinY(), shape.getMaxY() - this.circle.y)) * distanceY;
        }
        return this.contains(shape.getPolygon());
    }

    public boolean contains(Circle circle) {
        return this.circle.contains(circle.circle);
    }

    public boolean contains(Rectangle rectangle) {
        float distanceY;
        float distanceX = Math.max(this.circle.x - rectangle.getMinX(), rectangle.getMaxX() - this.circle.x);
        return this.circle.radius * this.circle.radius >= distanceX * distanceX + (distanceY = Math.max(this.circle.y - rectangle.getMinY(), rectangle.getMaxY() - this.circle.y)) * distanceY;
    }

    public boolean contains(Polygon polygon) {
        float[] vertices = polygon.getVertices();
        for (int i = 0; i < vertices.length; i += 2) {
            if (this.contains(vertices[i], vertices[i + 1])) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean intersects(Sizeable shape) {
        if (shape.isCircle()) {
            return this.intersects((Circle)shape);
        }
        return shape.getPolygon().intersects(this);
    }

    @Override
    public boolean intersectsIgnoringEdges(Sizeable shape) {
        if (shape.isCircle()) {
            return this.intersectsIgnoringEdges((Circle)shape);
        }
        return shape.getPolygon().intersectsIgnoringEdges(this);
    }

    @Override
    public boolean intersectsLineSegment(Vector2 pointA, Vector2 pointB) {
        Vector2 centerTmp = CENTER_TMP.get();
        centerTmp.set(this.circle.x, this.circle.y);
        return org.mini2Dx.gdx.math.Intersector.intersectSegmentCircle((Vector2)pointA, (Vector2)pointB, (Vector2)centerTmp, (float)(this.circle.radius * this.circle.radius));
    }

    @Override
    public boolean intersectsLineSegment(float x1, float y1, float x2, float y2) {
        Vector2 tmpVector1 = TMP_VECTOR1.get();
        Vector2 tmpVector2 = TMP_VECTOR2.get();
        Vector2 centerTmp = CENTER_TMP.get();
        tmpVector1.set(x1, y1);
        tmpVector2.set(x2, y2);
        centerTmp.set(this.circle.x, this.circle.y);
        return org.mini2Dx.gdx.math.Intersector.intersectSegmentCircle((Vector2)tmpVector1, (Vector2)tmpVector2, (Vector2)centerTmp, (float)(this.circle.radius * this.circle.radius));
    }

    @Override
    public float getWidth() {
        return this.getRadius() * 2.0f;
    }

    @Override
    public float getHeight() {
        return this.getRadius() * 2.0f;
    }

    public boolean intersects(Rectangle rectangle) {
        return Intersector.intersects(rectangle, this);
    }

    public boolean intersects(Circle circle) {
        return Vector2.dst((float)this.circle.x, (float)this.circle.y, (float)circle.getX(), (float)circle.getY()) <= this.circle.radius + circle.getRadius();
    }

    public boolean intersectsIgnoringEdges(Circle circle) {
        return Vector2.dst((float)this.circle.x, (float)this.circle.y, (float)circle.getX(), (float)circle.getY()) < this.circle.radius + circle.getRadius();
    }

    @Override
    public float getDistanceTo(float x, float y) {
        float result = Vector2.dst((float)this.circle.x, (float)this.circle.y, (float)x, (float)y);
        if (result <= this.circle.radius) {
            return 0.0f;
        }
        return result - this.circle.radius;
    }

    public float getDistanceFromCenter(Vector2 point) {
        return Vector2.dst((float)this.circle.x, (float)this.circle.y, (float)point.x, (float)point.y);
    }

    public float getDistanceFromCenter(float x, float y) {
        return Vector2.dst((float)this.circle.x, (float)this.circle.y, (float)x, (float)y);
    }

    @Override
    public int getNumberOfSides() {
        return 0;
    }

    @Override
    public void draw(Graphics g) {
        g.drawCircle(this.circle.x, this.circle.y, MathUtils.round((float)this.circle.radius));
    }

    @Override
    public void fill(Graphics g) {
        g.fillCircle(this.circle.x, this.circle.y, MathUtils.round((float)this.circle.radius));
    }

    public void set(Circle circle) {
        this.setXY(circle.getX(), circle.getY());
        this.setRadius(circle.getRadius());
    }

    @Override
    public float getX() {
        return this.circle.x;
    }

    @Override
    public float getY() {
        return this.circle.y;
    }

    @Override
    public void setX(float x) {
        this.setCenterX(x);
    }

    @Override
    public void setY(float y) {
        this.setCenterY(y);
    }

    @Override
    public float getCenterX() {
        return this.circle.x;
    }

    @Override
    public float getCenterY() {
        return this.circle.y;
    }

    @Override
    public void setCenter(float x, float y) {
        this.setXY(x, y);
    }

    @Override
    public void setCenterX(float x) {
        if (MathUtils.isEqual((float)this.circle.x, (float)x)) {
            return;
        }
        this.circle.x = x;
        this.setDirty();
        this.notifyPositionChangeListeners();
    }

    @Override
    public void setCenterY(float y) {
        if (MathUtils.isEqual((float)this.circle.y, (float)y)) {
            return;
        }
        this.circle.y = y;
        this.setDirty();
        this.notifyPositionChangeListeners();
    }

    @Override
    public void setXY(float x, float y) {
        if (MathUtils.isEqual((float)this.circle.x, (float)x) && MathUtils.isEqual((float)this.circle.y, (float)y)) {
            return;
        }
        this.circle.x = x;
        this.circle.y = y;
        this.setDirty();
        this.notifyPositionChangeListeners();
    }

    @Override
    public float getMinX() {
        return this.circle.x - this.circle.radius;
    }

    @Override
    public float getMinY() {
        return this.circle.y - this.circle.radius;
    }

    @Override
    public float getMaxX() {
        return this.circle.x + this.circle.radius;
    }

    @Override
    public float getMaxY() {
        return this.circle.y + this.circle.radius;
    }

    public float getRadius() {
        return this.circle.radius;
    }

    @Override
    public void setRadius(float radius) {
        if (MathUtils.isEqual((float)this.circle.radius, (float)radius)) {
            return;
        }
        this.circle.radius = radius;
        this.setDirty();
        this.notifySizeChangeListeners();
    }

    @Override
    public void scale(float scale) {
        this.setRadius(this.circle.radius * scale);
    }

    @Override
    public void translate(float translateX, float translateY) {
        if (MathUtils.isZero((float)translateX) && MathUtils.isZero((float)translateY)) {
            return;
        }
        this.circle.x += translateX;
        this.circle.y += translateY;
        this.setDirty();
        this.notifyPositionChangeListeners();
    }

    private void setDirty() {
        this.dirty = true;
    }

    private void computeBoundingBox() {
        if (!this.dirty) {
            return;
        }
        float diameter = this.circle.radius * 2.0f;
        this.boundingBox.set(this.getMinX(), this.getMinY(), diameter, diameter);
        this.dirty = false;
    }

    @Override
    public EdgeIterator edgeIterator() {
        return this.edgeIterator;
    }

    public Rectangle getBoundingBox() {
        this.computeBoundingBox();
        return this.boundingBox;
    }

    @Override
    public float getRotation() {
        return 0.0f;
    }

    @Override
    public void setRotation(float degrees) {
    }

    @Override
    public void setRotationAround(float centerX, float centerY, float degrees) {
    }

    @Override
    public void rotate(float degrees) {
    }

    @Override
    public void rotateAround(float centerX, float centerY, float degrees) {
    }

    @Override
    public boolean isCircle() {
        return true;
    }

    @Override
    public Polygon getPolygon() {
        return null;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.circle == null ? 0 : this.circle.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Circle other = (Circle)obj;
        if (Float.floatToIntBits(this.getX()) != Float.floatToIntBits(other.getX())) {
            return false;
        }
        if (Float.floatToIntBits(this.getY()) != Float.floatToIntBits(other.getY())) {
            return false;
        }
        return Float.floatToIntBits(this.getRadius()) == Float.floatToIntBits(other.getRadius());
    }

    private class CircleEdgeIterator
    extends EdgeIterator {
        private CircleEdgeIterator() {
        }

        @Override
        protected void beginIteration() {
        }

        @Override
        protected void endIteration() {
        }

        @Override
        protected void nextEdge() {
        }

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public float getPointAX() {
            return Circle.this.circle.x;
        }

        @Override
        public float getPointAY() {
            return Circle.this.circle.y;
        }

        @Override
        public float getPointBX() {
            return Circle.this.circle.x;
        }

        @Override
        public float getPointBY() {
            return Circle.this.circle.y;
        }

        @Override
        public LineSegment getEdgeLineSegment() {
            return null;
        }
    }
}

