/*
 * Decompiled with CFR 0.152.
 */
package org.mini2Dx.core.geom;

import org.mini2Dx.core.exception.MdxException;
import org.mini2Dx.core.geom.LineSegment;

public abstract class EdgeIterator {
    private boolean begun = false;

    public void begin() {
        if (this.begun) {
            throw new MdxException("Cannot call begin() without first calling end() on previous iteration");
        }
        this.beginIteration();
        this.begun = true;
    }

    public void end() {
        if (!this.begun) {
            throw new MdxException("Cannot call end() without first calling begin()");
        }
        this.endIteration();
        this.begun = false;
    }

    public void next() {
        if (!this.begun) {
            throw new MdxException("Cannot call next() without first calling begin()");
        }
        this.nextEdge();
    }

    protected abstract void beginIteration();

    protected abstract void endIteration();

    protected abstract void nextEdge();

    public abstract boolean hasNext();

    public abstract float getPointAX();

    public abstract float getPointAY();

    public abstract float getPointBX();

    public abstract float getPointBY();

    public abstract LineSegment getEdgeLineSegment();
}

