/*
 * Decompiled with CFR 0.152.
 */
package org.mini2Dx.core.geom;

import org.mini2Dx.core.geom.Circle;
import org.mini2Dx.core.geom.Polygon;
import org.mini2Dx.core.geom.Rectangle;
import org.mini2Dx.gdx.math.Vector2;
import org.mini2Dx.gdx.utils.FloatArray;

public class Intersector {
    private static final Vector2 ip = new Vector2();
    private static final Vector2 ep1 = new Vector2();
    private static final Vector2 ep2 = new Vector2();
    private static final Vector2 s = new Vector2();
    private static final Vector2 e = new Vector2();
    private static final FloatArray floatArray = new FloatArray();
    private static final FloatArray floatArray2 = new FloatArray();

    public static boolean intersectLines(Vector2 p1, Vector2 p2, Vector2 p3, Vector2 p4, Vector2 intersection) {
        float x1 = p1.x;
        float x2 = p2.x;
        float y1 = p1.y;
        float y2 = p2.y;
        float x3 = p3.x;
        float x4 = p4.x;
        float y3 = p3.y;
        float y4 = p4.y;
        float det3 = Intersector.det(x1 - x2, y1 - y2, x3 - x4, y3 - y4);
        if (det3 == 0.0f) {
            return false;
        }
        float det1 = Intersector.det(x1, y1, x2, y2);
        float det2 = Intersector.det(x3, y3, x4, y4);
        float x = Intersector.det(det1, x1 - x2, det2, x3 - x4) / det3;
        float y = Intersector.det(det1, y1 - y2, det2, y3 - y4) / det3;
        intersection.x = x;
        intersection.y = y;
        return true;
    }

    public static boolean intersectLineSegments(float segAX1, float segAY1, float segAX2, float segAY2, float segBX1, float segBY1, float segBX2, float segBY2) {
        float x1 = segAX1;
        float y1 = segAY1;
        float x2 = segAX2;
        float y2 = segAY2;
        float x3 = segBX1;
        float y3 = segBY1;
        float x4 = segBX2;
        float y4 = segBY2;
        if (x1 == x2 && y1 == y2 || x3 == x4 && y3 == y4) {
            return false;
        }
        float ax = x2 - x1;
        float ay = y2 - y1;
        float bx = x3 - x4;
        float by = y3 - y4;
        float cx = x1 - x3;
        float cy = y1 - y3;
        float alphaNumerator = by * cx - bx * cy;
        float commonDenominator = ay * bx - ax * by;
        if (commonDenominator > 0.0f ? alphaNumerator < 0.0f || alphaNumerator > commonDenominator : commonDenominator < 0.0f && (alphaNumerator > 0.0f || alphaNumerator < commonDenominator)) {
            return false;
        }
        float betaNumerator = ax * cy - ay * cx;
        if (commonDenominator > 0.0f ? betaNumerator < 0.0f || betaNumerator > commonDenominator : commonDenominator < 0.0f && (betaNumerator > 0.0f || betaNumerator < commonDenominator)) {
            return false;
        }
        if (commonDenominator == 0.0f) {
            float y3LessY1 = y3 - y1;
            float collinearityTestForP3 = x1 * (y2 - y3) + x2 * y3LessY1 + x3 * (y1 - y2);
            return collinearityTestForP3 == 0.0f && (x1 >= x3 && x1 <= x4 || x1 <= x3 && x1 >= x4 || x2 >= x3 && x2 <= x4 || x2 <= x3 && x2 >= x4 || x3 >= x1 && x3 <= x2 || x3 <= x1 && x3 >= x2) && (y1 >= y3 && y1 <= y4 || y1 <= y3 && y1 >= y4 || y2 >= y3 && y2 <= y4 || y2 <= y3 && y2 >= y4 || y3 >= y1 && y3 <= y2 || y3 <= y1 && y3 >= y2);
        }
        return true;
    }

    private static float det(float a, float b, float c, float d) {
        return a * d - b * c;
    }

    public static boolean intersects(Rectangle rectangle, Circle circle) {
        float closestX = circle.getX();
        float closestY = circle.getY();
        if (circle.getX() < rectangle.getMinX()) {
            closestX = rectangle.getMinX();
        } else if (circle.getX() > rectangle.getMaxX()) {
            closestX = rectangle.getMaxX();
        }
        if (circle.getY() < rectangle.getMinY()) {
            closestY = rectangle.getMinY();
        } else if (circle.getY() > rectangle.getMaxY()) {
            closestY = rectangle.getMaxY();
        }
        closestX -= circle.getX();
        closestX *= closestX;
        closestY -= circle.getY();
        closestY *= closestY;
        return closestX + closestY < circle.getRadius() * circle.getRadius();
    }

    public static boolean containsPolygon(Polygon p1, Polygon p2) {
        float[] polygonB = p2.getVertices();
        for (int i = 0; i < polygonB.length; i += 2) {
            if (p1.contains(polygonB[i], polygonB[i + 1])) continue;
            return false;
        }
        return true;
    }

    public static boolean intersectSegmentPolygon(Vector2 p1, Vector2 p2, float[] vertices) {
        float x1 = p1.x;
        float y1 = p1.y;
        float x2 = p2.x;
        float y2 = p2.y;
        int n = vertices.length;
        float x3 = vertices[n - 2];
        float y3 = vertices[n - 1];
        for (int i = 0; i < n; i += 2) {
            float ub;
            float xd;
            float yd;
            float ua;
            float y4 = vertices[i + 1];
            float x4 = vertices[i];
            float d = (y4 - y3) * (x2 - x1) - (x4 - x3) * (y2 - y1);
            if (d != 0.0f && (ua = ((x4 - x3) * (yd = y1 - y3) - (y4 - y3) * (xd = x1 - x3)) / d) >= 0.0f && ua <= 1.0f && (ub = ((x2 - x1) * yd - (y2 - y1) * xd) / d) >= 0.0f && ub <= 1.0f) {
                return true;
            }
            x3 = x4;
            y3 = y4;
        }
        return false;
    }
}

