/*
 * Decompiled with CFR 0.152.
 */
package org.mini2Dx.core.geom;

import org.mini2Dx.core.Geometry;
import org.mini2Dx.core.geom.PositionChangeListener;
import org.mini2Dx.core.geom.Positionable;
import org.mini2Dx.gdx.math.MathUtils;
import org.mini2Dx.gdx.math.Matrix3;
import org.mini2Dx.gdx.math.Vector2;
import org.mini2Dx.gdx.utils.Array;
import org.mini2Dx.gdx.utils.Disposable;

public class Point
extends Vector2
implements Positionable,
Disposable {
    private static final long serialVersionUID = 3773673953486445831L;
    private static final ThreadLocal<Vector2> TMP_SOURCE_VECTOR = new ThreadLocal<Vector2>(){

        @Override
        protected Vector2 initialValue() {
            return new Vector2();
        }
    };
    private static final ThreadLocal<Vector2> TMP_TARGET_VECTOR = new ThreadLocal<Vector2>(){

        @Override
        protected Vector2 initialValue() {
            return new Vector2();
        }
    };
    private final Geometry geometry;
    protected boolean disposed = false;
    protected Array<PositionChangeListener> positionChangeListeners;

    public Point(Geometry geometry) {
        this.geometry = geometry;
    }

    public Point() {
        this.geometry = null;
    }

    public Point(float x, float y) {
        super(x, y);
        this.geometry = null;
    }

    public Point(Point point) {
        super((Vector2)point);
        this.geometry = null;
    }

    public void dispose() {
        if (this.disposed) {
            return;
        }
        this.disposed = true;
        this.clearPositionChangeListeners();
        if (this.geometry == null) {
            return;
        }
        this.geometry.release(this);
    }

    public void setDisposed(boolean disposed) {
        this.disposed = disposed;
    }

    @Override
    public float getDistanceTo(float x, float y) {
        return this.dst(x, y);
    }

    @Override
    public float getDistanceTo(Positionable positionable) {
        return this.dst(positionable.getX(), positionable.getY());
    }

    @Override
    public void moveTowards(float x, float y, float speed) {
        Vector2 tmpSourceVector = TMP_SOURCE_VECTOR.get();
        Vector2 tmpTargetVector = TMP_TARGET_VECTOR.get();
        tmpSourceVector.set(this.getX(), this.getY());
        tmpTargetVector.set(x, y);
        Vector2 direction = tmpTargetVector.sub(tmpSourceVector).nor();
        float xComponent = speed * MathUtils.cosDeg((float)direction.angle());
        float yComponent = speed * MathUtils.sinDeg((float)direction.angle());
        tmpSourceVector.add(xComponent, yComponent);
        this.set(tmpSourceVector.x, tmpSourceVector.y);
    }

    @Override
    public void moveTowards(Positionable positionable, float speed) {
        this.moveTowards(positionable.getX(), positionable.getY(), speed);
    }

    @Override
    public <T extends Positionable> void addPostionChangeListener(PositionChangeListener<T> listener) {
        if (this.positionChangeListeners == null) {
            this.positionChangeListeners = new Array(true, 1);
        }
        this.positionChangeListeners.add(listener);
    }

    @Override
    public <T extends Positionable> void removePositionChangeListener(PositionChangeListener<T> listener) {
        if (this.positionChangeListeners == null) {
            return;
        }
        this.positionChangeListeners.removeValue(listener, false);
    }

    protected void notifyPositionChangeListeners() {
        if (this.positionChangeListeners == null) {
            return;
        }
        for (int i = this.positionChangeListeners.size - 1; i >= 0; --i) {
            if (i >= this.positionChangeListeners.size) {
                i = this.positionChangeListeners.size - 1;
            }
            PositionChangeListener listener = (PositionChangeListener)this.positionChangeListeners.get(i);
            listener.positionChanged(this);
        }
    }

    protected void clearPositionChangeListeners() {
        if (this.positionChangeListeners == null) {
            return;
        }
        this.positionChangeListeners.clear();
    }

    public void rotateAround(Point center, float degrees) {
        this.rotateAround(center.x, center.y, degrees);
    }

    public void rotateAround(float centerX, float centerY, float degrees) {
        if (degrees == 0.0f) {
            return;
        }
        float cos = MathUtils.cos((float)(degrees * ((float)Math.PI / 180)));
        float sin = MathUtils.sin((float)(degrees * ((float)Math.PI / 180)));
        float newX = cos * (this.x - centerX) - sin * (this.y - centerY) + centerX;
        float newY = sin * (this.x - centerX) + cos * (this.y - centerY) + centerY;
        this.set(newX, newY);
    }

    public boolean isOnLineBetween(Point a, Point b) {
        float areaOfTriangle = (a.x * (b.y - this.y) + b.x * (this.y - a.y) + this.x * (a.y - b.y)) / 2.0f;
        if (areaOfTriangle == 0.0f) {
            if (this.x == a.x && this.y == a.y) {
                return true;
            }
            if (this.x == b.x && this.y == b.y) {
                return true;
            }
            if (this.x == a.x) {
                return this.y > a.y && this.y < b.y || this.y > b.y && this.y < a.y;
            }
            return this.x > a.x && this.x < b.x || this.x > b.x && this.x < a.x;
        }
        return false;
    }

    public boolean equals(Vector2 v) {
        return this.x == v.x && this.y == v.y;
    }

    public boolean equals(Vector2 v, float delta) {
        return this.equals(v.x, v.y, delta);
    }

    public boolean equals(float x, float y, float delta) {
        return Math.abs(this.x - x) <= delta && Math.abs(this.y - y) <= delta;
    }

    @Override
    public float getX() {
        return this.x;
    }

    @Override
    public float getY() {
        return this.y;
    }

    @Override
    public void setX(float x) {
        this.set(x, this.y);
    }

    @Override
    public void setY(float y) {
        this.set(this.x, y);
    }

    @Override
    public void setXY(float x, float y) {
        this.set(x, y);
    }

    public Vector2 set(float x, float y) {
        if (MathUtils.isEqual((float)this.x, (float)x) && MathUtils.isEqual((float)this.y, (float)y)) {
            return this;
        }
        super.set(x, y);
        this.notifyPositionChangeListeners();
        return this;
    }

    public Vector2 add(float x, float y) {
        super.add(x, y);
        this.notifyPositionChangeListeners();
        return this;
    }

    public Vector2 sub(float x, float y) {
        super.sub(x, y);
        this.notifyPositionChangeListeners();
        return this;
    }

    public Vector2 mul(Matrix3 mat) {
        super.mul(mat);
        this.notifyPositionChangeListeners();
        return this;
    }

    public Vector2 mulAdd(Vector2 vec, float scalar) {
        super.mulAdd(vec, scalar);
        this.notifyPositionChangeListeners();
        return this;
    }

    public Vector2 mulAdd(Vector2 vec, Vector2 mulVec) {
        super.mulAdd(vec, mulVec);
        this.notifyPositionChangeListeners();
        return this;
    }

    public Vector2 scl(Vector2 v) {
        super.scl(v);
        this.notifyPositionChangeListeners();
        return this;
    }

    public Vector2 scl(float scalar) {
        super.scl(scalar);
        this.notifyPositionChangeListeners();
        return this;
    }

    public Vector2 scl(float x, float y) {
        super.scl(x, y);
        this.notifyPositionChangeListeners();
        return this;
    }

    public Vector2 set(Vector2 v) {
        return this.set(v.x, v.y);
    }

    public Vector2 add(Vector2 v) {
        return this.add(v.x, v.y);
    }

    public Vector2 sub(Vector2 v) {
        return this.sub(v.x, v.y);
    }

    public Point copy() {
        return new Point(this.x, this.y);
    }
}

