/*
 * Decompiled with CFR 0.152.
 */
package org.mini2Dx.core.geom;

import java.util.Arrays;
import org.mini2Dx.core.Geometry;
import org.mini2Dx.core.Graphics;
import org.mini2Dx.core.Mdx;
import org.mini2Dx.core.exception.MdxException;
import org.mini2Dx.core.geom.Circle;
import org.mini2Dx.core.geom.EdgeIterator;
import org.mini2Dx.core.geom.Intersector;
import org.mini2Dx.core.geom.LineSegment;
import org.mini2Dx.core.geom.Point;
import org.mini2Dx.core.geom.PolygonEdgeIterator;
import org.mini2Dx.core.geom.Rectangle;
import org.mini2Dx.core.geom.Shape;
import org.mini2Dx.core.geom.Sizeable;
import org.mini2Dx.core.geom.Triangle;
import org.mini2Dx.core.util.Lerper;
import org.mini2Dx.gdx.math.EarClippingTriangulator;
import org.mini2Dx.gdx.math.MathUtils;
import org.mini2Dx.gdx.math.Vector2;
import org.mini2Dx.gdx.utils.ShortArray;

public class Polygon
extends Shape {
    private static final String LOGGING_TAG = Polygon.class.getSimpleName();
    private static final ThreadLocal<Vector2> TMP_VECTOR1 = new ThreadLocal<Vector2>(){

        @Override
        protected Vector2 initialValue() {
            return new Vector2();
        }
    };
    private static final ThreadLocal<Vector2> TMP_VECTOR2 = new ThreadLocal<Vector2>(){

        @Override
        protected Vector2 initialValue() {
            return new Vector2();
        }
    };
    private static final ThreadLocal<EarClippingTriangulator> TRIANGULATOR = new ThreadLocal<EarClippingTriangulator>(){

        @Override
        protected EarClippingTriangulator initialValue() {
            return new EarClippingTriangulator();
        }
    };
    private final Vector2 centroid = new Vector2();
    float[] vertices;
    private float rotation = 0.0f;
    private int totalSidesCache = -1;
    private float minX;
    private float minY;
    private float maxX;
    private float maxY;
    private ShortArray triangles;
    private boolean isRectangle;
    private boolean isEquilateral;
    private boolean minMaxDirty = true;
    private boolean trianglesDirty = true;
    private boolean centroidDirty = true;

    public Polygon(Geometry geometry, float[] vertices) {
        super(geometry);
        this.vertices = vertices;
        this.getNumberOfSides();
    }

    public Polygon(float[] vertices) {
        this.vertices = vertices;
        this.getNumberOfSides();
    }

    public Polygon(Vector2[] points) {
        this(Polygon.toVertices(points));
    }

    @Override
    public void dispose() {
        if (this.disposed) {
            return;
        }
        this.disposed = true;
        this.clearPositionChangeListeners();
        this.clearSizeChangeListeners();
        if (this.geometry == null) {
            this.vertices = null;
            this.triangles = null;
            return;
        }
        this.geometry.release(this);
    }

    public boolean isSameAs(Polygon polygon) {
        for (int i = 0; i < this.vertices.length; ++i) {
            if (this.vertices[i] == polygon.vertices[i]) continue;
            return false;
        }
        return true;
    }

    public Polygon lerp(Polygon target, float alpha) {
        this.lerp(this, target, alpha);
        return this;
    }

    public void lerp(Polygon result, Polygon target, float alpha) {
        Polygon.lerp(result, this, target, alpha);
    }

    public static void lerp(Polygon result, Polygon from, Polygon target, float alpha) {
        float[] currentVertices = from.vertices;
        float[] targetVertices = target.vertices;
        float[] resultVertices = result.vertices;
        if (currentVertices.length != targetVertices.length) {
            throw new MdxException("Cannot lerp polygons with different vertice amounts");
        }
        if (from.getRotation() != target.getRotation()) {
            float newRotation = Lerper.lerp(from.rotation, target.getRotation(), alpha);
            if (from.getX() == target.getX() && from.getY() == target.getY()) {
                result.setRotation(newRotation);
            } else {
                result.setRotationAround(Lerper.lerp(currentVertices[0], targetVertices[0], alpha), Lerper.lerp(currentVertices[1], targetVertices[1], alpha), newRotation);
            }
        } else if (!from.isSameAs(target)) {
            for (int i = 0; i < currentVertices.length; i += 2) {
                resultVertices[i] = Lerper.lerp(currentVertices[i], targetVertices[i], alpha);
                resultVertices[i + 1] = Lerper.lerp(currentVertices[i + 1], targetVertices[i + 1], alpha);
            }
            result.vertices = resultVertices;
            result.setDirty();
            result.notifyPositionChangeListeners();
        }
    }

    @Override
    public Shape copy() {
        Polygon result = new Polygon(Arrays.copyOf(this.vertices, this.vertices.length));
        result.rotation = this.rotation;
        return result;
    }

    private void clearTotalSidesCache() {
        this.totalSidesCache = -1;
    }

    protected boolean triangleContains(float x, float y, float p1x, float p1y, float p2x, float p2y, float p3x, float p3y) {
        if (MathUtils.isEqual((float)p1x, (float)p2x) && MathUtils.isEqual((float)p2x, (float)p3x) && MathUtils.isEqual((float)p1y, (float)p2y) && MathUtils.isEqual((float)p2y, (float)p3y)) {
            return MathUtils.isEqual((float)x, (float)p1x) && MathUtils.isEqual((float)y, (float)p1y);
        }
        boolean b1 = this.sign(x, y, p1x, p1y, p2x, p2y) < 0.0f;
        boolean b2 = this.sign(x, y, p2x, p2y, p3x, p3y) < 0.0f;
        boolean b3 = this.sign(x, y, p3x, p3y, p1x, p1y) < 0.0f;
        return b1 == b2 && b2 == b3;
    }

    protected float sign(float x, float y, float p1x, float p1y, float p2x, float p2y) {
        return (x - p2x) * (p1y - p2y) - (p1x - p2x) * (y - p2y);
    }

    @Override
    public boolean contains(float x, float y) {
        this.minMaxDirtyCheck();
        if (x < this.minX) {
            return false;
        }
        if (y < this.minY) {
            return false;
        }
        if (x > this.maxX) {
            return false;
        }
        if (y > this.maxY) {
            return false;
        }
        this.checkSidesCache();
        if (this.isRectangle) {
            return this.triangleContains(x, y, this.vertices[0], this.vertices[1], this.vertices[2], this.vertices[3], this.vertices[6], this.vertices[7]) || this.triangleContains(x, y, this.vertices[6], this.vertices[7], this.vertices[2], this.vertices[3], this.vertices[4], this.vertices[5]);
        }
        int intersects = 0;
        for (int i = 0; i < this.vertices.length; i += 2) {
            float x1 = this.vertices[i];
            float y1 = this.vertices[i + 1];
            float x2 = this.vertices[(i + 2) % this.vertices.length];
            float y2 = this.vertices[(i + 3) % this.vertices.length];
            if (!(y1 <= y && y < y2) && (!(y2 <= y) || !(y < y1)) || !(x < (x2 - x1) / (y2 - y1) * (y - y1) + x1)) continue;
            ++intersects;
        }
        return intersects & true;
    }

    @Override
    public boolean contains(Vector2 vector2) {
        return this.contains(vector2.x, vector2.y);
    }

    @Override
    public boolean contains(Sizeable shape) {
        if (shape.isCircle()) {
            Rectangle circleBox = ((Circle)shape).getBoundingBox();
            return this.contains(circleBox.getPolygon());
        }
        return this.contains(shape.getPolygon());
    }

    public boolean contains(Polygon polygon) {
        this.checkSidesCache();
        if (this.isRectangle && MathUtils.round((float)this.rotation) % 90 == 0) {
            if (polygon.getMaxX() < this.getX()) {
                return false;
            }
            if (polygon.getMaxY() < this.getY()) {
                return false;
            }
            if (polygon.getX() > this.getMaxX()) {
                return false;
            }
            if (polygon.getY() > this.getMaxY()) {
                return false;
            }
            if (polygon.getMaxX() > this.getMaxX()) {
                return false;
            }
            if (polygon.getMaxY() > this.getMaxY()) {
                return false;
            }
            if (polygon.getX() < this.getX()) {
                return false;
            }
            return !(polygon.getY() < this.getY());
        }
        return Intersector.containsPolygon(this, polygon);
    }

    @Override
    public boolean intersects(Sizeable shape) {
        if (shape.isCircle()) {
            return this.intersects((Circle)shape);
        }
        return this.intersects(shape.getPolygon());
    }

    @Override
    public boolean intersectsIgnoringEdges(Sizeable shape) {
        if (shape.isCircle()) {
            return this.intersectsIgnoringEdges((Circle)shape);
        }
        return this.intersectsIgnoringEdges(shape.getPolygon());
    }

    public boolean intersects(Polygon polygon) {
        this.minMaxDirtyCheck();
        this.checkSidesCache();
        polygon.minMaxDirtyCheck();
        polygon.checkSidesCache();
        if (this.maxX < polygon.minX) {
            return false;
        }
        if (polygon.maxX < this.minX) {
            return false;
        }
        if (this.maxY < polygon.minY) {
            return false;
        }
        if (polygon.maxY < this.minY) {
            return false;
        }
        if (this.isRectangle && polygon.isRectangle && MathUtils.round((float)this.rotation) % 90 == 0 && MathUtils.round((float)polygon.rotation) % 90 == 0) {
            return true;
        }
        boolean result = false;
        PolygonEdgeIterator internalEdgeIterator = PolygonEdgeIterator.allocate(this);
        internalEdgeIterator.begin();
        while (internalEdgeIterator.hasNext()) {
            internalEdgeIterator.next();
            if (!polygon.intersects(internalEdgeIterator.getEdgeLineSegment())) continue;
            result = true;
            break;
        }
        internalEdgeIterator.end();
        return result;
    }

    public boolean intersectsIgnoringEdges(Polygon polygon) {
        this.minMaxDirtyCheck();
        this.checkSidesCache();
        polygon.minMaxDirtyCheck();
        polygon.checkSidesCache();
        if (this.isRectangle && polygon.isRectangle && MathUtils.round((float)this.rotation) % 90 == 0 && MathUtils.round((float)polygon.rotation) % 90 == 0) {
            boolean xAxisOverlaps = true;
            boolean yAxisOverlaps = true;
            if (this.maxX <= polygon.minX) {
                xAxisOverlaps = false;
            }
            if (polygon.maxX <= this.minX) {
                xAxisOverlaps = false;
            }
            if (this.maxY <= polygon.minY) {
                yAxisOverlaps = false;
            }
            if (polygon.maxY <= this.minY) {
                yAxisOverlaps = false;
            }
            return xAxisOverlaps && yAxisOverlaps;
        }
        if (polygon.minX >= this.maxX) {
            return false;
        }
        if (polygon.maxX <= this.minX) {
            return false;
        }
        if (polygon.minY >= this.maxY) {
            return false;
        }
        if (polygon.maxY <= this.minY) {
            return false;
        }
        boolean result = false;
        PolygonEdgeIterator internalEdgeIterator = PolygonEdgeIterator.allocate(this);
        internalEdgeIterator.begin();
        while (internalEdgeIterator.hasNext()) {
            internalEdgeIterator.next();
            if (!polygon.intersects(internalEdgeIterator.getEdgeLineSegment())) continue;
            result = true;
            break;
        }
        internalEdgeIterator.end();
        return result;
    }

    public boolean intersects(Triangle triangle) {
        return this.intersects(triangle.polygon);
    }

    public boolean intersects(Rectangle rectangle) {
        return this.intersects(rectangle.polygon);
    }

    public boolean intersects(Circle circle) {
        if (this.isRectangle) {
            this.minMaxDirtyCheck();
            float closestX = circle.getX();
            float closestY = circle.getY();
            if (circle.getX() < this.minX) {
                closestX = this.minX;
            } else if (circle.getX() > this.maxX) {
                closestX = this.maxX;
            }
            if (circle.getY() < this.minY) {
                closestY = this.minY;
            } else if (circle.getY() > this.maxY) {
                closestY = this.maxY;
            }
            closestX -= circle.getX();
            closestX *= closestX;
            closestY -= circle.getY();
            closestY *= closestY;
            return closestX + closestY < circle.getRadius() * circle.getRadius();
        }
        boolean result = false;
        PolygonEdgeIterator internalEdgeIterator = PolygonEdgeIterator.allocate(this);
        internalEdgeIterator.begin();
        while (internalEdgeIterator.hasNext()) {
            internalEdgeIterator.next();
            if (!circle.intersectsLineSegment(internalEdgeIterator.getPointAX(), internalEdgeIterator.getPointAY(), internalEdgeIterator.getPointBX(), internalEdgeIterator.getPointBY())) continue;
            result = true;
            break;
        }
        internalEdgeIterator.end();
        return result;
    }

    public boolean intersectsIgnoringEdges(Circle circle) {
        if (this.isRectangle) {
            this.minMaxDirtyCheck();
            float closestX = circle.getX();
            float closestY = circle.getY();
            if (circle.getX() < this.minX) {
                closestX = this.minX;
            } else if (circle.getX() > this.maxX) {
                closestX = this.maxX;
            }
            if (circle.getY() < this.minY) {
                closestY = this.minY;
            } else if (circle.getY() > this.maxY) {
                closestY = this.maxY;
            }
            closestX -= circle.getX();
            closestX *= closestX;
            closestY -= circle.getY();
            closestY *= closestY;
            return closestX + closestY < circle.getRadius() * circle.getRadius();
        }
        boolean result = false;
        PolygonEdgeIterator internalEdgeIterator = PolygonEdgeIterator.allocate(this);
        internalEdgeIterator.begin();
        while (internalEdgeIterator.hasNext()) {
            internalEdgeIterator.next();
            if (!circle.intersectsLineSegment(internalEdgeIterator.getPointAX(), internalEdgeIterator.getPointAY(), internalEdgeIterator.getPointBX(), internalEdgeIterator.getPointBY())) continue;
            result = true;
            break;
        }
        internalEdgeIterator.end();
        return result;
    }

    @Override
    public boolean intersects(LineSegment lineSegment) {
        return this.intersectsLineSegment(lineSegment.getPointA(), lineSegment.getPointB());
    }

    @Override
    public boolean intersectsLineSegment(Vector2 pointA, Vector2 pointB) {
        this.minMaxDirtyCheck();
        float minX = Math.min(pointA.x, pointB.x);
        if (minX > this.maxX) {
            return false;
        }
        float minY = Math.min(pointA.y, pointB.y);
        if (minY > this.maxY) {
            return false;
        }
        float maxX = Math.max(pointA.x, pointB.x);
        if (maxX < this.minX) {
            return false;
        }
        float maxY = Math.max(pointA.y, pointB.y);
        if (maxY < this.minY) {
            return false;
        }
        return Intersector.intersectSegmentPolygon(pointA, pointB, this.vertices);
    }

    @Override
    public boolean intersectsLineSegment(float x1, float y1, float x2, float y2) {
        this.minMaxDirtyCheck();
        float minX = Math.min(x1, x2);
        if (minX > this.maxX) {
            return false;
        }
        float minY = Math.min(y1, y2);
        if (minY > this.maxY) {
            return false;
        }
        float maxX = Math.max(x1, x2);
        if (maxX < this.minX) {
            return false;
        }
        float maxY = Math.max(y1, y2);
        if (maxY < this.minY) {
            return false;
        }
        Vector2 tmpVector1 = TMP_VECTOR1.get();
        Vector2 tmpVector2 = TMP_VECTOR2.get();
        tmpVector1.set(x1, y1);
        tmpVector2.set(x2, y2);
        return Intersector.intersectSegmentPolygon(tmpVector1, tmpVector2, this.vertices);
    }

    @Override
    public float getWidth() {
        this.minMaxDirtyCheck();
        return this.maxX - this.minX;
    }

    @Override
    public float getHeight() {
        this.minMaxDirtyCheck();
        return this.maxY - this.minY;
    }

    @Override
    public float getDistanceTo(float x, float y) {
        float result = org.mini2Dx.gdx.math.Intersector.distanceSegmentPoint((float)this.vertices[this.vertices.length - 2], (float)this.vertices[this.vertices.length - 1], (float)this.vertices[0], (float)this.vertices[1], (float)x, (float)y);
        for (int i = 0; i < this.vertices.length - 2; i += 2) {
            float distance = org.mini2Dx.gdx.math.Intersector.distanceSegmentPoint((float)this.vertices[i], (float)this.vertices[i + 1], (float)this.vertices[i + 2], (float)this.vertices[i + 3], (float)x, (float)y);
            if (!(distance < result)) continue;
            result = distance;
        }
        return result;
    }

    public void addPoint(float x, float y) {
        float[] existingVertices = this.vertices;
        float[] newVertices = new float[existingVertices.length + 2];
        if (existingVertices.length > 0) {
            System.arraycopy(existingVertices, 0, newVertices, 0, existingVertices.length);
        }
        newVertices[existingVertices.length] = x;
        newVertices[existingVertices.length + 1] = y;
        this.vertices = newVertices;
        this.clearTotalSidesCache();
        this.setDirty();
        this.notifyPositionChangeListeners();
        this.notifySizeChangeListeners();
    }

    public void addPoint(Vector2 point) {
        this.addPoint(point.x, point.y);
    }

    private void removePoint(int i) {
        float[] existingVertices = this.vertices;
        float[] newVertices = new float[existingVertices.length - 2];
        if (i > 0) {
            System.arraycopy(existingVertices, 0, newVertices, 0, i);
        }
        if (i < existingVertices.length - 2) {
            System.arraycopy(existingVertices, i + 2, newVertices, i, existingVertices.length - i - 2);
        }
        this.vertices = newVertices;
        this.setDirty();
        this.clearTotalSidesCache();
        this.notifyPositionChangeListeners();
        this.notifySizeChangeListeners();
    }

    public void removePoint(float x, float y) {
        float[] existingVertices = this.vertices;
        for (int i = 0; i < existingVertices.length; i += 2) {
            if (existingVertices[i] != x || existingVertices[i + 1] != y) continue;
            this.removePoint(i);
            return;
        }
    }

    public void removePoint(Vector2 point) {
        this.removePoint(point.x, point.y);
    }

    private void checkSidesCache() {
        if (this.totalSidesCache >= 0) {
            return;
        }
        this.totalSidesCache = this.vertices.length / 2;
        this.isRectangle = this.totalSidesCache == 4;
        this.isEquilateral = this.isEquilateral(1.0E-6f);
    }

    @Override
    public int getNumberOfSides() {
        this.checkSidesCache();
        return this.totalSidesCache;
    }

    @Override
    public void draw(Graphics g) {
        g.drawPolygon(this.vertices);
    }

    @Override
    public void fill(Graphics g) {
        g.fillPolygon(this.vertices, this.getTriangles().items);
    }

    public float[] getVertices() {
        return this.vertices;
    }

    public void setVertices(float[] vertices) {
        boolean changed = false;
        if (this.vertices.length == vertices.length) {
            for (int i = 0; i < vertices.length; ++i) {
                changed |= !MathUtils.isEqual((float)this.vertices[i], (float)vertices[i]);
            }
        } else {
            changed = true;
        }
        this.rotation = 0.0f;
        if (!changed) {
            return;
        }
        float previousX = this.getX();
        float previousY = this.getY();
        float previousWidth = this.getWidth();
        float previousHeight = this.getHeight();
        this.vertices = vertices;
        this.clearTotalSidesCache();
        this.setDirty();
        if (!MathUtils.isEqual((float)previousX, (float)this.getX()) || !MathUtils.isEqual((float)previousY, (float)this.getY())) {
            this.notifyPositionChangeListeners();
        }
        if (!MathUtils.isEqual((float)previousWidth, (float)this.getWidth()) || !MathUtils.isEqual((float)previousHeight, (float)this.getHeight())) {
            this.notifySizeChangeListeners();
        }
    }

    public void setVertices(Vector2[] vertices) {
        if (this.vertices.length != vertices.length * 2) {
            this.setVertices(Polygon.toVertices(vertices));
            return;
        }
        float previousX = this.getX();
        float previousY = this.getY();
        float previousWidth = this.getWidth();
        float previousHeight = this.getHeight();
        boolean changed = false;
        for (int i = 0; i < vertices.length; ++i) {
            int index = i * 2;
            changed |= !MathUtils.isEqual((float)this.vertices[index], (float)vertices[i].x);
            changed |= !MathUtils.isEqual((float)this.vertices[index + 1], (float)vertices[i].y);
            this.vertices[index] = vertices[i].x;
            this.vertices[index + 1] = vertices[i].y;
        }
        this.rotation = 0.0f;
        if (!changed) {
            return;
        }
        this.clearTotalSidesCache();
        this.setDirty();
        if (!MathUtils.isEqual((float)previousX, (float)this.getX()) || !MathUtils.isEqual((float)previousY, (float)this.getY())) {
            this.notifyPositionChangeListeners();
        }
        if (!MathUtils.isEqual((float)previousWidth, (float)this.getWidth()) || !MathUtils.isEqual((float)previousHeight, (float)this.getHeight())) {
            this.notifySizeChangeListeners();
        }
    }

    @Override
    public float getRotation() {
        return this.rotation;
    }

    @Override
    public void setRotation(float degrees) {
        this.setRotationAround(this.vertices[0], this.vertices[1], degrees);
    }

    @Override
    public void rotate(float degrees) {
        this.rotateAround(this.vertices[0], this.vertices[1], degrees);
    }

    @Override
    public void setRotationAround(float centerX, float centerY, float degrees) {
        if (this.rotation == degrees && centerX == this.getX() && centerY == this.getY()) {
            return;
        }
        this.rotateAround(centerX, centerY, degrees - this.rotation);
    }

    @Override
    public void rotateAround(float centerX, float centerY, float degrees) {
        if (degrees == 0.0f) {
            return;
        }
        this.rotation += degrees;
        float cos = MathUtils.cos((float)(degrees * ((float)Math.PI / 180)));
        float sin = MathUtils.sin((float)(degrees * ((float)Math.PI / 180)));
        for (int i = 0; i < this.vertices.length; i += 2) {
            float x = this.vertices[i];
            float y = this.vertices[i + 1];
            this.vertices[i] = cos * (x - centerX) - sin * (y - centerY) + centerX;
            this.vertices[i + 1] = sin * (x - centerX) + cos * (y - centerY) + centerY;
        }
        this.setDirty();
        this.notifyPositionChangeListeners();
    }

    @Override
    public float getX() {
        return this.getX(0);
    }

    @Override
    public float getY() {
        return this.getY(0);
    }

    public float getX(int index) {
        return this.vertices[index * 2];
    }

    public float getY(int index) {
        return this.vertices[index * 2 + 1];
    }

    @Override
    public float getCenterX() {
        if (this.centroidDirty) {
            this.setCentroid();
        }
        return this.centroid.x;
    }

    @Override
    public float getCenterY() {
        if (this.centroidDirty) {
            this.setCentroid();
        }
        return this.centroid.y;
    }

    private void setCentroid() {
        switch (this.getNumberOfSides()) {
            case 3: {
                this.centroid.x = (this.vertices[0] + this.vertices[2] + this.vertices[4]) / 3.0f;
                this.centroid.y = (this.vertices[1] + this.vertices[3] + this.vertices[5]) / 3.0f;
                break;
            }
            case 4: {
                if (MathUtils.isZero((float)this.rotation)) {
                    this.centroid.x = this.getX() + this.getWidth() * 0.5f;
                    this.centroid.y = this.getY() + this.getHeight() * 0.5f;
                    break;
                }
                float avgX1 = (this.vertices[0] + this.vertices[2] + this.vertices[4]) / 3.0f;
                float avgY1 = (this.vertices[1] + this.vertices[3] + this.vertices[5]) / 3.0f;
                float avgX2 = (this.vertices[0] + this.vertices[6] + this.vertices[4]) / 3.0f;
                float avgY2 = (this.vertices[1] + this.vertices[7] + this.vertices[5]) / 3.0f;
                this.centroid.x = avgX1 - (avgX1 - avgX2) * 0.5f;
                this.centroid.y = avgY1 - (avgY1 - avgY2) * 0.5f;
                break;
            }
            default: {
                float area = 0.0f;
                float x = 0.0f;
                float y = 0.0f;
                int last = this.vertices.length - 2;
                float x1 = this.vertices[last];
                float y1 = this.vertices[last + 1];
                for (int i = 0; i <= last; i += 2) {
                    float x2 = this.vertices[i];
                    float y2 = this.vertices[i + 1];
                    float a = x1 * y2 - x2 * y1;
                    area += a;
                    x += (x1 + x2) * a;
                    y += (y1 + y2) * a;
                    x1 = x2;
                    y1 = y2;
                }
                if (area == 0.0f) {
                    this.centroid.x = 0.0f;
                    this.centroid.y = 0.0f;
                    break;
                }
                this.centroid.x = x / (6.0f * (area *= 0.5f));
                this.centroid.y = y / (6.0f * area);
            }
        }
        this.centroidDirty = false;
    }

    @Override
    public void setCenter(float x, float y) {
        float centerX = this.getCenterX();
        float centerY = this.getCenterY();
        if (x == centerX && y == centerY) {
            return;
        }
        this.translate(x - centerX, y - centerY);
    }

    @Override
    public void setCenterX(float x) {
        float centerX = this.getCenterX();
        if (x == centerX) {
            return;
        }
        this.translate(x - centerX, 0.0f);
    }

    @Override
    public void setCenterY(float y) {
        float centerY = this.getCenterY();
        if (y == centerY) {
            return;
        }
        this.translate(0.0f, y - centerY);
    }

    @Override
    public float getMinX() {
        this.minMaxDirtyCheck();
        return this.minX;
    }

    @Override
    public float getMinY() {
        this.minMaxDirtyCheck();
        return this.minY;
    }

    @Override
    public float getMaxX() {
        this.minMaxDirtyCheck();
        return this.maxX;
    }

    @Override
    public float getMaxY() {
        this.minMaxDirtyCheck();
        return this.maxY;
    }

    public ShortArray getTriangles() {
        this.trianglesDirtyCheck();
        return this.triangles;
    }

    private static float[] toVertices(Vector2[] points) {
        if (points == null) {
            throw new MdxException(Point.class.getSimpleName() + " array cannot be null");
        }
        if (points.length < 3) {
            throw new MdxException(Point.class.getSimpleName() + " must have at least 3 points");
        }
        float[] result = new float[points.length * 2];
        for (int i = 0; i < points.length; ++i) {
            int index = i * 2;
            result[index] = points[i].x;
            result[index + 1] = points[i].y;
        }
        return result;
    }

    @Override
    public void setX(float x) {
        if (MathUtils.isEqual((float)x, (float)this.getX())) {
            return;
        }
        float xDiff = x - this.getX();
        for (int i = 0; i < this.vertices.length; i += 2) {
            int n = i;
            this.vertices[n] = this.vertices[n] + xDiff;
        }
        this.setDirty();
        this.notifyPositionChangeListeners();
    }

    @Override
    public void setY(float y) {
        if (MathUtils.isEqual((float)y, (float)this.getY())) {
            return;
        }
        float yDiff = y - this.getY();
        for (int i = 1; i < this.vertices.length; i += 2) {
            int n = i;
            this.vertices[n] = this.vertices[n] + yDiff;
        }
        this.setDirty();
        this.notifyPositionChangeListeners();
    }

    @Override
    public void setXY(float x, float y) {
        if (MathUtils.isEqual((float)x, (float)this.getX()) && MathUtils.isEqual((float)y, (float)this.getY())) {
            return;
        }
        float xDiff = x - this.getX();
        float yDiff = y - this.getY();
        for (int i = 0; i < this.vertices.length; i += 2) {
            int n = i;
            this.vertices[n] = this.vertices[n] + xDiff;
            int n2 = i + 1;
            this.vertices[n2] = this.vertices[n2] + yDiff;
        }
        this.setDirty();
        this.notifyPositionChangeListeners();
    }

    @Override
    public void setRadius(float radius) {
        Vector2 tmpVector1 = TMP_VECTOR1.get();
        tmpVector1.set(this.vertices[0], this.vertices[1]);
        this.scale(radius / tmpVector1.dst(this.getCenterX(), this.getCenterY()));
    }

    @Override
    public void scale(float scale) {
        if (!this.isEquilateral()) {
            Mdx.log.error(LOGGING_TAG, "Cannot set radius on non-equilateral Polygon");
            return;
        }
        for (int i = 0; i < this.vertices.length; i += 2) {
            Vector2 tmpVector1 = TMP_VECTOR1.get();
            tmpVector1.set(this.vertices[i], this.vertices[i + 1]);
            tmpVector1.sub(this.getCenterX(), this.getCenterY());
            tmpVector1.scl(scale);
            tmpVector1.add(this.vertices[i], this.vertices[i + 1]);
            this.vertices[i] = tmpVector1.x;
            this.vertices[i + 1] = tmpVector1.y;
        }
        this.setDirty();
        this.notifySizeChangeListeners();
    }

    public void set(Polygon polygon) {
        this.vertices = polygon.vertices;
        this.rotation = polygon.rotation;
        this.clearTotalSidesCache();
        this.setDirty();
        this.notifyPositionChangeListeners();
        this.notifySizeChangeListeners();
    }

    @Override
    public void translate(float translateX, float translateY) {
        if (MathUtils.isZero((float)translateX) && MathUtils.isZero((float)translateY)) {
            return;
        }
        for (int i = 0; i < this.vertices.length; i += 2) {
            int n = i;
            this.vertices[n] = this.vertices[n] + translateX;
            int n2 = i + 1;
            this.vertices[n2] = this.vertices[n2] + translateY;
        }
        this.setDirty();
        this.notifyPositionChangeListeners();
    }

    @Override
    public EdgeIterator edgeIterator() {
        return PolygonEdgeIterator.allocate(this);
    }

    public boolean isEquilateral() {
        this.checkSidesCache();
        return this.isEquilateral;
    }

    public boolean isEquilateral(float tolerance) {
        if (this.isRectangle()) {
            return MathUtils.isEqual((float)(this.getMaxX() - this.getX()), (float)(this.getMaxY() - this.getY()), (float)tolerance);
        }
        PolygonEdgeIterator edgeIterator = PolygonEdgeIterator.allocate(this);
        edgeIterator.begin();
        edgeIterator.next();
        float length = edgeIterator.getEdgeLineSegment().getLength();
        while (edgeIterator.hasNext()) {
            edgeIterator.next();
            float nextLength = edgeIterator.getEdgeLineSegment().getLength();
            if (MathUtils.isEqual((float)length, (float)nextLength, (float)tolerance)) continue;
            edgeIterator.end();
            return false;
        }
        edgeIterator.end();
        return true;
    }

    public boolean isRectangle() {
        this.checkSidesCache();
        return this.isRectangle;
    }

    @Override
    public boolean isCircle() {
        return false;
    }

    @Override
    public Polygon getPolygon() {
        return this;
    }

    boolean isDirty() {
        return this.minMaxDirty || this.trianglesDirty || this.centroidDirty;
    }

    private void setDirty() {
        this.minMaxDirty = true;
        this.trianglesDirty = true;
        this.centroidDirty = true;
    }

    private void minMaxDirtyCheck() {
        if (!this.minMaxDirty) {
            return;
        }
        this.calculateMinMaxXY(this.vertices);
        this.minMaxDirty = false;
    }

    private void trianglesDirtyCheck() {
        if (!this.trianglesDirty) {
            return;
        }
        this.computeTriangles(this.vertices);
        this.trianglesDirty = false;
    }

    private void computeTriangles(float[] vertices) {
        this.triangles = TRIANGULATOR.get().computeTriangles(vertices);
    }

    private void calculateMinMaxXY(float[] vertices) {
        int minXIndex = 0;
        int minYIndex = 1;
        int maxXIndex = 0;
        int maxYIndex = 1;
        for (int i = 2; i < vertices.length; i += 2) {
            if (vertices[i] < vertices[minXIndex]) {
                minXIndex = i;
            }
            if (vertices[i + 1] < vertices[minYIndex]) {
                minYIndex = i + 1;
            }
            if (vertices[i] > vertices[maxXIndex]) {
                maxXIndex = i;
            }
            if (!(vertices[i + 1] > vertices[maxYIndex])) continue;
            maxYIndex = i + 1;
        }
        this.minX = vertices[minXIndex];
        this.minY = vertices[minYIndex];
        this.maxX = vertices[maxXIndex];
        this.maxY = vertices[maxYIndex];
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + Arrays.hashCode(this.vertices);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Polygon other = (Polygon)obj;
        return Arrays.equals(this.vertices, other.vertices);
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < this.vertices.length; i += 2) {
            result.append("[");
            result.append(this.vertices[i]);
            result.append(",");
            result.append(this.vertices[i + 1]);
            result.append("]");
        }
        return result.toString();
    }
}

