/*
 * Decompiled with CFR 0.152.
 */
package org.mini2Dx.core.geom;

import org.mini2Dx.core.exception.MdxException;
import org.mini2Dx.core.geom.EdgeIterator;
import org.mini2Dx.core.geom.LineSegment;
import org.mini2Dx.core.geom.Polygon;
import org.mini2Dx.gdx.utils.Queue;

public class PolygonEdgeIterator
extends EdgeIterator {
    private static final Queue<PolygonEdgeIterator> POOL = new Queue();
    private int edge = 0;
    private final LineSegment edgeLineSegment;
    private Polygon polygon;

    private PolygonEdgeIterator() {
        this(new LineSegment(0.0f, 0.0f, 1.0f, 1.0f));
    }

    private PolygonEdgeIterator(LineSegment edgeLineSegment) {
        this.edgeLineSegment = edgeLineSegment;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PolygonEdgeIterator allocate(Polygon polygon) {
        PolygonEdgeIterator iterator;
        Queue<PolygonEdgeIterator> queue = POOL;
        synchronized (queue) {
            iterator = PolygonEdgeIterator.POOL.size == 0 ? new PolygonEdgeIterator() : (PolygonEdgeIterator)POOL.removeFirst();
        }
        iterator.polygon = polygon;
        return iterator;
    }

    @Override
    protected void beginIteration() {
        this.edge = -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void endIteration() {
        Queue<PolygonEdgeIterator> queue = POOL;
        synchronized (queue) {
            this.polygon = null;
            POOL.addLast((Object)this);
        }
    }

    @Override
    protected void nextEdge() {
        if (this.edge >= this.polygon.getNumberOfSides()) {
            throw new MdxException("No more edges remaining. Make sure to call end()");
        }
        ++this.edge;
        if (!this.hasNext()) {
            return;
        }
        this.edgeLineSegment.set(this.getPointAX(), this.getPointAY(), this.getPointBX(), this.getPointBY());
    }

    @Override
    public boolean hasNext() {
        return this.edge < this.polygon.getNumberOfSides() - 1;
    }

    @Override
    public float getPointAX() {
        if (this.edge < 0) {
            throw new MdxException("Make sure to call next() after beginning iteration");
        }
        return this.polygon.vertices[this.edge * 2];
    }

    @Override
    public float getPointAY() {
        if (this.edge < 0) {
            throw new MdxException("Make sure to call next() after beginning iteration");
        }
        return this.polygon.vertices[this.edge * 2 + 1];
    }

    @Override
    public float getPointBX() {
        if (this.edge < 0) {
            throw new MdxException("Make sure to call next() after beginning iteration");
        }
        if (this.edge == this.polygon.getNumberOfSides() - 1) {
            return this.polygon.vertices[0];
        }
        return this.polygon.vertices[(this.edge + 1) * 2];
    }

    @Override
    public float getPointBY() {
        if (this.edge < 0) {
            throw new MdxException("Make sure to call next() after beginning iteration");
        }
        if (this.edge == this.polygon.getNumberOfSides() - 1) {
            return this.polygon.vertices[1];
        }
        return this.polygon.vertices[(this.edge + 1) * 2 + 1];
    }

    @Override
    public LineSegment getEdgeLineSegment() {
        return this.edgeLineSegment;
    }
}

