/*
 * Decompiled with CFR 0.152.
 */
package org.mini2Dx.core.geom;

import org.mini2Dx.core.Geometry;
import org.mini2Dx.core.Graphics;
import org.mini2Dx.core.geom.Circle;
import org.mini2Dx.core.geom.EdgeIterator;
import org.mini2Dx.core.geom.Polygon;
import org.mini2Dx.core.geom.PositionChangeListener;
import org.mini2Dx.core.geom.Positionable;
import org.mini2Dx.core.geom.Shape;
import org.mini2Dx.core.geom.SizeChangeListener;
import org.mini2Dx.core.geom.Sizeable;
import org.mini2Dx.core.geom.Triangle;
import org.mini2Dx.core.util.Lerper;
import org.mini2Dx.gdx.math.Vector2;

public class Rectangle
extends Shape {
    private static final long serialVersionUID = 4016090439885217620L;
    private static final ThreadLocal<Vector2[]> TMP_VERTICES = new ThreadLocal<Vector2[]>(){

        @Override
        protected Vector2[] initialValue() {
            return new Vector2[]{new Vector2(), new Vector2(), new Vector2(), new Vector2()};
        }
    };
    private static final ThreadLocal<Rectangle> TMP_RECTANGLE = new ThreadLocal<Rectangle>(){

        @Override
        protected Rectangle initialValue() {
            return new Rectangle();
        }
    };
    final Polygon polygon;
    final ProxyListeners proxyListeners = new ProxyListeners();
    private float width;
    private float height;

    public Rectangle() {
        this(0.0f, 0.0f, 1.0f, 1.0f);
    }

    public Rectangle(Geometry geometry) {
        super(geometry);
        this.width = 1.0f;
        this.height = 1.0f;
        this.polygon = new Polygon(this.determineVertices(0.0f, 0.0f, this.width, this.height));
        this.initProxyListeners();
    }

    public Rectangle(float x, float y, float width, float height) {
        this.width = width;
        this.height = height;
        this.polygon = new Polygon(this.determineVertices(x, y, width, height));
        this.initProxyListeners();
    }

    public Rectangle(Rectangle rectangle) {
        this.width = rectangle.getWidth();
        this.height = rectangle.getHeight();
        this.polygon = (Polygon)rectangle.polygon.copy();
        this.initProxyListeners();
    }

    private void initProxyListeners() {
        this.polygon.addPostionChangeListener(this.proxyListeners);
        this.polygon.addSizeChangeListener(this.proxyListeners);
    }

    @Override
    public void dispose() {
        if (this.disposed) {
            return;
        }
        this.disposed = true;
        this.clearPositionChangeListeners();
        this.clearSizeChangeListeners();
        if (this.geometry == null) {
            return;
        }
        this.geometry.release(this);
    }

    @Override
    public Shape copy() {
        return new Rectangle(this);
    }

    private Vector2[] determineVertices(float x, float y, float width, float height) {
        Vector2[] result = TMP_VERTICES.get();
        result[0].set(x, y);
        result[1].set(x + width, y);
        result[2].set(x + width, y + height);
        result[3].set(x, y + height);
        return result;
    }

    @Override
    public boolean contains(float x, float y) {
        return this.polygon.contains(x, y);
    }

    @Override
    public boolean contains(Vector2 point) {
        return this.polygon.contains(point);
    }

    @Override
    public boolean contains(Sizeable shape) {
        return this.polygon.contains(shape);
    }

    public boolean contains(Rectangle rectangle) {
        return this.polygon.contains(rectangle.polygon);
    }

    public boolean contains(Circle circle) {
        return this.polygon.contains(circle.getBoundingBox());
    }

    @Override
    public boolean intersects(Sizeable shape) {
        return this.polygon.intersects(shape);
    }

    @Override
    public boolean intersectsIgnoringEdges(Sizeable shape) {
        return this.polygon.intersectsIgnoringEdges(shape);
    }

    public boolean intersects(Circle circle) {
        return this.polygon.intersects(circle);
    }

    public boolean intersects(Rectangle rectangle) {
        return this.polygon.intersects(rectangle);
    }

    public boolean intersects(float x, float y, float width, float height) {
        Rectangle tmpRectangle = TMP_RECTANGLE.get();
        tmpRectangle.set(x, y, width, height);
        tmpRectangle.setRotation(0.0f);
        return this.intersects(tmpRectangle);
    }

    public boolean intersects(Triangle triangle) {
        return this.polygon.intersects(triangle);
    }

    public boolean intersects(Polygon polygon) {
        return this.polygon.intersects(polygon);
    }

    @Override
    public boolean intersectsLineSegment(Vector2 pointA, Vector2 pointB) {
        return this.polygon.intersectsLineSegment(pointA, pointB);
    }

    @Override
    public boolean intersectsLineSegment(float x1, float y1, float x2, float y2) {
        return this.polygon.intersectsLineSegment(x1, y1, x2, y2);
    }

    public Rectangle intersection(Rectangle rect) {
        if (this.polygon.getRotation() != 0.0f || rect.getRotation() != 0.0f) {
            throw new UnsupportedOperationException("Rectangle.intersection is not implemented to handle rotated rectangles");
        }
        float newX = Math.max(this.getX(), rect.getX());
        float newY = Math.max(this.getY(), rect.getY());
        float newWidth = Math.min(this.getMaxX(), rect.getMaxX()) - newX;
        float newHeight = Math.min(this.getMaxY(), rect.getMaxY()) - newY;
        return new Rectangle(newX, newY, newWidth, newHeight);
    }

    @Override
    public int getNumberOfSides() {
        return 4;
    }

    @Override
    public void draw(Graphics g) {
        this.polygon.draw(g);
    }

    @Override
    public void fill(Graphics g) {
        this.polygon.fill(g);
    }

    public Rectangle lerp(Rectangle target, float alpha) {
        Rectangle.lerp(this, this, target, alpha);
        return this;
    }

    public Rectangle lerp(Rectangle result, Rectangle target, float alpha) {
        Rectangle.lerp(result, this, target, alpha);
        return this;
    }

    public static void lerp(Rectangle result, Rectangle from, Rectangle target, float alpha) {
        float x = Lerper.lerp(from.getX(), target.getX(), alpha);
        float y = Lerper.lerp(from.getY(), target.getY(), alpha);
        float width = from.width;
        float height = from.height;
        if (from.getWidth() != target.getWidth()) {
            width = Lerper.lerp(from.getWidth(), target.getWidth(), alpha);
        }
        if (from.getHeight() != target.getHeight()) {
            height = Lerper.lerp(from.getHeight(), target.getHeight(), alpha);
        }
        if (from.getRotation() != target.getRotation()) {
            float rotation = Lerper.lerp(from.getRotation(), target.getRotation(), alpha);
            result.setRotation(rotation);
        }
        result.set(x, y, width, height);
    }

    @Override
    public float getDistanceTo(float x, float y) {
        return this.polygon.getDistanceTo(x, y);
    }

    @Override
    public float getRotation() {
        return this.polygon.getRotation();
    }

    @Override
    public void setRotation(float degrees) {
        this.polygon.setRotation(degrees);
    }

    @Override
    public void rotate(float degrees) {
        this.polygon.rotate(degrees);
    }

    @Override
    public void rotateAround(float centerX, float centerY, float degrees) {
        this.polygon.rotateAround(centerX, centerY, degrees);
    }

    @Override
    public void setRotationAround(float centerX, float centerY, float degrees) {
        this.polygon.setRotationAround(centerX, centerY, degrees);
    }

    public Rectangle set(float x, float y, float width, float height) {
        float rotation = this.polygon.getRotation();
        if (rotation != 0.0f) {
            this.polygon.setRotation(-rotation);
        }
        this.polygon.setVertices(this.determineVertices(x, y, width, height));
        if (rotation != 0.0f) {
            this.polygon.setRotation(rotation);
        }
        this.width = width;
        this.height = height;
        return this;
    }

    public void set(Rectangle rectangle) {
        if (this.equals(rectangle)) {
            return;
        }
        this.set(rectangle.getX(), rectangle.getY(), rectangle.getWidth(), rectangle.getHeight());
        this.setRotation(rectangle.getRotation());
    }

    @Override
    public void setXY(float x, float y) {
        this.polygon.setXY(x, y);
    }

    public void setXY(Vector2 position) {
        this.polygon.setXY(position.x, position.y);
    }

    @Override
    public float getX() {
        return this.polygon.getX();
    }

    @Override
    public void setX(float x) {
        this.polygon.setX(x);
    }

    @Override
    public float getY() {
        return this.polygon.getY();
    }

    @Override
    public void setY(float y) {
        this.polygon.setY(y);
    }

    @Override
    public float getWidth() {
        return this.width;
    }

    public Rectangle setWidth(float width) {
        float rotation = this.polygon.getRotation();
        this.polygon.setRotation(-rotation);
        this.polygon.setVertices(this.determineVertices(this.getX(), this.getY(), width, this.getHeight()));
        this.polygon.setRotation(rotation);
        this.width = width;
        return this;
    }

    @Override
    public float getHeight() {
        return this.height;
    }

    public Rectangle setHeight(float height) {
        float rotation = this.polygon.getRotation();
        this.polygon.setRotation(-rotation);
        this.polygon.setVertices(this.determineVertices(this.getX(), this.getY(), this.getWidth(), height));
        this.polygon.setRotation(rotation);
        this.height = height;
        return this;
    }

    public Rectangle setSize(float width, float height) {
        float rotation = this.polygon.getRotation();
        this.polygon.setRotation(-rotation);
        this.polygon.setVertices(this.determineVertices(this.getX(), this.getY(), this.getWidth(), height));
        this.polygon.setRotation(rotation);
        this.width = width;
        this.height = height;
        return this;
    }

    public Rectangle setSize(float sizeXY) {
        float rotation = this.polygon.getRotation();
        this.polygon.setRotation(-rotation);
        this.polygon.setVertices(this.determineVertices(this.getX(), this.getY(), sizeXY, sizeXY));
        this.polygon.setRotation(rotation);
        this.width = sizeXY;
        this.height = sizeXY;
        return this;
    }

    @Override
    public void setRadius(float radius) {
        this.polygon.setRadius(radius);
        this.width = this.polygon.getMaxX() - this.polygon.getX();
        this.height = this.polygon.getMaxY() - this.polygon.getY();
    }

    @Override
    public void scale(float scale) {
        this.polygon.scale(scale);
        this.width = this.polygon.getMaxX() - this.polygon.getX();
        this.height = this.polygon.getMaxY() - this.polygon.getY();
    }

    @Override
    public void translate(float translateX, float translateY) {
        this.polygon.translate(translateX, translateY);
    }

    @Override
    public EdgeIterator edgeIterator() {
        return this.polygon.edgeIterator();
    }

    @Override
    public float getCenterX() {
        return this.polygon.getCenterX();
    }

    @Override
    public float getCenterY() {
        return this.polygon.getCenterY();
    }

    @Override
    public void setCenter(float x, float y) {
        this.polygon.setCenter(x, y);
    }

    @Override
    public void setCenterX(float x) {
        this.polygon.setCenterX(x);
    }

    @Override
    public void setCenterY(float y) {
        this.polygon.setCenterY(y);
    }

    @Override
    public float getMinX() {
        return this.polygon.getMinX();
    }

    @Override
    public float getMinY() {
        return this.polygon.getMinY();
    }

    @Override
    public float getMaxX() {
        return this.polygon.getMaxX();
    }

    @Override
    public float getMaxY() {
        return this.polygon.getMaxY();
    }

    public float[] getVertices() {
        return this.polygon.getVertices();
    }

    public String toString() {
        return "Rectangle [rotation=" + this.polygon.getRotation() + ", x=" + this.getX() + ", y=" + this.getY() + ", width=" + this.getWidth() + ", height=" + this.getHeight() + "]";
    }

    @Override
    public boolean isCircle() {
        return false;
    }

    @Override
    public Polygon getPolygon() {
        return this.polygon;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Float.floatToIntBits(this.getX());
        result = 31 * result + Float.floatToIntBits(this.getY());
        result = 31 * result + Float.floatToIntBits(this.height);
        result = 31 * result + Float.floatToIntBits(this.width);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Rectangle other = (Rectangle)obj;
        if (Float.floatToIntBits(this.getX()) != Float.floatToIntBits(other.getX())) {
            return false;
        }
        if (Float.floatToIntBits(this.getY()) != Float.floatToIntBits(other.getY())) {
            return false;
        }
        if (Float.floatToIntBits(this.height) != Float.floatToIntBits(other.height)) {
            return false;
        }
        if (Float.floatToIntBits(this.width) != Float.floatToIntBits(other.width)) {
            return false;
        }
        return Float.floatToIntBits(this.getRotation()) == Float.floatToIntBits(other.getRotation());
    }

    private class ProxyListeners
    implements PositionChangeListener<Positionable>,
    SizeChangeListener<Sizeable> {
        private ProxyListeners() {
        }

        @Override
        public void positionChanged(Positionable moved) {
            Rectangle.this.notifyPositionChangeListeners();
        }

        @Override
        public void sizeChanged(Sizeable changed) {
            Rectangle.this.notifySizeChangeListeners();
        }
    }
}

