/*
 * Decompiled with CFR 0.152.
 */
package org.mini2Dx.core.geom;

import org.mini2Dx.core.Geometry;
import org.mini2Dx.core.Graphics;
import org.mini2Dx.core.geom.EdgeIterator;
import org.mini2Dx.core.geom.LineSegment;
import org.mini2Dx.core.geom.Point;
import org.mini2Dx.core.geom.Polygon;
import org.mini2Dx.core.geom.PositionChangeListener;
import org.mini2Dx.core.geom.Positionable;
import org.mini2Dx.core.geom.Rectangle;
import org.mini2Dx.core.geom.Shape;
import org.mini2Dx.core.geom.SizeChangeListener;
import org.mini2Dx.core.geom.Sizeable;
import org.mini2Dx.gdx.math.Vector2;

public class RegularPolygon
extends Shape {
    private final float rotationSymmetry;
    private final int totalSides;
    private final Point center;
    final ProxyListeners proxyListeners = new ProxyListeners();
    private Polygon polygon;
    private float radius;

    protected RegularPolygon(Geometry geometry, int totalSides, float rotationSymmetry) {
        super(geometry);
        this.center = new Point(0.0f, 0.0f);
        this.rotationSymmetry = rotationSymmetry;
        this.totalSides = totalSides;
        this.setRadius(1.0f);
        this.initProxyListeners();
    }

    public RegularPolygon(float centerX, float centerY, float radius, int totalSides, float rotationSymmetry) {
        this.center = new Point(centerX, centerY);
        this.rotationSymmetry = rotationSymmetry;
        this.totalSides = totalSides;
        this.setRadius(radius);
        this.initProxyListeners();
    }

    public RegularPolygon(RegularPolygon regularPolygon) {
        this.center = regularPolygon.center.copy();
        this.rotationSymmetry = regularPolygon.rotationSymmetry;
        this.totalSides = regularPolygon.totalSides;
        this.setRadius(regularPolygon.getRadius());
        this.initProxyListeners();
    }

    private void initProxyListeners() {
        this.polygon.addPostionChangeListener(this.proxyListeners);
        this.polygon.addSizeChangeListener(this.proxyListeners);
    }

    @Override
    public void dispose() {
        this.clearPositionChangeListeners();
        this.clearSizeChangeListeners();
    }

    @Override
    public Shape copy() {
        return new RegularPolygon(this);
    }

    @Override
    public void draw(Graphics g) {
        this.polygon.draw(g);
    }

    @Override
    public void fill(Graphics g) {
        this.polygon.fill(g);
    }

    public boolean intersects(Polygon polygon) {
        return polygon.intersects(polygon);
    }

    public boolean intersects(Rectangle rectangle) {
        return rectangle.intersects(this.polygon);
    }

    @Override
    public boolean contains(float x, float y) {
        return this.polygon.contains(x, y);
    }

    @Override
    public boolean contains(Vector2 vector2) {
        return this.polygon.contains(vector2);
    }

    @Override
    public boolean contains(Sizeable shape) {
        return this.polygon.contains(shape);
    }

    @Override
    public boolean intersects(Sizeable shape) {
        return this.polygon.intersects(shape);
    }

    @Override
    public boolean intersectsIgnoringEdges(Sizeable shape) {
        return this.polygon.intersectsIgnoringEdges(shape);
    }

    @Override
    public boolean intersects(LineSegment lineSegment) {
        return this.intersectsLineSegment(lineSegment.getPointA(), lineSegment.getPointB());
    }

    @Override
    public boolean intersectsLineSegment(Vector2 pointA, Vector2 pointB) {
        return this.polygon.intersectsLineSegment(pointA, pointB);
    }

    @Override
    public boolean intersectsLineSegment(float x1, float y1, float x2, float y2) {
        return this.polygon.intersectsLineSegment(x1, y1, x2, y2);
    }

    @Override
    public float getWidth() {
        return this.radius * 2.0f;
    }

    @Override
    public float getHeight() {
        return this.radius * 2.0f;
    }

    @Override
    public float getDistanceTo(float x, float y) {
        return this.polygon.getDistanceTo(x, y);
    }

    @Override
    public float getRotation() {
        return this.polygon.getRotation();
    }

    @Override
    public void setRotation(float degrees) {
        this.polygon.setRotation(degrees);
    }

    @Override
    public void setRotationAround(float centerX, float centerY, float degrees) {
        this.polygon.setRotationAround(centerX, centerY, degrees);
    }

    @Override
    public void rotate(float degrees) {
        this.polygon.rotate(degrees);
    }

    @Override
    public void rotateAround(float centerX, float centerY, float degrees) {
        this.polygon.rotateAround(centerX, centerY, degrees);
    }

    @Override
    public float getX() {
        return this.center.getX();
    }

    @Override
    public void setX(float centerX) {
        if (this.center.getX() == centerX) {
            return;
        }
        float diff = centerX - this.center.getX();
        this.polygon.translate(diff, 0.0f);
        this.center.set(centerX, this.center.y);
    }

    @Override
    public float getY() {
        return this.center.getY();
    }

    @Override
    public void setY(float centerY) {
        if (this.center.getY() == centerY) {
            return;
        }
        float diff = centerY - this.center.getY();
        this.polygon.translate(0.0f, diff);
        this.center.set(this.center.x, centerY);
    }

    @Override
    public void setXY(float centerX, float centerY) {
        float diffX = centerX - this.center.getX();
        float diffY = centerY - this.center.getY();
        this.polygon.translate(diffX, diffY);
        this.center.set(centerX, centerY);
    }

    @Override
    public void translate(float translateX, float translateY) {
        this.setXY(this.getX() + translateX, this.getY() + translateY);
    }

    public float getRadius() {
        return this.radius;
    }

    @Override
    public void setRadius(float radius) {
        if (this.radius == radius) {
            return;
        }
        this.radius = radius;
        Vector2[] points = new Point[this.totalSides];
        points[0] = new Point(this.center.getX(), this.center.getY() - radius);
        for (int i = 1; i < points.length; ++i) {
            points[i] = new Point(points[0]);
            points[i].rotateAround(this.center, this.rotationSymmetry * (float)i);
        }
        if (this.polygon == null) {
            this.polygon = new Polygon(points);
        } else {
            this.polygon.setVertices(points);
        }
    }

    @Override
    public void scale(float scale) {
        this.setRadius(this.radius * scale);
    }

    public float getX(int index) {
        return this.polygon.getX(index);
    }

    public float getY(int index) {
        return this.polygon.getY(index);
    }

    @Override
    public int getNumberOfSides() {
        return this.totalSides;
    }

    @Override
    public EdgeIterator edgeIterator() {
        return this.polygon.edgeIterator();
    }

    @Override
    public boolean isCircle() {
        return false;
    }

    @Override
    public Polygon getPolygon() {
        return this.polygon;
    }

    @Override
    public float getMinX() {
        return this.polygon.getMinX();
    }

    @Override
    public float getMinY() {
        return this.polygon.getMinY();
    }

    @Override
    public float getMaxX() {
        return this.polygon.getMaxX();
    }

    @Override
    public float getMaxY() {
        return this.polygon.getMaxY();
    }

    @Override
    public float getCenterX() {
        return this.polygon.getCenterX();
    }

    @Override
    public float getCenterY() {
        return this.polygon.getCenterY();
    }

    @Override
    public void setCenter(float x, float y) {
        this.polygon.setCenter(x, y);
    }

    @Override
    public void setCenterX(float x) {
        this.polygon.setCenterX(x);
    }

    @Override
    public void setCenterY(float y) {
        this.polygon.setCenterY(y);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.polygon == null ? 0 : this.polygon.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RegularPolygon other = (RegularPolygon)obj;
        return !(this.polygon == null ? other.polygon != null : !this.polygon.equals(other.polygon));
    }

    private class ProxyListeners
    implements PositionChangeListener<Positionable>,
    SizeChangeListener<Sizeable> {
        private ProxyListeners() {
        }

        @Override
        public void positionChanged(Positionable moved) {
            RegularPolygon.this.notifyPositionChangeListeners();
        }

        @Override
        public void sizeChanged(Sizeable changed) {
            RegularPolygon.this.notifySizeChangeListeners();
        }
    }
}

