/*
 * Decompiled with CFR 0.152.
 */
package org.mini2Dx.core.geom;

import org.mini2Dx.core.Geometry;
import org.mini2Dx.core.Graphics;
import org.mini2Dx.core.geom.EdgeIterator;
import org.mini2Dx.core.geom.LineSegment;
import org.mini2Dx.core.geom.Point;
import org.mini2Dx.core.geom.Polygon;
import org.mini2Dx.core.geom.PositionChangeListener;
import org.mini2Dx.core.geom.Positionable;
import org.mini2Dx.core.geom.SizeChangeListener;
import org.mini2Dx.core.geom.Sizeable;
import org.mini2Dx.gdx.math.MathUtils;
import org.mini2Dx.gdx.math.Vector2;
import org.mini2Dx.gdx.utils.Array;
import org.mini2Dx.gdx.utils.Disposable;
import org.mini2Dx.lockprovider.ReadWriteLock;

public abstract class Shape
implements Sizeable,
Disposable {
    private static final Vector2 TMP_VECTOR = new Vector2();
    private static final Vector2 TMP_SOURCE_VECTOR = new Vector2();
    private static final Vector2 TMP_TARGET_VECTOR = new Vector2();
    protected final Geometry geometry;
    protected boolean disposed = false;
    protected final Array<PositionChangeListener> positionChangeListeners = new Array(4);
    protected final Array<SizeChangeListener> sizeChangeListeners = new Array(4);

    public Shape() {
        this.geometry = null;
    }

    public Shape(Geometry geometry) {
        this.geometry = geometry;
    }

    public void setDisposed(boolean disposed) {
        this.disposed = disposed;
    }

    public abstract void dispose();

    public abstract Shape copy();

    @Override
    public boolean intersects(LineSegment lineSegment) {
        return this.intersectsLineSegment(lineSegment.getPointA(), lineSegment.getPointB());
    }

    @Override
    public float getDistanceTo(Positionable positionable) {
        return this.getDistanceTo(positionable.getX(), positionable.getY());
    }

    public void add(float x, float y) {
        TMP_VECTOR.set(this.getX(), this.getY());
        TMP_VECTOR.add(x, y);
        this.setXY(Shape.TMP_VECTOR.x, Shape.TMP_VECTOR.y);
    }

    public void subtract(float x, float y) {
        TMP_VECTOR.set(this.getX(), this.getY());
        TMP_VECTOR.sub(x, y);
        this.setXY(Shape.TMP_VECTOR.x, Shape.TMP_VECTOR.y);
    }

    public abstract float getRotation();

    public abstract void setRotation(float var1);

    public void setRotationAround(Point center, float degrees) {
        this.setRotationAround(center.x, center.y, degrees);
    }

    public abstract void setRotationAround(float var1, float var2, float var3);

    public abstract void rotate(float var1);

    public abstract void rotateAround(float var1, float var2, float var3);

    public abstract void draw(Graphics var1);

    public abstract void fill(Graphics var1);

    public abstract void translate(float var1, float var2);

    @Override
    public abstract int getNumberOfSides();

    public abstract EdgeIterator edgeIterator();

    @Override
    public abstract boolean isCircle();

    @Override
    public abstract Polygon getPolygon();

    @Override
    public void moveTowards(float x, float y, float speed) {
        TMP_SOURCE_VECTOR.set(this.getX(), this.getY());
        TMP_TARGET_VECTOR.set(x, y);
        Vector2 direction = TMP_TARGET_VECTOR.sub(TMP_SOURCE_VECTOR).nor();
        float xComponent = speed * MathUtils.cosDeg((float)direction.angleDeg());
        float yComponent = speed * MathUtils.sinDeg((float)direction.angleDeg());
        TMP_SOURCE_VECTOR.add(xComponent, yComponent);
        this.setXY(Shape.TMP_SOURCE_VECTOR.x, Shape.TMP_SOURCE_VECTOR.y);
    }

    @Override
    public void moveTowards(Positionable positionable, float speed) {
        this.moveTowards(positionable.getX(), positionable.getY(), speed);
    }

    @Override
    public <T extends Positionable> void addPostionChangeListener(PositionChangeListener<T> listener) {
        this.positionChangeListeners.add(listener);
    }

    @Override
    public <T extends Positionable> void removePositionChangeListener(PositionChangeListener<T> listener) {
        Shape.removePositionListener(this.positionChangeListeners, listener);
    }

    @Override
    public <T extends Sizeable> void addSizeChangeListener(SizeChangeListener<T> listener) {
        this.sizeChangeListeners.add(listener);
    }

    @Override
    public <T extends Sizeable> void removeSizeChangeListener(SizeChangeListener<T> listener) {
        Shape.removeSizeListener(this.sizeChangeListeners, listener);
    }

    protected void notifyPositionChangeListeners() {
        Shape.notifyPositionListeners(this.positionChangeListeners, this);
    }

    protected void clearPositionChangeListeners() {
        Shape.clearPositionListeners(this.positionChangeListeners);
    }

    protected void notifySizeChangeListeners() {
        Shape.notifySizeListeners(this.sizeChangeListeners, this);
    }

    protected void clearSizeChangeListeners() {
        Shape.clearSizeListeners(this.sizeChangeListeners);
    }

    public static <T extends Positionable> void removePositionListener(Array<PositionChangeListener> positionChangeListeners, PositionChangeListener listener) {
        if (positionChangeListeners == null) {
            return;
        }
        positionChangeListeners.removeValue((Object)listener, false);
    }

    public static <T extends Positionable> void removePositionListener(ReadWriteLock lock, Array<PositionChangeListener> positionChangeListeners, PositionChangeListener listener) {
        lock.lockRead();
        if (positionChangeListeners == null) {
            lock.unlockRead();
            return;
        }
        lock.unlockRead();
        lock.lockWrite();
        positionChangeListeners.removeValue((Object)listener, false);
        lock.unlockWrite();
    }

    public static <T extends Positionable> void notifyPositionListeners(Array<PositionChangeListener> positionChangeListeners, T notifier) {
        if (positionChangeListeners == null) {
            return;
        }
        for (int i = positionChangeListeners.size - 1; i >= 0; --i) {
            if (i >= positionChangeListeners.size) {
                i = positionChangeListeners.size - 1;
            }
            PositionChangeListener listener = (PositionChangeListener)positionChangeListeners.get(i);
            listener.positionChanged(notifier);
        }
    }

    public static <T extends Positionable> void notifyPositionListeners(ReadWriteLock lock, Array<PositionChangeListener> positionChangeListeners, T notifier) {
        lock.lockRead();
        if (positionChangeListeners == null) {
            lock.unlockRead();
            return;
        }
        for (int i = positionChangeListeners.size - 1; i >= 0; --i) {
            if (i >= positionChangeListeners.size) {
                i = positionChangeListeners.size - 1;
            }
            PositionChangeListener listener = (PositionChangeListener)positionChangeListeners.get(i);
            lock.unlockRead();
            listener.positionChanged(notifier);
            lock.lockRead();
        }
        lock.unlockRead();
    }

    public static <T extends Positionable> void clearPositionListeners(Array<PositionChangeListener> positionChangeListeners) {
        if (positionChangeListeners == null) {
            return;
        }
        positionChangeListeners.clear();
    }

    public static <T extends Positionable> void clearPositionListeners(ReadWriteLock lock, Array<PositionChangeListener> positionChangeListeners) {
        lock.lockRead();
        if (positionChangeListeners == null) {
            lock.unlockRead();
            return;
        }
        lock.unlockRead();
        lock.lockWrite();
        positionChangeListeners.clear();
        lock.unlockWrite();
    }

    public static <T extends Sizeable> void removeSizeListener(Array<SizeChangeListener> sizeChangeListeners, SizeChangeListener listener) {
        if (sizeChangeListeners == null) {
            return;
        }
        sizeChangeListeners.removeValue((Object)listener, false);
    }

    public static <T extends Sizeable> void removeSizeListener(ReadWriteLock lock, Array<SizeChangeListener> sizeChangeListeners, SizeChangeListener listener) {
        lock.lockRead();
        if (sizeChangeListeners == null) {
            lock.unlockRead();
            return;
        }
        lock.unlockRead();
        lock.lockWrite();
        sizeChangeListeners.removeValue((Object)listener, false);
        lock.unlockWrite();
    }

    public static <T extends Sizeable> void notifySizeListeners(Array<SizeChangeListener> sizeChangeListeners, T notifier) {
        if (sizeChangeListeners == null) {
            return;
        }
        for (int i = sizeChangeListeners.size - 1; i >= 0; --i) {
            if (i >= sizeChangeListeners.size) {
                i = sizeChangeListeners.size - 1;
            }
            SizeChangeListener listener = (SizeChangeListener)sizeChangeListeners.get(i);
            listener.sizeChanged(notifier);
        }
    }

    public static <T extends Sizeable> void notifySizeListeners(ReadWriteLock lock, Array<SizeChangeListener> sizeChangeListeners, T notifier) {
        lock.lockRead();
        if (sizeChangeListeners == null) {
            lock.unlockRead();
            return;
        }
        for (int i = sizeChangeListeners.size - 1; i >= 0; --i) {
            if (i >= sizeChangeListeners.size) {
                i = sizeChangeListeners.size - 1;
            }
            SizeChangeListener listener = (SizeChangeListener)sizeChangeListeners.get(i);
            lock.unlockRead();
            listener.sizeChanged(notifier);
            lock.lockRead();
        }
        lock.unlockRead();
    }

    public static <T extends Sizeable> void clearSizeListeners(Array<SizeChangeListener> sizeChangeListeners) {
        if (sizeChangeListeners == null) {
            return;
        }
        sizeChangeListeners.clear();
    }

    public static <T extends Sizeable> void clearSizeListeners(ReadWriteLock lock, Array<SizeChangeListener> sizeChangeListeners) {
        lock.lockRead();
        if (sizeChangeListeners == null) {
            lock.unlockRead();
            return;
        }
        lock.unlockRead();
        lock.lockWrite();
        sizeChangeListeners.clear();
        lock.unlockWrite();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Float.floatToIntBits(this.getNumberOfSides());
        result = 31 * result + Float.floatToIntBits(this.getX());
        result = 31 * result + Float.floatToIntBits(this.getY());
        result = 31 * result + Float.floatToIntBits(this.getMinX());
        result = 31 * result + Float.floatToIntBits(this.getMinY());
        result = 31 * result + Float.floatToIntBits(this.getMaxX());
        result = 31 * result + Float.floatToIntBits(this.getMaxY());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Shape other = (Shape)obj;
        if (Float.floatToIntBits(this.getNumberOfSides()) != Float.floatToIntBits(other.getNumberOfSides())) {
            return false;
        }
        if (Float.floatToIntBits(this.getX()) != Float.floatToIntBits(other.getX())) {
            return false;
        }
        if (Float.floatToIntBits(this.getY()) != Float.floatToIntBits(other.getY())) {
            return false;
        }
        if (Float.floatToIntBits(this.getMinX()) != Float.floatToIntBits(other.getMinX())) {
            return false;
        }
        if (Float.floatToIntBits(this.getMinY()) != Float.floatToIntBits(other.getMinY())) {
            return false;
        }
        if (Float.floatToIntBits(this.getMaxX()) != Float.floatToIntBits(other.getMaxX())) {
            return false;
        }
        return Float.floatToIntBits(this.getMaxY()) == Float.floatToIntBits(other.getMaxY());
    }
}

