/*
 * Decompiled with CFR 0.152.
 */
package org.mini2Dx.core.graphics;

import org.mini2Dx.core.Graphics;
import org.mini2Dx.core.Mdx;
import org.mini2Dx.core.graphics.Color;
import org.mini2Dx.core.graphics.Sprite;
import org.mini2Dx.gdx.utils.Array;

public class Animation<T extends Sprite> {
    private Array<T> frames = new Array(true, 2);
    private Array<Float> durations = new Array(true, 2);
    private int currentFrameIndex = 0;
    private float elapsed = 0.0f;
    private boolean looping = false;
    private float rotation;
    private float originX;
    private float originY;
    private Color color;
    private boolean flipX;
    private boolean flipY;

    public void addFrame(T frame, float duration) {
        this.durations.add((Object)Float.valueOf(duration));
        this.frames.add(frame);
        if (this.color == null) {
            this.color = frame.getTint();
        }
        this.originX = frame.getOriginX();
        this.originY = frame.getOriginY();
    }

    public void removeFrame(int index) {
        this.durations.removeIndex(index);
        this.frames.removeIndex(index);
    }

    public void restart() {
        this.currentFrameIndex = 0;
        this.elapsed = 0.0f;
    }

    public void update(float delta) {
        this.elapsed += delta;
        if (this.durations.size == 0) {
            return;
        }
        float duration = ((Float)this.durations.get(this.currentFrameIndex)).floatValue();
        while (this.elapsed >= duration) {
            this.elapsed -= duration;
            if (this.currentFrameIndex == this.frames.size - 1) {
                if (this.looping) {
                    this.currentFrameIndex = 0;
                }
            } else {
                ++this.currentFrameIndex;
            }
            duration = ((Float)this.durations.get(this.currentFrameIndex)).floatValue();
        }
    }

    public void draw(Graphics g) {
        if (this.currentFrameIndex >= this.frames.size) {
            return;
        }
        T sprite = this.getCurrentFrame();
        sprite.setOrigin(this.originX, this.originY);
        sprite.setRotation(this.rotation);
        sprite.setTint(this.color);
        sprite.setFlip(this.flipX, this.flipY);
        g.drawSprite((Sprite)sprite);
        sprite.setRotation(0.0f);
    }

    public void draw(Graphics g, float x, float y) {
        if (this.currentFrameIndex >= this.frames.size) {
            return;
        }
        T sprite = this.getCurrentFrame();
        sprite.setOrigin(this.originX, this.originY);
        sprite.setRotation(this.rotation);
        sprite.setTint(this.color);
        sprite.setFlip(this.flipX, this.flipY);
        g.drawSprite((Sprite)sprite, x, y);
        sprite.setRotation(0.0f);
    }

    public T getFrame(int index) {
        return (T)((Sprite)this.frames.get(index));
    }

    public T getCurrentFrame() {
        return (T)((Sprite)this.frames.get(this.currentFrameIndex));
    }

    public int getNumberOfFrames() {
        return this.frames.size;
    }

    public int getCurrentFrameIndex() {
        return this.currentFrameIndex;
    }

    public boolean isLooping() {
        return this.looping;
    }

    public void setLooping(boolean looping) {
        this.looping = looping;
    }

    public void rotate(float degrees) {
        this.rotation += degrees;
        this.rotation %= 360.0f;
    }

    public float getRotation() {
        return this.rotation;
    }

    public void setRotation(float rotation) {
        this.rotation = rotation % 360.0f;
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        if (color == null) {
            return;
        }
        this.color = color;
    }

    public void setColor(float r, float g, float b, float a) {
        if (this.color == null) {
            this.color = Mdx.graphics.newColor(r, g, b, a);
        } else {
            this.color.set(r, g, b, a);
        }
    }

    public float getOriginX() {
        return this.originX;
    }

    public void setOriginX(float originX) {
        this.originX = originX;
    }

    public float getOriginY() {
        return this.originY;
    }

    public void setOriginY(float originY) {
        this.originY = originY;
    }

    public void flip(boolean flipX, boolean flipY) {
        this.flipX = flipX;
        this.flipY = flipY;
    }

    public void setFlipX(boolean flipX) {
        this.flipX = flipX;
    }

    public void setFlipY(boolean flipY) {
        this.flipY = flipY;
    }

    public boolean getFlipX() {
        return this.flipX;
    }

    public boolean getFlipY() {
        return this.flipY;
    }

    public boolean isFinished() {
        if (this.looping) {
            return false;
        }
        if (this.currentFrameIndex != this.frames.size - 1) {
            return false;
        }
        return this.elapsed >= ((Float)this.durations.get(this.currentFrameIndex)).floatValue();
    }
}

