/*
 * Decompiled with CFR 0.152.
 */
package org.mini2Dx.core.graphics;

import org.mini2Dx.core.Mdx;
import org.mini2Dx.core.graphics.Pixmap;
import org.mini2Dx.gdx.InputProcessor;

public abstract class CustomCursor
implements InputProcessor {
    protected final Pixmap upPixmap;
    protected final Pixmap downPixmap;
    protected final Pixmap emptyPixmap;
    protected final int xHotspot;
    protected final int yHotspot;
    protected boolean visible;

    public CustomCursor(Pixmap upPixmap, Pixmap downPixmap, int xHotspot, int yHotspot) {
        this.upPixmap = upPixmap;
        this.downPixmap = downPixmap;
        this.emptyPixmap = Mdx.graphics.newPixmap(upPixmap.getWidth(), upPixmap.getHeight(), upPixmap.getFormat());
        this.xHotspot = xHotspot;
        this.yHotspot = yHotspot;
        this.visible = true;
    }

    protected abstract void updateCursorVisibility();

    public Pixmap getUpPixmap() {
        return this.upPixmap;
    }

    public Pixmap getDownPixmap() {
        return this.downPixmap;
    }

    public Pixmap getEmptyPixmap() {
        return this.emptyPixmap;
    }

    public int getxHotspot() {
        return this.xHotspot;
    }

    public int getyHotspot() {
        return this.yHotspot;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
        this.updateCursorVisibility();
    }
}

