/*
 * Decompiled with CFR 0.152.
 */
package org.mini2Dx.core.graphics;

import org.mini2Dx.core.Mdx;
import org.mini2Dx.core.graphics.Sprite;
import org.mini2Dx.core.graphics.Texture;
import org.mini2Dx.core.graphics.TextureRegion;

public class SpriteSheet {
    private final int totalColumns;
    private final int totalRows;
    private final int totalFrames;
    private final int frameWidth;
    private final int frameHeight;
    private final Sprite[] frames;

    public SpriteSheet(Texture sheet, int frameWidth, int frameHeight) {
        this(Mdx.graphics.newTextureRegion(sheet), frameWidth, frameHeight);
    }

    public SpriteSheet(TextureRegion sheet, int frameWidth, int frameHeight) {
        this.frameWidth = frameWidth;
        this.frameHeight = frameHeight;
        this.totalColumns = sheet.getRegionWidth() / frameWidth;
        this.totalRows = sheet.getRegionHeight() / frameHeight;
        this.totalFrames = this.totalColumns * this.totalRows;
        this.frames = new Sprite[this.totalFrames];
        for (int i = 0; i < this.totalFrames; ++i) {
            int x = this.getFrameX(i) * frameWidth;
            int y = this.getFrameY(i) * frameHeight;
            if (sheet == null) continue;
            this.frames[i] = Mdx.graphics.newSprite(Mdx.graphics.newTextureRegion(sheet, x, y, frameWidth, frameHeight));
        }
    }

    public Sprite getSprite(int index) {
        return this.frames[index];
    }

    public Sprite getSprite(int x, int y) {
        int index = y * this.totalColumns + x;
        return this.frames[index];
    }

    public int getFrameX(int index) {
        return index % this.totalColumns;
    }

    public int getFrameY(int index) {
        return index / this.totalColumns;
    }

    public int getTotalColumns() {
        return this.totalColumns;
    }

    public int getTotalRows() {
        return this.totalRows;
    }

    public int getTotalFrames() {
        return this.totalFrames;
    }
}

